%TITLE "DOSTD.ASM"
;------------------------------------------------------------
; Written by Raymond F. Genovese for the Public Domain
;------------------------------------------------------------
; This Version prints the system time and date as.....
; Saturday  December 24, 1989  12:24:01 PM
;------------------------------------------------------------
        IDEAL
        DOSSEG
        MODEL TINY
        DATASEG
ampms           dw      'MP'            ;AM/PM string
;day name strings and index
s_dow   db      'Sunday',0
        db      'Monday',0
        db      'Tuesday',0
        db      'Wednesday',0
        db      'Thursday',0
        db      'Friday',0
        db      'Saturday',0
d_index db      0,7,14,22,32,41,48
;month name strings and index
s_month db      'January',0
        db      'February',0
        db      'March',0
        db      'April',0
        db      'May',0
        db      'June',0
        db      'July',0
        db      'August',0
        db      'September',0
        db      'October',0
        db      'November',0
        db      'December',0
m_index db      0,0,8,17,23,29,33,38,43,50,60,68,77
dostds  db      'Saturday  December 24, 1989  12:24:01 PM '
; note the extra space - paranoid, huh
        db      '$'
;------------------------------------------------------------
        CODESEG
        ORG     100h
PROC    main
start:
        mov     ah,02ah         ;get DOS date
        int     21h
        cld
        mov     di,offset dostds
        ;day of the week=al
        mov     ah,0
        mov     si,offset d_index
        add     si,ax
        mov     al,[si]                 ;get index value
        mov     si,offset s_dow
        add     si,ax                   ;and index
do_dow:
        lodsb
        cmp     al,0
        je      done_dow
        stosb
        jmp     short do_dow
done_dow:
        mov     ax,2020h
        mov     [di],ax
        inc     di
        inc     di
        ;day and month in dx
        mov     ah,0
        mov     al,dh                   ;month
        mov     bl,dl                   ;save day
        mov     si,offset m_index
        add     si,ax
        mov     al,[si]
        mov     si,offset s_month
        add     si,ax
do_month:
        lodsb
        cmp     al,0
        je      do_day
        stosb
        jmp     short do_month
do_day:
        mov     al,20h
        mov     [di],al
        inc     di
        mov     al,bl           ;get day in al
        call    binasc
        cmp     bl,9            ;check for 1 digit case
        ja      date_ok
        dec     di
        mov     al,[di]
        dec     di
        mov     [di],al
        inc     di
date_ok:
        mov     al,','
        mov     [di],al
        inc     di
        mov     al,20h
        mov     [di],al
        inc     di
        ;year in cx 1980-2099
        sub     cx,1900
        mov     al,19
        cmp     cl,100
        jb      this_century
        inc     al
        sub     cl,100
this_century:
        call    binasc
        mov     al,cl
        call    binasc
        mov     ax,2020h
        mov     [di],ax
        inc     di
        inc     di
        mov     ah,02ch         ;get DOS time
        int     21h
        cmp     ch,11
        ja      c_hours
        mov     ax,[ampms]
        mov     al,'A'
        mov     [ampms],ax
c_hours:
        cmp     ch,13
        jb      do_time
        sub     ch,12           ;make time 12 hour format
do_time:
        or      ch,ch
        jnz     no_roll
        mov     ch,12
no_roll:
        mov     bl,':'
        mov     al,ch           ;hours
        call    binasc
        mov     [di],bl
        inc     di
        mov     al,cl           ;minutes
        call    binasc
        mov     [di],bl
        inc     di
        mov     al,dh           ;seconds
        call    binasc
        mov     al,' '
        mov     [di],al
        inc     di
        mov     ax,[ampms]
        mov     [di],ax
        inc     di
        inc     di
        mov     ax,' $'
        mov     [di],ax
;Send to standard output device (normally the display).
        mov     dx,offset dostds
        mov     ah,09h
        int     21h
;set al to a return value if you like
        mov     ah,04ch
        int     21h                     ;back2dos
ENDP    main
;------------------------------------------------------------
PROC    binasc NEAR
;convert byte in ax (<100) to two ascii digits [di]
        mov     dl,0ah                  ;divisor
bin2asc:
        xor     ah,ah
        div     dl                      ;get a remainder
        add     ah,30h                  ;make it ascii
        mov     [di+1],ah               ;store the digit
        xor     ah,ah                   ;clear remainder
        div     dl
        add     ah,30h
        mov     [di],ah
        inc     di
        inc     di                      ;fix point
        ret
ENDP    binasc
;------------------------------------------------------------
        END     start
