;RM82TS8,16,24,32,40,48,56,64
; updated 11/20/90

;============================================================================
;   Copyright (C) Copr. 1990 by Sidney J. Kelly
;                   All Rights Reserved.
;           Sidney J. Kelly
;           150 Woodhaven Drive
;           Pittsburgh, PA 15228
;           home phone 412-561-0950 (7pm to 9:30pm EST)
;============================================================================

DOSSEG
.MODEL MEDIUM
	PUBLIC PRINTSCREEN, KILLPRINT

.CODE

; Please do not remove
Copyright       DB    13,10,'Copyright Copr. (C) 1990 Sidney J. Kelly',13,10
Copyright1      DB    'All Rights Reserved',13,10,26

;============================================================================
; DECLARE SUB PRINTSCREEN%(Mode%, Error%)
; IF Error% THEN
;       printer error
; else
;       all o.k.
; end if
;
; Input:  0 = turn off printscreen key
;         1 = printscreen, then shut down key again
; Prints to LPT1
;============================================================================

EVEN
Installed	db	0

EVEN
PRINTSCREEN     PROC    FAR
	Push    BP                      ; save stack frame
	Mov     BP,SP
	Mov     BX,[BP+8]               ; get address of mode
	Mov     BX,[BX]                 ; read value of mode
	Xor     AX,AX                   ; set ES to BIOS RAM
	Mov     ES,AX
	Or      BX,BX                   ; is mode zero?
	JZ      No_Print                ; yep, so skip ahead

Print:
	Xor	DX,DX			; select LPT1 or PRN
	Mov     AH, 2                   ; Check printer status for
	Int     17h                     ; Printer bios interrupt
        TEST    AH, 00101001b           ; Are any error bits on?
	JNE     Error_Exit              ; Yes?  Error so exit
	TEST    AH, 10010000b           ; Are both operation bits on?
	JZ      Error_Exit              ; No?  Error so exit
	Jmp	Short  BeginPrint       ; o.k. so try and print

Error_Exit:
	Mov	AX,-1                   ; return error
	Jmp	Short  No_Print		; turn off print screen

BeginPrint:                             ; No Errors
	Cmp	Installed,1          	; have we done this before
	JE	No_EGA                  ; if yes then skip ahead
	Mov	Installed,1             ; note that we are installed
	Mov     AH,12h                  ; EGA BIOS EGA special function;
					; service
	Mov     BL,10h                  ; request EGA info
	Int     10h                     ; call the BIOS
	CMP     BL,10h                  ; if BL is still 10h, no EGA
	JZ      No_EGA                  ; if no EGA so skip ahead

Select_Alt_Prnscrn:
	Mov     AX,1200h                ; select printscreen function
	Mov     BX,29h                  ; that understands screens other
	Int     10h                     ; other than 80 x 25

No_EGA:
	Mov     Byte PTR ES:[0500h],0h  ; tell RAM BIOS not busy, no error
	Push	BP                      ; (per Leading Edge MS-DOS reference)
	Int     5h                      ; do a print screen
	Pop	BP                      ; (--must save BP)
        Xor	AX,AX                   ; report no error

No_Print:
	Mov     Byte PTR ES:[0500h],01h ; tell RAM BIOS function is busy
	Mov	BX,[BP+6]               ; report back error
        Mov	[BX],AX                 ; if any
	Pop     BP                      ; restore stack
	Ret     4			; remove 2*2 parameters
PRINTSCREEN     ENDP

;============================================================================
; DECLARE SUB KILLPRINT (LptNum%)
;       CALL KILLPRINT(LptNum%)
;
; Halts LptNum%, by resetting and purging buffer. Printer reset to defaults
; all non-default formats lost.  Will do nothing if errors noted, printer
; is not busy.
;============================================================================

EVEN
KILLPRINT   PROC    FAR
	Push    BP                      ; address stack
	Mov     BP,SP
	Mov     BX,[BP+6]
	Mov     DX,[BX]                 ; get printer number in DX
	Dec     DX                      ; make it zero biased
	Cmp     DX,4                    ; make sure Lpt# is 0 to 3
	JB      @f                      ;
	Xor     AX,AX                   ; if out of range make it LPT1:
@@:
	Mov     AH, 2                   ; First, check printer status for
	Int     17h                     ; Printer bios interrupt
	TEST    AH, 00101001b           ; Are any error bits on?
	JNZ     Exit1                   ; Yes?  Error so exit because already
					; halted.
	TEST    AH, 80h                 ; is printer busy (bit 7 Clear)
	JNZ     Exit1                   ; nope, bit set, printer not busy
					; so quit, nothing to stop
	Mov     AH,1                    ; resets the printer to default
	Int     17h

Exit1:
	Pop     BP
	Ret     2                       ; remove 1 * 2 parameters
KILLPRINT   ENDP
END
