;RM82TS8,16,24,32,40,48updated 11/20/90

;===========================================================================
;   Copyright (C) Copr. 1990 by Sidney J. Kelly
;                   All Rights Reserved.
;           Sidney J. Kelly
;           150 Woodhaven Drive
;           Pittsburgh, PA 15228
;           home phone 412-561-0950 (7pm to 9:30pm EST)
;===========================================================================

DOSSEG
.model medium, BASIC
.code

; Please do not remove
Copyright       DB    13,10,'Copyright Copr. (C) 1990 Sidney J. Kelly',13,10
Copyright1      DB    'All Rights Reserved',13,10,26

;===========================================================================
;DECLARE FUNCTION DOSVER% ()
;CALL DOSVER%
;Returns DOS VERSION value as an integer, to get display value \ 100
;E.g. DOS Version 3.3 is returned as 330
;===========================================================================

EVEN
DOSVER PROC FAR BASIC
		Mov     AH,30h
		Int     21h
		OR      AL,AL      ;test for Version 1.xx
		JNE     adjust     ;if not equal then jump
		Mov     AX,10
		JMP     SHORT finis
adjust:
		Mov     BL,AL      ;multiply major value by 10
		Mov     CL,3       ;using shifts for speed
		SHL     AL,CL
		SHL     BL,1
		ADD     AL,BL      ;ADD values together
		Mov     DH,AH

		XOR     BX,BX
		XOR     AH,AH
		Mov     BX,AX      ;multiply major value by 10 again
		Mov     CL,3       ;using shifts for speed
		SHL     AX,CL
		SHL     BX,1
		ADD     AX,BX      ;ADD values together

		XOR     BX,BX      ;clear BX
		Mov     BL,DH      ;store DH in BL
		ADD     AX,BX      ;ADD minor version
finis:
		ret
DOSVER          Endp

;===========================================================================
; DECLARE SUB MEM2STRING (TEXT$,SegAddress%,OffAddress%)
; Reads bytes from memory and stores them into a string
; number of bytes transferred is = LEN(Text$)
; Assumes string is in near data (DGROUP) & not a fixed length string
; or a user defined TYPE.
;===========================================================================

EVEN
MEM2STRING Proc FAR BASIC USES DS SI DI, \
TEXTSTRG:Ptr, Seg_Addr:Ptr, Off_Addr:Ptr

	    Mov   AX,SS         ; Set up ES to point to DGROUP
	    Mov   ES,AX         ; for near strings

	    ASSUME ES:@data     ; tell MASM of change

	    Mov   BX,TEXTSTRG   ; put descriptor to TEXT$ into BX
	    Mov   CX,[BX]       ; put Len(TEXT$) into CX for loop counter
	    JCXZ  Exit3         ; if CX is zero it's a null string, exit now
	    Mov   DI,[BX+02]    ; put address of last character in X$ into DI
	    CLD                 ; Clear the direction flag to move data forward
	    Mov   BX,Off_Addr   ; get offset address
	    Mov   SI,[BX]       ; store in SI
	    Mov   BX,Seg_Addr   ; get segment address
	    Mov   DS,[BX]       ; store in DS.  Do this LAST because DS
				; is used to address stack!!
	    ASSUME DS:NOTHING

	    Rep   Movsb         ; rapidly move for source to TEXT$
Exit3:
	    Ret                 ; MASM automatically restores the balance
MEM2STRING Endp

;===========================================================================
; DECLARE FUNCTION MEM2INT% (SegAddress%,OffAddress%)
; Reads word from memory and returns an integer value
; Faster than PEEK(High_byte) * 256 + PEEK(Low_byte)
;===========================================================================

EVEN
MEM2INT Proc FAR BASIC , \
Seg_Addr:Ptr, Off_Addr:Ptr

	XOR   DX,DX          ; clear DX in case function is defined as long&
	Mov   BX,Seg_Addr    ; get segment address
	Mov   BX,[BX]        ; store temporarily in BX
	Mov   ES,BX
	Mov   BX,Off_Addr    ; get offset address
	Mov   BX,[BX]        ; store temporarily in BX
	Mov   BX,ES:[BX]     ; read ES:[BX] into BX
	Mov   AX,BX
	Ret                  ; MASM automatically restores the balance
MEM2INT Endp


COMMENT         |
===========================================================================
DECLARE SUB GETDOSVER (VERSION$)

	    VERSION$=SPACE$(4)
	    CALL GETDOSVER(VERSION$)
Returns DOS Version as a string
===========================================================================
		|

EVEN
GETDOSVER Proc Far BASIC, VERS:Ptr
	      Mov            AH,30h         ; function to get the DOS version
	      Int            21h            ; execute the function
					    ; we now have the major version
					    ; number in AL and the minor
					    ; version number in AH
	      OR             AL,AL          ; test for Version 1.xx
	      JNE            Adjust1        ; if not equal then make ver 1
	      Mov            AX,10
Adjust1:
	      Mov            CL,AH          ; put minor version # in CL
	      Mov            CH,0           ; convert from a byte to a word
	      Mov            AH,0           ; convert AL from byte to word

	      Mov            BX,VERS        ; get address of the string info
	      CMP  Word Ptr  [BX],4         ; is VERSION$ long enough?
	      JB             Done           ;   no, it's too short-- exit

	      Mov            BX,[BX+2]      ; get address of VERSION$ itself

	      ADD            AL,"0"         ; convert major version # to ASCII
	      Mov            [BX],AL        ; store it in VERSION$
	      Inc            BX             ; move to the next character
	      Mov Byte Ptr   [BX],"."       ; store decimal point in VERSION$
	      Inc            BX             ; move to the next character
	      Mov            AL,CL          ; put the minor version in AL
	      AAM                           ; convert to digits in AL and AH
	      XCHG           AL,AH          ; put digits in correct order
	      ADD            AX,"00"        ; convert minor version # to ASCII
	      Mov            [BX],AX        ; store it in VERSION$
Done:
	      Ret
GETDOSVER     Endp
END
