TITLE	DISASMBL	2-7-86	[6-22-88]

PATCH83	MACRO
ORG	$-3
DB	81
ORG	$+2
DB	0
ENDM
;
RET_NEAR	MACRO
DB	0C3H
ENDM
;
.RADIX	16
LF	EQU	0AH
CR	EQU	0DH
;
H1	EQU	1000			;THESE SET THE HIGH NIBBLE
H2	EQU	2000			;WHERE APPROPRIATE @ "L1BC0"
H3	EQU	3000			;THROUGH "CODES".
H4	EQU	4000
H5	EQU	5000
H6	EQU	6000
H7	EQU	7000
HA	EQU	0A000
;
;INITIAL VALUES :	CS:IP	0000:0100
;			SS:SP	0000:FFFF
S0000	SEGMENT
	ASSUME DS:S0000, SS:S0000 ,CS:S0000 ,ES:S0000
	ORG	$+0100H
L0100:	CLD
	MOV	SP,100
	MOV	AX,DS:2			;GET TOP OF MEMORY.
	MOV	BX,CS
	SUB	AX,BX			;CALC REMAINING MEMORY.
	TEST	AH,0F0
	JZ	L0115
	MOV	AX,0FFFF		;SET MEMORY SIZE TO 64Kb.
	JMP	SHORT	L0119

L0115:	MOV	CL,4			;MULTIPLY BY 16.
	SHL	AX,CL			;CALC # BYTES REMAINING.
L0119:	MOV	MEMSZ,AX		;SAVE MEMORY SIZE.
	SUB	AX,OFFSET EOPGM
	JB	L0126			;NOT ENOUGH MEMORY.
	CMP	AX,100
	JNB	L012C			;THERE IS ENOUGH MEMORY.
L0126:	MOV	DX,OFFSET INSUF		;POINT @ NOT ENOUGH MEMORY MSG.
	JMP	L0214

L012C:	MOV	DX,OFFSET BREAK		;POINT @ MY BREAK CODE.
	MOV	AX,2523			;SET BREAK VECTOR.
	INT	21
	MOV	SI,81			;POINT @ DEFAULT DTA.
	CALL	SKPST			;SEE IF A FILE NAME WAS GIVEN.
	JNZ	L013F		;DATA @ si (DEFAULT DTA) NOT <CR>.
	JMP	L0204			;NO FILE NAME GIVEN; GO GET IT.

L013F:	CALL	NEW_X			;CHANGE EXECUTABLE FILE.
	CALL	SKPST			;SKIP OVER SPACES & <TAB>s.
	JNZ	L014F			;DATA @ si NOT <CR>.
L0147:	MOV	BYTE PTR DSTFN,' '	;SET 1st BYTE OF FILENAME=SPC.
	JMP	L0269
;
;
L014F:	CMP	AL,';'			;EXIT TO DOS?
	JZ	L0147			;YES.
	CALL	SKP_C		;NO, SKIP OVER COMMA, SPACE & <TAB>.
	MOV	AX,2904		;si NOW POINTS @ STRING TO PARSE.
	MOV	DI,OFFSET ASMFCB	;POINT @ FCB FOR .ASM FILE.
	INT	21			;PARSE.
	CMP	BYTE PTR ASMFN,' '	;1st BYTE OF FILENAME=SPC?
	JNZ	L017D			;NO.
	PUSH	SI			;YES.
	MOV	SI,OFFSET SRCFCB	;POINT @ FCB FOR EXECUTABLE.
	MOV	DI,OFFSET ASMFCB	;POINT @ FCB FOR .ASM FILE.
	MOV	CX,9
	REPZ	MOVSB			;MOVE FILENAME & PERIOD.
	MOV	SI,OFFSET ASMXTN	;POINT @ "ASM" EXTENSION.
	MOV	DI,OFFSET ASMXT		;POINT @ FCB EXTENSION.
	MOV	CX,3
	REPZ	MOVSB			;MOVE EXTENSION.
	POP	SI
L017D:	CALL	SKPST			;SKIP OVER SPACES & <TAB>s.
	JZ	L01BD			;DATA @ si IS <CR>.
	CMP	AL,';'			;EXIT TO DOS?
	JZ	L01B9			;YES.
	CALL	SKP_C		;NO, SKIP OVER COMMA, SPACE & <TAB>.
	MOV	DI,OFFSET TBLFCB	;POINT @ FCB FOR .TBL FILE.
	MOV	AX,2904		;si NOW POINTS @ STRING TO PARSE.
	INT	21			;PARSE.
	CMP	BYTE PTR TBLFN,' '	;1st BYTE OF FILENAME=SPC?
	JNZ	L01B0			;NO.
	PUSH	SI			;YES.
	MOV	SI,OFFSET SRCFCB	;POINT @ EXECUTABLE FCB.
	MOV	DI,OFFSET TBLFCB	;POINT @ FCB FOR .TBL FILE.
	MOV	CX,9
	REPZ	MOVSB			;MOVE FILENAME & PERIOD.
	MOV	SI,OFFSET TBLXTN	;POINT @ TBL EXTENSION.
	MOV	DI,OFFSET TBLXT		;POINT @ FCB EXTENSION.
	MOV	CX,3
	REPZ	MOVSB			;MOVE EXTENSION.
	POP	SI
L01B0:	CALL	SKPST			;SKIP OVER SPACES & <TAB>s.
	JZ	L01BD			;DATA @ si IS <CR>.
	CMP	AL,';'			;EXIT TO DOS?
	JNZ	L0211			;NO.
L01B9:	DEC	TODOS			;SET EXIT-TO-DOS FLAG.
L01BD:	MOV	SI,OFFSET ASMFN		;POINT @ FCB FILENAME.
	MOV	DI,OFFSET NUL_D		;POINT @ NULL DEVICE NAME.
	MOV	CX,4
	REPZ	CMPSB			;NULL DEVICE?
	JNZ	L01D1			;NO.
	CMP	BYTE PTR ASMFS,' '
	JZ	L01EB
L01D1:	CMP	BYTE PTR ASMFN,' '	;1st BYTE OF FILENAME=SPC?
	JZ	L01EB			;YES.
	MOV	BYTE PTR CHOICE,'A'	;SET TO WRITE .ASM FILE.
	MOV	SI,OFFSET ASMFCB	;POINT @ FCB FOR .ASM FILE.
	MOV	DI,OFFSET DSTFCB	;POINT @ FCB FOR DEST FILE.
	MOV	CX,24
	REPZ	MOVSB			;MOVE 36 BYTES.
	CALL	L0714			;GO PROCESS .SEQ FILE.
L01EB:	CMP	BYTE PTR TBLFN,' '	;1st BYTE OF FILENAME=SPC?
	JZ	L0226			;YES.
	MOV	BYTE PTR CHOICE,'R'	;SET TO WRITE .TBL FILE.
	MOV	SI,OFFSET TBLFCB	;POINT @ FCB FOR .TBL FILE.
	MOV	DI,OFFSET DSTFCB	;POINT @ DEST FCB.
	MOV	CX,24
	REPZ	MOVSB			;MOVE 36 BYTES.
	JMP	SHORT	L0269
;
;
L0204:	MOV	DX,OFFSET INTRO		;POINT @ INTRO MESSAGE.
	MOV	AH,9
	INT	21			;DISPLAY IT.
	CALL	GETKB			;GET KBD & DISPLAY EOL.
	JMP	SHORT	L0287
;
;
L0211:	MOV	DX,OFFSET CMDER		;POINT @ INVALID COMMAND MSG.
L0214:	MOV	SP,100
	MOV	AL,7			;BEEP.
	CALL	DI_AL			;DISPLAY THE CHARACTER IN al.
L021C:	CALL	DIEOL			;DISPLAY EOL.
	MOV	AH,9
	INT	21
L0223:	CALL	DIEOL			;DISPLAY EOL.
L0226:	TEST	BYTE PTR TODOS,0FF	;EXIT TO DOS?
	JNZ	E_O_J			;YES.
	CLD				;NO.
	MOV	SP,100
	MOV	DX,OFFSET XARQ1		;POINT @ COMMAND LINE PART 1.
	MOV	AH,9
	INT	21			;DISPLAY IT.
	MOV	SI,OFFSET SRCFCB
	CALL	DI_FN			;DISPLAY FILE NAME.
	MOV	DX,OFFSET XARQ2		;POINT @ COMMAND LINE PART 2.
	MOV	AH,9
	INT	21			;DISPLAY IT.
	CALL	GETKB			;GET KBD & DISPLAY EOL.
	CALL	SKPST			;SKIP OVER SPACES & <TAB>s.
	JZ	L0226			;DATA @ si IS <CR>.
	LODSB				;GET CHOICE OF X, A, R OR Q.
	AND	AL,5F			;CONVERT COMMAND TO UPPER CASE.
	MOV	CHOICE,AL		;SAVE CHOICE OF X, A, R OR Q.
	MOV	DI,OFFSET DSTFCB	;POINT @ DEST FCB.
	CMP	AL,'A'			;WRITE .ASM?
	JNZ	L0262			;NO.
	CALL	L053A			;YES, PARSE FILE NAME.
	CALL	L0714			;WRITE .ASM.
	JMP	SHORT	L0226

L0262:	CMP	AL,'R'			;WRITE CROSS REF?
	JNZ	L0283			;NO.
	CALL	L053A			;YES, PARSE FILE NAME.
;
;
L0269:	CMP	@PASS,2			;PASS 2?
	JZ	L0277			;YES.
	PUSH	DI
	PUSH	SI
	CALL	L071B
	POP	SI
	POP	DI
L0277:	CMP	BYTE PTR DSTFN,' '	;1st BYTE OF FILENAME=SPC?
	JZ	L0226			;YES.
	CALL	L0B4A
	JMP	SHORT	L0226

L0283:	CMP	AL,'X'			;CHANGE EXECUTABLE?
	JNZ	L028C			;NO.
L0287:	CALL	NEW_X			;CHANGE EXECUTABLE FILE.
	JMP	SHORT	L0226

L028C:	CMP	AL,'Q'			;QUIT?
	JNZ	L0211			;NO.
E_O_J:	INT	20			;END OF JOB.
;
;
BREAK:	STI
	PUSH	CS
	POP	SS
	MOV	SP,100
	PUSH	CS
	POP	DS
	PUSH	CS
	POP	ES
	CALL	DIEOL			;DISPLAY EOL.
	CALL	L064A		;OUTPUT WRITE BUFF & CLOSE FILE IF REQ.
	CMP	@PASS,2			;PASS 2?
	JZ	L02AC			;YES.
	CALL	L0572
L02AC:	MOV	DX,OFFSET E_O_L		;POINT @ EOL.
	TEST	BYTE PTR TODOS,0FF	;EXIT TO DOS?
	JNZ	E_O_J			;YES.
	JMP	L021C			;NO.
;
;
SEQ_I	DB	0,'/IAX',0,0	;THE 11 VALID SEQUENTIAL INSTRUCTIONS.
	DB	'D#$SWBC'
SWTCH	DB	'MHZBTFLERO'		;THE 10 VALID SWITCHES.
;
L02D0:	MOV	AL,0FF			;SET on CONDITION.
	MOV	DI,OFFSET SWT_O		;POINT @ FIRST TOGGLE SWITCH.
	MOV	CX,0A
	REPZ	STOSB			;SET ALL SWITCHES ON.
	MOV	SI,OFFSET MAC83		;POINT @ 1st MACRO.
L02DD:	LODSB				;DISABLE ALL MACROS.
	CMP	AL,0FF			;END OF MACROS?
	JZ	L02EC			;YES.
	CMP	AL,1			;MACRO TEXT?
	JA	L02DD			;YES.
	MOV	BYTE PTR [SI-1],0	;SET MACRO'S FLAG BYTE=ZERO.
	JMP	SHORT	L02DD		;CONTINUE UNTIL DONE.

L02EC:	PUSH	W2A17			;SAVE EXECUTABLE'S .EXT.
	PUSH	W2A19
	MOV	SI,OFFSET SEQXTN	;POINT @ SEQ EXTENSION.
	MOV	DI,OFFSET SRCXT		;POINT @ SOURCE EXTENSION.
	MOV	CX,3
	REPZ	MOVSB			;MOVE EXTENSION.
	MOV	BYTE PTR ITYPE,CL	;SET INSTR'N TYPE TO ZERO.
	CALL	OPENF			;OPEN THE .SEQ FILE.
	MOV	DI,OFFSET EOPGM
	JNB	L0314			;NO OPEN ERROR.
L030B:	POP	W2A19		;EOF OR ERROR, RESTORE EXECUTABLE .EXT.
	POP	W2A17
	RET_NEAR

L0314:	MOV	AX,SRCFS		;GET .SEQ FILE SIZE.
	MOV	FILESZ,AX		;SAVE .SEQ FILE SIZE.
	MOV	BX,5			;POINT @ SWT_T.
	XOR	CX,CX
L031F:	CALL	L04BE			;SET SWITCH IN MEMORY.
	DEC	BX			;NEXT LOWER TOGGLE SWITCH.
	JPE	L031F			;NOT DONE YET.
	MOV	WORD PTR SEQADR,CX	;CLEAR SEQ ADDRESS.
L0329:	CALL	L04D7			;GET SEQ ADDR DATA.
	JB	L030B			;ERROR OR END OF FILE (EOF).
	CALL	RNSKP	;READ NEXT SEQ BYTE, SKIPPING SPC & <TAB>.
	CMP	AL,'a'			;LESS THAN LOWER CASE "A"?
	JB	L0337			;YES.
	AND	AL,5F			;CONVERT TO UPPER CASE.
L0337:	CMP	BYTE PTR ITYPE,0FF	;SEQ REGISTER INSTR'N?
	JZ	L03B5			;GO HANDLE REGISTER INSTR'N.
	PUSH	DI
	MOV	DI,OFFSET SEQ_I	;POINT @ VALID SEQUENTIAL INSTR'NS.
	MOV	CX,0E
	REPNZ	SCASB			;LOOK @ (UP TO) 14 OF THEM.
	POP	DI
	JNZ	L03A6			;ERROR - INVALID INSTRUCTION.
	CMP	BYTE PTR ITYPE,0C0	;STRUCTURE INSTR'N?
	JNZ	L0354			;NO.
	JMP	L03EB			;GO HANDLE STRUCTURE INSTR'N.

L0354:	CMP	AL,'X'			;STRUCTURE?
	JNZ	L0360			;NO.
	MOV	BYTE PTR ITYPE,0C0	;SET STRUCTURE INSTR'N TYPE.
	JMP	L03F8
;
L0360:	CMP	AL,'/'			;TOGGLE SWITCH FOLLOWS?
	JNZ	L03D1			;NO, NOT A TOGGLE.
	CALL	SEQRD			;GET NEXT SEQ BYTE.
	CMP	AL,'a'			;LESS THAN LOWER CASE "A"?
	JB	L036D			;YES.
	AND	AL,5F			;NO, CONVERT TO UPPER CASE.
L036D:	PUSH	DI
	MOV	DI,OFFSET SWTCH		;POINT @ THE TOGGLE SWITCHES.
	MOV	CX,0A			;LOOK @ (UP TO) 10 OF THEM.
	REPNZ	SCASB
	POP	DI
	JNZ	L03A6			;ERROR - INVALID SWITCH.
	XCHG	BX,CX			;PUT SWITCH DATA IN bx.
	CALL	SEQRD			;LOOK FOR + OR -.
	CMP	BX,8			;SWT_H OR SWT_M?
	JNB	L039E			;YES, DO NOT TOGGLE THEM.
	NOT	BYTE PTR [BX+SWT_O]	;ASSUME TOGGLE.
	MOV	AH,0FF			;SET on CONDITION.
	CMP	AL,'+'			;SET ON?
	JZ	L0393			;YES.
	CMP	AL,'-'			;SET OFF?
	JNZ	L0397			;NO.
	MOV	AH,0			;SET off CONDITION.
L0393:	MOV	[BX+SWT_O],AH		;SET THE SWITCH.
L0397:	PUSH	AX
	CALL	L04BE			;SET SWITCH IN MEMORY.
	POP	AX
	JMP	SHORT	L03A3

L039E:	MOV	BYTE PTR [BX+SWT_O],0	;TURN OFF THE H OR M SWITCH.
L03A3:	JMP	L0497
;
;
L03A6:	MOV	DX,0			;SET dx TO ERROR ADDRESS.
SEQADR	EQU	$-2			;L031F, L03F8, L041D.
	MOV	DI,OFFSET ZEROH		;POINT @ "0000H" TEXT.
	CALL	DX2ASC			;CONVERT TO ASCII.
	MOV	DX,OFFSET TYPER		;POINT @ .SEQ TYPE ERROR MSG.
	JMP	L0214
;
;
L03B5:	MOV	CL,AL			;SAVE BYTE IN cl.
	CALL	SEQRD			;GET NEXT SEQ BYTE.
	AND	AL,5F			;CONVERT TO UPPER CASE.
	MOV	AH,AL			;MOVE BYTE TO ah FOR WORD SCAN.
	MOV	AL,CL			;RECOVER BYTE FROM cl.
	PUSH	DI
	MOV	DI,OFFSET REGSG		;POINT @ SEGMENT REGISTERS.
	MOV	CX,4
	REPNZ	SCASW			;LOOK @ (UP TO) 4 OF THEM.
	POP	DI
	JNZ	L03A6			;ERROR - INVALID SEG REGISTER.
	ADD	CL,10			;INDICATE THIS IS A SEG REG.
	JMP	SHORT	L03F8

L03D1:	CMP	AL,'A'			;"ASSUME" INSTRUCTION?
	JNZ	L03DB			;NO.
	DEC	BYTE PTR ITYPE	;YES, SET SEG REGISTER INSTR'N TYPE.
	JMP	SHORT	L03F8

L03DB:	CMP	AL,'I'			;"INITIAL INSTRUCTION POINTER"?
	JNZ	L03F8			;NO.
	MOV	INITIP,BX		;SET INITIAL ip ADDRESS.
	MOV	BYTE PTR IPFLG,0FF	;SET ip FLAG.
	JMP	L049B			;GO GET NEXT SEQ INSTR'N.

L03EB:	CMP	CL,1			;HANDLE STRUC INSTR'N.
	JB	L03A6			;SEQ TYPE ERROR.
	CMP	CL,8			;VALID INSTR'NS FOR STRUC?
	JA	L03A6			;SEQ TYPE ERROR.
	OR	CL,40			;INDICATE THIS IS A STRUC.
;
L03F8:	MOV	AH,4			;ENTRIES ARE 4 BYTES LONG.
	CALL	ROOMQ			;MAKE SURE THERE IS ENOUGH ROOM
	TEST	BYTE PTR ITYPE,0FF	;SEG REGISTER INSTR'N?
	JNZ	L0421			;YES.
	CMP	BX,WORD PTR SEQADR	;IS ADDR >= CURRENT SEQ ADR?
	JNB	L041D			;YES.
	PUSH	DI			;NO, SO OUT-OF-ORDER ERROR.
	MOV	DX,WORD PTR SEQADR	;GET CURRENT SEQ ADDRESS.
	MOV	DI,OFFSET ZHEOL		;POINT @ "0000H, CR, LF".
	CALL	DX2ASC			;CONVERT SEQ ADDR TO ASCII.
	MOV	DX,OFFSET ORDER		;POINT @ ADDR OUT OF ORDER MSG.
	MOV	AH,9
	INT	21			;DISPLAY IT.
	POP	DI
L041D:	MOV	WORD PTR SEQADR,BX	;SAVE CURRENT SEQ ADDRESS.
L0421:	MOV	AX,BX
	STOSW				;SET ADDRESS IN MEMORY.
	MOV	AL,CL			;cl CONTAINS SWITCH/INSTR'N #.
	STOSB				;SET INSTRUCTION.
	MOV	BX,DI			;SAVE HIGHEST ADDRESS USED.
	MOV	AL,0
	STOSB				;SET 4th BYTE TO ZERO.
	CALL	RNSKP	;GET NEXT SEQ BYTE, SKIPPING SPC & <TAB>.
	CMP	AL,';'			;SEMICOLON?
	JZ	L04A2			;YES, SKIP OVER COMMENTS.
L0433:	CMP	AL,CR			;<CR>?
	JZ	L0459			;YES.
	CMP	AL,LF			;<LF>?
	JZ	L0459			;YES.
	CMP	AL,9			;<TAB>?
	JZ	L0459			;YES.
	MOV	AH,1			;ENTRY IS 1 BYTE LONG.
	CALL	ROOMQ			;MAKE SURE THERE IS ENOUGH ROOM
	CMP	AL,'a'			;LESS THAN LOWER CASE "A"?
	JB	L044A			;YES.
	AND	AL,5F			;NO, CONVERT TO UPPER CASE.
L044A:	STOSB
	INC	BYTE PTR [BX]
	CMP	BYTE PTR [BX],7F
	JZ	L0459
	CALL	SEQRD			;GET NEXT SEQ BYTE.
	CMP	AL,' '			;SPACE?
	JNZ	L0433			;NO.
L0459:	TEST	BYTE PTR [BX],0FF
	JZ	L0497
	OR	BYTE PTR [DI-1],80	;SET THE HIGH BIT ON.
	CMP	BYTE PTR [BX],7F
	JZ	L0497
	CMP	AL,CR			;<CR>?
	JZ	L0497			;YES.
	CALL	RNSKP	;GET NEXT SEQ BYTE, SKIPPING SPC & <TAB>.
	CMP	AL,';'			;SEMICOLON?
	JZ	L04A2			;YES.
L0472:	CMP	AL,CR			;<CR>?
	JZ	L0493			;YES.
	CMP	AL,9			;<TAB>?
	JNZ	L047C			;NO.
	MOV	AL,' '			;SET TO SPACE.
L047C:	MOV	AH,1			;ENTRY IS 1 BYTE LONG.
	CALL	ROOMQ			;MAKE SURE THERE IS ENOUGH ROOM
	STOSB				;STUFF A SPACE INTO MEMORY.
	OR	BYTE PTR [BX],80	;INDICATE USER LABEL (???).
	INC	BYTE PTR [BX]
	CMP	BYTE PTR [BX],0FF
	JZ	L0493
	CALL	SEQRD			;GET NEXT SEQ BYTE.
	CMP	AL,';'			;SEMICOLON?
	JNZ	L0472			;NO.
L0493:	OR	BYTE PTR [DI-1],80	;SET THE HIGH BIT ON.
L0497:	CMP	AL,CR			;<CR>?
	JZ	L04B1			;YES.
L049B:	CALL	RNSKP	;GET NEXT SEQ BYTE, SKIPPING SPC & <TAB>.
	CMP	AL,';'			;SEMICOLON?
	JNZ	L04AD			;NO.
L04A2:	CALL	RNSKP			;SKIP OVER COMMENTS.
	CMP	AL,1A			;END OF FILE?
	JZ	L04BB			;YES, SO ERROR.
	CMP	AL,CR			;<CR>?
	JNZ	L04A2			;NO, KEEP LOOKING.
L04AD:	CMP	AL,CR			;<CR>?
	JNZ	L04BB			;NO, SO ERROR.
L04B1:	CALL	SEQRD			;GET NEXT SEQ BYTE.
	CMP	AL,LF			;<LF>?
	JNZ	L04BB			;NO, SO ERROR.
	JMP	L0329			;EOL.  GO GET NEXT LINE.

L04BB:	JMP	L03A6			;SEQ TYPE ERROR.

L04BE:	MOV	AH,4			;ENTRY LENGTH IS 4 BYTES.
	CALL	ROOMQ			;MAKE SURE THERE IS ENOUGH ROOM
	MOV	AX,CX
	STOSW				;SET SWITCH # IN MEMORY.
	MOV	AL,BL
	OR	AL,20			;INDICATE THIS IS A SWITCH.
	TEST	BYTE PTR [BX+SWT_O],0FF	;IS THE SWITCH ON?
	JZ	L04D3			;NO.
	OR	AL,10			;YES, SET THE ON BIT.
L04D3:	MOV	AH,0
	STOSW				;SET SWITCH VALUE.
	RET_NEAR

L04D7:	CALL	RNSKP			;READ 1st SEQ RECORD.
	CMP	AL,';'			;SEMICOLON?
	JNZ	L04E1			;NO.
	POP	AX			;YES, SKIP OVER COMMENTS.
	JMP	SHORT	L04A2

L04E1:	XOR	BX,BX
	CMP	AL,'&'			;AMPERSAND (LINE CONTINUATION)?
	JZ	L04EE			;YES.
	MOV	BYTE PTR ITYPE,0	;CLEAR INSTRUCTION TYPE.
	JMP	SHORT	L04F6

L04EE:	CALL	RNSKP	;GET NEXT SEQ BYTE, SKIPPING SPC & <TAB>.
	JMP	SHORT	L04F6

L04F3:	CALL	SEQRD			;GET NEXT SEQ BYTE.
L04F6:	MOV	AH,AL
	CMP	AL,'A'			;LESS THAN UPPER CASE "A"?
	JB	L04FE			;YES.
	AND	AL,5F			;NO, CONVERT TO UPPER CASE.
L04FE:	SUB	AL,'0'			;CONVERT FROM ASCII.
	JB	L0521			;OOPS.
	CMP	AL,0A			;NUMERIC?
	JB	L0508			;MAYBE.
	SUB	AL,7			;CONVERT TO HEX.
L0508:	CMP	AL,0F			;GREATER THAN HEX 0F?
	JA	L0521			;YES, SO END OF ADDR FIELD.
	MOV	CX,4
L050F:	ADD	BX,BX			;ACCUMULATE SEQ ADDRESS.
	JB	L051B			;ERROR.
	LOOP	L050F
	MOV	AH,0
	ADD	BX,AX
	JNB	L04F3			;NO ERROR.
L051B:	MOV	DX,OFFSET HEXER		;POINT @ HEX ERROR MSG.
	JMP	L0214

L0521:	CMP	AH,' '			;SPACE?
	JZ	L0539			;YES.
	CMP	AH,9			;<TAB>?
	JZ	L0539			;YES.
	AND	AH,5F			;CONVERT TO UPPER CASE.
	CMP	AH,'H'			;"H"ex APPENDED TO SEQ ADDR?
	JZ	L0539			;YES.
	CMP	AH,1A			;END OF FILE?
	STC				;SET EOF CONDTITON.
	JNZ	L051B			;NOT EOF, SO ERROR.
L0539:	RET_NEAR
;
;
L053A:	CALL	SKPST			;SKIP OVER SPACES & <TAB>s.
	JNZ	PARSE			;NOT <CR>.
	CMP	DI,OFFSET SRCFCB	;POINTED @ SOURCE FILE FCB?
	JZ	L0563			;YES.
	MOV	SI,OFFSET CON_D	;POINT @ STRING TO PARSE. (CON:)
PARSE:	MOV	AX,2901			;PARSE.
	INT	21
	OR	AL,AL			;ERROR?
	JNZ	L0558			;YES.
	CMP	BYTE PTR [DI+1],' '	;1st BYTE OF FILENAME=SPC?
	JZ	L0558			;YES, ERROR.
	RET_NEAR

L0558:	MOV	SI,DI
	CALL	DI_FN			;DISPLAY FILE NAME.
	MOV	DX,OFFSET FILER		;POINT @ FILE SPEC ERROR MSG.
	JMP	L0214
;
L0563:	MOV	BYTE PTR SRCFN,' '	;SET 1st BYTE OF FILENAME=SPC.
	JMP	L0226
;
;
NEW_X:	MOV	DI,OFFSET SRCFCB	;CHANGE EXECUTABLE FILE.
	CALL	L053A			;PARSE FILE NAME.
L0572:	MOV	HIPTR,OFFSET EOPGM	;SET HIGH MEM PTR TO EOP
	MOV	AL,0			;CLEAR THE FOLLOWING:
	MOV	BYTE PTR L0F48,AL
	MOV	BYTE PTR @PASS,1	;SET PASS 1.
	MOV	IPFLG,AL		;CLEAR THE ip FLAG.
	MOV	INITIP,100		;SET INITIAL ip.
	RET_NEAR
;
;
L058C:	MOV	DI,OFFSET WRKBF		;POINT @ WORK BUFFER.
	PUSH	CX
	PUSH	SI
	PUSH	DI
	MOV	DX,AX
	CALL	DX2ASC			;CONVERT TO ASCII.
	POP	DI
	XCHG	SI,DI
	MOV	CX,4
L059D:	LODSB
	CALL	WRTWB			;OUTPUT DATA TO WRITE BUFFER.
	LOOP	L059D
	POP	SI
	POP	CX
	RET_NEAR
;
;
L05A6:
	MOV	AX,DX
	PUSH	DI
	CALL	L058C		;CONVERT ax TO ASCII IN WORK BUFF.
	POP	DI
	RET_NEAR
;
;
L05AE:	MOV	AL,CR		;STUFF AN EOL INTO THE WRITE BUFFER.
	CALL	WRTWB			;OUTPUT DATA TO WRITE BUFFER.
	MOV	AL,LF
;THE FOLLOWING IS "CUTE" CODE.  I HATE IT.
	TEST	AX,4CB0
L05B6	EQU	$-2			;L0B3D, L100C, L1185.
;L05B6:	MOV	AL,'L'
	TEST	AX,3BB0
L05B9	EQU	$-2			;L09D5, L0A35, L1072, L1140.
;L05B9:	MOV	AL,';'			;SET al TO SEMICOLON.
	TEST	AX,9B0
L05BC	EQU	$-2	;L060F, L08C5, L097E, L09D5, L09FB, L1072, L1140, L1221
;L05BC:	MOV	AL,9			;SET al TO <TAB>.
	TEST	AX,20B0
L05BF	EQU	$-2			;L0626, L0A50, L102D.
;L05BF:	MOV	AL,' '			;SET al TO SPACE.

WRTWB:	TEST	BYTE PTR SWT_O,0FF	;IS THE .ASM OUTPUT SWITCH ON?
	JZ	L0600		;NO, SO DON'T OUTPUT TO WRITE BUFFER.
	CMP	@PASS,1			;PASS 1?
	JZ	L0600		;YES.  DON'T OUTPUT TO WRITE BUFF.
	PUSH	AX			;OUTPUT DATA TO WRITE BUFFER.
	PUSH	DI
	MOV	DI,OFFSET @COL		;GET COLUMN #.
	INC	BYTE PTR [DI]		;ACCUMULATE LENGTH.
	CMP	AL,9			;<TAB>?
	JNZ	L05E0			;NO.
	ADD	BYTE PTR [DI],7		;ADJUST COLUMN # FOR <TAB>.
	AND	BYTE PTR [DI],0F8
L05E0:	MOV	DI,WBPTR		;GET POINTER INTO WRITE BUFF.
	AND	AL,7F			;STRIP HIGH BIT FROM DATA.
	STOSB				;PUT DATA INTO WRITE BUFFER.
	CMP	DI,OFFSET EOPGM		;END OF BUFFER?
	JNZ	L05F0			;NOT YET.
	CALL	SEQWR			;WRITE BUFF & SHOW IT EMPTY.
L05F0:	MOV	WBPTR,DI		;SAVE POINTER INTO WRITE BUFF.
	INC	OUTLL		;ACCUMULATE OUTPUT FILE LENGTH.
	JNZ	L05FE			;LENGTH IS LESS THAN 64Kb.
	INC	OUTLH		;INCREMENT HIGH WORD OF LENGTH.
L05FE:	POP	DI
	POP	AX
L0600:	RET_NEAR

ASCWR:	LODSB			;OUTPUT ASCII @ si TO WRITE BUFF UNTIL
	TEST	AL,7F			;BYTE WITH HIGH BIT SET FOUND.
	JZ	L060D
	CALL	WRTWB			;OUTPUT DATA TO WRITE BUFFER.
	AND	AL,80			;CLEAR THE 7 LOW BITS.
	JZ	ASCWR			;JUMP IF HIGH BIT NOT SET.
L060D:	RET_NEAR
;
;
L060E:	PUSH	AX			;TAB OR SPACE TO COLUMN cx.
L060F:	MOV	AH,@COL			;GET COLUMN #.
	AND	AH,7
	MOV	AL,7
	SUB	AL,AH
	CBW
	CMP	CX,AX			;<TAB> OR SPACE?
	JBE	L0626			;SPACE.
	SUB	CX,AX
	CALL	L05BC	;PUT A <TAB> INTO WRITE BUFFER IF .ASM ENABLED.
	JMP	SHORT	L0629

L0626:	CALL	L05BF	;PUT SPACE INTO WRITE BUFFER IF .ASM ENABLED.
L0629:	LOOP	L060F
	POP	AX
	RET_NEAR
;
;
SEQWR:	PUSH	DX
	MOV	DX,OFFSET WRTBF		;POINT @ WRITE BUFFER.
	MOV	AH,1A
	INT	21			;SET DTA.
	XCHG	DX,DI			;SET di TO BEGINNING OF BUFF.
	MOV	DX,OFFSET DSTFCB	;POINT @ FCB.
	MOV	AH,15
	INT	21			;SEQUENTIAL WRITE.
	POP	DX
	OR	AL,AL			;ERROR?
	JNZ	L0644			;YES.
	RET_NEAR

L0644:	MOV	DX,OFFSET DSKER		;POINT @ DISK FULL MSG.
	JMP	L0214
;
;
L064A:	RET_NEAR			;BREAK, L0B43, L0B67, L0C03.
;THE ABOVE ret_near IS SET TO nop @ L0C03.
	MOV	BYTE PTR L064A,0C3	;RESTORE TO RET_NEAR.
	MOV	AL,1A			;SET al TO EOF.
	CALL	WRTWB			;OUTPUT EOF TO WRITE BUFFER.
	MOV	BX,WBPTR		;GET POINTER INTO WRITE BUFF.
	SUB	BX,OFFSET WRTBF		;CALC # BYTES IN THE BUFFER.
	PUSHF
	JZ	L0663			;WRITE NOT REQUIRED.
	CALL	SEQWR			;WRITE THE BUFFER.
L0663:	POPF
	JZ	L0677			;GO CLOSE THE FILE.
	MOV	AX,200			;SET ax=512.
	SUB	AX,BX
	JZ	L0677			;GO CLOSE THE FILE.
	SUB	DSTFS,AX		;REDUCE REMAINING FILE SIZE.
	JNB	L0677			;GO CLOSE THE FILE.
	DEC	WORD PTR DSTHI	;HANDLE HIGH WORD OF FILE LENGTH.
L0677:	MOV	DX,OFFSET DSTFCB	;POINT @ FCB TO CLOSE.
	MOV	AH,10
	INT	21			;CLOSE FILE.
	OR	AL,AL			;ERROR?
	JNZ	L06AB			;YES.
	MOV	DX,OFFSET SZMSG		;POINT @ BYTES IN FILE MSG.
	MOV	AH,9
	INT	21			;DISPLAY IT.
	MOV	DI,OFFSET WRKBF		;POINT @ WORK BUFFER.
	PUSH	DI			;SAVE POINTER TO DISPLAY DATA.
	MOV	DX,OUTLH		;GET OUTPUT FILE LENGTH (HIGH).
	OR	DX,DX			;SKIP CONVERT IF ZERO.
	JZ	L0698
	CALL	DX2ASC			;CONVERT FILE LENGTH TO ASCII.
L0698:	MOV	DX,OUTLL		;GET OUTPUT FILE LENGTH (LOW).
	CALL	DX2ASC			;CONVERT FILE LENGTH TO ASCII.
	MOV	AX,'$H'			;APPEND "H$".
	STOSW
	POP	DX		;RECOVER POINTER TO DISPLAY DATA.
	MOV	AH,9
	INT	21			;DISPLAY OUTPUT FILE LENGTH.
	JMP	SHORT	DIEOL

L06AB:	MOV	DX,OFFSET OFCER	;POINT @ CAN'T CLOSE OUTPUT FILE MSG.
	JMP	L0214
;
;
DI_FN:	PUSH	CX
	LODSB				;GET THE DRIVE #.
	CMP	AL,0			;DEFAULT DRIVE?
	JZ	L06C6			;YES.
	CMP	BYTE PTR [SI],' '	;SPACE?
	JZ	L06C6			;YES.
	OR	AL,40			;CONVERT DRIVE # TO LETTER.
	CALL	DI_AL			;DISPLAY THE DRIVE LETTER.
	MOV	AL,':'			;DISPLAY A COLON.
	CALL	DI_AL			;DISPLAY THE COLON.
L06C6:	LODSB
	MOV	CX,8			;DISPLAY THE FILE NAME.
	CMP	AL,' '			;SPACE?
	JNZ	L06D4			;NO.
	CALL	L0703			;DISPLAY A PERIOD.
	JMP	SHORT	L06EA

L06D3:	LODSB
L06D4:	CALL	L06EC
	LOOP	L06D3
	CMP	BYTE PTR [SI],' '	;SPACE?
	JZ	L06EA			;YES.
	MOV	CX,3
	CALL	L0703			;DISPLAY A PERIOD.
L06E4:	LODSB				;DISPLAY THE EXTENSION.
	CALL	L06EC
	LOOP	L06E4
L06EA:	POP	CX
	RET_NEAR

L06EC:	CMP	AL,' '			;SPACE?
	JNZ	DI_AL			;NO, DISPLAY THE CHARACTER.
	RET_NEAR
;
;
GETKB:	MOV	AH,0A			;BUFFERED KBD INPUT.
	MOV	DX,OFFSET KBDBF		;POINT @ BUFFER LEN BYTE.
	INT	21			;GET KBD.
	MOV	SI,OFFSET L296A		;POINT @ KBD DATA.
DIEOL:	MOV	AL,CR			;DISPLAY <CR>.
	CALL	DI_AL
	MOV	AL,LF			;DISPLAY <LF>.

;MORE "CUTE" CODE.
	TEST	AX,2EB0
L0703	EQU	$-2			;L06C6, L06D4.
;L0703:	MOV	AL,'.'			;SET al TO PERIOD.

DI_AL:	PUSH	AX
	PUSH	DX
	AND	AL,7F			;STRIP HIGH BIT.
	XCHG	DX,AX			;MOVE THE CHARACTER TO dl.
	MOV	AH,2
	INT	21			;DISPLAY THE CHARACTER IN dl.
	POP	DX
	POP	AX
	RET_NEAR
;
;
L0714:	CMP	@PASS,2			;PASS 2?
	JZ	L0722			;YES.
L071B:	CALL	L02D0			;GO PROCESS THE .SEQ FILE.
	MOV	ENDSEQ,DI	;SET POINTER TO 1+END OF SEQ DATA.
;
L0722:	MOV	BYTE PTR L286E,0
	MOV	BYTE PTR L1082,24	;RESTORE JUMP TO ORIGINAL.
	MOV	BX,SEQPTR
	TEST	BYTE PTR [BX],80	;IS THE HIGH BIT ON?
	JNZ	L073A			;YES.
	MOV	BYTE PTR L2888,0FF
L073A:	CALL	L0C37		;OPEN EXEC FILE; SET UP cs:ip & ss:sp.
	MOV	BYTE PTR SWT_O,0FF	;SET THE .ASM OUTPUT SWITCH ON.
	JNB	L0747			;NO OPEN ERROR.
	JMP	L0223			;OPEN ERROR.

L0747:	MOV	BP,SEQPTR
	CMP	@PASS,1			;PASS 1?
	JNZ	L075C			;NO.
	MOV	DX,OFFSET RTMSG		;POINT @ BUILDING REF TBL MSG.
	MOV	AH,9
	INT	21			;DISPLAY IT.
	JMP	SHORT	L0799
;
;
L075C:	CALL	L0E4C			;FIND END OF ???.
	CALL	L0B70	;PUT TITLE INTO WRITE BUFFER & OPEN OUTPUT FILE
	JNB	L076A			;NO ERROR.
	JMP	L0214			;ERROR.

L076A:	TEST	BYTE PTR SWT_M,0FF	;IS THE MACRO SWITCH ON?
	JZ	L0789			;NO.
	MOV	SI,OFFSET MAC83		;POINT @ 1st MACRO.
L0774:	LODSB
	CMP	AL,0FF			;END OF MACROS?
	JZ	L0789			;YES.
	CMP	AL,1			;IS THIS MACRO ENABLED?
	JNZ	L0782			;NO.
	CALL	ASCWR		;YES, PUT IT INTO THE WRITE BUFF.
	JMP	SHORT	L0774		;NEXT MACRO.

L0782:	LODSB				;FIND END OF CURRENT MACRO.
	TEST	AL,80			;IS THE HIGH BIT ON?
	JNZ	L0774			;YES, END OF MACRO FOUND.
	JMP	SHORT	L0782		;NO, KEEP LOOKING FOR END.

L0789:	MOV	SI,OFFSET RDX16		;POINT @ .RADIX 16 TEXT.
	TEST	BYTE PTR SWT_H,0FF	;APPEND "H"?
	JNZ	L0796			;YES.
	MOV	SI,OFFSET LF_CR		;POINT @ LF, CR & INIT VALUES.
L0796:	CALL	ASCWR			;WRITE TO THE BUFFER.
;
L0799:	CMP	BYTE PTR @PROG,80
	JNZ	L07A5
	MOV	BYTE PTR @PROG,0
L07A5:	MOV	SI,L2889
	CMP	SI,ENDSEQ
	JB	L07B2
L07AF:	JMP	L088F			;SEQ ADDR > cs:ip.

L07B2:	MOV	AX,CURIP		;GET THE CURRENT ip.
	CMP	AX,[SI]			;COMPARE TO SEQ ADDRESS.
	JB	L07AF			;SEQ > ip.
	MOV	CX,SI			;SAVE si.
	LODSW	;GET THE SEQ ADDR.
	LODSB	;GET THE PROGRAM POINTER.
	PUSH	AX
	LODSB
	MOV	WORD PTR L1124,SI
	AND	AL,7F			;STRIP HIGH BIT.
	MOV	AH,0
	ADD	SI,AX
	POP	AX
	MOV	L2889,SI
	CMP	AL,9			;SWITCH 9 = X, STRUCTURE?
	JNZ	L0817			;NO.
	CMP	SI,ENDSEQ
	JNB	L07FE
	TEST	BYTE PTR [SI+2],40	;STRUCTURE?
	JZ	L07FE			;NO.
	MOV	SI,CX			;RECOVER si.
	MOV	WORD PTR L0803,SI	;SET STRUCTURE POINTERS.
	MOV	WORD PTR L08E4,SI
L07E8:	ADD	SI,3
	LODSB
	AND	AL,7F			;STRIP HIGH BIT.
	MOV	AH,0
	ADD	SI,AX
	CMP	SI,ENDSEQ
	JNB	L07FE
	TEST	BYTE PTR [SI+2],40	;STRUCTURE?
	JNZ	L07E8			;YES.
L07FE:	MOV	L2889,SI
	MOV	DI,0
L0803	EQU	$-2			;L07B2, L0C3D.
	OR	DI,DI			;IS A STRUCTURE DEFINED?
	JZ	L0811			;NO, SO ERROR.
	MOV	BYTE PTR STFLG,0FF	;SET THE STRUCTURE FLAG.
	JMP	SHORT	L0888

L0811:	MOV	DX,OFFSET STRER		;POINT @ UNDEFINED STRUC MSG.
	JMP	L0214

L0817:	TEST	AL,20			;SWITCH?
	JNZ	L0851			;YES.
	CMP	AL,0A			;PROGRAM POINTER < 10?
	JB	L0866			;YES.
L081F:	CMP	SI,ENDSEQ
	JNB	L0888
	LODSW				;GET THE SEQUENTIAL ADDR.
	MOV	CX,AX
	MOV	NXTSEQ,AX		;SAVE IT.
	LODSB
	PUSH	AX
	LODSB
	AND	AL,7F			;STRIP HIGH BIT.
	MOV	AH,0
	ADD	SI,AX
	POP	AX
	SUB	AL,10
	JB	L088C
	CMP	AL,3
	JA	L088C
	SHL	AL,1
	MOV	AH,0
	MOV	BYTE PTR L1082,AH	;SET THE JUMP TO L1083.
	MOV	BX,AX
	MOV	[BX+L2823],CX
	MOV	L2889,SI
	JMP	SHORT	L081F

L0851:	MOV	BL,AL			;al=SWITCH VALUE @ L2E9E ->.
	AND	BL,0CF			;CONVERT TO BINARY.
	MOV	BH,0
	TEST	AL,10			;IS SWITCH ENABLED?
	MOV	AL,BH			;SET off CONDITION.
	JZ	L0860			;SWITCH IS NOT ENABLED.
	NOT	AL			;TOGGLE THE SWITCH.
L0860:	MOV	[BX+SWT_O],AL		;SET THE SWITCH.
	JMP	SHORT	L0888

L0866:	MOV	@PROG,AL		;SET THE PROGRAM POINTER.
	CMP	AL,6			;ROUTINE 6?
	JNZ	L0872			;NO.
	MOV	BYTE PTR @PROG,80	;YES.
L0872:	MOV	BYTE PTR STFLG,0	;CLEAR THE STRUCTURE FLAG.
	MOV	W2919,0
	MOV	BYTE PTR L2856,0
	MOV	AX,WORD PTR L0803	;MAKE SURE BOTH STRUCTURE
	MOV	WORD PTR L08E4,AX	;INDICATORS ARE THE SAME.
L0888:	LODSW			;GET SEQ ADDR OF NEXT LINE OF SEQ FILE.
	MOV	NXTSEQ,AX		;SAVE IT.
L088C:	JMP	L07A5

L088F:	XOR	AX,AX			;CLEAR THE FOLLOWING:
	MOV	WORD PTR ASCPTR,AX
	MOV	L2854,AX
	MOV	L2846,AL
	MOV	NOPRQ,AL		;CLEAR nop REQUIRED FLAG.
	MOV	EOLRQ,AL		;CLEAR EOL REQUIRED FLAG.
	CMP	@PASS,1			;PASS 1?
	JZ	L08C8			;YES.
	CALL	L1081			;TAKE THE MODIFIED JUMP.
L08AD:	TEST	BYTE PTR L2888,0FF
	JZ	L08C5
	MOV	AX,[BP+1]
	CMP	AX,CURIP
	JA	L08C5
	CALL	L0FA8
	CALL	L10A8		;PUT REST OF PRELIMS INTO WRITE BUFF.
	JZ	L08AD			;NOW DO PRELIMINARY EQUATES.
L08C5:	CALL	L05BC	;PUT A <TAB> INTO WRITE BUFFER IF .ASM ENABLED.
L08C8:	MOV	BYTE PTR ITYPE,0A	;RESTORE JUMP TO ORIGINAL.
	TEST	BYTE PTR L2856,0FF
	JNZ	L0917
	TEST	BYTE PTR STFLG,0FF	;IS THE STRUCTURE FLAG SET?
	JZ	L0917			;NO.
	TEST	W2919,0FFFF
	JNZ	L0917
	MOV	SI,0
L08E4	EQU	$-2			;L07B2, 30872, L0902.
L08E6:	LEA	SI,[SI+3]
	LODSB
	AND	AL,7F			;STRIP HIGH BIT.
	MOV	AH,0
	ADD	SI,AX
	CMP	SI,ENDSEQ
	JNB	L08FC
	TEST	BYTE PTR [SI+2],40	;STRUCTURE?
	JNZ	L0902			;YES.
L08FC:	MOV	SI,WORD PTR L0803
	JMP	SHORT	L08E6

L0902:	MOV	WORD PTR L08E4,SI
	LODSW
	MOV	W2919,AX
	LODSB				;GET THE PROGRAM POINTER.
	AND	AL,3F
	MOV	@PROG,AL		;SET THE PROGRAM POINTER.
	LODSB
	AND	AL,7F			;STRIP HIGH BIT.
	MOV	AH,0
	ADD	SI,AX
L0917:	MOV	BYTE PTR L286E,1
	MOV	DI,OFFSET WRKBF		;POINT @ WORK BUFFER.
	MOV	BYTE PTR [DI],80	;SET THE 1st BYTE TO 80.
	CALL	L165A			;SET L287C TO 80.
	MOV	BH,0
	MOV	@COL,BH			;CLEAR THE COLUMN #.
	MOV	BL,@PROG
	AND	BL,7F			;STRIP HIGH BIT.
	ADD	BX,BX			;CONVERT TO WORD OFFSET.
	CALL	WORD PTR [BX+L1BA9]	;CALL THE APPROPRIATE ROUTINE.
	MOV	AH,0BH			;DO THIS SO break WILL WORK.
	INT	21			;CHECK KBD STATUS.
	CMP	@PASS,1			;PASS 1?
	JZ	L0984			;YES.
	JMP	SHORT	L094F
ITYPE	EQU	$-1	;L02EC, L0337, L0354, L03D1, L03F8, L04E1, L08C8, L1420

	MOV	DX,0
L0946	EQU	$-2			;L0A7D, L1420, L1447.
	MOV	AX,3B09			;<TAB> SEMICOLON.
	STOSW
	CALL	DX2ASC			;CONVERT TO ASCII.
L094F:	TEST	BYTE PTR L2866,0FF
	JZ	L0963
	MOV	AL,9			;<TAB>.
	STOSB
	CALL	ORIDE			;DO SEG OVERRIDE IF NECESSARY.
	MOV	AL,9			;<TAB>.
	STOSB
	MOV	AX,'??'
	STOSW
L0963:	OR	BYTE PTR [DI-1],80	;SET THE HIGH BIT ON.
	MOV	SI,OCPTR		;GET THE OP CODE POINTER.
	AND	SI,0FFF
	ADD	SI,OFFSET CODES		;ADD IT TO THE OP CODE ADDRESS.
	CALL	ASCWR			;WRITE THE OP CODE TO THE BUFF.
	MOV	SI,OFFSET WRKBF		;SOURCE IS WORK BUFFER.
	TEST	BYTE PTR [SI],7F	;WORK BUFF CONTENTS ZERO?
	JZ	L0984			;YES, SKIP WRITING WORK BUFF.
L097E:	CALL	L05BC	;PUT A <TAB> INTO WRITE BUFFER IF .ASM ENABLED.
	CALL	ASCWR			;XFR WORK BUFF TO WRITE BUFFER.
L0984:	MOV	DI,L288D
	CMP	DI,SEQPTR
	JNB	L09AB
	MOV	AX,[DI]
	CMP	AX,CURIP
	JA	L09AB
	ADD	DI,2
	MOV	L288D,DI
	MOV	SI,OFFSET RELOC		;POINT @ ";Reloc" TEXT.
	MOV	DX,0
L09A1	EQU	$-2			;L1472.
	CALL	L0E70
	OR	BYTE PTR [DI],1		;SET THE LOW BIT.
	JMP	SHORT	L097E

L09AB:	MOV	SI,OFFSET T_S_Q	;POINT @ "<TAB>, SEMICOLON, QUOTE".
	TEST	BYTE PTR @PROG,7F
	JNZ	L09BE
	TEST	BYTE PTR [SI+3],7F
	JZ	L09BE
	CALL	ASCWR	;XFR "<TAB>, SEMICOLON, QUOTE" TO WRITE BUFF.
L09BE:	TEST	BYTE PTR SWT_O,0FF	;IS .ASM OUTPUT ENABLED?
	JNZ	L09C8			;YES.
	JMP	L0AAA

L09C8:	MOV	BYTE PTR L0A10,28	;SET COLUMN TO 40.
	TEST	WORD PTR ASCPTR,0FFFF	;IS THERE ASCII DATA TO WRITE?
	JZ	L09ED			;NO.
L09D5:	CALL	L05BC	;PUT A <TAB> INTO WRITE BUFFER IF .ASM ENABLED.
	CMP	@COL,1E			;COLUMN 30?
	JB	L09D5			;LESS, KEEP TABBING.
	CALL	L05B9	;PUT A SEMICOLON INTO WRITE BUFFER IF ENABLED.
	MOV	SI,0FFFF		;POINT @ ASCII DATA.
ASCPTR	EQU	$-2	;si POINTS @ ASCII DATA TO XFR TO WRITE BUFF.
	CALL	ASCWR			;XFR ASCII DATA TO WRITE BUFF.
	MOV	BYTE PTR L0A10,40	;SET COLUMN TO 64.
L09ED:	TEST	BYTE PTR SWT_T,0FF	;IS TRACE OUTPUT ENABLED?
	JZ	L0A6A			;NO.
	MOV	BL,@COL			;GET COLUMN #.
	AND	BL,0F8
L09FB:	ADD	BL,8			;INCREMENT TO NEXT TAB STOP.
	CALL	L05BC	;PUT A <TAB> INTO WRITE BUFFER IF .ASM ENABLED.
	CMP	BL,28			;COLUMN 40?
	JB	L09FB			;LESS, KEEP TABBING.
	MOV	WORD PTR L0A48,10	;SET TO CVT 16 BYTES TO ASCII.
	JZ	L0A35
	CMP	BL,40			;COLUMN 64 OR 40, AS SPECIFIED?
L0A10	EQU	$-1			;L09C8, L09D5.
	JB	L0A35			;LESS.
	CALL	L05AE			;OUTPUT EOL TO WRITE BUFFER.
	CALL	L05BC	;PUT A <TAB> INTO WRITE BUFFER IF .ASM ENABLED.
	CALL	L05BC			;(DO THREE OF THEM).
	CALL	L05BC
	MOV	WORD PTR L0A48,18	;SET TO CVT 24 BYTES TO ASCII.
	CMP	L2854,6
	JA	L0A35
	CALL	L05BC	;PUT A <TAB> INTO WRITE BUFFER IF .ASM ENABLED.
	CALL	L05BC			;(DO THREE OF THEM).
	CALL	L05BC
L0A35:	CALL	L05B9	;PUT A SEMICOLON INTO WRITE BUFFER IF ENABLED.
	MOV	AX,CURIP
	MOV	CX,L2854
	SUB	AX,CX
	CMP	CX,WORD PTR L0A48
	JBE	L0A4A
	MOV	CX,10			;CONVERT 16 BYTES TO ASCII.
L0A48	EQU	$-2			;L09FB, L0A10, L0A35.
L0A4A:	CALL	L058C		;CONVERT ax TO ASCII IN WORK BUFF.
	MOV	SI,OFFSET BUF24		;POINT @ 24-BYTE BUFFER.
L0A50:	CALL	L05BF	;PUT SPACE INTO WRITE BUFFER IF .ASM ENABLED.
	LODSB				;GET A BYTE FROM BUF24.
	MOV	DI,OFFSET WRKBF		;POINT @ WORK BUFFER.
	PUSH	DI
	CALL	DL2ASC	;CONVERT ax TO ASCII & STUFF INTO WORK BUFF.
	POP	DI
	XCHG	SI,DI			;SOURCE IS NOW WORK BUFFER.
	LODSB			;GET 1st BYTE FROM THE WORK BUFF.
	CALL	WRTWB			;OUTPUT DATA TO WRITE BUFFER.
	LODSB			;GET 2nd BYTE FROM THE WORK BUFF.
	CALL	WRTWB			;OUTPUT DATA TO WRITE BUFFER.
	XCHG	SI,DI			;SOURCE IS BUF24 AGAIN.
	LOOP	L0A50
L0A6A:
	CALL	L05AE			;OUTPUT EOL TO WRITE BUFFER.
	TEST	BYTE PTR NOPRQ,0FF	;IS A nop REQUIRED?
	JZ	L0A7D			;NO.
	MOV	SI,OFFSET NO_OP		;OUTPUT NOP TO WRITE BUFFER.
	CALL	ASCWR
	CALL	L05AE			;OUTPUT EOL TO WRITE BUFFER.
L0A7D:	CMP	BYTE PTR OPCDE,81	;IS PATCH83 REQUIRED?
	JNZ	L0AA0			;NO.
	CMP	WORD PTR L0946,0FF
	JNB	L0AA0
	MOV	AL,OPCD2		;GET THE 2nd OP CODE.
	AND	AL,0C3
	CMP	AL,0C3		;REGISTER INSTR'N USING bx OR di?
	JNZ	L0AA0			;NO.
	MOV	BYTE PTR MAC83,1	;YES, ENABLE PATCH83 MACRO.
	MOV	SI,OFFSET PAT83		;POINT @ PATCH83 TEXT.
	CALL	ASCWR			;OUTPUT IT TO THE WRITE BUFFER.
L0AA0:	TEST	BYTE PTR EOLRQ,0FF	;IS AN EOL REQUIRED?
	JZ	L0AAA			;NO.
	CALL	L05AE			;OUTPUT EOL TO WRITE BUFFER.
L0AAA:	TEST	FILESZ,0FFFF
	JZ	L0AB5			;DONE.
	JMP	L0799			;NOT DONE.

L0AB5:	TEST	BYTE PTR IPFLG,0FF	;IS THE ip FLAG SET?
	JNZ	L0AE3			;YES.
	MOV	DX,CDESG		;GET cs SEGMENT.
	MOV	CL,4			;MULTIPLY BY 16.
	SHL	DX,CL
	ADD	DX,CDEIP		;ADD ip OFFSET.
	MOV	WORD PTR START@,DX	;STORE START ADDRESS.
	MOV	BYTE PTR @PROG,0	;SET THE PROGRAM POINTER.
	MOV	BYTE PTR L286A,0
	MOV	BYTE PTR L2869,20
	MOV	BYTE PTR SWT_R,0FF	;ENABLE .TBL OUTPUT.
	CALL	L0EAB
L0AE3:	CMP	@PASS,1			;PASS 1?
	JZ	L0AFE			;YES, GO CLOSE THE SOURCE FILE.
	MOV	BYTE PTR SWT_O,0FF	;NO, ENABLE .ASM OUTPUT.
L0AEF:	TEST	BYTE PTR L2888,0FF
	JZ	L0AFE			;NO, GO CLOSE THE SOURCE FILE.
	CALL	L0FA8
	CALL	L10A8
	JMP	SHORT	L0AEF

L0AFE:	MOV	DX,OFFSET SRCFCB	;POINT @ FCB TO CLOSE.
	MOV	AH,10
	INT	21			;CLOSE.
	CMP	@PASS,1			;PASS 1?
	JNZ	L0B00			;NO, DONE.
	MOV	BYTE PTR @PASS,2	;SET TO PASS 2.
	CMP	CHOICE,'A'		;WRITE .ASM FILE?
	JNZ	L0B49			;NO.
	JMP	L0722			;YES.

L0B00:					;CLOSE THE SEQ HELP FILE.
	MOV	AH,3E			;THE CLOSE HANDLE FUNCTION.
	MOV	BX,HLPHD		;THE HELP FILE'S HANDLE.
	INT	21			;IGNORE ERROR.
	CMP	HLPNZ,0			;IS THE HELP FILE EMPTY?
	JNZ	L0B1B			;NO, DON'T DELETE IT.
	MOV	AH,41			;YES, DELETE IT.
	LEA	DX,HLPFN		;POINT @ HELP FILENAME.
	INT	21			;DELETE HELP FILE.

L0B1B:	CALL	L1221			;HANDLE SEGMENT ENDS.
	MOV	SI,OFFSET ENDTAB	;POINT @ "END <TAB>".
	CALL	ASCWR			;OUTPUT IT TO WRITE BUFFER.
	TEST	BYTE PTR IPFLG,0FF	;IS THE ip FLAG SET?
	JNZ	L0B43			;YES.
	MOV	DX,0
START@	EQU	$-2			;L0AB5. START ADDRESS.
	CALL	L0E70
	CALL	L1B70
	JBE	L0B3D			;GO OUTPUT AN L TO WRITE BUFF.
	CALL	ASCWR			;XFR START ADDR TO WRITE BUFF.
	JMP	SHORT	L0B43

L0B3D:	CALL	L05B6	;PUT AN L INTO WRITE BUFFER IF .ASM ENABLED.
	CALL	L05A6		;OUTPUT START ADDR TO WRITE BUFFER.
L0B43:	CALL	L05AE			;OUTPUT EOL TO WRITE BUFFER.
	CALL	L064A		;OUTPUT WRITE BUFF & CLOSE FILE IF REQ.
L0B49:	RET_NEAR
;
;
L0B4A:	MOV	BX,SEQPTR		;WRITE .TBL FILE.
	TEST	BYTE PTR [BX],80	;IS THE HIGH BIT ON?
	JNZ	L0B6F			;YES, DONE.
	MOV	BYTE PTR L2888,0FF
	MOV	BYTE PTR L0FBB,0	;RESTORE TO ORIGINAL.
	CALL	L0B70		;PUT TITLE INTO WORK BUFF & OPEN FILE.
	MOV	SI,BP
	JNB	L0B67			;NO FILE CREATION ERROR.
	JMP	L0214

L0B67:	CALL	L0FA8			;WRITE .TBL FILE.
	JZ	L0B67			;NOT DONE.
	CALL	L064A		;OUTPUT WRITE BUFF & CLOSE FILE IF REQ.
L0B6F:	RET_NEAR
;
;
L0B70:	MOV	AX,OFFSET WRTBF		;SET PTR TO BEGINNING OF BUFF.
	MOV	WBPTR,AX		;SAVE POINTER INTO WRITE BUFF.
	MOV	SI,OFFSET TYTLE		;POINT @ "TITLE".
	CALL	ASCWR		;WRITE THE ASCII TO THE WRITE BUFF.
	MOV	SI,OFFSET SRCFN		;POINT @ FCB SOURCE FILE NAME.
	MOV	CX,8
L0B82:	LODSB			;MAKE THE SOURCE FILE NAME THE TITLE.
	CMP	AL,' '			;SPACE?
	JZ	L0B8C			;YES.
	CALL	WRTWB			;OUTPUT DATA TO WRITE BUFFER.
	LOOP	L0B82
L0B8C:	MOV	DI,OFFSET WRKBF		;POINT @ WORK BUFFER.
	PUSH	DI
	MOV	AL,9			;<TAB>.
	STOSB
	MOV	DX,SRCDTE		;GET SOURCE FILE DATE.
	MOV	BX,DX
	MOV	CL,5
	SHR	BX,CL
	AND	BX,0F			;CLEAR THE NON-MONTH BITS.
	PATCH83
	CALL	L11E7		;CONVERT MONTH & PUT IN WORK BUFF.
	MOV	BX,DX
	AND	BX,1F			;CLEAR THE NON-DAY BITS.
	PATCH83
	CALL	L11E4		;CONVERT DAY & PUT IN WORK BUFF.
	MOV	BL,DH
	SHR	BX,1			;GET RID OF THE NON-YEAR BITS.
	ADD	BX,50			;ADD 80 TO YEAR.
	CALL	L11E4		;CONVERT YEAR & PUT IN WORK BUFF.
	MOV	AX,5B09			;<TAB> [.
	STOSW
	MOV	AH,2A			;GET DATE.
	INT	21
	MOV	BL,DH			;MONTH IN bl.
	MOV	BH,0
	CALL	L11E7		
	MOV	BL,DL			;DAY IN bl.
	CALL	L11E4		;CONVERT DAY & PUT IN WORK BUFF.
	MOV	BX,CX			;YEAR IN bx.
	SUB	BX,76C			;SUBTRACT 1900 FROM YEAR.
	CALL	L11E4		;CONVERT YEAR & PUT IN WORK BUFF.
	MOV	AL,']'
	STOSB
	MOV	AX,8A0DH		;<CR> <LF W/HIGH BIT SET>.
	STOSW
	POP	SI
	CALL	ASCWR			;COPY WORK BUFF TO WRITE BUFF.
	CALL	L05AE			;OUTPUT EOL TO WRITE BUFFER.
	MOV	DX,OFFSET DSTFCB	;POINT @ FCB TO OPEN.
	MOV	AH,16
	INT	21			;CREATE FILE.
	PUSH	AX			;SAVE CREATE STATUS.
	MOV	AH,DSTRV		;GET THE 1st RESERVED BYTE.
	CMP	AH,0FF
	JZ	L0C03
	MOV	DX,OFFSET WRTGF		;POINT @ WRITING MSG.
	MOV	AH,9
	INT	21			;DISPLAY IT.
	MOV	SI,OFFSET DSTFCB	;POINT @ FCB.
	CALL	DI_FN			;DISPLAY FILE NAME.
	CALL	DIEOL			;DISPLAY EOL.
L0C03:	MOV	BYTE PTR L064A,90	;CHANGE THE ret_near TO nop.
	MOV	BYTE PTR DSTCR,0	;SET CURRENT RECORD # TO ZERO.
	MOV	WORD PTR DSTRS,200	;SET RECORD SIZE TO 512 BYTES.
	MOV	BYTE PTR SWT_E,0FF	;SET THE EMBEDDED ADDR SWT ON.
	MOV	BYTE PTR SWT_O,0FF	;ENABLE .ASM OUTPUT.
	MOV	OUTLL,0			;CLEAR OUTPUT FILE LEN (LOW),
	MOV	OUTLH,0			; (HIGH).
	MOV	BP,SEQPTR
	POP	AX			;RECOVER CREATE STATUS.
L0C2E:	OR	AL,AL			;ERROR?
	JZ	L0C36			;NO.
	MOV	DX,OFFSET DIRER		;POINT @ NO ROOM IN DIR MSG.
	STC				;INDICATE ERROR.
L0C36:	RET_NEAR

L0C37:	CALL	OPENF			;OPEN THE EXEC FILE.
	JNB	L0C38			;NO ERROR.
	RET_NEAR

L0C38:					;OPEN THE SEQUENTIAL HELP FILE.
	CMP	@PASS,2			;PASS 2?
	JNZ	L0C3D			;NO, DON'T CREATE THE HELP FILE
	LEA	SI,SRCFN		;FILENAME IS EXEC FILE NAME.
	LEA	DI,HLPFN
	MOV	CX,8			;MAX OF 8 BYTES.
L0C39:
	LODSB
	CMP	AL,' '			;END OF FILE NAME?
	JZ	L0C3A			;YES.
	STOSB				;NO.
	LOOP	L0C39			;CONTINUE UNTIL END OF NAME.
L0C3A:
	LEA	SI,S_QXT		;EXTENSION IS ".S_Q".
	MOV	CX,5			;ALSO MOVE THE ZERO FOR
	REP	MOVSB			;AN ASCIZ FILE NAME.
	MOV	AH,3C			;CREATE FILE FUNCTION.
	LEA	DX,HLPFN
	INT	21
	JNB	L0C3B			;NO CREATE ERROR.
	LEA	DX,DIRER
	JMP	L0214			;ERROR.
L0C3B:
	MOV	HLPHD,AX		;SAVE HANDLE.

L0C3D:	MOV	L2889,OFFSET EOPGM
	MOV	AX,ENDSEQ
	MOV	L288D,AX
	XOR	AX,AX			;CLEAR THE FOLLOWING.
	MOV	L2866,AL
	MOV	BYTE PTR ERFLG,AL
	MOV	L2856,AL
	MOV	W2919,AX
	MOV	WORD PTR L0803,AX
	MOV	STFLG,AL		;CLEAR THE STRUCTURE FLAG.
	MOV	@PROG,AL
	MOV	L2854,AX
	CMP	@PASS,1			;PASS 1?
	JNZ	L0CD1			;NO.
	MOV	BYTE PTR L10B7,AL
	MOV	XESZH,AL		;CLEAR EXEC SIZE (HIGH).
	MOV	L2891,AX
	MOV	CDESG,AX		;SET cs:ip.
	MOV	CDEIP,100		;ip=100.
	MOV	STKSG,AX		;SET ss:sp.
	MOV	STKSP,0FFFF		;sp=FFFF.
	MOV	AX,SRCFS		;GET SOURCE FILE SIZE.
	MOV	XESZL,AX		;SET EXEC SIZE (LOW).
	MOV	DI,ENDSEQ
	CMP	WORD PTR SRCXT,'XE'	;LOOK FOR ".EXE".
	JNZ	L0CB7			;THIS IS NOT AN ".EXE" FILE.
	CMP	BYTE PTR L2A1A,'E'
	JNZ	L0CB7
	CALL	L0D5A			;HANDLE .EXE FILE TYPE.
	MOV	DI,HIPTR
	TEST	BYTE PTR IPFLG,0FF	;IS THE ip FLAG SET?
	JNZ	L0CB7			;YES.
	MOV	INITIP,0
L0CB7:	MOV	SEQPTR,DI
	MOV	BYTE PTR [DI],0C0
	MOV	AH,3			;ENTRY LENGTH IS 3 BYTES.
	CALL	ROOMQ			;MAKE SURE THERE IS ENOUGH ROOM
	MOV	AL,'A'
	STOSB
	XOR	AX,AX
	MOV	WORD PTR SEGVAL,AX	;CLEAR SEGMENT VALUE.
	STOSW
	MOV	BYTE PTR L2888,0
L0CD1:	MOV	AX,XESZL
	MOV	FILESZ,AX
	MOV	WORD PTR SRCRS,200	;SET RECORD SIZE TO 512 BYTES.
	MOV	WORD PTR SRCCB,0	;SET CURRENT BLOCK # TO ZERO.
	MOV	AL,XESZH
	MOV	SRCCR,AL		;SET CURRENT RECORD NUMBER.
	MOV	DI,OFFSET CS_IP		;POINT @ cs:ip VALUE.
	MOV	DX,CDESG		;GET THE CODE SEGMENT.
	CALL	DX2ASC			;CONVERT cs SEG TO ASCII.
	MOV	DX,CDEIP		;GET THE INSTRUCTION POINTER.
	INC	DI			;SKIP OVER THE COLON.
	CALL	DX2ASC			;CONVERT ip OFFSET TO ASCII.
	MOV	DI,OFFSET L2823
	XOR	AX,AX
	MOV	CX,4
	REPZ	STOSW			;CLEAR 4 WORDS.
	MOV	DI,OFFSET SS_SP		;POINT @ ss:sp VALUE.
	MOV	DX,STKSG		;GET THE STACK SEGMENT.
	CALL	DX2ASC			;CONVERT ss SEG TO ASCII.
	INC	DI			;SKIP OVER THE COLON.
	MOV	CL,4			;MULTIPLY BY 16.
	SHL	DX,CL
	PUSH	DX
	MOV	DX,STKSP		;GET THE STACK POINTER.
	CALL	DX2ASC			;CONVERT sp OFFSET TO ASCII.
	MOV	AX,INITIP		;SET THE CURRENT ip TO
	MOV	CURIP,AX		;THE EXEC PROG'S INITIAL ip.
	MOV	L287F,OFFSET WRTBF
	POP	AX
	PUSH	AX
	ADD	DX,AX
	TEST	BYTE PTR L10B7,0FF
	PUSHF
	JZ	L0D3D
	CALL	L0EAB
	MOV	BX,0			;POINT @ THE CORRECT OFFSET.
L0D38	EQU	$-2			;L0D3D, L0EA6.
	OR	BYTE PTR [BX],1		;SET THE LOW BIT THERE.
L0D3D:	POPF
	POP	DX
	JZ	L0D53
	CALL	L0EAB
	MOV	BX,WORD PTR L0D38	;POINT @ THE CORRECT OFFSET.
	OR	BYTE PTR [BX],1		;SET THE LOW BIT THERE.
	MOV	L2825,DX
	MOV	WORD PTR L10BE,DX
L0D53:	CLC				;INDICATE NO ERROR.
	MOV	BYTE PTR L0FBB,0
L0D59:	RET_NEAR

L0D5A:	DEC	BYTE PTR L10B7		;HANDLE .EXE FILE.
	MOV	WORD PTR SRCRS,1	;SET RECORD SIZE TO 1 BYTE.
	MOV	DX,OFFSET BUF26		;POINT @ BUFFER.
	MOV	AH,1A
	INT	21			;SET DTA.
	MOV	DX,OFFSET SRCFCB	;POINT @ FCB OF FILE TO READ.
	MOV	CX,1A			;READ 26 BLOCKS (BYTES).
	MOV	AH,27
	INT	21			;RANDOM BLOCK READ.
	OR	AL,AL			;ERROR?
	JZ	L0D7F			;NO.
	JMP	SHORT	L0DFA		;YES, ERROR.

L0D7F:	MOV	AX,HDRSZ		;GET THE .EXE HEADER SIZE/16.
	ADD	AX,1F			;ROUND UP.
	MOV	CL,5
	SHR	AX,CL
	MOV	XESZH,AL
	MOV	CL,9
	SHL	AX,CL
	XCHG	BX,AX
	MOV	AX,EXESZ		;GET THE .EXE FILE SIZE/512.
	DEC	AX			;REDUCE FOR BYTES IN LAST PAGE.
	SHL	AX,CL
	SUB	AX,BX
	MOV	BX,B_L_P		;GET # BYTES IN LAST PAGE.
	CMP	BX,4
	JNZ	L0DA5
	MOV	BX,200			;SET bx TO 512.
L0DA5:	ADD	AX,BX
	MOV	XESZL,AX
	MOV	AX,OFFRE	;GET OFFSET TO 1st RELOCATION ENTRY.
	MOV	SRCRR,AX		;SET RELATIVE RECORD #.
	TEST	@REL,0FFFF		;ANY RELOCATION ENTRIES?
	JZ	L0D59			;NO.
	MOV	DX,OFFSET BUF04		;POINT @ BUFFER.
	MOV	AH,1A
	INT	21			;SET DTA.
L0DBF:	MOV	DX,OFFSET SRCFCB	;POINT @ FCB OF FILE TO READ.
	MOV	CX,4			;READ 4 BLOCKS (BYTES).
	MOV	AH,27
	INT	21			;RANDOM BLOCK READ.
	OR	AL,AL			;ERROR?
	JNZ	L0DFA			;YES.
	MOV	BX,RELSG		;GET RELOCATION SEGMENT.
	MOV	CL,4			;MULTIPLY BY 16.
	SHL	BX,CL
	ADD	BX,BUF04		;ADD RELOCATION OFFSET.
	MOV	DI,ENDSEQ
L0DDD:	CMP	DI,HIPTR
	JNB	L0DEC
	CMP	BX,[DI]
	JBE	L0DEC
	ADD	DI,2
	JMP	SHORT	L0DDD

L0DEC:	MOV	AH,2			;ENTRY LENGTH IS 2 BYTES.
	CALL	ROOMQ			;MAKE SURE THERE IS ENOUGH ROOM
	XCHG	BX,AX
	STOSW
	DEC	@REL			;REDUCE # RELOC'N ENTRIES.
	JNZ	L0DBF			;NOT DONE YET.
	RET_NEAR

L0DFA:	MOV	DX,OFFSET RDERR		;POINT @ .EXE READ ERROR MSG.
	JMP	L0214
;
;
OPENF:	MOV	DX,OFFSET SRCFCB	;POINT @ FCB OF FILE TO OPEN.
	MOV	DI,OFFSET SRCCB		;POINT @ CURRENT BLOCK.
	MOV	CX,19
	MOV	AL,0
	REPZ	STOSB			;CLEAR 25 BYTES (REST OF FCB).
	MOV	AH,0F
	INT	21			;OPEN FILE.
	MOV	L287F,OFFSET WRTBF
	MOV	WORD PTR SRCRS,200	;SET RECORD SIZE TO 512 BYTES.
	OR	AL,AL			;OPEN ERROR?
	JZ	L0E36			;NO.
	MOV	DX,OFFSET FILEM		;POINT @ FILE MSG.
	MOV	AH,9
	INT	21			;DISPLAY IT.
	MOV	SI,OFFSET SRCFCB
	CALL	DI_FN			;DISPLAY FILE NAME.
	MOV	DX,OFFSET NF_ER		;POINT @ NOT FOUND MSG.
	MOV	AH,9
	INT	21			;DISPLAY IT.
	STC				;INDICATE ERROR.
L0E36:	RET_NEAR
;
;
SKP_C:	CALL	SKPST			;SKIP OVER SPACES & <TAB>s.
	CMP	AL,','			;COMMA?
	JNZ	L0E49			;NO.
	INC	SI
SKPST:	LODSB				;SKIP OVER SPACES & <TAB>s.
	CMP	AL,' '			;SPACE?
	JZ	SKPST			;YES.
	CMP	AL,9			;<TAB>?
	JZ	SKPST			;YES.
	DEC	SI			;RESET POINTER TO 1st BYTE.
L0E49:	CMP	AL,CR			;<CR>?
	RET_NEAR
;
;
L0E4C:	MOV	SI,SEQPTR
L0E50:	MOV	DL,0
	TEST	BYTE PTR [SI],80	;IS THE HIGH BIT ON?
	JZ	L0E58			;NO.
	RET_NEAR

L0E58:	MOV	BX,SI
L0E5A:	ADD	SI,3
	MOV	AL,[SI]
	TEST	AL,0C0
	JNZ	L0E67
	OR	DL,AL
	JMP	SHORT	L0E5A

L0E67:	OR	DL,DL
	JNZ	L0E50
	OR	BYTE PTR [BX],20
	JMP	SHORT	L0E50

L0E70:
	MOV	DI,OFFSET BU128		;POINT @ 128-BYTE BUFFER.
	CMP	L2891,40
	JB	L0E88
	MOV	CX,20			;LOOK @ (UP TO) 32 ENTRIES.
	JMP	SHORT	L0E82

L0E7F:	ADD	DI,4
L0E82:	CMP	DX,[DI]
	JZ	L0E8F
	JNB	L0E8D
L0E88:	SUB	DI,4
	JMP	SHORT	L0E8F

L0E8D:	LOOPNZ	L0E7F
L0E8F:	MOV	DI,[DI+2]
	JMP	SHORT	L0E97

L0E94:	ADD	DI,3
L0E97:	MOV	AL,[DI]
	TEST	AL,0C0
	JZ	L0E94
	TEST	AL,80			;IS THE HIGH BIT ON?
	JNZ	L0EA6			;YES.
	CMP	DX,[DI+1]
	JA	L0E94
L0EA6:	MOV	WORD PTR L0D38,DI
	RET_NEAR
;
;
L0EAB:	CMP	@PASS,1			;PASS 1?
	JNZ	L0EA6			;NO.
	TEST	BYTE PTR SWT_R,0FF	;YES, IS .TBL OUTPUT ENABLED?
	JZ	L0EA6			;NO.
	PUSH	DI		;SAVE THE POINTER TO THE WORK BUFF.
	MOV	BX,CURIP
	TEST	BYTE PTR @PROG,7F
	JNZ	L0EC9
	SUB	BX,L2854
L0EC9:	CALL	L0E70
	JZ	L0EE4
	INC	L2891
	MOV	AH,6			;ENTRY IS 6 BYTES LONG.
	CALL	ENUFQ			;MAKE SURE THERE IS ENOUGH ROOM
	JB	L0EF8			;THERE ISN'T.
	MOV	BYTE PTR [DI],40
	MOV	[DI+1],DX
	ADD	DI,3
	JMP	SHORT	L0F0C

L0EE4:	ADD	DI,3
	TEST	BYTE PTR [DI],0C0
	JNZ	L0EF1
	CMP	BX,[DI+1]
	JNB	L0EE4
L0EF1:	MOV	AH,3			;ENTRY IS 3 BYTES LONG.
	CALL	ENUFQ			;MAKE SURE THERE IS ENOUGH ROOM
	JNB	L0F0C			;THERE IS.
L0EF8:	MOV	AL,0			;FLAG - ERROR ALREADY DISPLAYED
ERFLG	EQU	$-1			;L0C3D, L0EF8.
	OR	AL,AL			;IS ERROR FLAG SET?
	JNZ	L0F6A			;YES, DON'T REPEAT ERROR MESG.
	PUSH	DX
	MOV	DX,OFFSET INCER		;POINT @ REF TBL INCOMPLETE MSG
	MOV	AH,9
	MOV	BYTE PTR ERFLG,AH	;SET ERROR FLAG.
	INT	21			;DISPLAY ERROR MESSAGE.
	JMP	SHORT	L0F69

L0F0C:	MOV	AL,L286A
	MOV	CL,4			;DIVIDE BY 16.
	SHR	AL,CL
	MOV	CL,30	;'0'
	AND	CL,L2869
	OR	AL,CL
	TEST	BYTE PTR @PROG,7F
	JZ	L0F24
	MOV	AL,0
L0F24:	MOV	[DI],AL
	MOV	[DI+1],BX
	MOV	BYTE PTR L2888,0FF
	TEST	WORD PTR L2891,3F
	JNZ	L0F6A
	MOV	SI,SEQPTR
	MOV	DI,OFFSET BU128		;POINT @ 128-BYTE BUFFER.
	PUSH	DX
	PUSH	BX
	MOV	BL,20			;SET FOR 32 ENTRIES.
	MOV	CL,5
	MOV	DX,L2891
	MOV	AL,0
L0F48	EQU	$-1			;L0572, L0F24.
	CMP	AL,DL
	JZ	L0F68
	MOV	BYTE PTR L0F48,DL
	SHR	DX,CL
L0F53:	MOV	CX,DX
	MOV	AX,SI
	INC	SI
	MOVSW
	STOSW
L0F5A:	ADD	SI,3
	TEST	BYTE PTR [SI],0C0
	JZ	L0F5A
	LOOP	L0F5A
	DEC	BL			;REDUCE # ENTRIES.
	JNZ	L0F53			;NOT DONE YET.
L0F68:	POP	BX
L0F69:	POP	DX
L0F6A:	POP	DI
	RET_NEAR
;
;
ROOMQ:	CALL	ENUFQ		;MAKE SURE THERE IS ENOUGH MEMORY.
	JNB	L0F75			;THERE IS.
	POP	AX		;RESTORE STACK FOR NO RET FROM CALL.
	JMP	L0126

L0F75:	RET_NEAR			;THERE WAS ENOUGH MEMORY.

ENUFQ:	PUSH	DI
	PUSH	SI
	PUSH	CX
	PUSH	AX
	MOV	AL,AH			;MOVE # BYTES REQUIRED TO al.
	MOV	AH,0
	MOV	CX,HIPTR
	MOV	SI,CX
	SUB	CX,DI
	INC	CX
	MOV	DI,SI
	ADD	DI,AX
	CMP	DI,OFFSET EOPGM
	JB	L0F97
	CMP	MEMSZ,DI		;END OF AVAILABLE MEMORY?
	JNB	L0F9A			;NO.
L0F97:	STC				;YES, INDICATE ERROR.
	JMP	SHORT	L0FA3

L0F9A:	MOV	HIPTR,DI		;SAVE HIGHEST MEMORY USED.
	STD
	REPZ	MOVSB
	CLD
	CLC				;INDICATE NO ERROR.
L0FA3:	POP	AX
	POP	CX
	POP	SI
	POP	DI
L0FA7:	RET_NEAR
;
;
L0FA8:	TEST	BYTE PTR L2888,0FF	;WRITE .TBL FILE.
	JZ	L0FA7
	MOV	DI,BP
	MOV	AL,[DI]
	AND	AL,1			;CLEAR THE HIGH 7 BITS.
	MOV	BYTE PTR L10AB,AL
	JZ	L0FC3
	MOV	AL,0
L0FBB	EQU	$-1			;L0B4A, L0D53, L10DF.
	OR	AL,AL			;END OF S0000?
	JZ	L0FC3			;NO.
	CALL	L1221			;HANDLE SEGMENT ENDS.
L0FC3:	PUSH	[DI+1]
	MOV	SI,BP
	MOV	BYTE PTR L2863,0
	MOV	AL,SWT_O		;GET THE .ASM OUTPUT SWITCH.
	PUSH	AX			;SAVE IT.
	OR	AL,AL			;IS .ASM OUTPUT ENABLED?
	JZ	L0FD8			;NO.
	MOV	AL,SWT_E		;GET THE EMBEDDED ADDR SWITCH.
L0FD8:	MOV	SWT_O,AL		;SET THE .ASM OUTPUT SWITCH.
	CALL	L1067	;PUT 6 <TAB>s & SEMICOLON INTO WRITE BUFF.
	XOR	CX,CX
L0FE0:	INC	L2863
	MOV	AL,L2863
	MOV	BX,8			;START IN COLUMN 8.
	CMP	CHOICE,'A'		;WRITE .ASM FILE?
	JNZ	L0FF4			;NO.
	INC	AL
	INC	BX			;NEXT COLUMN.
L0FF4:	OR	CX,CX
	JZ	L100C
	CMP	AL,9
	JBE	L1009
	CALL	L05AE			;OUTPUT EOL TO WRITE BUFFER.
	CALL	L1067	;PUT 6 <TAB>s & SEMICOLON INTO WRITE BUFF.
	MOV	BYTE PTR L2863,2
	MOV	CX,BX			;SPECIFY COLUMN #.
L1009:	CALL	L060E			;TAB OR SPACE TO COLUMN cx.
L100C:	CMP	CHOICE,'A'		;WRITE .ASM FILE?
	JNZ	L1016			;NO.
	CALL	L05B6	;PUT AN L INTO WRITE BUFFER IF .ASM ENABLED.
L1016:	LODSB
	LODSW
	CALL	L058C		;CONVERT ax TO ASCII IN WORK BUFF.
	MOV	CX,4
	MOV	AL,[SI-3]
	TEST	AL,40
	JZ	L102D
	TEST	AL,1
	JZ	L104D
	MOV	AL,'S'			;MOVE "S" TO WRITE BUFFER.
	JMP	SHORT	L1049

L102D:	PUSH	AX
	CALL	L05BF	;PUT SPACE INTO WRITE BUFFER IF .ASM ENABLED.
	POP	AX
	MOV	CL,4			;DIVIDE BY 16.
	SHR	AL,CL
	AND	AL,3			;THE TABLE HAS 4 ENTRIES.
	MOV	BX,OFFSET SGTBL		;POINT @ SEGMENT TYPE TABLE.
	XLAT				;GET THE SEGMENT FOR .REF FILE.
	CALL	WRTWB			;OUTPUT DATA TO WRITE BUFFER.
	DEC	CX
	MOV	AL,[SI-3]
	AND	AL,0F			;THE TABLE HAS 9 ENTRIES.
	MOV	BX,OFFSET RTTBL		;POINT @ REF TYPE TABLE.
	XLAT				;GET THE REF TYPE FOR .REF FILE
L1049:	CALL	WRTWB			;OUTPUT DATA TO WRITE BUFFER.
	DEC	CX
L104D:	CMP	BYTE PTR [SI],3F
	JBE	L0FE0
	CALL	L05AE			;OUTPUT EOL TO WRITE BUFFER.
	POP	AX		;RECOVER THE .ASM SWITCH (L0FC3).
	MOV	SWT_O,AL		;SET THE .ASM OUTPUT SWITCH.
	MOV	BP,SI
	LODSB
	TEST	AL,80			;IS THE HIGH BIT ON?
	JZ	L1065			;NO.
	MOV	BYTE PTR L2888,0
L1065:	POP	DX
	RET_NEAR
;
;
L1067:	CMP	CHOICE,'A'		;WRITE .ASM FILE?
	JNZ	L107B			;NO.
	PUSH	CX
	MOV	CX,6			;ENTER 6 <TAB>s INTO WRITE BUFF
L1072:	CALL	L05BC	;PUT A <TAB> INTO WRITE BUFFER IF .ASM ENABLED.
	LOOP	L1072
	POP	CX
	JMP	L05B9	;PUT A SEMICOLON INTO WRITE BUFFER AND RETURN.

L107B:	MOV	BYTE PTR @COL,0		;CLEAR THE COLUMN #.
	RET_NEAR
;
;
L1081:	JMP	SHORT	L10A7
L1082	EQU	$-1			;L0722, L081F, L1083.
;
L1083:	MOV	BYTE PTR L1082,24	;RESTORE THE JUMP TO ORIGINAL.
	PUSH	DI			;HANDLE ASSUMES.
	PUSH	DX
	MOV	SI,OFFSET L2823
	MOV	DI,OFFSET ASSU1		;POINT @ DEFAULT ASSUMES PART 1
	MOV	CX,4			;DO 4 SEGMENTS.
L1093:	PUSH	CX
	LODSW
	XCHG	DX,AX
	CALL	DX2ASC			;CONVERT TO ASCII.
	POP	CX
	ADD	DI,6			;NEXT SEGMENT DATA OFFSET.
	LOOP	L1093
	MOV	SI,OFFSET ASSUM		;POINT @ DEFAULT ASSUMES.
	CALL	ASCWR			;XFR ASSUMES TO WRITE BUFFER.
	POP	DX
	POP	DI
L10A7:	RET_NEAR
;
;
L10A8:	PUSH	DX		;DO 1st SEG, ASSUMES, ORG (IF NEEDED) &
	PUSHF				;EQUATES.
	MOV	AL,0
L10AB	EQU	$-1			;L0FA8.
	TEST	AL,1
	JZ	L110E
	MOV	WORD PTR EOL_H,8A0DH	;<CR> <LF W/HIGH BIT SET>.
	MOV	AL,0
L10B7	EQU	$-1			;L0C3D, L0CD1, L0D5A.
	OR	AL,AL
	JZ	L10C8
	CMP	DX,8888
L10BE	EQU	$-2			;L0D3D.
	JNZ	L10C8
	MOV	WORD PTR EOL_H,'  '	;2 SPACES.
L10C8:	MOV	AL,'S'
	CALL	WRTWB			;OUTPUT DATA TO WRITE BUFFER.
	MOV	WORD PTR SEGVAL,DX	;SAVE SEGMENT VALUE.
	CALL	L05A6			;OUTPUT SEG VALUE TO WRITE BUFF
	MOV	SI,OFFSET T_SEG		;POINT @ "<TAB> SEGMENT".
	CALL	ASCWR			;XFR TO WRITE BUFFER.
	MOV	WORD PTR EOL_H,8A0DH	;<CR> <LF W/HIGH BIT SET>.
	MOV	BYTE PTR L0FBB,0FF
	TEST	BYTE PTR @PROG,7F
	JNZ	L10EF
	CALL	L1083			;HANDLE ASSUMES.
L10EF:	OR	DX,DX			;IS AN ORIGIN REQUIRED?
	JNZ	L110E			;NO.
	MOV	AX,INITIP		;GET INITIAL ip.
	OR	AX,AX			;IS IT ZERO?
	JZ	L110E			;YES, NO ORIGIN IS REQUIRED.
	PUSH	DX
	XCHG	DX,AX			;CHANGE ORIGIN.
	MOV	SI,OFFSET ORIGN		;POINT @ ORIGIN.
	CALL	ASCWR			;XFR TO WRITE BUFFER.
	CALL	L05A6			;OUTPUT ORIGIN TO WRITE BUFFER.
	MOV	AL,'H'			;APPEND "H".
	CALL	WRTWB			;OUTPUT TO WRITE BUFFER.
	CALL	L05AE			;OUTPUT EOL TO WRITE BUFFER.
	POP	DX
L110E:	MOV	AX,CURIP
	TEST	FILESZ,0FFFF
	JZ	L111D
	CMP	AX,DX			;ARE ORIGIN & CURRENT ip EQUAL?
	JZ	L1122			;YES.
L111D:	CALL	L119B
	JMP	SHORT	L1198		;DONE.

L1122:	PUSH	SI
	MOV	SI,0
L1124	EQU	$-2			;L07B2, L119B.
	CMP	DX,[SI-4]
	JNZ	L1185
	TEST	BYTE PTR [SI-1],0FF
	JZ	L1185
	PUSH	DX
	MOV	DL,[SI-1]
	TEST	DL,80			;IS THE HIGH BIT ON?
	JZ	L1150			;NO.
	PUSH	SI
	XOR	DX,DX			;CLEAR THE COUNTER.
L113D:	LODSB
	INC	DX			;COUNT IN dx.
	TEST	AL,80			;IS THE HIGH BIT ON?
	JZ	L113D			;NO.
	CALL	L05B9	;PUT A SEMICOLON INTO WRITE BUFFER IF ENABLED.
	CALL	L05BC	;PUT A <TAB> INTO WRITE BUFFER IF .ASM ENABLED.
	CALL	ASCWR
	CALL	L05AE			;OUTPUT EOL TO WRITE BUFFER.
	POP	SI
L1150:	CMP	BYTE PTR [SI],0AE	;(PERIOD W/HIGH BIT SET)
	JZ	L1184
	POP	AX
	CALL	ASCWR
	TEST	BYTE PTR @PROG,0F
	JNZ	L1167
	INC	DL
	MOV	AL,':'			;COLON.
	CALL	WRTWB			;OUTPUT TO WRITE BUFFER.
L1167:	CMP	DL,7
	JBE	L1181
	TEST	BYTE PTR @PROG,0F
	JZ	L117E
	MOV	SI,OFFSET TEQUT		;POINT @ "<TAB> EQU <TAB>".
	CALL	ASCWR			;XFR TO WRITE BUFFER.
	MOV	AL,'$'			;DOLLAR SIGN.
	CALL	WRTWB			;OUTPUT TO WRITE BUFFER.
L117E:	CALL	L05AE			;OUTPUT EOL TO WRITE BUFFER.
L1181:	POP	SI
	JMP	SHORT	L1198		;DONE.

L1184:	POP	DX
L1185:	POP	SI
	CALL	L05B6	;PUT AN L INTO WRITE BUFFER IF .ASM ENABLED.
	CALL	L05A6			;CONVERT HEX OFFSET TO ASCII.
	TEST	BYTE PTR @PROG,0F
	JNZ	L1198
	MOV	AL,':'			;COLON.
	CALL	WRTWB			;COLON TO WRITE BUFF.
	CALL	L05AE			;EOL AFTER LABEL.
L1198:	POPF
	POP	DX
	RET_NEAR
;
;
L119B:	PUSH	DX			;HANDLE EQUATES.
	MOV	DI,OFFSET WRKBF		;POINT @ WORK BUFFER.
	PUSH	DI
	PUSH	AX
	MOV	SI,WORD PTR L1124
	CMP	DX,[SI-4]
	JNZ	L11B5
	TEST	BYTE PTR [SI-1],0FF
	JZ	L11B5
	CALL	L18A4			;XFR ASCII @ si TO WORK BUFF.
	JMP	SHORT	L11BB

L11B5:	MOV	AL,'L'
	STOSB
	CALL	DX2ASC			;CONVERT OFFSET TO ASCII.
L11BB:	MOV	SI,OFFSET TEQUT		;POINT @ "<TAB> EQU <TAB>".
	CALL	L18A4			;XFR IT TO WORK BUFF.
	POP	AX
	SUB	AX,DX
L11C4:	XCHG	DX,AX
	MOV	AL,'$'
	MOV	AH,'-'
	OR	DH,DH
	JNS	L11D1
	MOV	AH,'+'
	NEG	DX
L11D1:	STOSW
	CALL	L1345
	CALL	L136C
	MOV	BYTE PTR [DI],0
	POP	SI
	CALL	ASCWR
	CALL	L05AE			;OUTPUT EOL TO WRITE BUFFER.
	POP	DX
	RET_NEAR
;
;
L11E4:	MOV	AL,'-'			;PUT A DASH INTO WRITE BUFF.
	STOSB
L11E7:	PUSH	CX			;COUNT 10,000's IN AL AND
	PUSH	SI			;CONVERT TO ASCII, THEN
	MOV	SI,OFFSET L1215		;COUNT 1,000'S, 100's, TENS
	MOV	CX,5			;AND ONES UNTIL CONVERSION
L11EF:	MOV	AL,0			;IS COMPLETE.
	ADD	SI,2			;POINT @ DECIMAL DATA.
L11F4:	SUB	BX,[SI]			;SUBTRACT DECIMAL AMOUNT.
	JB	L11FC			;NO MORE OF THIS AMOUNT.
	INC	AL			;COUNT IN al.
	JMP	SHORT	L11F4		;REPEAT FOR THIS DECIMAL AMT.

L11FC:	ADD	BX,[SI]			;RESTORE bx.
	OR	AL,'0'			;CONVERT NUMBER TO ASCII.
	OR	CH,CH
	JNZ	L1208
	TEST	AL,0F			;DON'T OUTPUT IF ZERO.
	JZ	L120B
L1208:	STOSB				;OUTPUT NON-ZERO DATA.
	INC	CH
L120B:	DEC	CL
	JNZ	L11EF
	OR	CH,CH
	JNZ	L1214
	STOSB
L1214:	POP	SI
L1215:	POP	CX
	RET_NEAR
	DW	2710,3E8,64,0A,1	;10000, 1000, 100, 10 & 1.
;
;
L1221:	PUSH	DX			;HANDLE SEGMENT ENDS.
	MOV	DX,0			;GET SEGMENT VALUE.
SEGVAL	EQU	$-2			;L0CB7, L10C8.
	CALL	L05BC	;PUT A <TAB> INTO WRITE BUFFER IF .ASM ENABLED.
	MOV	AL,'S'
	CALL	WRTWB			;OUTPUT TO WRITE BUFFER.
	CALL	L05A6			;OUTPUT "Snnnn" TO WRITE BUFF.
	MOV	SI,OFFSET ENDSG		;POINT @ "ENDS <CR> <LF>".
	CALL	ASCWR			;XFR SEGMENT ENDS TO WRITE BUFF
	POP	DX
	RET_NEAR
;
;
RNSKP:	CALL	SEQRD			;GET NEXT SEQ BYTE.
	CMP	AL,' '			;SPACE?
	JZ	RNSKP			;YES.
	CMP	AL,9			;<TAB>?
	JZ	RNSKP			;YES.
	RET_NEAR
;
;
WRHLP:					;WRITE SEQ HELP FILE.
	PUSH	AX
	PUSH	BX
	PUSH	CX
	MOV	AH,40			;WRITE FUNCTION.
	MOV	BX,HLPHD		;HELP FILE'S HANDLE.
	MOV	CX,8			;WRITE 8 BYTES.
	INT	21
	JB	WRBAD			;ERROR.
	CMP	AX,CX			;# BYTES WRITTEN = # REQUESTED?
	JNZ	WRBAD			;NO, SO ERROR.
	OR	HLPNZ,1			;INDICATE FILE NOT EMPTY.
	POP	CX
	POP	BX
	POP	AX
	RET_NEAR
WRBAD:
	LEA	DX,DSKER
	JMP	L0214			;ERROR ABORT.
;
;
L1250:	TEST	BYTE PTR L2866,0FF
	JZ	L125A
	JMP	ERHDL

L125A:	MOV	L2866,AL
	SHL	AL,1
	NOT	AL
	AND	AL,'0'
	MOV	L2869,AL
	JMP	SHORT	L1277
;
PRECD:				;HANDLE "PRECEEDING" CODES: lock & rep.
	MOV	SI,OCPTR		;GET THE OP CODE POINTER.
	AND	SI,0FFF			;CLEAR THE HIGH NIBBLE.
	ADD	SI,OFFSET CODES		;POINT @ CORRECT OP CODE.
	CALL	ASCWR			;XFR IT TO THE WRITE BUFFER.
L1277:	CALL	SEQRD			;READ EXECUTABLE FILE.
	MOV	AH,0			;CLEAR ah.
	MOV	BX,AX
	MOV	OPCDE,AL		;SAVE OP CODE.
	ADD	BX,BX		;CONVERT OP CODE TO DWORD OFFSET.
	ADD	BX,BX
	ADD	BX,OFFSET L1BC0	;POINT @ CORRECT OFFSET IN OP CODE TBL.
	MOV	CX,[BX]			;GET OP CODE POINTER.
	MOV	OCPTR,CX		;SAVE IT.
	MOV	DH,0F0
	AND	DH,CH
	MOV	L286A,DH
	MOV	DI,OFFSET WRKBF		;POINT @ WORK BUFFER.
	MOV	BX,[BX+2]	;GET PTR TO ROUTINE THAT HANDLES THIS OP CODE.
	TEST	BYTE PTR L2866,0FF
	JNZ	L12AD
	MOV	L2869,BH
L12AD:	AND	BH,0F			;CLEAR THE HIGH NIBBLE.
	ADD	BX,L288B	;ADD OFFSET OF 1st ROUTINE. (L1250).
	XCHG	CX,BX			;OP CODE POINTER IS NOW IN bx.
	JMP	CX			;GO TO THE APPROPRIATE ROUTINE.
;
;
L12B8:					;HANDLE OP CODES 80, 81 & 82.
	CALL	L17E6
L12BB:	CALL	L18B0
	JMP	SHORT	L1322
;
;
CDE83:					;HANDLE OP CODE 83.
	CALL	L17E6
	CALL	L18B0
	MOV	AL,','			;COMMA.
	STOSB
	CALL	SEQRD			;GET NEXT BYTE FROM EXEC FILE.
	CBW
	XCHG	DX,AX
	MOV	BYTE PTR L286A,0
	CALL	L1420
	CALL	L13CB
	OR	DH,DH
	JNZ	L12DE
	RET_NEAR

L12DE:	DEC	DI
	CMP	BYTE PTR [DI-1],','	;COMMA?
	JNZ	L12DE			;NO.
	NEG	DX
	MOV	AL,'-'
	STOSB
	JMP	SHORT	L1345
;
;
LDSES:					;HANDLE lds & les.
	CALL	DECODE			;DECODE 2nd OP CODE.
	MOV	AL,REGCD		;GET THE reg CODE.
	CALL	GPR16		;GET THE CORRECT GENERAL PURPOSE REG.
	MOV	AL,','			;COMMA.
	STOSB
	OR	BYTE PTR HLPBW,2	;SAY THIS IS A WORD REF.
	MOV	SI,OFFSET DWPTR		;POINT @ "DWORD PTR".
	CALL	L18A4			;XFR IT TO THE WORK BUFF.
	JMP	L18BA		;GO HANDLE reg/mem FINAL OPERAND.
;
;
L12FF:					;HANDLE mov	???
	CALL	DECODE			;DECODE 2nd OP CODE.
	OR	AL,AL
	JZ	L12BB
	JMP	L17FE
;
;
R_N_P:					;HANDLE ret_near_pop.
	MOV	BX,OFFSET MACNP		;POINT @ RET NEAR POP MACRO.
	JMP	SHORT	L1311		;ENABLE IT.

R_F_P:					;HANDLE ret_far_pop.
	MOV	BX,OFFSET MACFP		;POINT @ RET FAR POP MACRO.
L1311:	MOV	BYTE PTR [BX],1		;ENABLE THE MACRO.
	CALL	L1B10	;LOAD dx WITH NEXT 2 BYTES OF EXEC FILE.
	INC	EOLRQ			;SET EOL REQUIRED FLAG.
	JMP	SHORT	L1342
;
;
ALXIM:					;HANDLE code	accum,immed.
	MOV	AL,0			;USE accum.
L131F:	CALL	L1554		;GO MOVE CORRECT REG TO WORK BUFF.
L1322:	MOV	AL,','			;COMMA.
	STOSB				;PUT IT IN THE WORK BUFFER.
	TEST	BYTE PTR OPCDE,1	;IS THE WORD BIT SET?
	JZ	L132F			;NO.
	JMP	L13C3			;YES.

L132F:	CALL	SEQRD			;GET BYTE-SIZE IMMEDIATE VALUE.
L1332:	MOV	BYTE PTR L286A,0
L1337:	MOV	AH,0
	MOV	DX,AX
	TEST	BYTE PTR SWT_B,0FF	;BYTE REFERENCES?
	JZ	L1345			;NO.
L1342:	CALL	L0EAB
L1345:	OR	DX,DX			;IS IMMED VALUE ZERO?
	JZ	IMZER			;YES.
	CALL	L138A		;NO, CONVERT IMMED VALUE TO ASCII.
	CMP	DX,0A			;NUMERIC?
	JB	L1385			;YES.
	MOV	AL,DL			;NO.
	CALL	L1A7D			;ALPHABETIC?
	JNB	L136C			;NO.
	PUSH	DI			;YES, SO PUT IT IN QUOTES.
	MOV	DI,OFFSET L287C
	MOV	AH,27			;SINGLE QUOTE.
	CMP	AL,AH		;IS THE QUOTED BYTE A SINGLE QUOTE?
	JNZ	L1364			;NO.
	MOV	AH,22			;YES, SO USE DOUBLE QUOTE.
L1364:	MOV	[DI-1],AH
	OR	AH,80			;SET THE HIGH BIT ON.
	STOSW				;OUTPUT DATA & END QUOTE.
	POP	DI
L136C:	MOV	AL,[DI-1]
	CMP	AL,'H'			;HEX SPECIFIED?
	JZ	L1385			;YES.
	TEST	BYTE PTR SWT_H,0FF	;APPEND "H"?
	JZ	L1382			;NO.
	CMP	AL,'B'			;BINARY?
	JZ	L1382			;YES.
	CMP	AL,'D'			;DECIMAL?
	JNZ	L1385			;NO.
L1382:	MOV	AL,'H'			;SPECIFY HEX.
	STOSB
L1385:	RET_NEAR

IMZER:	MOV	AL,'0'			;ZERO.
	STOSB
	RET_NEAR

L138A:	MOV	BYTE PTR L13C2,0
	MOV	AL,DH
	CALL	L1396
	MOV	AL,DL
L1396:	MOV	AH,AL
	MOV	CL,4
	SHR	AL,CL			;DIVIDE BY 16.
	CALL	L13A1
	MOV	AL,AH
L13A1:	AND	AL,0F
	TEST	BYTE PTR L13C2,0FF
	JNZ	L13BA
	OR	AL,AL
	JNZ	L13AF
	RET_NEAR

L13AF:	MOV	L13C2,AL
	CMP	AL,0A
	JB	L13BA
	MOV	BYTE PTR [DI],'0'
	INC	DI
L13BA:	ADD	AL,90			;ADD 144.
	DAA
	ADC	AL,40			;ADD 64, NOW + 128.
	DAA
	STOSB				;STUFF ASCII INTO MEMORY @ di.
L13C1:	RET_NEAR
;
;
L13C2	DB	0			;L138A, L13A1, L13AF.
L13C3:					;HANDLE WORD-SIZE IMMED VALUE.
	MOV	BYTE PTR L286A,0
	CALL	L141D
L13CB:	MOV	AL,DL
	CALL	L1A7D
	JNB	L13C1
	MOV	AL,DH
	CALL	L1A7D
	JNB	L13C1
	MOV	AH,DL
	PUSH	DI
	PUSH	BX
	MOV	DI,OFFSET L287C
	MOV	BL,27			;SINGLE QUOTE.
	CMP	AL,BL			;IS LOW BYTE A SINGLE QUOTE?
	JZ	L13EA			;YES, SO USE A DOUBE QUOTE.
	CMP	AH,BL			;IS HIGH BYTE A SINGLE QUOTE?
	JNZ	L13EC			;NO.
L13EA:	MOV	BL,22			;YES, SO USE A DOUBLE QUOTE.
L13EC:	MOV	[DI-1],BL
	STOSW				;STUFF IN THE WORD.
	XCHG	BX,AX
	OR	AL,80			;SET THE HIGH BIT ON.
	STOSB				;END QUOTE.
	POP	BX
	POP	DI
	RET_NEAR

;
;oops! CALL/JMP FAR PTR GENERATES AN ERROR DURING ASSEMBLY:
L13FB:			;HANDLE jmp	far	ptr AND call far ptr.
	CALL	L1B10	;LOAD dx WITH NEXT 2 BYTES OF EXEC FILE.
	XCHG	BX,DX			;SAVE OFFSET IN bx.
	CALL	L1B10	;LOAD dx WITH NEXT 2 BYTES OF EXEC FILE.
	MOV	CL,4
	PUSH	DX			;SAVE SEGMENT.
	SHL	DX,CL			;MULTIPLY SEGMENT BY 16.
	ADD	BX,DX
	XCHG	BX,DX	;NOW dx=SEG*16, bx=ABSOLUTE OFFSET.
	CALL	L14C8	;I think this adjusts BX for instr'n length.
	POP	DX			;RECOVER THE SEGMENT VALUE.
	CALL	L1420
	SUB	DI,5
	RET_NEAR
;
;
L1417:					;HANDLE mov	???
	MOV	HLPFG,-1		;SET HELP FLAG ON, IN CASE.
	CALL	L15FA
	MOV	AL,','			;COMMA.
	STOSB
L1418:	CALL	SELPTR
L141D:	CALL	L1B10	;LOAD dx WITH NEXT 2 BYTES OF EXEC FILE.
L1420:	MOV	WORD PTR L0946,DX
	PUSH	BX
	MOV	BL,L2869
	TEST	BL,80			;IS THE HIGH BIT ON?
	JNZ	L1446			;YES.
	AND	BL,'0'
	MOV	CL,3
	SHR	BL,CL
	MOV	BH,0
	MOV	AX,[BX+L2823]
	OR	AX,AX
	JZ	L1446
	ADD	DX,AX
	MOV	BYTE PTR ITYPE,0	;RESET INSTRUCTION TYPE.
L1446:	POP	BX
L1447:	CALL	ORIDE			;DO SEG OVERRIDE IF NECESSARY.
	PUSH	DI
	MOV	DI,L288D
	CMP	DI,SEQPTR
	JNB	L147C
	MOV	AX,[DI]
	POP	DI
	CMP	AX,CURIP
	JNB	L147B
	MOV	DX,WORD PTR L0946
	TEST	DX,0F000
	JZ	L146E
	MOV	AX,3F09			;<TAB> ?.
	STOSW
	JMP	SHORT	L1472

L146E:	MOV	CL,4			;MULTIPLY BY 16.
	SHL	DX,CL
L1472:	MOV	WORD PTR L09A1,DX
	MOV	AL,'S'
	JMP	L1519

L147B:	PUSH	DI
L147C:	CALL	L0E70
	TEST	BYTE PTR [DI],20
	POP	DI
	JZ	L148F
	TEST	BYTE PTR SWT_L,0FF	;LABELS OR NUMBERS?
	JNZ	L148F			;LABELS.
	JMP	L1345			;NUMBERS.

L148F:	MOV	AL,L286A
	MOV	AH,@PROG
	CMP	DX,INITIP
	JNB	L14B8
	OR	AH,AH
	JNZ	L14C8
	OR	AL,AL
	JZ	L14B5
	CMP	AL,60
	JA	L14C8
	CMP	BYTE PTR [DI-1],':'	;COLON?
	JZ	L14B5			;YES.
	MOV	AX,'SD'			;DATA SEGMENT.
	STOSW
	MOV	AL,':'			;COLON.
	STOSB
L14B5:	JMP	L1342

L14B8:	OR	AX,AX
	JNZ	L14C8
	CMP	DX,0FFFF
	JZ	L1514
	MOV	SI,OFFSET OFFST		;POINT @ "OFFSET".
	CALL	L18A4			;XFR IT TO WORK BUFF.
	MOV	BYTE PTR HLPFG,0	;DON'T WRITE A HELP ENTRY.
L14C8:	CMP	@PASS,2			;PASS 2?
	JZ	L14D9			;YES.
	TEST	BYTE PTR @PROG,80	;NO, IS THE HIGH BIT ON?
	JNZ	L1501			;YES.
	JMP	L0EAB

L14D9:	CALL	L1B70
	JB	L150D
	JZ	L1502
	TEST	BYTE PTR L286A,0FF
	JZ	L14F2
	CMP	BYTE PTR [SI-2],3
	JNZ	L14F2
	PUSH	SI
	CALL	SELPTR
	POP	SI
L14F2:	PUSH	SI
	CALL	L18A4			;XFR ASCII @ si TO WORK BUFF.
	POP	AX
	XCHG	SI,AX
	TEST	BYTE PTR [SI-1],80	;IS THE HIGH BIT ON?
	JZ	L1501			;NO.
	MOV	WORD PTR ASCPTR,AX	;SET THE POINTER TO THIS DATA.
L1501:	RET_NEAR

L1502:	TEST	BYTE PTR [SI-1],80	;IS THE HIGH BIT ON?
	JZ	L150D			;NO.
	INC	SI
	MOV	WORD PTR ASCPTR,SI	;SET THE POINTER TO THIS DATA.
L150D:	TEST	BYTE PTR @PROG,80	;IS THE HIGH BIT ON?
	JZ	L1517			;NO.
L1514:	JMP	L138A

L1517:
	CMP	BYTE PTR HLPFG,-1	;IS THE HELP FLAG SET?
	JNZ	L1518			;NO.
	PUSH	DI
	LEA	DI,HLP_B		;SET DEST.
	CALL	DX2ASC		;CONVERT LABEL ADDR TO ASCII @ HLP_B.
	LEA	DI,HLP_W		;REPEAT FOR HLP_W.
	CALL	DX2ASC
	POP	DI
	CALL	L0AA1			;WRITE HELP FILE.
L1518:
	MOV	AL,'L'
L1519:	STOSB
	CALL	L0EAB
DX2ASC:	MOV	AL,DH			;CONVERT dx TO ASCII.
	CALL	DL2ASC			;DO dh FIRST.
	MOV	AL,DL			;CONVERT dl TO ASCII.
DL2ASC:	MOV	AH,AL
	SHR	AL,1
	SHR	AL,1
	SHR	AL,1
	SHR	AL,1
	CALL	AL2ASC	;CVT al TO ASCII & STUFF INTO MEMORY @ di.
	MOV	AL,AH			;NOW CONVERT ah.
AL2ASC:	AND	AL,0F			;CONVERT al TO ASCII.
	ADD	AL,90			;ADD 144.
	DAA
	ADC	AL,40			;ADD 64, NOW + 128.
	DAA
	STOSB				;STUFF INTO MEMORY @ di.
	RET_NEAR
;
;
AAM_D:				;HANDLE aad & aam (2-BYTE OP CODES).
	CALL	SEQRD			;GET NEXT BYTE FROM EXEC FILE.
	CMP	AL,0A
	JNZ	L1545
	RET_NEAR

L1545:	JMP	L1810
;
;
RMREG:					;HANDLE code	reg/mem,reg.
	CALL	DECODE			;DECODE 2nd OP CODE.
	CALL	L18B0			;HANDLE reg/mem.
	MOV	AL,','			;COMMA.
	STOSB
L1551:	MOV	AL,REGCD		;GET THE reg CODE.
L1554:	MOV	SI,OFFSET REG_8		;POINT @ 8-BIT REGISTERS.
	OR	BYTE PTR HLPBW,1	;SAY THIS IS A BYTE REF.
	TEST	BYTE PTR OPCDE,1	;IS THE WORD BIT SET?
	JZ	L1561			;NO.
;
GPR16:		;HANDLE inc, dec, push & pop GENERAL PURPOSE reg16.
	MOV	SI,OFFSET REG16		;POINT @ 16-BIT REGISTERS.
	OR	BYTE PTR HLPBW,2	;SAY THIS IS A WORD REF.
L1561:	AND	AL,7
	CBW
	ADD	SI,AX			;CONVERT TO WORD OFFSET.
	ADD	SI,AX			;POINT @ CORRECT DATA.
	MOVSW			;MOVE CORRECT DATA TO WORK BUFF.
	RET_NEAR
;
;
P_PSR:				;HANDLE push OR pop SEGMENT REGISTER.
	MOV	CL,3		;SEG REGISTER DATA IS IN BITS 3, 4 &
	SHR	AL,CL		;5, SO SHIFT OFF LOW-ORDER 3 BITS.
SEGRG:					;HANDLE SEGMENT REGISTER.
	AND	AL,3		;VALID VALUES ARE ZERO THRU 3.
	MOV	SI,OFFSET REGSG		;POINT @ SEGMENT REGISTERS.
	OR	BYTE PTR HLPBW,2	;SAY THIS IS A WORD REF.
	JMP	SHORT	L1561	;GO MOVE CORRECT SEG REG TO WORK BUFF.
;
;
L1575:					;HANDLE mov	???
	MOV	BYTE PTR OPCDE,1
	CALL	DECODE			;DECODE 2nd OP CODE.
	CMP	AL,4
	JB	L1584
L1581:	JMP	L17FE

L1584:	CALL	L18B0
	MOV	AL,','			;COMMA.
	STOSB
	MOV	AL,REGCD		;GET THE reg CODE.
	JMP	SHORT	SEGRG
;
;
L158F:					;HANDLE mov	???
	CALL	DECODE
	CMP	AL,4
	JNB	L1581
	CALL	SEGRG			;PUT CORRECT SEG REG INTO BUFF.
	MOV	BYTE PTR OPCDE,1
	JMP	SHORT	L15B4
;
;
POP16:					;HANDLE pop	mem16.
	CALL	DECODE			;DECODE 2nd OP CODE.
	OR	AL,AL
	JNZ	L1581
	JMP	SHORT	L15B7
;
;
L_E_A:					;HANDLE lea.
	OR	BYTE PTR OPCDE,1	;SET THE WORD BIT.
;
REGRM:					;HANDLE code	reg,reg/mem.
	CALL	DECODE			;DECODE 2nd OP CODE.
	CALL	L1551		;GET THE CORRECT GENERAL PURPOSE REG.
L15B4:	MOV	AL,','			;COMMA.
	STOSB
L15B7:	JMP	L18B0		;GO HANDLE reg/mem FINAL OPERAND.
;
;
L15BA:					;HANDLE jmp	short.
	INC	EOLRQ			;SET EOL REQUIRED FLAG.
;
L15BE:				;HANDLE CONDITIONAL JUMPS & LOOPS.
	CALL	SEQRD
	CBW
	MOV	DX,AX
	JMP	SHORT	L15E2
;
;
L15C6:					;HANDLE jmp.
	INC	EOLRQ			;SET EOL REQUIRED FLAG.
	CALL	L1B10	;LOAD dx WITH NEXT 2 BYTES OF EXEC FILE.
	PUSH	DX
	CALL	L15E2
	POP	DX
	INC	DH
	JNZ	L15DE
	OR	DL,DL
	JNS	L15DE
	INC	BYTE PTR NOPRQ		;SET nop REQUIRED FLAG.
L15DE:	RET_NEAR
;
;
L15DF:					;HANDLE call.
	CALL	L1B10	;LOAD dx WITH NEXT 2 BYTES OF EXEC FILE.
L15E2:	ADD	DX,CURIP		;ADD THE CURRENT ip.
	JMP	L1447
;
;
XCHAX:					;HANDLE xchg	reg16,AX.
	CALL	GPR16		;GET THE CORRECT GENERAL PURPOSE REG.
	MOV	AL,','			;COMMA.
	STOSB
	MOV	AL,0			;SET SOURCE REG TO ax.
	JMP	GPR16
;
;
L15F4:					;HANDLE mov	???,accum.
	MOV	HLPFG,-1		;SET HELP FLAG ON, IN CASE.
	CALL	L1418
	MOV	AL,','			;COMMA.
	STOSB
L15FA:	JMP	SHORT	AL_AX		;GO SELECT al OR ax AND RET.
;
;
STRNG:			;HANDLE STRING CODES (movsb, scasw, Etc.).
	TEST	BYTE PTR L2866,0FF
	JZ	L165F
	MOV	DL,AL
	SUB	AL,0A4
	SHR	AL,1
	MOV	BX,OFFSET L2030		;POINT @ movs AND cmps OP CODES
	CALL	L185A
	DEC	BX
	JNZ	PTRNDX
	JMP	ERHDL

PTRNDX:				;HANDLE type PTR [index reg].
	CALL	SELPTR			;SELECT THE CORRECT type PTR.
	CMP	DL,0A8			;USE si OR di?
	JA	L1624			;si.
	MOV	SI,OFFSET OF_DI		;POINT @ [DI].
	CALL	L18A4			;XFR IT TO THE WORK BUFF.
L1624:	CALL	ORIDE			;DO SEG OVERRIDE IF NECESSARY.
	MOV	SI,OFFSET OF_SI		;POINT @ [SI].
	JMP	L18A4			;XFR IT TO THE WORK BUFF & RET.
;
;
L162D:					;HANDLE mov	???
	MOV	HLPFG,-1		;SET HELP FLAG ON, IN CASE.
	MOV	BYTE PTR OPCDE,0
	JMP	SHORT	L1639
;
L1634:					;HANDLE mov	???
	MOV	HLPFG,-1		;SET HELP FLAG ON, IN CASE.
	MOV	BYTE PTR OPCDE,1
L1639:	AND	AL,7
	JMP	L131F
;
;
L163E:					;HANDLE int	3.
	MOV	AL,3
	JMP	L1332
;
;
OUTIM:			;HANDLE out	immed,al & out	immed,ax.
	CALL	L1654
	MOV	AL,','			;COMMA.
	STOSB
;
AL_AX:	MOV	AL,0			;USE accum.
	JMP	L1554	;GO GET THE CORRECT GENERAL PURPOSE REG.
;
;
IN_IM:			;HANDLE in	al,immed & in	ax,immed.
	CALL	AL_AX			;SELECT al OR ax.
	MOV	AL,','			;COMMA.
	STOSB
;
L1654:					;HANDLE int	immed.
	CALL	SEQRD
	CALL	L1337
L165A:	MOV	BYTE PTR L287C,80
L165F:	RET_NEAR
;
;
L1660:					;HANDLE 8087 CODE D8.
	CALL	L171A
	MOV	AX,'TS'
	STOSW
	MOV	AL,','			;COMMA.
	STOSB
L166A:	MOV	AX,'TS'
	STOSW
	MOV	AX,'0('			;LEFT PAREN, ZERO.
	OR	AH,R_MCD
	STOSW
	MOV	AL,')'			;RIGHT PAREN.
	STOSB
	RET_NEAR
;
;
L167A:					;HANDLE 8087 CODE DC.
	CALL	L171A
	CALL	L166A
	JMP	L1712
;
;
L1683:					;HANDLE 8087 CODE D9.
	CALL	L171A
	MOV	AL,OPCD2
	SUB	AL,0E0
	JB	L1697
	MOV	BX,OFFSET L2054
	CALL	L185A
	DEC	BX
	JZ	L16AF
L1696:	RET_NEAR

L1697:	MOV	BX,OFFSET L204C
	MOV	AL,REGCD		;GET THE reg CODE.
	CALL	L185A
	MOV	AL,OPCD2
	SUB	AL,0D0
	JB	L166A
	JZ	L1696
	AND	AL,0F
	CMP	AL,8
	JNB	L166A
L16AF:	JMP	L17FE
;
;
L16B2:					;HANDLE 8087 CODE DA.
	CALL	L171A
	JMP	L17FE
;
;
L16B8:					;HANDLE 8087 CODE DB.
	CALL	L171A
	MOV	BX,OFFSET L20B4
	MOV	AL,OPCD2
	SUB	AL,0E0
	JB	L172F
	CMP	AL,4
	JNB	L172F
	JMP	L185A
;
;
L16CC:					;HANDLE 8087 CODE DD.
	CALL	L171A
	CMP	REGCD,4
	JNB	L172F
	MOV	BX,OFFSET L20CC
	CALL	L185A
	CMP	BYTE PTR OPCDE,0DDH
	JZ	L16EA
	TEST	BYTE PTR REGCD,0FF
	JZ	L172F
L16EA:	JMP	L166A
;
;
L16ED:					;HANDLE 8087 CODE DE.
	CALL	L171A
	MOV	BX,OFFSET L20D4
	MOV	AL,REGCD
	CALL	L185A
	CMP	REGCD,3
	JNZ	L1708
	CMP	BYTE PTR OPCD2,0D9
	JNZ	L172F
	RET_NEAR

L1708:	CALL	L166A
	CMP	REGCD,2
	JZ	L1719
L1712:	MOV	AL,','			;COMMA.
	STOSB
	MOV	AX,'TS'
	STOSW
L1719:	RET_NEAR

L171A:	TEST	BYTE PTR SWT_F,0FF	;ARE 8087 INSTRUCTIONS ENABLED?
	JNZ	DO_87			;YES.
	CALL	NO_87			;NO.
	CMP	MODCD,3
	JZ	L1719
	DEC	BX
	POP	AX
	JNZ	L1732
L172F:	JMP	L17FE			;CAN'T DISASSEMBLE.

L1732:	JMP	L18BA
;
;
DO_87:	POP	CX			;HANDLE 8087 CODES.
	MOV	OCPTR,9DH		;SET THE OP CODE POINTER TO esc
	AND	AL,7
	MOV	DL,AL
	CALL	DECODE			;DECODE 2nd OP CODE.
	MOV	CL,3
	SHL	DL,CL
	OR	AL,DL
	CALL	L1332
	MOV	BYTE PTR OPCDE,1
	JMP	L15B4
;
;
IN_DX:				;HANDLE in	al,dx & in	ax,dx.
	CALL	AL_AX			;SELECT al OR ax.
	MOV	AL,','			;COMMA.
	STOSB
L175A:	MOV	AX,'XD'			;dx.
	STOSW
	RET_NEAR
;
;
OUTDX:				;HANDLE out	dx,al & out	dx,ah.
	CALL	L175A			;dx.
	MOV	AL,','			;COMMA.
	STOSB
	JMP	AL_AX			;GO SELECT al OR ax AND RET.
;
;
ROTSH:				;HANDLE ROTATE & SHIFT INSTRUCTIONS.
	CALL	L1865
	CALL	L18B0
	MOV	AL,','			;COMMA.
	STOSB
	TEST	BYTE PTR OPCDE,2	;IS THE DIR OR SIGN BIT SET?
	JZ	L177D			;NO.
	MOV	AX,'LC'		;# OF ROTATES OR SHIFTS IS IN cl.
	STOSW
	RET_NEAR

L177D:	MOV	AL,'1'			;# OF ROTATES OR SHIFTS IS 1.
	STOSB
	RET_NEAR
;
;
L1781:					;HANDLE OP CODES F6 AND F7.
	CALL	L1865
	OR	AL,AL
	JNZ	L179D
	JMP	L12BB
;
;
L178B:					;HANDLE OP CODES FE AND FF.
	CALL	L1865
	CMP	L286A,50
	JNZ	L1799
	INC	EOLRQ			;SET EOL REQUIRED FLAG.
L1799:	CMP	AL,2
	JNB	L17A0
L179D:	JMP	L18B0

L17A0:	TEST	BYTE PTR OPCDE,1	;IS THE WORD BIT SET?
	JZ	L17FE			;NO.
	CMP	AL,2
	JZ	L179D
	CMP	AL,4
	JZ	L179D
	JMP	L18B0
;
;
RET_N:					;HANDLE ret_near.
	MOV	BX,OFFSET MACRN		;POINT @ RET NEAR MACRO.
	JMP	SHORT	L17C0		;ENABLE IT.
;
;
L17B7:					;HANDLE IRET.
	INC	EOLRQ			;SET EOL REQUIRED FLAG.
	JMP	SHORT	SINGL
;
;
RET_F:					;HANDLE ret_far.
	MOV	BX,OFFSET MACRF		;POINT @ RET FAR MACRO.
L17C0:	MOV	BYTE PTR [BX],1		;ENABLE THE MACRO.
	INC	EOLRQ			;SET EOL REQUIRED FLAG.
;
XLATE:					;HANDLE xlat.
	CALL	ORIDE			;DO SEG OVERRIDE IF NECESSARY.
;
SINGL:			;HANDLE SINGLE-BYTE OP CODES (aaa, nop, Etc.).
	TEST	BYTE PTR L2866,0FF
	JZ	L1835
;
ERHDL:					;HANDLE ERRORS.
	TEST	BYTE PTR L2866,0FF
	JZ	DEF_B
	MOV	AL,L2866
	CALL	L1332
	MOV	AL,','			;COMMA.
	STOSB
	MOV	AL,OPCDE
	JMP	SHORT	DEF_B

L17E6:	CALL	L1865
	CMP	BYTE PTR OPCDE,82
	JB	L17FC
	CMP	AL,1
	JZ	L17FD
	CMP	AL,4
	JZ	L17FD
	CMP	AL,6
	JZ	L17FD
L17FC:	RET_NEAR

L17FD:	POP	BX
L17FE:	MOV	AL,OPCDE
	CALL	L1332
	MOV	AL,','			;COMMA.
	STOSB
	MOV	AL,OPCD2
DEF_B:	MOV	OCPTR,6A		;SET THE OP CODE POINTER TO db.
L1810:	CALL	L1332
	MOV	AX,3B09			;<TAB> SEMICOLON.
	STOSW				;OUTPUT TO WORK BUFFER.
	MOV	AX,'??'
	STOSW
	JMP	L165A			;SET L287C TO 80 & RETURN.
;
;
ORIDE:					;HANDLE SEGMENT OVERRIDE.
	TEST	BYTE PTR L2866,0FF	;IS A SEG OVERRIDE REQUIRED?
	JZ	L1835			;NO.
	PUSH	AX
	MOV	AL,L2866		;GET THE SEGMENT.
	CALL	P_PSR			;DECIDE WHAT SEG REG.
	MOV	AL,':'			;COLON.
	STOSB
	MOV	BYTE PTR L2866,0	;CLEAR THE SEG O'RIDE DATA.
	POP	AX
	STC
L1835:	RET_NEAR
;
;
DECODE:					;DECODE mod,reg,r/m.
	CALL	SEQRD			;GET NEXT EXEC BYTE.
	MOV	OPCD2,AL		;SAVE IT.
	MOV	AH,AL
	AND	AL,7			;CLEAR THE HIGH 5 BITS.
	MOV	R_MCD,AL		;THE LOW 3 BITS ARE r/m.
	MOV	CL,3
	SHR	AH,CL			;GET RID OF THE 3 LOW BITS.
	MOV	AL,AH
	AND	AL,7			;CLEAR THE HIGH 5 BITS.
	MOV	REGCD,AL		;THESE 3 BITS ARE reg.
	SHR	AH,CL
	MOV	MODCD,AH		;THE HIGH 2 BITS ARE mod.
	RET_NEAR
;
;
NO_87:					;DON'T DISASSEMBLE 8087 CODES.
	CALL	DECODE			;DECODE 2nd OP CODE.
	MOV	DL,AL
L185A:	MOV	AH,0
	ADD	BX,AX
	ADD	BX,AX
	XOR	AX,AX
	DEC	BX
	JMP	SHORT	L1873
;
;
L1865:	CALL	DECODE			;DECODE 2nd OP CODE.
	MOV	DL,AL
	CBW
	ADD	BX,AX
	ADD	BX,AX
	ADD	BX,AX
	MOV	AL,[BX]
L1873:	TEST	BYTE PTR L2866,0FF
	JNZ	L187D
	MOV	L2869,AL
L187D:	MOV	AX,[BX+1]
	MOV	OCPTR,AX		;SAVE THE OP CODE POINTER.
	MOV	BX,AX
	MOV	L286A,AH
	AND	BYTE PTR L286A,0F0
	OR	AX,AX
	MOV	AL,DL
	JNZ	L18AF
	JMP	L17FD
;
;
SELPTR:					;SELECT POINTER TYPE.
	MOV	SI,OFFSET B_PTR		;POINT @ "BYTE PTR ".
	MOV	BYTE PTR HLPBW,1	;SAY THIS IS A BYTE REF.
	TEST	BYTE PTR OPCDE,1	;IS THE WORD BIT SET?
	JZ	L18A4			;NO.
	MOV	SI,OFFSET W_PTR		;POINT @ "WORD PTR ".
	MOV	BYTE PTR HLPBW,2	;SAY THIS IS A WORD REF.
L18A4:	LODSB
	MOV	AH,AL
	AND	AL,7F			;STRIP HIGH BIT.
	STOSB
	AND	AH,80
	JZ	L18A4
L18AF:	RET_NEAR
;
;
L18B0:	CMP	MODCD,3
	JZ	L18BA
	CALL	SELPTR			;SELECT THE type PTR.
L18BA:	MOV	AX,RMMOD	;GET mod INTO ah AND r/m INTO al.
	CMP	AH,3			;IS r/m A reg?
	JNZ	L18C5			;NO, SO IT IS mem.
	JMP	L1554	;YES, GET THE CORRECT GENERAL PURPOSE REG.

L18C5:	MOV	DX,AX
	CMP	AX,6		;IS ea disp-high AND disp-low?
	JNZ	L18CF		;NO, USE A BASE AND/OR INDEX REGISTER.
	MOV	HLPFG,-1		;SET THE HELP FLAG ON.
	JMP	L141D		;YES, THIS IS A DIRECT MEMORY OPERAND.

L18CF:	MOV	BL,AL
	MOV	BH,0
	SHL	BX,1
	CMP	[BX+BASE],'P'		;IS THE REGISTER bp?
	JNZ	L18E1			;NO.
	MOV	BYTE PTR L2869,10
L18E1:	CALL	ORIDE			;DO SEG OVERRIDE IF NECESSARY.
	MOV	AL,'['
	STOSB
	MOV	AX,WORD PTR [BX+BASE]	;GET CORRECT BASE REGISTER.
	STOSW
	CMP	DL,4			;INDEX REGISTER ALSO?
	JNB	L18FC			;NO.
	MOV	AL,'+'
	STOSB
	AND	BL,2
	MOV	AX,WORD PTR [BX+INDEX]	;GET CORRECT INDEX REGISTER.
	STOSW
L18FC:	OR	DH,DH			;ANY dispLACEMENT?
	JZ	L1924			;NO.
	DEC	DH			;NEGATIVE DISPLACEMENT?
	JZ	L190C			;MAYBE.
	MOV	AL,'+'			;NO, dispLACEMENT IS POSITIVE.
	STOSB
	CALL	L141D
	JMP	SHORT	L1924

L190C:	CALL	SEQRD
	CBW
	MOV	DX,AX
	MOV	AH,AL
	MOV	AL,'+'
	OR	AH,AH
	JNS	L191E
	MOV	AL,'-'
	NEG	AH
L191E:	STOSB
	MOV	AL,AH
	CALL	L1332
L1924:	MOV	AL,']'
	STOSB
	JMP	L165A			;SET L287C TO 80 & RETURN.
;
;
L192A:					;EXECUTES WHEN @PROG IS 5.
	MOV	WORD PTR L1965,0D20A	;SET L1965 TO or	dl,dl.
	JMP	SHORT	L1938
;
;
L1932:					;EXECUTES WHEN @PROG IS 4.
	MOV	WORD PTR L1965,0CAFE	;RESTORE L1965 TO dec	dl.
L1938:	TEST	BYTE PTR L2856,0FF
	JNZ	L1970
	CALL	L132F
	MOV	AX,W2919
	MOV	BYTE PTR L291A,0
	OR	AH,AH
	JNZ	L1950
	DEC	AH
L1950:	AND	DL,AH
L1952:	SHR	AH,1
	JB	L195A
	SHR	DL,1
	JMP	SHORT	L1952

L195A:	OR	DL,DL
	JNZ	L1965
L195E:	MOV	OCPTR,6A		;SET THE OP CODE POINTER TO db.
	RET_NEAR

L1965:	DEC	DL			;L192A
	MOV	L2856,DL
	JZ	L195E
	MOV	AL,','			;COMMA.
	STOSB
L1970:		;EXECUTES WHEN @PROG IS 3 OR IS CALLED FROM L1938.
	XOR	CX,CX
	MOV	OCPTR,6A		;SET THE OP CODE POINTER TO db.
L1978:	CALL	SEQRD
	MOV	DL,AL
	TEST	BYTE PTR L2846,0FF
	PUSHF
	CMP	AL,','			;COMMA?
	JZ	L19AD			;YES.
	CMP	AL,27			;SINGLE QUOTE?
	JZ	L19AD			;YES.
	CMP	AL,22			;DOUBLE QUOTE?
	JZ	L19AD			;YES.
	CALL	L1A7D
	JNB	L19AD
	POPF
	JNZ	L199D
	MOV	AL,27			;SINGLE QUOTE.
	STOSB
	MOV	L2846,AL
L199D:	MOV	AL,DL
	STOSB
	INC	CX
	CMP	AL,'$'
	JNZ	L19E5
L19A5:	CALL	L19F1
	JB	L19ED
	JMP	L1A68

L19AD:	POPF
	JZ	L19B9
	MOV	AX,2C27			;QUOTE, COMMA.
	STOSW
	MOV	BYTE PTR L2846,0
L19B9:	CMP	DL,CR			;<CR>?
	JNZ	L19C3			;NO.
	MOV	AX,'RC'			;<CR>.
	JMP	SHORT	L19CB

L19C3:	CMP	DL,LF			;<LF>?
	JNZ	L19CE			;NO.
	MOV	AX,'FL'			;<LF>.
L19CB:	STOSW
	JMP	SHORT	L19D5

L19CE:	MOV	AL,DL
	PUSH	CX
	CALL	L1332
	POP	CX
L19D5:	MOV	AL,','			;COMMA.
	STOSB
	CMP	DL,0A
	JZ	L19A5
	TEST	DL,80			;IS THE HIGH BIT ON?
	JNZ	L19A5			;YES.
	ADD	CX,4
L19E5:	CMP	CX,35
	CALL	L19F1
	JNB	L1978
L19ED:	RET_NEAR

L19EE:	CMP	CX,16
L19F1:	PUSH	BX
	PUSHF
	TEST	BYTE PTR L2856,0FF
	JZ	L1A0D
	DEC	L2856
	JNZ	L1A1A
	TEST	BYTE PTR STFLG,0FF	;IS THE STRUCTURE FLAG SET?
	JZ	L1A5D			;NO.
	DEC	W2919
	JMP	SHORT	L1A5D

L1A0D:	TEST	BYTE PTR STFLG,0FF	;IS THE STRUCTURE FLAG SET?
	JZ	L1A1A			;NO.
	DEC	W2919
	JZ	L1A5D
L1A1A:	TEST	FILESZ,0FFFF
	JZ	L1A5D
	MOV	AX,L2889
	CMP	AX,ENDSEQ
	MOV	AX,CURIP
	JNB	L1A34
	CMP	NXTSEQ,AX
	JBE	L1A5D
L1A34:	CMP	@PASS,1			;PASS 1?
	JZ	L1A47			;YES.
	TEST	BYTE PTR L2888,0FF
	JZ	L1A47
	CMP	AX,[BP+1]
	JNB	L1A5D
L1A47:	MOV	BX,L288D
	CMP	BX,SEQPTR
	JNB	L1A55
	CMP	AX,[BX]
	JNB	L1A5D
L1A55:	POPF
	JNB	L1A5E
	CLC
	POP	BX
	RET_NEAR

L1A5B	DW	0			;L1A5E.
L1A5D:	POPF
L1A5E:	POP	BX
	POP	L1A5B
	STC
	CALL	WORD PTR L1A5B		;CALL THE APPROPRIATE ROUTINE.
L1A68:	CMP	BYTE PTR [DI-1],','	;COMMA?
	JNZ	L1A72			;NO.
	DEC	DI
	MOV	BYTE PTR [DI],0
L1A72:	TEST	BYTE PTR L2846,0FF
	JZ	L1A7C
	MOV	AL,27			;SINGLE QUOTE.
	STOSB
L1A7C:	RET_NEAR

L1A7D:	CMP	AL,20	;' '
	CMC				;TOGGLE CARRY FLAG.
	JNB	L1A84
	CMP	AL,7BH
L1A84:	RET_NEAR
;
;
L1A85:				;EXECUTES WHEN @PROG IS EITHER 1 OR 2.
	MOV	AX,7E			;SET THE OP CODE POINTER TO jle
	CMP	@PROG,1
	JNZ	L1A92
	MOV	AX,6A			;SET THE OP CODE POINTER TO db.
L1A92:	MOV	OCPTR,AX		;SAVE THE OP CODE POINTER.
	XOR	BX,BX
	MOV	CX,BX
	CALL	L1AFC
L1A9C:	MOV	WORD PTR L1ACA,AX
	CALL	L19EE
	JB	L1AC5
L1AA4:	CALL	L1AFC
	CMP	AX,WORD PTR L1ACA
	JNZ	L1AB5
	INC	BX
	CALL	L19EE
	JB	L1AE0
	JMP	SHORT	L1AA4

L1AB5:	PUSH	AX
	OR	BX,BX
	JZ	L1ABF
	CALL	L1AE0
	JMP	SHORT	L1AC2

L1ABF:	CALL	L1AC5
L1AC2:	POP	AX
	JMP	SHORT	L1A9C

L1AC5:	ADD	CX,6
	PUSH	CX
	MOV	DX,0
L1ACA	EQU	$-2			;L1A9C, L1AA4.
	CMP	@PROG,1
	JNZ	L1AD8
	CALL	L1342
	JMP	SHORT	L1ADB

L1AD8:	CALL	L1447
L1ADB:	MOV	AL,','			;COMMA.
	STOSB
	POP	CX
	RET_NEAR

L1AE0:	ADD	CX,0A
	PUSH	CX
	INC	BX
	XCHG	DX,BX
	CALL	L1345
	MOV	SI,OFFSET SPDUP		;POINT @ " DUP(".
	CALL	L18A4
	POP	CX
	CALL	L1AC5
	DEC	DI
	MOV	AX,',)'			;RIGHT PAREN, COMMA.
	STOSW
	XOR	BX,BX
	RET_NEAR

L1AFC:	CALL	SEQRD
	MOV	AH,AL
	MOV	AL,0
	CMP	@PROG,1
	JZ	L1B0D
	CALL	SEQRD
L1B0D:	XCHG	AH,AL
	RET_NEAR

L1B10:					;LOAD dx FROM EXEC FILE.
	CALL	SEQRD
	MOV	DL,AL
	CALL	SEQRD
	MOV	DH,AL
	RET_NEAR
;
;
SEQRD:	PUSH	SI			;READ THE SOURCE FILE.
	MOV	AL,0
	TEST	FILESZ,0FFFF
	JZ	L1B57
	MOV	SI,L287F
	CMP	SI,OFFSET WRTBF		;END OF SEQ BUFFER?
	JB	L1B4E
	PUSH	AX
	PUSH	DX
	MOV	AH,1A
	MOV	DX,OFFSET SEQBF		;POINT @ SEQ BUFFER.
	INT	21			;SET DTA.
	XCHG	DX,SI
	MOV	DX,OFFSET SRCFCB	;POINT @ FCB TO READ.
	MOV	AH,14
	INT	21			;SEQUENTIAL READ.
	CMP	AL,1			;EOF?
	JNZ	L1B4C			;NO.
	MOV	FILESZ,0		;SET FILE SIZE TO ZERO.
L1B4C:	POP	DX
	POP	AX
L1B4E:	LODSB				;GET A BYTE OF THE FILE.
	MOV	L287F,SI
	DEC	FILESZ			;REDUCE FILE SIZE.
L1B57:	INC	L2854
	INC	CURIP			;INCREMENT ip.
	MOV	SI,L2854
	CMP	SI,18			;24 BYTES?
	JA	L1B6E			;MORE.
	ADD	SI,OFFSET L282A
	MOV	[SI],AL			;SAVE DATA.
L1B6E:	POP	SI
	RET_NEAR
;
;
L1B70:	MOV	SI,OFFSET EOPGM
L1B73:	CMP	SI,ENDSEQ
	JA	L1B95
	CMP	DX,[SI]
	PUSHF
	LODSW
	LODSB
	LODSB
	AND	AL,7F			;STRIP HIGH BIT.
	MOV	AH,0
	ADD	SI,AX
	POPF
	JB	L1B95
	JNZ	L1B73
	OR	AX,AX
	JZ	L1B73
	SUB	SI,AX
	CMP	BYTE PTR [SI],0AE	;PERIOD W/HIGH BIT SET.
	CLC
	RET_NEAR

L1B95:	STC
	RET_NEAR
;
L0AA1:					;DO HELP FILE.
	CMP	@PASS,2			;PASS 2?
	JNZ	L0AA3			;NO, DON'T WRITE HELP.
	CMP	SWT_Z,0			;IS HELP REQUESTED?
	JZ	L0AA3			;NO, DON'T WRITE HELP.
	CMP	HLPFG,0			;IS THE HELP FLAG SET?
	JZ	L0AA3			;NO, DON'T WRITE HELP.
	CMP	HLPBW,3			;BOTH BYTE & WORD INDICATED?
	JZ	L0AA3			;YES, DON'T WRITE HELP.
	PUSH	DX
	LEA	DX,HLP_W		;ASSUME WORD TYPE.
	TEST	BYTE PTR HLPBW,2	;IS THE WORD BIT SET?
	JNZ	L0AA2			;YES, WRITE WORD ENTRY.
	LEA	DX,HLP_B		;POINT @ BYTE TYPE.
	TEST	BYTE PTR HLPBW,1	;IS THE BYTE BIT SET?
	JZ	L0AA3			;NO, DON'T WRITE AN ENTRY.
L0AA2:
	CALL	WRHLP			;WRITE HELP FILE ENTRY.
	POP	DX
L0AA3:
	MOV	BYTE PTR HLPBW,0	;CLEAR THE BYTE/WORD FLAG.
	MOV	BYTE PTR HLPFG,0	;CLEAR THE HELP FLAG.
RET_NEAR
;
;
;DATA WITH THE HIGH BIT ON SIGNALS THE END OF THE TEXT.
;
;THE FOLLOWING ARE POINTERS TO PROGRAM ROUTINES TO HANDLE THE
;INSTRUCTION CODES, WHICH ARE CONVERTED TO NUMBERS (IN REVERSE ORDER
;OF THEIR APPEARANCE @SEQ_I) IN THE .SEQ FILE AREA OF MEMORY.
L1BA9	DW	L1277			;.SEQ TYPE IS C, CODE.
	DW	L1A85			;.SEQ TYPE IS B, BYTE.
	DW	L1A85			;.SEQ TYPE IS W, WORD.
	DW	L1970			;.SEQ TYPE IS S, STRING.
	DW	L1932			;.SEQ TYPE IS $ STRING.
	DW	L192A			;.SEQ TYPE IS # STRING.
	DW	L1277		;.SEQ TYPE IS D, GENERATE DATA OPERAND.
	DW	L1277			;no type has been defined.
	DW	L1277			;no type has been defined.
	DW	0,0	;.SEQ TYPES X AND A ARE HANDLED @ L0354 & L03D1
	DB	0			;.SEQ TYPE I IS HANDLED @ L03DB
;THE FOLLOWING IS A TABLE OF OP CODE POINTERS & ASSOCIATED ROUTINES.
;THE "L1250" IS SUBTRACTED TO KEEP THE HIGH NIBBLE ZERO.
;"CODES" IS SUBTRACTED TO KEEP THE HIGH NIBBLE ZERO.
;H1, H2, H3, H4, H5, H6, H7 & HA SET THE HIGH NIBBLE.  I DON'T
;UNDERSTAND WHY.
L1BC0	DW	H4+_ADD-CODES,RMREG-L1250
Q01	DW	H4+_ADD-CODES,RMREG-L1250	;ADD
Q02	DW	H1+_ADD-CODES,REGRM-L1250	;ADD
Q03	DW	H1+_ADD-CODES,REGRM-L1250	;ADD
Q04	DW	_ADD-CODES,ALXIM-L1250		;ADD	AL,immed.
Q05	DW	_ADD-CODES,ALXIM-L1250		;ADD	AX,immed.
Q06	DW	_PUSH-CODES,P_PSR-L1250		;PUSH	ES.
Q07	DW	_POP-CODES,P_PSR-L1250		;POP	ES.
Q08	DW	H4+_OR-CODES,RMREG-L1250	;OR
Q09	DW	H4+_OR-CODES,RMREG-L1250	;OR
Q0A	DW	H1+_OR-CODES,REGRM-L1250	;OR
Q0B	DW	H1+_OR-CODES,REGRM-L1250	;OR
Q0C	DW	_OR-CODES,ALXIM-L1250		;OR	AL,immed.
Q0D	DW	_OR-CODES,ALXIM-L1250		;OR	AX,immed.
Q0E	DW	_PUSH-CODES,P_PSR-L1250		;PUSH	CS.
	DW	0,ERHDL-L1250
Q10	DW	H4+_ADC-CODES,RMREG-L1250	;ADC
Q11	DW	H4+_ADC-CODES,RMREG-L1250	;ADC
Q12	DW	H1+_ADC-CODES,REGRM-L1250	;ADC
Q13	DW	H1+_ADC-CODES,REGRM-L1250	;ADC
Q14	DW	_ADC-CODES,ALXIM-L1250		;ADC	AL,immed.
Q15	DW	_ADC-CODES,ALXIM-L1250		;ADC	AX,immed.
Q16	DW	_PUSH-CODES,P_PSR-L1250		;PUSH	SS.
Q17	DW	_POP-CODES,P_PSR-L1250		;POP	SS.
Q18	DW	H4+_SBB-CODES,RMREG-L1250	;SBB
Q19	DW	H4+_SBB-CODES,RMREG-L1250	;SBB
Q1A	DW	H1+_SBB-CODES,REGRM-L1250	;SBB
Q1B	DW	H1+_SBB-CODES,REGRM-L1250	;SBB
Q1C	DW	_SBB-CODES,ALXIM-L1250		;SBB	AL,immed.
Q1D	DW	_SBB-CODES,ALXIM-L1250		;SBB	AX,immed.
Q1E	DW	_PUSH-CODES,P_PSR-L1250		;PUSH	DS.
Q1F	DW	_POP-CODES,P_PSR-L1250		;POP	DS.
Q20	DW	H4+_AND-CODES,RMREG-L1250	;AND
Q21	DW	H4+_AND-CODES,RMREG-L1250	;AND
Q22	DW	H1+_AND-CODES,REGRM-L1250	;AND
Q23	DW	H1+_AND-CODES,REGRM-L1250	;AND
Q24	DW	_AND-CODES,ALXIM-L1250		;AND	AL,immed.
Q25	DW	_AND-CODES,ALXIM-L1250		;AND	AX,immed.
	DW	0,0				;26 IS es SEG O'RIDE.
Q27	DW	_DAA-CODES,SINGL-L1250		;DAA.
Q28	DW	H4+_SUB-CODES,RMREG-L1250	;SUB
Q29	DW	H4+_SUB-CODES,RMREG-L1250	;SUB
Q2A	DW	H1+_SUB-CODES,REGRM-L1250	;SUB
Q2B	DW	H1+_SUB-CODES,REGRM-L1250	;SUB
Q2C	DW	_SUB-CODES,ALXIM-L1250		;SUB	AL,immed.
Q2D	DW	_SUB-CODES,ALXIM-L1250		;SUB	AX,immed.
	DW	0,0				;2E IS cs SEG O'RIDE.
Q2F	DW	_DAS-CODES,SINGL-L1250		;DAS.
Q30	DW	H4+_XOR-CODES,RMREG-L1250	;XOR
Q31	DW	H4+_XOR-CODES,RMREG-L1250	;XOR
Q32	DW	H1+_XOR-CODES,REGRM-L1250	;XOR
Q33	DW	H1+_XOR-CODES,REGRM-L1250	;XOR
Q34	DW	_XOR-CODES,ALXIM-L1250		;XOR	AL,immed.
Q35	DW	_XOR-CODES,ALXIM-L1250		;XOR	AX,immed.
	DW	0,0				;36 IS ss SEG O'RIDE.
Q37	DW	0,SINGL-L1250			;AAA.
Q38	DW	H2+_CMP-CODES,RMREG-L1250	;CMP
Q39	DW	H2+_CMP-CODES,RMREG-L1250	;CMP
Q3A	DW	H2+_CMP-CODES,REGRM-L1250	;CMP
Q3B	DW	H2+_CMP-CODES,REGRM-L1250	;CMP
Q3C	DW	_CMP-CODES,ALXIM-L1250		;CMP	AL,immed.
Q3D	DW	_CMP-CODES,ALXIM-L1250		;CMP	AX,immed.
	DW	0,0				;3E IS ds SEG O'RIDE.
Q3F	DW	_AAS-CODES,SINGL-L1250		;AAS.
Q40	DW	_INC-CODES,GPR16-L1250		;INC	AX.
Q41	DW	_INC-CODES,GPR16-L1250		;INC	CX.
Q42	DW	_INC-CODES,GPR16-L1250		;INC	DX.
Q43	DW	_INC-CODES,GPR16-L1250		;INC	BX.
Q44	DW	_INC-CODES,GPR16-L1250		;INC	SP.
Q45	DW	_INC-CODES,GPR16-L1250		;INC	BP.
Q46	DW	_INC-CODES,GPR16-L1250		;INC	SI.
Q47	DW	_INC-CODES,GPR16-L1250		;INC	DI.
Q48	DW	_DEC-CODES,GPR16-L1250		;DEC	AX.
Q49	DW	_DEC-CODES,GPR16-L1250		;DEC	CX.
Q4A	DW	_DEC-CODES,GPR16-L1250		;DEC	DX.
Q4B	DW	_DEC-CODES,GPR16-L1250		;DEC	BX.
Q4C	DW	_DEC-CODES,GPR16-L1250		;DEC	SP.
Q4D	DW	_DEC-CODES,GPR16-L1250		;DEC	BP.
Q4E	DW	_DEC-CODES,GPR16-L1250		;DEC	SI.
Q4F	DW	_DEC-CODES,GPR16-L1250		;DEC	DI.
Q50	DW	_PUSH-CODES,GPR16-L1250		;PUSH	AX.
Q51	DW	_PUSH-CODES,GPR16-L1250		;PUSH	CX.
Q52	DW	_PUSH-CODES,GPR16-L1250		;PUSH	DX.
Q53	DW	_PUSH-CODES,GPR16-L1250		;PUSH	BX.
Q54	DW	_PUSH-CODES,GPR16-L1250		;PUSH	SP.
Q55	DW	_PUSH-CODES,GPR16-L1250		;PUSH	BP.
Q56	DW	_PUSH-CODES,GPR16-L1250		;PUSH	SI.
Q57	DW	_PUSH-CODES,GPR16-L1250		;PUSH	DI.
Q58	DW	_POP-CODES,GPR16-L1250		;POP	AX.
Q59	DW	_POP-CODES,GPR16-L1250		;POP	CX.
Q5A	DW	_POP-CODES,GPR16-L1250		;POP	DX.
Q5B	DW	_POP-CODES,GPR16-L1250		;POP	BX.
Q5C	DW	_POP-CODES,GPR16-L1250		;POP	SP.
Q5D	DW	_POP-CODES,GPR16-L1250		;POP	BP.
Q5E	DW	_POP-CODES,GPR16-L1250		;POP	SI.
Q5F	DW	_POP-CODES,GPR16-L1250		;POP	DI.
	DW	0,ERHDL-L1250
	DW	0,ERHDL-L1250
	DW	0,ERHDL-L1250
	DW	0,ERHDL-L1250
	DW	0,ERHDL-L1250
	DW	0,ERHDL-L1250
	DW	0,ERHDL-L1250
	DW	0,ERHDL-L1250
	DW	0,ERHDL-L1250
	DW	0,ERHDL-L1250
	DW	0,ERHDL-L1250
	DW	0,ERHDL-L1250
	DW	0,ERHDL-L1250
	DW	0,ERHDL-L1250
	DW	0,ERHDL-L1250
	DW	0,ERHDL-L1250
Q70	DW	H5+_JO-CODES,L15BE-L1250+HA	;JO	label.
Q71	DW	H5+_JNO-CODES,L15BE-L1250+HA	;JNO	label.
Q72	DW	H5+_JB-CODES,L15BE-L1250+HA	;JB	label.
Q73	DW	H5+_JNB-CODES,L15BE-L1250+HA	;JNB	label.
Q74	DW	H5+_JZ-CODES,L15BE-L1250+HA	;JZ	label.
Q75	DW	H5+_JNZ-CODES,L15BE-L1250+HA	;JNZ	label.
Q76	DW	H5+_JBE-CODES,L15BE-L1250+HA	;JBE	label.
Q77	DW	H5+_JA-CODES,L15BE-L1250+HA	;JA	label.
Q78	DW	H5+_JS-CODES,L15BE-L1250+HA	;JS	label.
Q79	DW	H5+_JNS-CODES,L15BE-L1250+HA	;JNS	label.
Q7A	DW	H5+_JPE-CODES,L15BE-L1250+HA	;JPE	label.
Q7B	DW	H5+_JPO-CODES,L15BE-L1250+HA	;JPO	label.
Q7C	DW	H5+_JL-CODES,L15BE-L1250+HA	;JL	label.
Q7D	DW	H5+_JGE-CODES,L15BE-L1250+HA	;JGE	label.
Q7E	DW	H5+_JLE-CODES,L15BE-L1250+HA	;JLE	label.
Q7F	DW	H5+_JG-CODES,L15BE-L1250+HA	;JG	label.
Q80	DW	L1FD8,L12B8-L1250
Q81	DW	L1FD8,L12B8-L1250
Q82	DW	L1FD8,L12B8-L1250
Q83	DW	L1FD8,CDE83-L1250
Q84	DW	H2+_TEST-CODES,REGRM-L1250	;TEST	reg8,reg8/mem8.
Q85	DW	H2+_TEST-CODES,REGRM-L1250	;TEST	reg16,reg16/mem16.
Q86	DW	H3+_XCHG-CODES,REGRM-L1250	;XCHG	reg8,reg8/mem8.
Q87	DW	H3+_XCHG-CODES,REGRM-L1250	;XCHG	reg16,reg16/mem16.
Q88	DW	H3+_MOV-CODES,RMREG-L1250	;MOV
Q89	DW	H3+_MOV-CODES,RMREG-L1250	;MOV
Q8A	DW	H1+_MOV-CODES,REGRM-L1250	;MOV
Q8B	DW	H1+_MOV-CODES,REGRM-L1250	;MOV
Q8C	DW	H3+_MOV-CODES,L1575-L1250	;MOV
Q8D	DW	H1+_LEA-CODES,L_E_A-L1250	;LEA	reg16,mem16.
Q8E	DW	H1+_MOV-CODES,L158F-L1250	;MOV
Q8F	DW	H3+_POP-CODES,POP16-L1250	;POP	mem16.
Q90	DW	_NOP-CODES,SINGL-L1250		;NOP.
Q91	DW	_XCHG-CODES,XCHAX-L1250		;XCHG	CX,AX.
Q92	DW	_XCHG-CODES,XCHAX-L1250		;XCHG	DX,AX.
Q93	DW	_XCHG-CODES,XCHAX-L1250		;XCHG	BX,AX.
Q94	DW	_XCHG-CODES,XCHAX-L1250		;XCHG	SP,AX.
Q95	DW	_XCHG-CODES,XCHAX-L1250		;XCHG	BP,AX.
Q96	DW	_XCHG-CODES,XCHAX-L1250		;XCHG	SI,AX.
Q97	DW	_XCHG-CODES,XCHAX-L1250		;XCHG	DI,AX.
Q98	DW	_CBW-CODES,SINGL-L1250		;CBW.
Q99	DW	_CWD-CODES,SINGL-L1250		;CWD.
Q9A	DW	H6+CALF-CODES,L13FB-L1250+HA	;CALL	FAR PTR
Q9B	DW	_WAIT-CODES,SINGL-L1250		;WAIT.
Q9C	DW	_PSHF-CODES,SINGL-L1250		;PUSHF.
Q9D	DW	_POPF-CODES,SINGL-L1250		;POPF.
Q9E	DW	_SAHF-CODES,SINGL-L1250		;SAHF.
Q9F	DW	_LAHF-CODES,SINGL-L1250		;LAHF.
QA0	DW	H1+_MOV-CODES,L1417-L1250	;MOV
QA1	DW	H1+_MOV-CODES,L1417-L1250	;MOV
QA2	DW	H3+_MOV-CODES,L15F4-L1250	;MOV
QA3	DW	H3+_MOV-CODES,L15F4-L1250	;MOV
QA4	DW	_MOVB-CODES,STRNG-L1250		;MOVSB.
QA5	DW	_MOVW-CODES,STRNG-L1250		;MOVSW.
QA6	DW	_CMPB-CODES,STRNG-L1250		;CMPSB.
QA7	DW	_CMPW-CODES,STRNG-L1250		;CMPSW.
QA8	DW	_TEST-CODES,ALXIM-L1250		;TEST	AL,immed.
QA9	DW	_TEST-CODES,ALXIM-L1250		;TEST	AX,immed.
QAA	DW	_STOB-CODES,STRNG-L1250		;STOSB.
QAB	DW	_STOW-CODES,STRNG-L1250		;STOSW.
QAC	DW	_LODB-CODES,STRNG-L1250		;LODSB.
QAD	DW	_LODW-CODES,STRNG-L1250		;LODSW.
QAE	DW	_SCAB-CODES,STRNG-L1250		;SCASB.
QAF	DW	_SCAW-CODES,STRNG-L1250		;SCASW.
QB0	DW	_MOV-CODES,L162D-L1250		;MOV
QB1	DW	_MOV-CODES,L162D-L1250		;MOV
QB2	DW	_MOV-CODES,L162D-L1250		;MOV
QB3	DW	_MOV-CODES,L162D-L1250		;MOV
QB4	DW	_MOV-CODES,L162D-L1250		;MOV
QB5	DW	_MOV-CODES,L162D-L1250		;MOV
QB6	DW	_MOV-CODES,L162D-L1250		;MOV
QB7	DW	_MOV-CODES,L162D-L1250		;MOV
QB8	DW	_MOV-CODES,L1634-L1250		;MOV
QB9	DW	_MOV-CODES,L1634-L1250		;MOV
QBA	DW	_MOV-CODES,L1634-L1250		;MOV
QBB	DW	_MOV-CODES,L1634-L1250		;MOV
QBC	DW	_MOV-CODES,L1634-L1250		;MOV
QBD	DW	_MOV-CODES,L1634-L1250		;MOV
QBE	DW	_MOV-CODES,L1634-L1250		;MOV
QBF	DW	_MOV-CODES,L1634-L1250		;MOV
	DW	0,ERHDL-L1250
	DW	0,ERHDL-L1250
QC2	DW	RETNP-CODES,R_N_P-L1250		;RET NEAR	n.
QC3	DW	_RETN-CODES,RET_N-L1250		;RET NEAR.
QC4	DW	H1+_LES-CODES,LDSES-L1250	;LES	reg16,mem16.
QC5	DW	H1+_LDS-CODES,LDSES-L1250	;LDS	reg16,mem16.
QC6	DW	H3+_MOV-CODES,L12FF-L1250	;MOV
QC7	DW	H3+_MOV-CODES,L12FF-L1250	;MOV
	DW	0,ERHDL-L1250
	DW	0,ERHDL-L1250
QCA	DW	RETFP-CODES,R_F_P-L1250		;RET FAR	n.
QCB	DW	_RETF-CODES,RET_F-L1250		;RET FAR.
QCC	DW	H6+_INT-CODES,L163E-L1250+H2	;INT	3.
QCD	DW	H6+_INT-CODES,L1654-L1250+H2	;INT	immed.
QCE	DW	_INTO-CODES,SINGL-L1250		;INTO.
QCF	DW	_IRET-CODES,L17B7-L1250+H2	;IRET.
QD0	DW	L1FC0,ROTSH-L1250
QD1	DW	L1FC0,ROTSH-L1250
QD2	DW	L1FC0,ROTSH-L1250
QD3	DW	L1FC0,ROTSH-L1250
QD4	DW	_AAM-CODES,AAM_D-L1250		;AAM.
QD5	DW	_AAD-CODES,AAM_D-L1250		;AAD.
	DW	_DB-CODES,ERHDL-L1250
QD7	DW	_XLAT-CODES,XLATE-L1250		;XLAT.
QD8	DW	L2020,L1660-L1250	;THE FOLLOWING ARE 8087 CODES.
QD9	DW	L203C,L1683-L1250
QDA	DW	L2094,L16B2-L1250
QDB	DW	L20A4,L16B8-L1250
QDC	DW	L2020,L167A-L1250
QDD	DW	L20BC,L16CC-L1250
QDE	DW	L2094,L16ED-L1250
QDF	DW	L20E4,L16CC-L1250
QE0	DW	H5+_LOOPN-CODES,L15BE-L1250+HA	;LOOPNZ	label.
QE1	DW	H5+_LOOPZ-CODES,L15BE-L1250+HA	;LOOPZ	label.
QE2	DW	H5+_LOOP-CODES,L15BE-L1250+HA	;LOOP	label.
QE3	DW	H5+_JCXZ-CODES,L15BE-L1250+HA	;JCXZ	label.
QE4	DW	H7+_IN-CODES,IN_IM-L1250	;IN	AL,immed.
QE5	DW	H7+_IN-CODES,IN_IM-L1250	;IN	AX,immed.
QE6	DW	H7+_OUT-CODES,OUTIM-L1250	;OUT	immed,AL.
QE7	DW	H7+_OUT-CODES,OUTIM-L1250	;OUT	immed,AX,
QE8	DW	H6+_CALL-CODES,L15DF-L1250+HA	;CALL	label.
QE9	DW	H5+_JMP-CODES,L15C6-L1250+HA	;JMP	label.
QEA	DW	H5+_JMPF-CODES,L13FB-L1250+HA	;JMP	FAR PTR.
QEB	DW	H5+JMPSH-CODES,L15BA-L1250+HA	;JMP	SHORT	label.
QEC	DW	H7+_IN-CODES,IN_DX-L1250	;IN	AL,DX.
QED	DW	H7+_IN-CODES,IN_DX-L1250	;IN	AX,DX.
QEE	DW	H7+_OUT-CODES,OUTDX-L1250	;OUT	DX,AL.
QEF	DW	H7+_OUT-CODES,OUTDX-L1250	;OUT	DX,AX.
QF0	DW	_LOCK-CODES,PRECD-L1250		;LOCK.
	DW	0,ERHDL-L1250
QF2	DW	_REPN-CODES,PRECD-L1250		;REP (or REPNZ).
QF3	DW	_REPZ-CODES,PRECD-L1250		;REPZ.
QF4	DW	_HLT-CODES,SINGL-L1250		;HLT.
QF5	DW	_CMC-CODES,SINGL-L1250		;CMC.
QF6	DW	L1FF0,L1781-L1250
QF7	DW	L1FF0,L1781-L1250
QF8	DW	_CLC-CODES,SINGL-L1250		;CLC.
QF9	DW	_STC-CODES,SINGL-L1250		;STC.
QFA	DW	_CLI-CODES,SINGL-L1250		;CLI.
QFB	DW	_STI-CODES,SINGL-L1250		;STI.
QFC	DW	_CLD-CODES,SINGL-L1250		;CLD.
QFD	DW	_STD-CODES,SINGL-L1250		;STD.
QFE	DW	L2008,L178B-L1250
QFF	DW	L2008,L178B-L1250	;END OF OP CODES.
;THE FOLLOWING HANDLE OP CODES WITH MULTIPLE POSSIBLE MNEMONICS.
L1FC0	DB	0
	DW	H4+_ROL-CODES			;ROL
	DB	0
	DW	H4+_ROR-CODES			;ROR
	DB	0
	DW	H4+_RCL-CODES			;RCL
	DB	0
	DW	H4+_RCR-CODES			;RCR
	DB	0
	DW	H4+_SHL-CODES			;SHL
	DB	0
	DW	H4+_SHR-CODES			;SHR
	DB	0
	DW	0			;not an op code.
	DB	0
	DW	H4+_SAL-CODES			;SAL
L1FD8	DB	0
	DW	H4+_ADD-CODES			;ADD
	DB	0
	DW	H4+_OR-CODES			;OR
	DB	0
	DW	H4+_ADC-CODES			;ADC
	DB	0
	DW	H4+_SBB-CODES			;SBB
	DB	0
	DW	H4+_AND-CODES			;AND
	DB	0
	DW	H4+_SUB-CODES			;SUB
	DB	0
	DW	H4+_XOR-CODES			;XOR
	DB	0
	DW	H2+_CMP-CODES			;CMP
L1FF0	DB	0
	DW	H2+_TEST-CODES			;TEST
	DB	0
	DW	0			;not an op code.
	DB	0
	DW	H4+_NOT-CODES			;NOT
	DB	0
	DW	H4+_NEG-CODES			;NEG
	DB	0
	DW	H1+_MUL-CODES			;MUL
	DB	0
	DW	H1+_IMUL-CODES			;IMUL
	DB	0
	DW	H1+_DIV-CODES			;DIV
	DB	0
	DW	H1+_IDIV-CODES			;IDIV
L2008	DB	0
	DW	H4+_INC-CODES			;INC
	DB	0
	DW	H4+_DEC-CODES			;DEC
	DB	20
	DW	H6+_CALL-CODES			;CALL
	DB	20
	DW	H6+CALD-CODES			;CALL	DWORD PTR
	DB	20
	DW	H5+_JMP-CODES			;JMP
	DB	20
	DW	H5+JMPDW-CODES			;JMP	DWORD PTR
	DB	0
	DW	H1+_PUSH-CODES			;PUSH
	DB	0
	DW	0			;not an op code.
L2020	DW	H1+F03-CODES			;FADD
	DW	H1+F43-CODES			;FMUL
	DW	H1+F09-CODES			;FCOM
	DW	H1+F10-CODES			;FCOMP
	DW	H1+F59-CODES			;FSUB
	DW	H1+F61-CODES			;FSUBR
	DW	H1+F14-CODES			;FDIV
	DW	H1+F16-CODES			;FDIVR
L2030	DW	_MOVS-CODES			;MOVS
	DW	_CMPS-CODES			;CMPS
	DW	1,1			;not op codes.
	DW	_LODS-CODES			;LODS
	DW	1			;not an op code.
L203C	DW	H1+F33-CODES			;FLD
	DW	1			;not an 8087 code.
	DW	H3+F54-CODES			;FST
	DW	H3+F57-CODES			;FSTP
	DW	H1+F38-CODES			;FLDENV
	DW	H1+F37-CODES			;FLDCW
	DW	H3+F56-CODES			;FSTENV
	DW	H3+F55-CODES			;FSTCW
L204C	DW	H1+F33-CODES			;FLD
	DW	F65-CODES			;FXCH
	DW	F45-CODES			;FNOP
	DW	F57-CODES			;FSTP
L2054	DW	F07-CODES			;FCHS
	DW	F02-CODES			;FABS
	DW	1,1			;not 8087 codes.
	DW	F63-CODES			;FTST
	DW	F64-CODES			;FXAM
	DW	1,1			;not 8087 codes.
	DW	F34-CODES			;FLD1
	DW	F36-CODES			;FLDL2T
	DW	F35-CODES			;FLDL2E
	DW	F41-CODES			;FLDPI
	DW	F39-CODES			;FLDLG2
	DW	F40-CODES			;FLDLN2
	DW	F42-CODES			;FLDZ
	DW	1
	DW	F01-CODES			;F2XM1
	DW	F67-CODES			;FYL2X
	DW	F48-CODES			;FPTAN
	DW	F46-CODES			;FPATAN
	DW	F66-CODES			;FXTRACT
	DW	1
	DW	F12-CODES			;FDECSTP
	DW	F27-CODES			;FINCSTP
	DW	F47-CODES			;FPREM
	DW	F68-CODES			;FYL2XP1
	DW	F53-CODES			;FSQRT
	DW	1
	DW	F49-CODES			;FRNDINT
	DW	F52-CODES			;FSCALE
	DW	1,1
L2094	DW	H1+F20-CODES			;FIADD
	DW	H1+F26-CODES			;FIMUL
	DW	H1+F21-CODES			;FICOM
	DW	H1+F22-CODES			;FICOMP
	DW	H1+F31-CODES			;FISUB
	DW	H1+F32-CODES			;FISUBR
	DW	H1+F23-CODES			;FIDIV
	DW	H1+F24-CODES			;FIDIVR
L20A4	DW	H1+F25-CODES			;FILD
	DW	1
	DW	H3+F29-CODES			;FIST
	DW	H3+F30-CODES			;FISTP
	DW	1
	DW	H1+F33-CODES			;FLD
	DW	1
	DW	H3+F57-CODES			;FSTP
L20B4	DW	F18-CODES			;FENI
	DW	F13-CODES			;FDISI
	DW	F08-CODES			;FCLEX
	DW	F28-CODES			;FINIT
L20BC	DW	H1+F33-CODES			;FLD
	DW	1
	DW	H3+F54-CODES			;FST
	DW	H3+F57-CODES			;FSTP
	DW	F50-CODES			;FRSTOR
	DW	1
	DW	H3+F51-CODES			;FSAVE
	DW	H3+F58-CODES			;FSTSW
L20CC	DW	H3+F19-CODES			;FFREE
	DW	H3+F65-CODES			;FXCH
	DW	H3+F54-CODES			;FST
	DW	H3+F57-CODES			;FSTP
L20D4	DW	H1+F04-CODES			;FADDP
	DW	H1+F44-CODES			;FMULP
	DW	H1+F10-CODES			;FCOMP
	DW	H1+F11-CODES			;FCOMPP
	DW	H1+F60-CODES			;FSUBP
	DW	H1+F62-CODES			;FSUBRP
	DW	H1+F15-CODES			;FDIVP
	DW	H1+F17-CODES			;FDIVRP
L20E4	DW	H1+F25-CODES			;FILD
	DW	1
	DW	H3+F29-CODES			;FIST
	DW	H3+F30-CODES			;FISTP
	DW	H1+F05-CODES			;FBLD
	DW	H1+F25-CODES			;FILD
	DW	H3+F06-CODES			;FBSTP
	DW	H3+F30-CODES			;FISTP
CODES	DB	'AA',0C1	;aaa	THE OP CODES, ETC. W/HIGH BIT ON
_AAD	DB	'AA',0C4
_AAM	DB	'AA',0CDH
_AAS	DB	'AA',0D3
_ADC	DB	'AD',0C3
_ADD	DB	'AD',0C4
_AND	DB	'AN',0C4
B_PTR	DB	'BYTE PTR',0A0
_CALL	DB	'CAL',0CC
CALD	DB	'CALL',9,'DWORD PT',0D2
CALF	DB	'CALL',9,'FAR PT',0D2
_CBW	DB	'CB',0D7
_CLC	DB	'CL',0C3
_CLD	DB	'CL',0C4
_CLI	DB	'CL',0C9
_CMC	DB	'CM',0C3
_CMP	DB	'CM',0D0
_CMPS	DB	'CMP',0D3
_CMPB	DB	'CMPS',0C2	;cmpsb
_CMPW	DB	'CMPS',0D7	;cmpsw
CON_D	DB	'CON:',CR
_CWD	DB	'CW',0C4
_DAA	DB	'DA',0C1
_DAS	DB	'DA',0D3
_DB	DB	'D',0C2
_DD	DB	'D',0C4
_DEC	DB	'DE',0C3
OF_DI	DB	'[DI]',0AC
_DIV	DB	'DI',0D6
SPDUP	DB	' DUP',0A8
_DW	DB	'D',0D7
DWPTR	DB	'DWORD PTR',0A0
ENDTAB	DB	'END',89
ENDSG	DB	9,'ENDS',CR,LF,';',CR,8A
TEQUT	DB	9,'EQU',89
_ESC	DB	'ES',0C3	;esc
F01	DB	'F2XM',0B1	;f2xm1	8087 INSTRUCTIONS BEGIN.
F02	DB	'FAB',0D3	;fabs  (ALL THESE ARE MASM RESERVED
F03	DB	'FAD',0C4	;fadd	 WORDS).
F04	DB	'FADD',0D0	;faddp
F05	DB	'FBL',0C4	;fbld
F06	DB	'FBST',0D0	;fbstp
F07	DB	'FCH',0D3	;fchs
F08	DB	'FCLE',0D8	;fclex
F09	DB	'FCO',0CDH	;fcom
F10	DB	'FCOM',0D0	;fcomp
F11	DB	'FCOMP',0D0	;fcompp
F12	DB	'FDECST',0D0	;fdecstp
F13	DB	'FDIS',0C9	;fdisi
F14	DB	'FDI',0D6	;fdiv
F15	DB	'FDIV',0D0	;fdivp
F16	DB	'FDIV',0D2	;fdivr
F17	DB	'FDIVR',0D0	;fdivrp
F18	DB	'FEN',0C9	;feni
F19	DB	'FFRE',0C5	;ffree
F20	DB	'FIAD',0C4	;fiadd
F21	DB	'FICO',0CDH	;ficom
F22	DB	'FICOM',0D0	;ficomp
F23	DB	'FIDI',0D6	;fidiv
F24	DB	'FIDIV',0D2	;fidivr
F25	DB	'FIL',0C4	;fild
F26	DB	'FIMU',0CC	;fimul
F27	DB	'FINCST',0D0	;fincstp
F28	DB	'FINI',0D4	;finit
F29	DB	'FIS',0D4	;fist
F30	DB	'FIST',0D0	;fistp
F31	DB	'FISU',0C2	;fisub
F32	DB	'FISUB',0D2	;fisubr
F33	DB	'FL',0C4	;fld
F34	DB	'FLD',0B1	;fld1
F35	DB	'FLDL2',0C5	;fldl2e
F36	DB	'FLDL2',0D4	;fldl2t
F37	DB	'FLDC',0D7	;fldcw
F38	DB	'FLDEN',0D6	;fldenv
F39	DB	'FLDLG',0B2	;fldlg2
F40	DB	'FLDLN',0B2	;fldln2
F41	DB	'FLDP',0C9	;fldpi
F42	DB	'FLD',0DA	;fldz
F43	DB	'FMU',0CC	;fmul
F44	DB	'FMUL',0D0	;fmulp
F45	DB	'FNO',0D0	;fnop
F46	DB	'FPATA',0CE	;fpatan
F47	DB	'FPRE',0CDH	;fprem
F48	DB	'FPTA',0CE	;fptan
F49	DB	'FRNDIN',0D4	;frndint
F50	DB	'FRSTO',0D2	;frstor
F51	DB	'FSAV',0C5	;fsave
F52	DB	'FSCAL',0C5	;fscale
F53	DB	'FSQR',0D4	;fsqrt
F54	DB	'FS',0D4	;fst
F55	DB	'FSTC',0D7	;fstcw
F56	DB	'FSTEN',0D6	;fstenv
F57	DB	'FST',0D0	;fstp
F58	DB	'FSTS',0D7	;fstsw
F59	DB	'FSU',0C2	;fsub
F60	DB	'FSUB',0D0	;fsubp
F61	DB	'FSUB',0D2	;fsubr
F62	DB	'FSUBR',0D0	;fsubrp
F63	DB	'FTS',0D4	;ftst
F64	DB	'FXA',0CDH	;fxam
F65	DB	'FXC',0C8	;fxch
F66	DB	'FXTRAC',0D4	;fxtract
F67	DB	'FYL2',0D8	;fyl2x
F68	DB	'FYL2XP',0B1	;fyl2xp1	8087 INSTRUCTIONS END.
_HLT	DB	'HL',0D4
_IDIV	DB	'IDI',0D6
_IMUL	DB	'IMU',0CC
_IN	DB	'I',0CE
_INC	DB	'IN',0C3
_INT	DB	'IN',0D4
_INTO	DB	'INT',0CF
_IRET	DB	'IRE',0D4
_JA	DB	'J',0C1
_JB	DB	'J',0C2
_JBE	DB	'JB',0C5
_JCXZ	DB	'JCX',0DA
_JG	DB	'J',0C7
_JGE	DB	'JG',0C5
_JL	DB	'J',0CC
_JLE	DB	'JL',0C5
_JMP	DB	'JM',0D0
_JMPF	DB	'JMP',9,'FAR PT',0D2
JMPDW	DB	'JMP',9,'DWORD PT',0D2
JMPSH	DB	'JMP',9,'SHOR',0D4
_JNB	DB	'JN',0C2
_JNO	DB	'JN',0CF
_JNS	DB	'JN',0D3
_JNZ	DB	'JN',0DA
_JO	DB	'J',0CF
_JPE	DB	'JP',0C5
_JPO	DB	'JP',0CF
_JS	DB	'J',0D3
_JZ	DB	'J',0DA
_LAHF	DB	'LAH',0C6
_LDS	DB	'LD',0D3
_LEA	DB	'LE',0C1
_LES	DB	'LE',0D3
_LOCK	DB	'LOCK',89
_LODS	DB	'LOD',0D3
_LODB	DB	'LODS',0C2	;lodsb
_LODW	DB	'LODS',0D7	;lodsw
_LOOP	DB	'LOO',0D0
_LOOPN	DB	'LOOPN',0DA	;loopnz
_LOOPZ	DB	'LOOP',0DA
_MOV	DB	'MO',0D6
_MOVS	DB	'MOV',0D3
_MOVB	DB	'MOVS',0C2	;movsb
_MOVW	DB	'MOVS',0D7	;movsw
_MUL	DB	'MU',0CC
_NEG	DB	'NE',0C7
NO_OP	DB	9		;<TAB> nop
_NOP	DB	'NO',0D0
_NOT	DB	'NO',0D4
OFFST	DB	'OFFSET',0A0
_OR	DB	'O',0D2
_OUT	DB	'OU',0D4
_POP	DB	'PO',0D0
_POPF	DB	'POP',0C6
_PUSH	DB	'PUS',0C8
_PSHF	DB	'PUSH',0C6	;pushf
_RCL	DB	'RC',0CC
_RCR	DB	'RC',0D2
_REPN	DB	'REPNZ',89
_REPZ	DB	'REPZ',89
_RETF	DB	'RET_FA',0D2
RETFP	DB	'RET_FAR_PO',0D0
_RETN	DB	'RET_NEA',0D2
RETNP	DB	'RET_NEAR_PO',0D0
_ROL	DB	'RO',0CC
_ROR	DB	'RO',0D2
_SAHF	DB	'SAH',0C6
_SAL	DB	'SA',0D2
_SBB	DB	'SB',0C2
_SCAB	DB	'SCAS',0C2	;scasb
_SCAW	DB	'SCAS',0D7	;scasw
_SHL	DB	'SH',0CC
_SHR	DB	'SH',0D2
OF_SI	DB	'[SI',0DDH	;[si]
_STC	DB	'ST',0C3
_STD	DB	'ST',0C4
_STI	DB	'ST',0C9
_STOB	DB	'STOS',0C2	;stosb
_STOW	DB	'STOS',0D7	;stosw
_SUB	DB	'SU',0C2
TYTLE	DB	'TITLE',89
_TEST	DB	'TES',0D4
_WAIT	DB	'WAI',0D4
W_PTR	DB	'WORD PTR',0A0
_XCHG	DB	'XCH',0C7
_XLAT	DB	'XLA',0D4
_XOR	DB	'XO',0D2
;TEXT USED IN THE .ASM FILE.
T_SEG	DB	9,'SEGMENT'
EOL_H	DB	CR,8A			;EOL WITH THE HIGH BIT SET.
ASSUM	DB	9,'ASSUME DS:S'		;ASSUMEs TEXT.
ASSU1	DB	'0000',2C,' SS:S0000 ',2C,'CS:S0000 ',2C,'ES:S0000',CR,8A
ORIGN	DB	9,'ORG',9,'$',0ABH	;ORIGIN TEXT.
REG_8	DB	'ALCLDLBLAHCHDHBH'	;8-BIT REGISTER NAMES.
REG16	DB	'AXCXDXBXSPBPSIDI'	;16-BIT REGISTER NAMES.
REGSG	DB	'ESCSSSDS'		;SEGMENT REGISTER NAMES
BASE	DB	'BXBXBPBP'		;BASE REGISTER NAMES.
INDEX	DB	'SIDIBPBX'		;INDEX REGISTER NAMES.
RTTBL	DB	'IRTWMJCP?'	;REFERENCE TYPE TABLE FOR .REF FILE.
SGTBL	DB	'DSCE'			;SEGMENT TABLE FOR .REF FILE.
MAC83	DB	0,'PATCH83',9,'MACRO',CR,LF	;PATCH83 MACRO.
	DB	'ORG',9,'$-3',CR,LF
	DB	'DB',9,'81',CR,LF
	DB	'ORG',9,'$+2',CR,LF
	DB	'DB',9,'0',CR,LF
	DB	'ENDM',CR,LF
	DB	';',CR,8A
MACRF	DB	0,'RET_FAR',9,'MACRO',CR,LF	;RET_FAR MACRO.
	DB	'DB',9,'0CBH',CR,LF
	DB	'ENDM',CR,LF
	DB	';',CR,8A
MACFP	DB	0,'RET_FAR_POP',9,'MACRO',9,'X',CR,LF	;RET_FAR_POP
	DB	'DB',9,'0CAH',CR,LF		;MACRO.
	DB	'DW',9,'X',CR,LF
	DB	'ENDM',CR,LF
	DB	';',CR,8A
MACRN	DB	0,'RET_NEAR',9,'MACRO',CR,LF	;RET_NEAR MACRO.
	DB	'DB',9,'0C3H',CR,LF
	DB	'ENDM',CR,LF
	DB	';',CR,8A
MACNP	DB	0,'RET_NEAR_POP',9,'MACRO',9,'X',CR,LF	;RET_NEAR_POP
	DB	'DB',9,'0C2H',CR,LF		;MACRO.
	DB	'DW',9,'X',CR,LF
	DB	'ENDM',CR,LF
	DB	';',CR,8A,0FF
PAT83	DB	9,'PATCH83',CR,8A		;PATCH83 TEXT.
RDX16	DB	'.RADIX',9,'16',CR,LF		;.RADIX 16 TEXT.
LF_CR	DB	'LF',9,'EQU',9,'0AH',CR,LF	;<LF> EQUATE.
	DB	'CR',9,'EQU',9,'0DH',CR,LF,';',CR,LF	;<CR> EQUATE.
	DB	';INITIAL VALUES :',9,'CS:IP',9	;INITIAL VALUES TEXT.
CS_IP	DB	'0000:0000',CR,LF	;cs:ip VALUES TEXT.
	DB	';',9,9,9,'SS:SP',9	;ss:sp TEXT.
SS_SP	DB	'0000:0000',CR,8A	;ss:sp VALUES TEXT.
XARQ1	DB	'X <$'			;BEGINNING OF COMMAND LINE.
XARQ2	DB	'>',2C,' A <CON>',2C,' R <CON> or Q ? $'	;THE REST.
OFCER	DB	CR,LF,'Unable to close output file$'
FILEM	DB	'File $'
NF_ER	DB	' not found',7
E_O_L	DB	CR,LF,'$'
DIRER	DB	'No room in disk directory$'
DSKER	DB	'Insufficient space on disk$'
RDERR	DB	'Error in reading .EXE file$'
TYPER	DB	'Unrecognized type in .SEQ file near address '
ZEROH	DB	'0000H$'		;ADDR WHERE .SEQ TYPE ERROR IS.
ORDER	DB	'Addresses out of order near address '
ZHEOL	DB	'0000H',CR,LF,'$'	;ADDR WHERE OUT OF ORDER.
STRER	DB	'Undefined structure in .SEQ file$'
RELOC	DB	';Relo',0E3		;RELOC TEXT.
ASMXTN	DB	'ASM'			;.ASM FILE EXTENSION TEXT.
NUL_D	DB	'NUL '			;THE NULL DEVICE'S NAME.
S_QXT	DB	'.S_Q',0		;SEQ HELP FILE'S EXTENSION.
SEQXTN	DB	'SEQ'			;.SEQ FILE EXTENSION TEXT.
TBLXTN	DB	'TBL'			;.TBL FILE EXTENSION TEXT.
HEXER	DB	'Hex value error in .SEQ file$'
SZMSG	DB	'Bytes in output file: $'
FILER	DB	' File spec error$'
INCER	DB	7,'Reference table incomplete due to '
INSUF	DB	'Insufficient memory$'
CMDER	DB	'Invalid command$'
WRTGF	DB	CR,LF,'Writing $'
RTMSG	DB	'Building Reference Table',CR,LF,'$'
HLPBW	DB	0			;1 = BYTE, 2 = WORD ENTRY IN HELP FILE.
HLPFG	DB	0			;WRITE HELP IF FLAG IS ON.
HLPFN	DB	20 DUP(0)	;ASCIZ FILENAME OF SEQ HELP FILE.
HLPHD	DW	0			;SEQ HELP FILE'S HANDLE.
HLPNZ	DB	0			;SEQ HELP FILE NOT EMPTY FLAG.
HLP_B	DB	'0000',9,'B',CR,LF	;DATA TYPE = BYTE.
HLP_W	DB	'0000',9,'W',CR,LF	;DATA TYPE = WORD.
;
L2823	DW	0			;L081F, L0CD1, L1083, L1420.
L2825	DW	0,0			;L0D3D.
	DB	0
L282A	DB	0			;L1B57.
BUF24	DW	0C DUP(0)		;A 24-BYTE BUFFER.
RMMOD	LABEL	WORD
R_MCD	DB	0			;r/m BITS OF OP CODE #2.
MODCD	DB	0			;mod BITS OF OP CODE #2.
REGCD	DB	0			;reg BITS OF OP CODE #2.
L2846	DB	0			;L088F, L1978, L19AD, L1A72.
@COL 	DB	0			;COLUMN COUNTER.
OUTLL	DW	0			;OUTPUT FILE LENGTH (LOW).
OUTLH	DW	0			;OUTPUT FILE LENGTH (HIGH).
FILESZ	DW	0		;SOURCE FILE SIZE NOT ALREADY DONE.
XESZL	DW	0			;EXEC FILE SIZE (LOW).
XESZH	DB	0			; (HIGH).
L2854	DW	0	;L088F, L09FB, L0A35, L0C3D, L0EAB, L1B57.
L2856	DB	0	;L0872, L08C8, L0C3D, L1938, L1965, L19F1.
CURIP	DW	0			;CURRENT ip.
INITIP	DW	0			;INITIAL ip.
EOLRQ	DB	0			;FLAGS EOL REQUIRED.
NOPRQ	DB	0			;FLAGS nop REQUIRED.
OCPTR	DW	0	;OFFSET FROM CODES @ L20F4 TO CORRECT OP CODE.
@PASS	DB	0			;THE PASS #.
CHOICE	DB	0			;CHOICE OF X, A, R OR Q.
L2863	DB	0,0,0			;L0FC3, L0FE0, L0FF4.
L2866	DB	0	;L094F, L0C3D, L1250, L125A, L1277, STRNG,
					;SINGL, ERHDL, ORIDE, L1873.
L2869	DB	0	;L0AB5, L0F0C, L125A, L1277, L1420 ,L1873, L18CF
L286A	DB	0	;L0AB5, L0F0C, L1277, CDE83, L1332, L13C3,
					;L148F, L14D9, L178B, L187D.
OPCDE	DB	0			;OP CODE.
OPCD2	DB	0			;OP CODE #2.
IPFLG	DB	0			;INITIAL ip FLAG.
L286E	DB	0			;L0722, L0917.
TODOS	DB	0			;EXIT TO DOS FLAG.
SWT_O	DB	0FF			;.ASM OUTPUT SWITCH.
SWT_R	DB	0FF			;.TBL OUTPUT SWITCH.
SWT_E	DB	0FF			;EMBEDDED ADDRESSES SWITCH.
SWT_L	DB	0FF			;LABELS OR NUMBERS SWITCH.
SWT_F	DB	0FF			;ENABLE 8087 OP CODES SWITCH.
SWT_T	DB	0FF			;TRACE OUTPUT SWITCH.
SWT_B	DB	0FF			;BYTE REFERNECES SWITCH.
SWT_Z	DB	0FF			;SEQ HELP FILE SWITCH.
SWT_H	DB	0FF			;APPEND Hex SWITCH.
SWT_M	DB	0FF			;MACRO LIBRARY SWITCH.
T_S_Q	DB	9,3BH,27		;<TAB>, SEMICOLON, SINGLE QUOTE
L287C	DB	'HL',0A7		;QUOTED DATA - HIGH LOW QUOTE.
L287F	DW	0			;L0CD1, OPENF, SEQRD, L14BE.
WBPTR	DW	0	;POINTER TO CURRENT OFFSET INTO THE WRITE BUFF.
MEMSZ	DW	0			;AVAILABLE MEMORY.
NXTSEQ	DW	0			;NEXT SEQ FILE ADDRESS.
@PROG	DB	0		;POINTER TO PROG ROUTINES @ L1BA9.
L2888	DB	0	;L0722, L08AD, L0AEF, L0B4A, L0CB7, L0F24,
					;L0FA8, L104D, L1A34.
L2889	DW	0	;L07A5, L07B2, L07FE, L081F, L0C3D, L1A1A.
L288B	DW	L1250			;FIRST OP CODE ROUTINE ADDR.
L288D	DW	0			;L0984, L0C3D, L1447, L1A47.
ENDSEQ	DW	0	;L071B, L07A5, L07B2, L07E8, L081F, L08E6,<-|
			;L0C3D, L0DBF, L1A1A   END OF SEQ DATA.     |
L2891	DW	0			;L0C3D, L0E70, L0EC9, L0F24 |
SEQPTR	DW	0	;L0722, L0747, L0984, L0B4A, L0C03, L0CB7,  |
	;L0E4C, L0F24, L1447, L1A47  POINTER TO END OF SEQ DATA.  <-|
BU128	DB	80 DUP(0)		;128-BYTE BUFFER.
HIPTR	DW	0			;POINTER TO HIGHEST MEMORY USED
W2919	LABEL	WORD	;L0872, L08C8, L0902, L0C3D, L1938, L19F1, L1A0D
L2919	DB	0
L291A	DB	0			;L1938.
STFLG	DB	0			;STRUCTURE FLAG.
ASMFCB	DB	0			;FCB FOR .ASM FILE.
ASMFN	DB	'        '
ASMXT	DB	'       '
ASMFS	DB	'                      '
TBLFCB	DB	0			;FCB FOR .TBL FILE.
TBLFN	DB	'        '
TBLXT	DB	'                             '
KBDBF	DB	20			;32 BYTES MAX KBD INPUT.
INTRO	DB	'T'
L296A	DB	'he IBM Personal Computer Assembly'	;KBD BUFFER.
WRKBF	DB	' Code Generator',CR,LF	;WORKING BUFFER.
	DB	'By J. Gersbach BTVVMLAB(U6081) Public Domain Material',CR,LF
	DB	'Version 2.01 - Enhancements By J. Damke BOEVM1(DAMKE)',CR,LF,LF
	DB	'Comm'
SRCFCB	DB	'a'
SRCFN	DB	'nd summ'
W2A17	LABEL	WORD
L2A17	DB	'a'
SRCXT	DB	'r'			;EXECUTABLE FILE EXTENSION.
W2A19	LABEL	WORD
L2A19	DB	'y'
L2A1A	DB	' '
SRCCB	DB	':',CR
SRCRS	DB	LF,9
SRCFS	DW	2058			;"X ".
	DB	'Ex'
SRCDTE	DW	6365			;"ec".
	DB	'utable fil'
SRCCR	DB	'e'
SRCRR	DW	7073			;"sp".
	DB	'ec'
DSTFCB	DB	CR
DSTFN	DB	LF,9,'A <Assembly'
DSTRS	DB	' C'
DSTFS	DW	646F			;"od".
DSTHI	DB	'e file'
DSTRV	DB	'spec>',CR,LF,9
DSTCR	DB	'R <Reference table filespec>',CR,LF,9,'Q Quit and '
BUF26	DB	're'			;BUFFER FOR 26 BLOCK READ.
B_L_P	DW	7574			;"tu". # BYTES IN LAST PAGE.
EXESZ	DW	6E72			;"rn". .EXE FILE SIZE/512.
@REL 	DW	7420			;# RELOCATION ENTRIES.
HDRSZ	DW	206F			;"o ". SIZE OF HEADER/16.
	DB	'DOS',CR
STKSG	DW	0A0A			;<LF> <LF>.  ss VALUE.
STKSP	DW	7845,6365		;"Exec".  sp VALUE.
CDEIP	DW	7475			;"ut".  ip VALUE.
CDESG	DW	6261			;"ab".  cs VALUE.
OFFRE	DW	656C			;"le".  OFFSET TO RELOC'N ENTRIES.
BUF04	DW	6620			;" f".	;BUFFER FOR 4 BLOCK READ.
RELSG	DW	6C69			;"il".  SEG VALUE OF RELOC'N ENTRY.
	DB	'es'
SEQBF	DB	'pec ? $'		;BUFFER FOR SEQ READ.
	DB	1F9 DUP(0)
WRTBF	DB	0			;BUFFER FOR WRITE.
EOPGM	EQU	$+1FF
	S0000	ENDS
;
END	L0100
