CODE	 segment
	 assume  cs:CODE
	 org	 100h

MOV_STR  struc

	 dw	 ?		; Caller's BP
MOFF	 dw	 ?		; Caller's offset
MSEG	 dw	 ?		; Caller's segment
MFLG	 dw	 ?		; Caller's flags

MOV_STR  ends

INITIAL:
	 jmp	 START

OLDINT08_VEC label dword
OLDINT08_OFF dw  ?
OLDINT08_SEG dw  ?

SAVE_CX  dw	 ?
SAVE_SI  dw	 ?
SAVE_DI  dw	 ?

START:
	 xor	 ax,ax
	 mov	 ds,ax
	 assume  ds:nothing

	 cli
	 mov	 ax,offset cs:INT08
	 xchg	 ax,ds:[08h*4]
	 mov	 OLDINT08_OFF,ax

	 mov	 ax,cs
	 xchg	 ax,ds:[08h*4+2]
	 mov	 OLDINT08_SEG,ax
	 sti

	 mov	 ax,cs
	 add	 ax,30h 	; Skip past current segment
	 mov	 es,ax		; Make that ES
MOVE_AGAIN:
	 mov	 cx,-1
	 xor	 si,si		; Offsets of 0
	 xor	 di,di
MOVE_INT:
	 rep	 movs byte ptr es:[di],es:[si]
	 jcxz	 MOVE_AGAIN

	 ret			; Return to DOS

INT08:
	 pushf
	 call	 OLDINT08_VEC

	 sti			; Allow interrupts

	 push	 bp		; Prepare to address the stack
	 mov	 bp,sp		; Hello, Mr. Stack

	 push	 ax		; Save registers
	 push	 es

	 mov	 ax,cs

	 cmp	 ax,[bp].MSEG	; Same segment?
	 jne	 INT08_EXIT	; No, skip out

	 cmp	 [bp].MOFF,offset cs:MOVE_INT+1 ; Interrupted offset?
	 jne	 INT08_EXIT	; No, skip out

	 mov	 SAVE_CX,cx	; Save parameters
	 mov	 SAVE_SI,si
	 mov	 SAVE_DI,di

	 cli
	 les	 ax,OLDINT08_VEC ; Restore old handler
	 mov	 ds:[08h*4],ax
	 mov	 ds:[08h*4+2],es
INT08_EXIT:
	 pop	 es		; Restore
	 pop	 ax

	 pop	 bp		; Restore

	 iret			; Return to interrupted instruction

CODE	 ends

	 end	 INITIAL
