;	DESC:	Search for a volume name                             V1.00
;	IN:	*{DRIVE} drive number (0:default,1:A,2:B,etc...)
;	OUT:	*{SEG_VAL} segment and
;		*{OFFSET} offset of volume name
;		*{FLAG} has a value of 0 if a volume label is found
;	SAMPLE:	Callm,<DRIVE>,<SEG_VAL,OFFSET,FLAG>
;	################################################################

SRCH_VOD Segment Para Public 'DATA'
TRANSFER	DB	80H DUP(0)
SEGER		DW	0
OFFER		DW	0
FCBSRCH		DB	0FFH,5 DUP(0),8
DRIVE		DB	0
		DB	'???????????'
SRCH_VOD Ends
 

	Extrn	PUSHALL:Near
	Extrn	POPALL:Near
	Extrn	GET_DSK:Near
	Extrn	SET_DSK:Near

SRCH_VOC	Segment
	Assume	CS:SRCH_VOC,DS:SRCH_VOD
	Public	SRCH_VOL

						;notice.
	DB	'SRCH_VOL - V1.00, Copyright 1987, CoreTechs   ',0DH,0AH

SRCH_VOL	Proc	Near
	Call	PUSHALL				;save registers.

	Mov	AX,SRCH_VOD			;setup workarea.
	Mov	DS,AX

	Call	GET_DSK				;get DTA.
	Pop	SEGER				;and save address.
	Pop	OFFER

	Pop	AX				;recover drive number.

	Mov	DRIVE,AL			;save drive number.

	Push	DS				;setup DTA.
	Mov	AX,OFFSET TRANSFER
	Push	AX
	Call	SET_DSK

	Mov	AX,1100H			;search for volume name.
	Mov	DX,OFFSET FCBSRCH
	Int	21H

	Mov	AH,0				;return search flag.
	Push	AX

	Mov	AX,OFFSET TRANSFER
	Add	AX,8

	Push	AX				;return offset and
	Push	DS				;segment of volume name.

	Push	SEGER				;restore DTA.
	Push	OFFER
	Call	SET_DSK

	Call	POPALL				;restore registers.
	Ret
SRCH_VOL	Endp

SRCH_VOC	Ends
	End
