;	DESC:	Displays hexadecimal codes as ASCII values           V1.00
;	IN:	*{HEX_WORD} hex word (0000 - FFFF)
;	OUT:	*{ASC_HI} first two characters of result (i.e EF from EFAB)
;		*{ASC_LO} second two characters of result (i.e. AB from EFAB)
;	SAMPLE:	Callm	HEXDSPLY,<HEX_WORD>,<ASC_HI,ASC_LO>
;	##################################################################

	Extrn	PUSHALL:Near
	Extrn	POPALL:Near

HEXDSPLC	Segment
	Assume	CS:HEXDSPLC
	Public	HEXDSPLY

						;notice.
	DB	'HEXDSPLY - V1.00, Copyright 1987, CoreTechs   ',0DH,0AH

HEXDSPLY	Proc	Near
	Call	PUSHALL				;save registers.

	Pop	DX				;recover hex word.

	Mov	AX,0F000H			;mask out 4th nibble.
	And	AX,DX
	Mov	BH,AH
	Mov	CL,4
	Shr	BH,CL				;store in BH.

	Mov	AX,00F0H			;mask out 2nd nibble.
	And	AX,DX
	Mov	CH,AL
	Mov	CL,4
	Shr	CH,CL				;save permanent in CH.

	Mov	AX,0F00H			;mask out 3rd nibble.
	And	AX,DX
	Mov	BL,AH				;store in BH.

	Mov	AX,000FH			;mask out 1st nibble.
	And	AX,DX
	Mov	CL,AL				;store in CL.

	Cmp	BH,9				;determine if hex digit is
	Ja	BH1				;in 0-9 range.

	Add	BH,30H				;if not, add to make ASCII.
	Jmp	BL1

BH1:	Add	BH,37H				;add to make letter.

BL1:	Cmp	BL,9				;determine if hex digit is
	Ja	BL2				;in 0-9 range.

	Add	BL,30H				;if not, add to make ASCII.
	Jmp	CH1

BL2:	Add	BL,37H				;add to make letter.

CH1:	Cmp	CH,9				;determine if hex digit is
	Ja	CH2				;in 0-9 range.

	Add	CH,30H				;if not, add to make ASCII.
	Jmp	CL1

CH2:	Add	CH,37H				;add to make letter.

CL1:	Cmp	CL,9				;determine if hex digit is
	Ja	CL2				;in 0-9 range.

	Add	CL,30H				;if not, add to make ASCII.
	Jmp	DONE

CL2:	Add	CL,37H				;add to make letter.

DONE:	Push	CX				;return hex in ASCII format.
	Push	BX

	Call	POPALL				;recover registers.
	Ret

HEXDSPLY	Endp
HEXDSPLC	Ends
	End
