;	DESC:	gets a line of text from the keyboard                V1.00
;	IN:	*{MAX_CHARS} maximum # of characters to get from keyboard
;	OUT:	*{SEG_VAL} segment and
;		*{OFFSET} offset of text buffer
;		*{LENGTH} length of text
;	SAMPLE:	Callm	GET_CHAR,<MAX_CHARS>,<SEG_VAL,OFFSET,LENGTH>
;	##################################################################

GET_TEXD Segment Para Public 'DATA'
BUFFER		DB	80H DUP(20H)		;input buffer.
GET_TEXD Ends


	Extrn	PUSHALL:Near
	Extrn	POPALL:Near

GET_TEXC	Segment
	Assume	CS:GET_TEXC
	Public	GET_TEXT
						;notice.
	DB	'GET_TEXT - V1.00, Copyright 1987, CoreTechs   ',0DH,0AH

GET_TEXT	Proc	Near			;get character from keyboard.

	Call	PUSHALL				;save registers.

	Mov	AX,GET_TEXD			;setup workarea.
	Mov	DS,AX

	Mov	BP,OFFSET BUFFER		;locate buffer.

	Pop	CX				;get max. # of chars to get.

ANOTHR:	Mov	AH,0				;get a char from keyboard.
	Int	16H

	Mov	DS:[BP],AX			;store character in buffer.
	Inc	BP

	Cmp	AX,1C0DH			;see if end of line?
	Jz	FINITO

	Cmp	BP,CX				;see if max chars is exceeded.
	Jz	FINITO

	Jmp	ANOTHR				;else, get next char.

FINITO:	Push	BP				;return buffer length.

	Mov	AX,OFFSET BUFFER		;return buffer address.
	Push	AX
	Push	DS

	Call	POPALL				;restore registers
	Ret

GET_TEXT	Endp
GET_TEXC	Ends
	End
