;	DESC:	Converts Bit-Mapped file date to ASCII format        V1.00
;	IN :	*file date in form yyyyyyymmmmmddddd
;		where mm is the month 1-12
;		      dd is the day 1-31
;		      yy is the year 0-119 (1980-2099)
;	OUT :	*segment and
;		*offset of the file date in the form
;		mm/dd/yy
;	SAMPLE:	Callm	FILEDATE,<DATE>,<ES,BX>
;	################################################################

FILEDATD Segment Para Public 'FILEDATD'
MONTH		DW	'10'			;date to be returned in
		DB	'/'			;ASCII format.
DAY		DW	'10'
		DB	'/'
YEAR		DW	'08'
FILEDATD Ends

	Extrn	PUSHALL:Near
	Extrn	POPALL:Near
	Extrn	HEX_ASC:Near

FILEDATC	Segment
	Assume	CS:FILEDATC,DS:FILEDATD
	Public	FILEDATE

	Include	CALLM.MAC

						;notice.
	DB	'FILEDATE - V1.00, Copyright 1987, CoreTechs   ',0DH,0AH

FILEDATE	Proc	Near

	Call	PUSHALL				;save all registers.

	Mov	AX,FILEDATD			;set up the workarea.
	Mov	DS,AX

	Pop	DX				;recover bit-mapped date.

	Mov	AX,01E0H			;Mask out month from date.
	And	AX,DX
	Mov	CL,5
	Shr	AX,CL

						;convert month to ASCII.
	Callm	HEX_ASC,<0,AX>,<BX,BX,BX,BX,MONTH>
	Mov	AX,MONTH			;flip upper and lower parts
	Xchg	AH,AL				;of date components.
	Mov	MONTH,AX

	Mov	AX,001FH			;Mask out day from date.
	And	AX,DX

						;convert day to ASCII.
	Callm	HEX_ASC,<0,AX>,<BX,BX,BX,BX,DAY>
	Mov	AX,DAY				;flip upper and lower parts
	Xchg	AH,AL				;of date components.
	Mov	DAY,AX

	Mov	AX,0FE00H			;Mask out year from date.
	And	AX,DX
	Mov	CL,9
	Shr	AX,CL
	Add	AX,80				;for offset from 1900.

						;convert year to ASCII.
	Callm	HEX_ASC,<0,AX>,<BX,BX,BX,BX,YEAR>
	Mov	AX,YEAR				;flip upper and lower parts
	Xchg	AH,AL				;of date components.
	Mov	YEAR,AX

	Mov	AX,OFFSET MONTH			;return offset to date.
	Push	AX
	Push	DS

	Call	POPALL				;recover all registers.

	Ret

FILEDATE	Endp
FILEDATC	Ends
	End
