;
; Author: Scott Hopson          Mail: 76207,674
;
; This program traps the timer and system services interrupts
; The system services interrupt gets the System Request key from
; the keyboard interrupt. The code in int15 checks for a SysReq keypress
; and sets or resets a flag.
; The code for that vectors into the timer interrupt counts 18 clock ticks
; which occur at a rate of aprox. 18.2 ticks per second. After 18 ticks 
; been counted the code checks the flag set by int15 if it is 1 then the
; int8 routine gets the current Real Time Clock values stored in CMOS and
; converts the BCD values to bytes which are printed in the upper right hand
; corner of the text screen.
;
; As with most of my other programs you may use this and if you like it
; you DON'T have to pay me. I make enough money writing real software for a
; real company already. Besides I've already paid for my trip to the Bahamaas.
;
; Just use this code to help you learn something if you don't already know it.
;
; I believe in a free exchange of information for learning purposes so that
; we may all become better at our profession, as long as the info is not 
; proprietary.

                
code            segment para    public 'CODE'
                assume cs:code
                org     100h            ; this is a .COM program you must use
start:          jmp     main            ; exe2bin or link with /t option in
                                        ; TLINK from Borland.
oldint15        dw      2 dup(?)
oldtimer        dw      2 dup(?)
screen          dw      ?
printflag       db      1
clockval        db      3 dup(?)
count           db      0
oldbits         db      ?
clockstr        db      '??:??:???'  ; clock string buffer
                
int15           proc    far
                cmp     ah,85h       ;looking for SysRequest Key
                jne     call15
                cmp     al,0         ;only keypress...  
                jne     call15
                cmp     cs:printflag,0    ;let's switch flags...
                jne     st0
                mov     cs:printflag,1
                jmp     call15
st0:            mov     cs:printflag,0
call15:         pushf
                call    dword ptr cs:[oldint15]
                iret
int15           endp                            
                

int8            proc    far
                push    ax      ; always save regs. or you might blow up an
                push    cx      ; interrupted process, NO make that you WILL
                push    dx      ; blow up an interrupted process which will
                push    ds      ; cause a meltdown of the Operating System
                push    es
                push    si
                push    di
                
                push    cs      ; setup data segment
                pop     ds      
                
                pushf           ; call orginal vector so it can do
                call    dword ptr cs:[oldtimer]  ; its own housekeeping
                
get_time:       cmp     count,18     ; let's update on every second
                je      yah          ; timer ticks about 18.2 times per sec.
                jmp     exit
yah:            mov     count,0      ; reset counter
                cmp     printflag,1  ; are we allowed to display clock
                je      goon         ; yes
                jmp     exit         ; or did user press SysRequest key?

goon:           mov     ah,2    ; get real time clock values, remember they are
                int     1ah     ; returned as BCD that's Binary Coded Decimal 
                                ; for you beginners
                cmp     ch,12h  ; is it am or pm
                jb      amflag          ; it's am
                mov     clockstr+8,'p'  ; no it's pm
;
; Now comes the difficult part, We must convert the BCD values to printable
; ascii characters. Not to hard once you get the hang of it. I don't claim
; this to be the best method but it's fairly quick and that's what we need.
; We need to perform all this code in less than 1/18th of a second or the 
; system timer might start to lag a bit.
                
; The following section converts the values so we can get a 12 hour clock
; instead of a 24 hour clock.
;                
                cmp     ch,12h   ; is it 12 noon yet
                je      passit   ; yes so just skip it value is ok
                cmp     ch,19h   ; no, well is it later than 7:59 PM
                ja      subhigher ; yes, well let's handle it
                sub     ch,12h   ; no so just subtract 12 to get 12 hour time
                jmp     passit   ; and go on to next section
subhigher:      cmp     ch,21h   ; is it later than 9:59 PM
                ja      adjustbcd ; yes
                sub     ch,18h   ; no, so we subtract appropriate value
                jmp     passit
adjustbcd:      cmp     ch,22h   ; is it later than 10:59 PM
                ja      clk11    ; yes
                mov     ch,10h   ; no but it's still 10:?? PM
                jmp     passit
clk11:          mov     ch,11h   ; it is the 11th hour PM
                jmp     passit   ; we don't care about 12:00 PM because we                                              
                                 ; wrap around to 0:00 AM
                                 
amflag:         mov     clockstr+8,'a'  ; set the am flag

passit:         mov     clockval,ch     ; store clock values in the string
                mov     clockval+1,cl
                mov     clockval+2,dh
                mov     cx,0304h    ; load count into ch and shift val into cl
                mov     si,offset clockval 
                mov     di,offset clockstr
convert:        mov     ah,[si]     ; now comes the actual BCD convertion stuff
                shr     ah,cl
                add     ah,48
                mov     [di],ah
                inc     di
                mov     ah,[si]
                rol     ah,cl
                shr     ah,cl
                add     ah,48
                mov     [di],ah
                inc     di          ; skip the colon in the string
                inc     di
                dec     ch
                cmp     ch,0
                je      printit     ; we're done so let's display the string
                inc     si
                jmp     convert

printit:        mov     es,word ptr screen  ; load es with video mem address
                mov     di,142              ; starting screen position
                mov     si,offset clockstr  ; location of string to display
                mov     cx,9                ; number of bytes to display
                cld
loopit:         movsb           ; move a byte from DS:SI to ES:DI
                inc     di      ; leave current attribute in place
                loop    loopit  ; keep going until cx = 0
                
exit:           inc     count   ; just another tick
                pop     di
                pop     si      ; restore all pushed registers or you'll be
                pop     es      ; sorry!
                pop     ds
                pop     dx
                pop     cx
                pop     ax
                
                iret            ; return from interrupt
                
lastbyte        db      ?       ; marker for end of memory to save when we
                                ; go TSR, we just toss the stuff we don't need
int8            endp            

                
main            proc    near
                push    cs      ; setup data segment
                pop     ds      

                int     11h     ; get machine hardware info
                test    al,30h  ; is out screen monochrome
                jnz     cga     ; or cga
                mov     word ptr screen,0b000h  ; mono
                jmp     getvect
cga:            mov     word ptr screen,0b800h

getvect:        mov     ax,3508h        ; get system timer interrupt
                int     21h
                mov     word ptr oldtimer,bx    ; save it
                mov     word ptr oldtimer+2,es

                mov     ax,2508h        ; revector int 8
                mov     dx,offset int8  ; to our code
                int     21h

                mov     ax,3515h        ; get system services interrupt
                int     21h
                mov     word ptr oldint15,bx  ; save it also
                mov     word ptr oldint15+2,es

                mov     ax,2515h        ; and revector to our code
                mov     dx,offset int15
                int     21h

                mov     es,cs:2ch       ; free our copy of DOS environment
                mov     ah,49h          ; PSP:2ch points to environment segment
                int     21h             ; which we don't need
                
                mov     ah,09h          ; display our little message
                mov     dx,offset message
                int     21h
                
                mov     dx,offset lastbyte ; get end address of memory to keep 
                int     27h             ; call old DOS TSR call

message         db      'Clock Program Loaded...',10,13
                db      'Press [SysReq] Key to disable Clock',10,13
                db      'Press [SysReq] Key again to enable Clock',10,13,24h

main            endp
code            ends
                end     start                                           