; CTRLALT5.ASM is a TSR utility to discourage malicious others from rebooting
; your computer under uncontrolled circumstances. Once loaded, the computer
; will ignore any <Ctrl><Alt><Del> attempts, unless the TSR's effect is first
; cleared by pressing a special key sequence.
;
; Loading:	Make sure CTRLALT5.COM is in the current drive/directory and
;		type CTRLALT5, followed by <Enter>. 
;
; Usage:	After the program is loaded, any attempt to reboot using the
;		standard <Ctrl><Alt><Del> sequence will be ignored. Only after
;		the "clear key" sequence has been pressed (default is
;		<Ctrl><Alt><K5>, where <K5> is the '5' key on the numeric
;		keypad) will the standard reboot sequence function.
;
; Program by:	Donald G. Roy
; Date:		August 4, 1987
; Version:	1.01
;
;-- Modification History: ---------------------------------------------------
; 07/05/87	- added code to release the DOS environment passed to program
;		  (reduces memory requirement by 80 bytes)
;
;-- Program begins: ---------------------------------------------------------
;
; Equates:
;
KB_DATA		EQU	60H		;keyboard data port
KB_CTRL		EQU	61H		;keyboard control port
EOI		EQU	20H		;8259 end-of-int value
INT_CTRL_PORT	EQU	20H		;8259 PIC port
DEL_KEY		EQU	83		;scan code for 'DEL' key
ALT_KEY		EQU	8		;shift code for Alt key
CTRL_KEY	EQU	4		;shift code for Ctrl key
;
;the program's effect is nullified by pressing <Ctrl><Alt> with the key
; whose SCAN code is specified below. After this, any <Ctrl><Alt><Del>
; request will proceed normally. Reset this value to your liking.
;
CLEAR_KEY	EQU	76		;scan code for keypad-5 key
;
CODE		SEGMENT PARA PUBLIC 'CODE'
		ASSUME	CS:CODE
		ORG 44			;segment of environment area
ENVIRON		DW 	?		;environment pointer, used later
		ORG	100H
BEGIN:		JMP	INITIALIZE	;jump to initialization code
;
; storage area
;
OLD_INT_9H	LABEL	DWORD		;old keyboard interrupt vector
OLD_KBD_INT	DW	2 DUP (?)
;
; All keystrokes are checked here. If neither the <Del> key, or the "clear
; key" have been pressed, the program passes the keystroke along the chain
; of execution (ie: to BIOS or any other TSR that has captured INT 9H).
;
CTRLALT		PROC	NEAR
		STI			;enable interrupts
		PUSH	AX		;save registers
		PUSH	BX
		PUSH	CX
		PUSH	DX
		PUSH	SI
		PUSH	DI
		PUSH	DS
		PUSH	ES
		IN	AL,KB_DATA	;get scan code from KB
		CMP	AL,DEL_KEY	;was the 'DEL' key pressed?
		JNE	CA4		;no, see if clear key request
		MOV	AH,2		;get state of shift keys
		INT	16H		;from BIOS
		TEST	AL,ALT_KEY	;is the ALT key depressed?
		JE	EXIT		;no, get lost
		TEST	AL,CTRL_KEY	;is the CTRL key also depressed?
		JE	EXIT		;no
		JMP	CA5		;else ignore reboot request
CA4:		CMP	AL,CLEAR_KEY	;is this a clear key request?
		JNE	EXIT		;no, ignore
		MOV	AH,2		;get state of shift keys
		INT	16H		;from BIOS
		TEST	AL,ALT_KEY	;is the ALT key depressed?
		JE	EXIT		;no, get lost
		TEST	AL,CTRL_KEY	;is the CTRL key also depressed?
		JE	EXIT		;no
;
;we have a proper key sequence for the clear key request
;
		CALL	KB_RESET	;enable the keyboard
;
;reset the keyboard interrupt vector to original state as it
;was found at startup so next <ctrl><Alt><Del> request will work OK.
;
		MOV	AH,25H			;set new vector
		MOV	AL,9			;for INT 9H
		MOV	DX,OLD_KBD_INT[2]	;get the segment
		MOV	DS,DX			;into DS
		MOV	DX,OLD_KBD_INT		;get offset of KB handler
		INT	21H			;and reset via DOS
		JMP	DONE			;and leave
;
;EXIT is achieved thru here when execution is to be transferred to the
; normal KB interrupt handling routine.
;
EXIT:		POP	ES		;restore registers
		POP	DS
		POP	DI
		POP	SI
		POP	DX
		POP	CX
		POP	BX
		POP	AX
		JMP	OLD_INT_9H	;goto KB BIOS routine
;
;the Ctrl-Alt-Del combination was pressed. Unless the TSR's effect has been
; cleared, the request is ignored.
;
CA5:		CALL	KB_RESET	;reset KB, end 8259 int
DONE:		POP	ES		;restore registers for exit
		POP	DS
		POP	DI
		POP	SI
		POP	DX
		POP	CX
		POP	BX
		POP	AX
		IRET			;return to interrupted program
CTRLALT		ENDP
;
;KB_RESET resets the keyboard and sends an EOI to the 8259 PIC.
;
KB_RESET	PROC	NEAR
		IN	AL,KB_CTRL	;get current control port value
		MOV	AH,AL		;save it
		OR	AL,80H		;set bit 7
		OUT	KB_CTRL,AL	;send reset value
		MOV	AL,AH		;restore orig value
		OUT	KB_CTRL,AL	;send value to enable keyboard
		CLI			;disable interrupts
		MOV	AL,EOI		;get end of INT value
		OUT	INT_CTRL_PORT,AL	;send to 8259 chip
		STI			;enable interrupts
		RET
KB_RESET	ENDP
;
;INITIALIZE performs the necessary steps for resident installation.
;
INITIALIZE	PROC	NEAR
;save old INT 9 vector and replace it with one pointing to the code
; we'll leave behind in memory.
		MOV	AH,35H			;get vector
		MOV	AL,9
		INT	21H
		MOV	OLD_KBD_INT,BX		;save offset
		MOV	OLD_KBD_INT[2],ES	;save segment
		MOV	AH,25H			;set new vector
		MOV	AL,9
		LEA	DX,CTRLALT		;point to body of program
		INT	21H
;
;Reduce memory requirements by trashing the copy of the environment
; passed to the program by DOS.
;
		MOV AX,ENVIRON	;point to environment
		MOV ES,AX
		MOV AH,73	;and free it
		INT 21H		;via DOS
;
;exit through INT 27H (terminate and stay resident)
;
		MOV	DX,OFFSET INITIALIZE
		INT	27H
INITIALIZE	ENDP
;
CODE	ENDS
	END	BEGIN
