cseg	segment para public 'code'
org	100h
exec	proc far

; This program is used as a program loader. After being used to load
; a program, it can be used to load up to 4 programs, including return of
; control to the original program. DOS 2.00 or later is required.
; To use it with interpretive BASIC, enter 'EXEC BASIC.COM progname'.
; See the sample program RUNIT.BAS for an example of the use of this
; program.

	assume cs:cseg,ds:cseg,ss:nothing,es:nothing

p000:	mov dx,offset copyr	; print copyright message
	call p500
	mov ah,30h		; get dos version
	int 21h
	cmp al,0		; is al zero?
	jnz p005		; no - it's dos 2.00 or later
	mov dx,offset baddos
	call p500		; print message
	jmp p099		; terminate

p005:				; set PSP pointer in communications area
	push ds
	xor ax,ax		; make it zero
	mov ds,ax
	mov si,4f0h		; set pointer to subroutine entry point
	mov ax,offset another
	mov [si],ax		; save is dos comm. area
	add si,2		; set pointer to PSP
	mov ax,es		; get PSP segment
	mov [si],ax		; save in dos comm. area
	pop ds			; restore ds

p010:				; check command line
	mov si,80h		; get command line
p015:				; restart entry point
	mov al,[si]
	cmp al,0		; anything there?
	jnz p020		; yes
	mov dx,offset nocomm	; no
	call p500		; print message
	jmp p099		; terminate

p020:				; copy command line
	mov ch,0
	mov cl,al
	inc si			; check next char
	mov al,[si]
	cmp al,' '              ; is it a leading space?
	jnz p021		; no
	inc si			; yes - ignore it
	dec cl
p021:
	push cx 		; save char count
	mov al,0		; initialize work area
	mov cx,offset stak
	mov di,offset prog
	sub cx,di
	repnz stosb		; zero it
	pop cx			; restore char count

	mov di,offset prog	; point to target area
p022:
	mov al,[si]		; get char
	cmp al,' '              ; space?
	jz p025 		; yes
	cmp al,'/'              ; slash?
	jz p025 		; yes
	mov [di],al		; copy char
	inc si
	inc di
	loop p022
p025:
	push si 		; save command start point
	mov di,offset comm
	mov [di],cl		; set remaining length
	inc di
	repnz movsb		; copy command portion
	mov al,0dh
	mov [di],al		; add carriage return

	pop si			; get command start point
	mov di,offset fcb1
	mov ah,29h
	mov al,1		; scan off leading separators
	int 21h 		; parse filename for fcb1

	mov di,offset fcb2
	mov ah,29h
	mov al,1
	int 21h 		; parse filename for fcb2

p040:				; release memory
	mov ax,offset endprog	; number of paragraphs to keep
	add ax,15		; last address plus 15
	mov cl,4
	sar ax,cl		; divide by 16 to get paragraphs
	mov bx,ax
	mov ah,4ah
	int 21h 		; free memory
	jnc p050		; no error
	aam
	add ax,3030h
	xchg ah,al
	mov si,offset memerr
	mov [si],ax
	mov dx,offset badmem
	call p500
	jmp p099

p050:				; point to command line
	mov si,offset parm2
	mov dx,offset comm
	mov [si],dx
	mov ax,ds
	mov [si+2],ax

p060:				; point to fcbs
	mov si,offset parm3	; fcb 1
	mov dx,offset fcb1
	mov [si],dx
	mov ax,ds
	mov [si+2],ax

	mov si,offset parm4	; fcb 2
	mov dx,offset fcb2
	mov [si],dx
	mov ax,ds
	mov [si+2],ax

p070:				; make call
	mov si,offset stak	; save stack
	mov [si],sp
	mov [si+2],ss

	mov ah,4bh		; load prog
	mov al,0		; load & execute
	mov dx,offset prog	; point to prog name
	mov bx,offset parm1	; point to parameter
	int 21h 		; load & execute program

	mov bx,cs		; restore stack
	mov ds,bx
	mov es,bx
	mov si,offset stak
	cli			; no interrupts
	mov sp,[si]
	mov ss,[si+2]
	sti			; allow interrupts
	jnc p080		; no error
	aam			; get error code
	add ax,3030h
	xchg ah,al
	mov si,offset callerr
	mov [si],ax
	mov dx,offset badcal1	; print error message
	call p500
	mov si,offset comm
	mov al,'$'
	mov [si],al
	mov dx,offset prog
	call p500
	mov dx,offset badcal2
	call p500
	jmp p099

p080:				; start next program
	mov si,offset another
	mov cx,[si]		; any more to execute?
	jcxz p099		; no
	dec cx
	mov [si],cx		; decrement counter
	mov si,offset prog1	; point to first program
	mov ax,80		; size of each program name
	mul cx
	add si,ax		; point to next program
	jmp p015		; execute it

p099:				; end
	push ds
	xor ax,ax		; make it zero
	mov ds,ax
	mov si,4f0h		; word at 0:4f0 is dos comm. area
	mov [si],ax		; zero it
	add si,2		; next word
	mov [si],ax		; zero it too
	pop ds			; restore ds
	int 20h 		; terminate

p500	proc near		; print message
	push ax
	mov ah,9
	int 21h
	pop ax
	ret
p500	endp

	; messages

copyr	db 'EXEC - Copyright 1983 Data Base Decisions',10,13,'$'
baddos	db 'DOS 2.00 or later required',07,'$'
nocomm	db 'No file entered',07,'$'

badmem	db 'Unable to release memory.  Error: '
memerr	dw 0
	db 7,'$'

badcal1 db 'Unable to execute program $'

badcal2 db '  Error: '
callerr dw 0
	db 7,'$'

	; work area

prog	db 80 dup(0)		; program name
comm	db 80 dup(0)		; command line parameters - may be overridden
				; by fcb(s)
fcb1	db 40 dup(0)		; fcb 1
fcb2	db 40 dup(0)		; fcb 2

stak	dw 0			; save sp
	dw 0			; save ss

	; program data area

signature dw 01237h		; used by application to validate that
				; EXEC.COM is really there
another dw 0			; execute another? 0=no, 1=yes
prog1	db 80 dup(0)		; 1st program
prog2	db 80 dup(0)		; 2nd program
prog3	db 80 dup(0)		; 3rd program
prog4	db 80 dup(0)		; 4th program

	; exec parameter block

parm1	dw 0			; environment
parm2	dd 0			; command line
parm3	dd 0			; default FCB
parm4	dd 0			; second default FCB

endprog db 0

exec	endp
cseg	ends
end	exec
                                                                                          