; QFRESH.ASM - lengthen DRAM refresh interval for improved system performance
;
; QFRESH.COM - sets quick refresh - PCTOOLS SI reports 285%
; DFRESH.COM - resets to default refresh - PCTOOLS SI reports 260%


INTERVAL_LOW	EQU	0dh	; start testing at 30h, BIOS uses 0Dh
INTERVAL_HIGH	EQU	00h	; start testing at 00h, BIOS uses 00h

; Peter's AT, Michael's AT optimum 0076h

CODE	SEGMENT
	ASSUME	CS:CODE, DS:CODE
	ORG	100h
start:
	jmp	set_timer
msg	db	"Normal memory refresh active$", 0Dh, 0Ah

set_timer:

	mov	al, 74h			; Timer #1, low byte then high byte
	out	43h, al			; send command
	mov	al, INTERVAL_LOW	; load low byte of interval
	out	41h, al			; send to timer
	mov	al, INTERVAL_HIGH	; load high byte of interval
	out	41h, al			; send to timer
	mov	dx, OFFSET msg		; load pointer to msg
	mov	ah, 09h			; DOS display string
	int	21h			; call DOS
	mov	ax, 4C00h		; DOS exit, ERRORLEVEL=0
	int	21h			; call DOS

CODE	ENDS
	END	start

	