;compare. asm  -  comparison with cmpsb
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
STACKSEG    SEGMENT   STACK  'STACK'

             dw     500h  dup (?)

STACKSEG    ENDS
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
DATASTUFF    SEGMENT   PUBLIC  'DATA'

ax_byte      db  2
bx_byte      db  2
cx_byte      db  2
dx_byte      db  2
si_byte      db  2
di_byte      db  2
bp_byte      db  2
sp_byte      db  2

; + + + + + + + + + + + + + + + START DATA BELOW THIS LINE
EXTRN  ch1str:BYTE
entry_banner     db  13,10, "Enter a word for a word search", 0
no_match_banner  db  "There was no match", 0
input_buffer     db   80 dup (?) 
letter_count     dw   ?
; + + + + + + + + + + + + + + + END DATA ABOVE THIS LINE

DATASTUFF    ENDS
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
CODESTUFF    SEGMENT   PUBLIC  'CODE'

EXTRN  show_regs:NEAR , set_reg_style:NEAR , set_count:NEAR
EXTRN  set_blue:NEAR , get_continue:NEAR

EXTRN  get_num:NEAR ,            print_num:NEAR 
EXTRN  get_string:NEAR ,         print_string:NEAR
EXTRN  get_ascii_byte:NEAR  ,    print_ascii_byte:NEAR
EXTRN  get_ascii:NEAR  ,         print_ascii:NEAR
EXTRN  get_hex_byte:NEAR ,       print_hex_byte:NEAR
EXTRN  get_hex:NEAR ,            print_hex:NEAR 
EXTRN  get_binary_byte:NEAR ,    print_binary_byte:NEAR
EXTRN  get_binary:NEAR ,         print_binary:NEAR

EXTRN  get_signed_byte:NEAR ,    print_signed_byte:NEAR
EXTRN  get_unsigned_byte:NEAR ,  print_unsigned_byte:NEAR
EXTRN  get_signed:NEAR ,         print_signed:NEAR
EXTRN  get_unsigned:NEAR ,       print_unsigned:NEAR 
EXTRN  get_signed_4byte:NEAR ,   print_signed_4byte:NEAR
EXTRN  get_unsigned_4byte:NEAR , print_unsigned_4byte:NEAR
EXTRN  get_signed_8byte:NEAR ,   print_signed_8byte:NEAR
EXTRN  get_unsigned_8byte:NEAR , print_unsigned_8byte:NEAR

       ASSUME cs:CODESTUFF, ds:DATASTUFF

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

main   proc far
start: push  ds               ; set up for return
       sub   ax,ax
       push  ax

       mov   ax, DATASTUFF
       mov   ds,ax

; + + + + + + + + + + + + + + + START CODE BELOW THIS LINE
       mov   ax, seg ch1str      ; load es register
       mov   es, ax
       cld                       ; clear DF (increment)

big_loop:
       ; get a word for the word search
       mov   ax, offset entry_banner
       call  print_string
       mov   ax, offset input_buffer
       call  get_string

       ; find the end of string
       mov   al, 0               ; compare with 0
       mov   bx, offset input_buffer
       mov   cx, 0               ; letter count
letter_count_loop:
       cmp   al, [bx]            ; compare to 0
       je    end_of_count_loop
       inc   cx                  ; increment count
       inc   bx                  ; increment pointer
       jmp   letter_count_loop
end_of_count_loop:
       jcxz  big_loop    ; if cx = 0, string is empty so redo
       mov   letter_count, cx	   ; store our count

       ; look for word match
       mov   di, offset ch1str
       mov   cx, $$$$           ; $$$$ = length of ch1str
       sub   cx, letter_count   ; start of last possible match

word_search_loop:
       push  di                  ; start of search
       push  cx                  ; character count for ch1str
       mov   si, offset input_buffer
       mov   cx, letter_count
       repe  cmpsb               ; the actual comparison
       je    found_it            ; if equal we matched

       ; no match. are we finished?
       pop   cx
       pop   di
       inc   di                  ; move to next character
       loop  word_search_loop

       ; we fell through. We finished, but found no match
       mov   ax, offset no_match_banner
       call  print_string
       jmp   big_loop

found_it:
       pop   cx                  ; clear cx off the stack
       pop   di                  ; start of the match
       mov   si, offset input_buffer
       mov   cx, 25              ; move 25 characters
transfer_loop:
       mov   al, es:[di]
       mov   [si], al
       inc   si
       inc   di
       loop  transfer_loop
       mov   BYTE PTR [si], 0    ; end of a C string

       mov   ax, offset input_buffer
       call  print_string
       jmp   big_loop
; + + + + + + + + + + + + + + + END CODE ABOVE THIS LINE

       ret

main   endp

CODESTUFF    ENDS
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

       END     start


