PAGE 66,132
TITLE NOLF - PRINTER FRONT END
;
; BY: RICHARD HAMILTON (713) 726-9459
;
; PURPOSE:
; THIS PROGRAM IS A FRONT END TO THE PRINTER INTERRUPT TO DELETE ANY 
; LINE FEEDS SENT BY THE SOFTWARE TO THE PRINTER. THIS IS FOR PRINTERS
; WHICH WILL ALWAYS INSERT LF AFTER CR.
;
; NOTE: THROUGH OUT THIS PROGRAM THE PRINTER INTERRUPT IS REFERRED TO
;       BY IT'S DECIMAL NUMBER. MANY PEOPLE REFUR TO INTERRUPTS BY
;       THEIR HEXIDECIMAL NUMBER. THE PRINTER INTERRUPT IS 17H OR 23D.
;
; TECHNICAL DESIGN:
; THIS PROGRAM SHOULD BE INVOKED IN THE AUTOEXEC.BAT FILE OR ANY TIME 
; AFTER BOOTING DOS. UPON FIRST ENTRY THE PROGRAM WILL SAVE THE STANDARD 
; INTERRUPT 23 ADDRESS IN THIS PROGRAM FOR A JUMP AFTER CHECKING THE 
; CHARTER SENT (IN AL) FOR LF. THE STANDARD INTERRUPT 23 ADDRESS WILL
; BE REPLACED WITH THE ADDRESS OF THIS PROGRAM'S SECONDARY ENTRY POINT
; CHARACTER SCANNING. NEXT THE PROGRAM WILL EXIT TO DOS WITH AN INTERRUPT
; 27H TO STAY RESIDENT. BECAUSE THE PSP PRECEEDS THIS CODE, 100H BYTES ARE
; TAKEN FROM AVALIABLE MEMORY FOR THE PSP BY USING INT 27H. MANY PROGRAMS
; MOVE THE CODE FROM THE SECONDARY ENTRY POINT TO PROGRAM'S LASTBYTE AND
; OVERLAY THE PSP. THEN THEY DO NOT ADJUST DX FOR THE PSP LENGTH, AND
; CONSEQUENTLY KEEP RESIDENT ONLY THE LENGTH OF CODE THAT WAS MOVED OVER
; THE PSP. BECAUSE WE ARE USING INT 27, ONLY THE FIRST 5C OF THE PSP IS 
; NECESSARY TO KEEP. ALTHOUGH THIS PRACTICE SAVES A FEW BYTES, IT WAS
; NOT DONE IN THIS PROGRAM FOR THE SAKE OF SIMPLICITY. AS THIS PROGRAM IS
; RIGHT NOW, IT TAKES LESS THAN 300 BYTES INCLUDING THE PSP.
; PLEASE CONSULT THE TECHNICAL REFERENCE MANUAL STARTING OF PAGE A-42 FOR 
; ADDITIONAL INSIGHTS INTO THE BIOS PRINTER INTERRUPT HANDLER.
;
; INPUTS:  AL CONTAINS INPUT PRINT BYTE
;          ALL OTHER VALUES UNKNOWN
;
; OUTPUTS: AL CONTAINS INPUT PRINT BYTE OR
;          AN IRET IS DONE WITH NO PROCESSING
;
CSEG     SEGMENT PARA PUBLIC 'CODE'
         ASSUME  CS:CSEG
START    PROC    FAR
INIT:                                 ;THIS POINT IS ENTERED ONLY ONCE TO SET
                                      ;UP VECTOR TABLE FOR INT23.
                                      ;INTERRUPT VECTOR ADDRESSES FOR INVOCKING
                                      ;AT THE SECONDARY ENTRY POINT "PRINT".
         CLI                          ;CLEAR INTERRUPTS SO WE WILL NOT BE 
                                      ;INTERRUPTED BY ANY ADDITIONAL PRINTING.
         XOR    DX,DX                 ;SET DX TO 0 FOR MOVE INTO ES.
         MOV    ES,DX                 ;POINT TO LOWEST SEGMENT IN DOS.
         LDS    DX,DWORD PTR ES:INT23_ADDR ;GET PREVIOUS INT 23 SEGMENT & OFFSET.
         MOV    WORD PTR CS:INT23_SAV,DX ;STORE REAL INT23 ADDRESS IN OUR ROUTINE.
         MOV    WORD PTR CS:INT23_SAV+2,DS ;ALSO STORE INT23 SEGMENT ADDRESS.
         MOV    WORD PTR ES:INT23_OFF,OFFSET PRINT ;STORE OUR NEW ENTRY POINT
                                      ;OFFSET IN VECTOR TABLE.
         MOV    ES:INT23_SEG,CS       ;STORE OUR NEW SEGMENT ADDRESS IN VECTOR
                                      ;TABLE.
         STI                          ;IT IS NOW SAFE TO ALLOW INTERRUPTS.
         LEA    DX,WORD PTR CS:LASTBYTE ;SET PROGRAM LENGTH FOR INT 27H SO DOS
                                      ;KNOWS HOW MUCH MEMORY WILL BE RESIDENT
         ADD    DX,100H               ;ADD IN LENGTH OF PSP IN TOTAL MEMORY.
         INT    27H                   ;GO BACK TO DOS WITH RESIDENCY.
;
; THE FOLLOWING IS LOCATED HERE BECAUSE THE MICROSOFT ASSEMBLER HAS A BUG
; WHICH WILL RESOLVE THE FOWARD DOUBLE WORD REFERENCE TO THIS VARIABLE, BUT
; WILL STILL INDICATE A PHASE ERROR. THIS BUG HAS BEEN REPORTED TO IBM AND
; MICROSOFT.
; 
INT23_SAV DD     0                    ;INTERRUPT 23 JUMP TABLE ADDRESS SAVE AREA.
;
PRINT:
         CMP    AL,CS:LINEF           ;IS THE CHAR A LINE FEED?
         JE     SKIPLF                ;YES, GO SKIP LINEFEED.
         JMP    DWORD PTR INT23_SAV   ;JUMP TO BIOS FOR STANDARD KB PROCESSING.
SKIPLF:  IRET                         ;RETURN TO PROGRAM DOING NOTHING.
;
; DATA DEFINITIONS FOLLOW. THESE ARE IN THE CODE SEGMENT FOR SIMPLICITY.
;
LINEF     DB     0AH                   ;DEFINE CHAR FOR LINEFEED.
INT23_ADDR EQU   5CH                   ;OFFSET INTO VECTOR TABLE FOR INT23 ADDRESS. 
INT23_OFF EQU    5CH                   ;OFFSET INTO VECTOR TABLE FOR INT23 OFFSET.
INT23_SEG EQU    5EH                   ;OFFSET INTO VECTOR TABLE FOR INT23 SEGMENT.
LASTBYTE  EQU    $+1                   ;THIS MUST BE ONE MORE THAN THE LAST BYTE OF
                                       ;THIS PROGRAM TO INDICATE TO DOS HOW MUCH
                                       ;MEMORY TO KEEP RESIDENT AFTER INT 27H.
START     ENDP
CSEG      ENDS
          END
