;
;Define save area for old stack and new stack
;
stack_ptr	dw	?	;old stack pointer
stack_seg	dw	?	;old stack segment

newstack	db 100h dup (?)	;256 bytes for new stack
newstacktop	equ	$-2	;top of new stack



;
;switch to new stack
;
switch2new	proc	near		;switch to new stack
		cli			;turn interrupts off
		mov	cs:stack_ptr,sp	;save old SP
		mov	cs:stack_seg,ss	;save old SS
		mov	ax,cs		;get current segment
		mov	ss,ax		;set stack segment
		mov	sp,newstacktop	;set stack pointer
		sti			;re-enable interrupts
		ret			;return to caller
switch2new	endp			;


;
;switch back to old stack
;
switch2old	proc	near		;switch back to old stack
		cli			;turn interrupts off
		mov	ss,cs:stack_seg	;restore old SS
		mov	sp,cs:stack_ptr	;restore old SP
		sti			;re-enable interrupts
		ret			;return to caller
switch2old	endp			;
