	PAGE	,132

CSEG	SEGMENT
	ASSUME	CS:CSEG, DS:NOTHING, ES:NOTHING
	ORG	0000H			; For all device drivers

Header	DD	-1			; One device
	DW	08000H			; Character device
StratA	DW	Strat			; Strategy entrance
IntrA	DW	Intr			; Interrupt entrance
	DB	'Scrolock'		; 8 character dummy name

;	Note: Put resident part of DDD here.
	TITLE	SCROLOCK -- Holds screen every page

COMMENT	$
	SCROLOCK.COM -- Locks scrolling of screen

	Generate EXE file using the following commands:
	MASM SCROLOCK;
	LINK SCROLOCK;

	Load from CONFIG.SYS file by use of the command:
	DEVICE=SCROLOCK.EXE followed by an optional line count
	and an optional keyword ON. If no line count is given,
	the CGA normal line count of 25 will be used. If the
	keyword ON is used, Scroll-Lock will be turned on.

	Load at system command or from within AUTOEXEC.BAT.
	Type: SCROLOCK followed by an optional line count and
	an optional keyword ON. If no line count is given, the
	CGA normal line count of 25 will be used. If the keyword
	ON is used, Scroll-Lock will be turned on.

	To use, toggle the Scroll-Lock key to activate and
	deactivate. If active, screen will fill to the bottom
	line, will scroll until the line where the cursor was is
	at the top and then the screen will freeze with the
	cursor in the bottom left corner. To get the next
	screen-full, hit any key. Note: The key will be
	used later, so if you want just another screen-full,
	hit the Ctrl, Alt or either Shift key.

	If your CONFIG.SYS file contains the line
	DEVICE=ANSI.SYS
	you MUST change ANSI.SYS with these instructions:
	
	DEBUG ANSI.SYS
	E 29D 90 90
	E 2A1 90 90
	W
	Q

	$

;	All Data
;	--------

DATA		SEGMENT AT 00040H	; ROM-BIOS Data area
		ORG	00017H
KB_FLAG		DB	?
SCROLL_STATE	EQU	010H
DATA		ENDS

OldIntr09	DW	?		; Interrupt vector storage
		DW	?
OldIntr10	DW	?
		DW	?
LineCount	DB	?		; Line counter
ActPage		DB	?		; Active page (0 usually)
MaxRows		DB	25		; Maximum screen rows

COMMENT	$
	If your screen has more than 25 lines, enter the
	correct number on the command line after SCROLOCK.
	You may use SCROLOCK for each screen length you have
	available on your video board. Otherwise, don't load
	SCROLOCK more than once.
	$

;	Intercept of Interrupt 10H -- BIOS Video Call
;	---------------------------------------------

NewIntr10:
	STI				; Allow interrupts
	PUSH	DS			; Save registers
	PUSH	AX
	PUSH	CS			; Set DS = CS
	POP	DS
	ASSUME	DS:CSEG
	CMP	AH,005H			; Change active page?
	JE	SetPage			; Yes, save page
	CMP	AH,000H			; Change video mode?
	JE	ClrScrAndPage		; Yes, stop at bottom
	CMP	AX,00600H		; Clear video screen?
	JE	ClrScr			; Yes, stop at bottom
	CMP	AX,00601H		; Roll up one line?
	JNE	ExitIntr10		; No, exit
	CMP	CX,000H			; From first line?
	JNE	ExitIntr10		; No, exit
	MOV	AL,MaxRows
	CMP	DH,AL			; To last line?
	JNE	ExitIntr10		; No, exit
	PUSH	DS			; Yes, set up for keyboard
	MOV	AX,SEG DATA		; status check in low
	MOV	DS,AX			; memory 0040:0017
	ASSUME	DS:DATA
	TEST	KB_FLAG,SCROLL_STATE
	POP	DS			; Scroll-Lock locked?
	ASSUME	DS:CSEG
	JZ	ExitIntr10		; No, not locked
	INC	LineCount		; Yes, now count lines
	MOV	AL,MaxRows		; Overflow point
LoopUntil:
	CMP	LineCount,AL		; Maximum roll?
	JA	LoopUntil		; Yes, loop until key pressed
	JMP	SHORT ExitIntr10	; No, roll some more

ClrScrAndPage:
	MOV	ActPage,000H		; Reset page zero
ClrScr:
	MOV	AL,MaxRows
	MOV	LineCount,AL		; Do not allow any roll
	JMP	SHORT ExitIntr10

SetPage:
	MOV	ActPage,AL		; Save new page
ExitIntr10:
	POP	AX			; Restore registers
	POP	DS
	JMP	DWORD PTR CS:OldIntr10	; Perform video request

;	Intercept of Interrupt 9H -- Hardware Keyboard
;	----------------------------------------------

NewIntr09:
	ASSUME	DS:NOTHING
	PUSH	AX			; Save registers
	PUSH	BX
	PUSH	CX
	PUSH	DX
	STI				; Allow interrupts
	IN	AL,060H			; Read scan code
	TEST	AL,080H			; Key pressed?
	JNE	ExitIntr09		; No, exit
	MOV	AH,003H			; Yes, get cursor line
	MOV	BH,ActPage		; for this page
	INT	010H
	MOV	AH,MaxRows		; Calculate rows to bottom
	SUB	AH,DH
	MOV	LineCount,AH		; Allow roll again
ExitIntr09:
	POP	DX			; Restore registers
	POP	CX
	POP	BX
	POP	AX
	JMP	DWORD PTR CS:OldIntr09	; Perform keyboard request

IOPacket	STRUC
IO_CMDLEN	DB	?
IO_UNIT		DB	?
IO_CMD		DB	?
IO_STATUS	DW	?
		DB	8 DUP(?)
IO_MEDIA	DB	?
IO_ADDRESS	DW	?
		DW	?
IO_COUNT	DW	?
IO_START	DW	?
IOPacket	ENDS

Init	PROC	FAR
	ASSUME	DS:NOTHING, ES:NOTHING

Packet	DD	0			; Request packet address

Strat:
	MOV	WORD PTR Packet,BX	; Save Packet info
	MOV	WORD PTR Packet+2,ES
	RET

Intr:
	PUSH	BX			; Save registers
	PUSH	DS

;	Note: Put initialization code here.
;	Save all registers used except DS & BX.
;	After code, restore same registers and
;	JMP to "Exit".

;	Initialization Procedure
;	------------------------

	PUSH	AX			; Save registers used
	PUSH	DX
	PUSH	ES
	PUSH 	SI
	LDS	BX,DWORD PTR Packet
	LDS	SI,DWORD PTR [BX+IO_COUNT]
	SUB	BX,BX			; Zero counter
Bypass:
	LODSB				; Get CMD character
	CMP	AL,00DH			; CR code?
	JE	Install			; Yes, done with analysis
	CMP	AL,00AH			; LF code?
	JE	Install			; Yes, done with analysis
	CMP	AL,01AH			; EOF code?
	JE	Install			; Yes, done with analysis
	CALL	Delimit			; Is it a delimiter?
	JNE	Bypass			; No, skip garbage
CommandLoop:
	LODSB				; Get a character
	CMP	AL,00DH			; CR code?
	JE	Install			; Yes, done with analysis
	CMP	AL,00AH			; LF code?
	JE	Install			; Yes, done with analysis
	CMP	AL,01AH			; EOF code?
	JE	Install			; Yes, done with analysis
	CMP	AL,'0'			; Below digits?
	JB	CommandLoop		; Yes, ignore all
	CMP	AL,'9'			; Within digits?
	JNA	Digits			; Yes, accumulate count
	AND	AL,NOT 020H		; Translate lower case
	CMP	AL,'N'			; N of ON?
	JNE	CommandLoop		; No, ignore all
	PUSH	DS			; Yes, set Scroll-Lock
	MOV	AX,SEG DATA		; bit in low
	MOV	DS,AX			; memory 0040:0017
	ASSUME	DS:DATA
	OR	KB_FLAG,SCROLL_STATE
	POP	DS
	ASSUME	DS:CSEG
	JMP	CommandLoop		; and look for more

Digits:
	SUB	AL,'0'			; Convert to value
	SHL	BL,1			; Multiply BL by 10
	ADD	AL,BL			; by shifts and adds
	SHL	BL,1
	SHL	BL,1
	ADD	BL,AL			; Keep value in BL
	JMP	CommandLoop		; Get more

Install:
	OR	BL,BL			; Any value found?
	JNZ	HasDigits		; Yes, bypass set-to-25
	MOV	BL,25			; No, set to 25
HasDigits:
	PUSH	CS			; DS = CS for DOS functs
	POP	DS
	ASSUME	DS:CSEG
	MOV	MaxRows,BL		; Save for scroll limits
	DEC	MaxRows			; Adjust line count down
	MOV	LineCount,000H		; Scroll full page
	MOV	ActPage,000H		; Assume page 0
	MOV	AX,03509H		; Get interrupt 9 vector
	INT	021H
	MOV	OldIntr09,BX		; Save it
	MOV	OldIntr09+2,ES
	MOV	DX,OFFSET NewIntr09	; Set new interrupt 9 vector
	MOV	AX,02509H
	INT	021H
	MOV	AX,03510H		; Get interrupt 10 vector
	INT	021H
	MOV	OldIntr10,BX		; Save it
	MOV	OldIntr10+2,ES
	MOV	DX,OFFSET NewIntr10	; Set new interrupt 10 vector
	MOV	AX,02510H
	INT	021H
	MOV	DX,OFFSET Message	; Show installed message
	MOV	AH,009H
	INT	021H
	POP	SI			; Restore registers
	POP	ES
	POP	DX
	POP	AX
	JMP	SHORT Exit

Delimit	PROC	NEAR
	CMP	AL,9			; Tab?
	JE	DelimitEnd
	CMP	AL,' '			; Space?
	JE	DelimitEnd
	CMP	AL,'/'			; Switch?
	JE	DelimitEnd
	CMP	AL,'-'			; Unix switch?
	JE	DelimitEnd
	OR	AL,AL			; Null?
DelimitEnd:
	RET				; Exit Z or NZ
Delimit	ENDP

Message		DB	'SCROLOCK installed',00DH,00AH,'$'

Exit:
	ASSUME	DS:NOTHING, ES:NOTHING
	LDS	BX,DWORD PTR Packet	; Restore Packet info
	MOV	WORD PTR [BX+IO_ADDRESS],OFFSET Init	; Set memory
;	Note: Change "Init" above to correct ending address
	MOV	WORD PTR [BX+IO_ADDRESS+2],CS	; to be resident
	MOV	[BX+IO_STATUS],00100H	; Set done bits
	POP	DS			; Restore registers used
	POP	BX
	RET				; Exit device installaion
Init	ENDP

;	Delete lines containing "ENDS" and "END" above.

EXEPacket	IOPacket	<>	; Requires packet space

Start	PROC	NEAR			; Execute DDD installation
	MOV	SP,OFFSET StackTop	; Shorten stack
	PUSH	ES			; Save PSP segment
	MOV	AH,049H			; Release environment
	MOV	ES,ES:0002CH
	INT	021H
	PUSH	CS			; DS = CS
	POP	DS
	ASSUME	DS:CSEG
	POP	AX			; ES:0081 = Command string
	MOV	EXEPacket.IO_COUNT+2,AX	; Put address in packet
	MOV	EXEPacket.IO_COUNT,00081H
	SUB	AL,AL			; 0 = Initialize DDD
	MOV	EXEPacket.IO_CMD,AL	; Put command in packet
	MOV	BX,OFFSET EXEPacket	; ES:BX = packet address
	PUSH	CS
	POP	ES
	ASSUME	ES:CSEG
	PUSH	CS			; FAR return
	CALL	StratA			; Perform strategy
	PUSH	CS			; FAR return
	CALL	IntrA			; Perform interrupt
	MOV	DX,EXEPacket.IO_ADDRESS	; Get ending address
	ADD	DX,0010FH		; Add PSP and round up
	MOV	CL,4			; Convert to paragraphs
	SHR	DX,CL
	MOV	AX,03100H		; DOS stay resident function
	INT	021H

		DW	080H DUP (?)
StackTop	DW	0
Start	ENDP
CSEG	ENDS
	END	Start
