
       page    64,132
       title   SIZER - test the size of a file for PASCAL batch files
       subttl  by Tony Alan Rhea 11/14/83
;
;
comment *

       This program tests the size of a file and sets an errorlevel
       based on it's findings.  Currently, it is set up for the file
       ERRLOG and expects it to be 115 bytes long.  If it does not find
       the file or it is not 115 bytes big, an errorlevel 1 is returned
       (the file is assumed to be in the current working directory).
       Otherwise, errorlevel 0 is returned.  This program requires DOS
       2.0.

       This program is currently set up for the PASCAL compiler.  If PAS1
       goes OK, the following output is generated:

         IBM Personal Computer Pascal Compiler
         Version 1.00 (C)Copyright IBM Corp 1981
          Pass One    No Errors Detected.

       which is exactly 115 bytes big when redirected to a disk file.  To use
       this program with the other compilers/assemblers, follow these steps.
          1. Run the compiler/assembler on a known good program and redirect
             the output to the disk file ERRLOG.
          2. Do a "DIR ERRLOG" and look at the size of the file.
          3. Put the file size in the EQUATE section below in SIZELO (SIZEHI
             should always be zero unless your compiler generates more than
             64k of messages!).
          4. If you like, change the FILENAME DB statement near the end of
             this program to a filename of your liking.
          5. Assemble and link as follows:
                MASM SIZER,,;
                LINK SIZER;                   (Ignore "NO STACK" message)
                EXE2BIN SIZER.EXE SIZER.COM
          6. Have fun!

       One note for you PASCAL fans: PAS2 does not like to have his output
       redirected -- it hangs the system.  I haven't investigated it so I
       don't know the reason why.  If someone figures out why, please pass
       it along.

       Usage:
             echo off
             cls
             echo Compiling %1 .....
             pas1 %1,,; > errlog
             SIZER
             if errorlevel 1 goto error
             echo PAS1 ok.  Starting PAS2....
             pas2
             goto end
             :error
             edit %1.pas
             :end
             echo on

       Copyright (C) 1983  Tony Alan Rhea
       This program may be copied and distributed for personal use
       but not for profit provided this notice is included.  Author makes
       no warranty, expressed or implied, as to the correct nature and
       operation of this software.


       You may make and distribute as many copies of this program as you wish
       for your PERSONAL use only ( NOT for business purposes, please! ).
       Feel free to modify, mutilate, or adulterate this program.  If you come
       up with an bug or improvement, please let me know by writing me at this
       address:
               Tony A. Rhea
               1030 Ivy Lane
               Cary, NC  27511
       If you do modify it, please give me credit in the program.  This helps
       to preserve my ego and increase my fame (but, unfortunately, NOT my
       financial status).  Also, I would appreciate a copy of the modified
       version, preferably on disk (I'll be happy to return your diskette).

       If you like this program ( or HATE it ), please let me know.  Drop me
       a line at the address given above.

       This program has been submitted for publication in PC-WORLD magazine.


         Revision history:
            rev 1.0  11/14/83                         { original release }


       *
;
;
; Equates
;
;
one    equ     '1'
zero   equ     '0'
cr     equ     0dh
lf     equ     0ah
dollar equ     '$'
sizelo equ    115d             ;expected file size in bytes -- low portion
sizehi equ    0                ;expected file size in bytes -- hi  portion
       page
;
;
; Program entry point
;
;
cseg   segment para 'code'
       assume  cs:cseg, ds:cseg, ss:nothing, es:cseg
       org     100h            ;for .COM file
entry  proc    near
       mov     ah,30h          ;set function code -- get DOS version number
       int     21h             ;and request DOS service
       cmp     al,0            ;is it pre-DOS 2.0?
       jne     entry10         ;if not, continue
       jmp     dosexit         ;else tell user & quit
;
;
; At this point we have DOS 2.0 or better.  Try to open the file.
;
;
entry10 label  near
       push    cs              ;save CS and
       pop     ds              ;get into DS for addressability
       lea     dx,filename     ;point DS:DX to filename
       mov     ax,3d00h        ;function = open file for read-only
       int     21h             ;request DOS service
       jnc     entry20         ;if no carry flag, continue
       jmp     fileerror10     ;else cannot open file -- error ID in AX
;
;
; At this point we have opened the file.  Now let's get it's size.
; The file handle is in AX.
;
;
entry20 label  near
       mov     bx,ax           ;put file handle in BX
       mov     ax,4202h        ;function code -- LSEEK to EOF
       xor     cx,cx           ;set CX and
       xor     dx,dx           ;DX to zero -- no offset desired
       int     21h             ;request DOS service
       jnc     entry30         ;if no carry flag then continue
       jmp     fileerror10     ;else access error -- ID in AX, handle in BX
;
;
; Now the read/write pointer is at the end-of-file.  DX:AX contains the
; new location of the pointer (DX contains the most significant part).
;
;
entry30 label  near
       cmp     dx,sizehi       ;is high portion of file size same?
       je      entry40         ;if so, continue
       jmp     sizediff        ;else file is a different size
entry40 label  near
       cmp     ax,sizelo       ;is low portion of file size same?
       je      entry50         ;if so, continue
       jmp     sizediff        ;else file is a different size
       page
;
;
; At this point we have determined that the file exists and is the desired
; size.  Set errorlevel 0 and exit, closing the file.
;
;
entry50 label  near
       mov     ah,3eh          ;set function code = close file -- handle in BX
       int     21h             ;request DOS service
       jnc     entry60         ;if no carry flag, continue
       jmp     fileerror       ;else error closing file
entry60 label  near
       mov     ax,4c00h        ;set DOS function -- terminate with errorlevel 0
       int     21h             ;and request DOS service -- end of program
;
;
; If we get here we don't have DOS 2.0.  Tell user about it and terminate via
; function 0 (which works for all DOS versions).
;
;
dosexit label near
       lea     dx,errmsg1      ;point DX to DOS error msg
       mov     ah,9            ;set function code -- print string
       int     21h             ;and request DOS service
       xor     ax,ax           ;set function code to zero -- program terminate
       int     21h             ;and request DOS service (no errorlevel returned)
;
;
; If we get here we encountered a file error after we successfully opened the
; file.  We must close it in order to release the handle for other programs to
; use.
;
;
fileerror label near
       push    ax              ;save the error code for a moment
       mov     ah,3eh          ;set function code = close file -- handle in BX
       int     21h             ;request DOS service
       pop     ax              ;get error code back -- ignore errors in closing file
;
;
; If we get here we encountered a file error of some sort.  Display the error.
; The error code is in AX.
;
;
fileerror10 label near
       push    ax              ;save error code for a moment
       lea     dx,errmsg2      ;point DX to syntax error msg
       mov     ah,9            ;set function code -- print string
       int     21h             ;and request DOS service
       pop     dx              ;get error code into DX
       cmp     dl,9            ;is it greater than nine?
       jle     fileerror20     ;if so, then only a one digit error code
       push    dx              ;else save a copy of error code
       mov     dl,one          ;and put a '1' in DL -- tens digit
       mov     ah,02           ;set function code -- display char in DL
       int     21h             ;and request DOS service
       pop     dx              ;restore old error code and
       sub     dl,10d          ;subtract ten -- tens digit now displayed
fileerror20 label near
       add     dl,zero         ;convert from binary to ASCII code
       mov     ah,02           ;set function code -- display char in DL
       int     21h             ;and request DOS service
       mov     dl,cr           ;send
       mov     ah,02           ;    a
       int     21h             ;    carriage return
       mov     dl,lf           ;and a
       mov     ah,02           ;    line feed
       int     21h             ;to the console to keep things pretty
sizediff label near
       mov     ax,4c01h        ;set DOS function -- terminate with errorlevel 1
       int     21h             ;and request DOS service -- end of program
entry  endp
       page
;
;
; Messages/other stuff
;
;
filename db    'ERRLOG', 0                     ;filename to look for
errmsg1 db     'SIZER requires DOS 2.0 or greater.', cr, lf, dollar
errmsg2 db     'File access error -- status: ', dollar
copyright db   'SIZER -- Copyright (C) 1983 Tony Alan Rhea'
;
;
cseg   ends
       end     entry
                                                                                                                    