

       page    64,132
       title   SETERROR-sets the ERRORLEVEL for DOS batch file processing
       subttl  by Tony Alan Rhea 10/24/83
;
;
comment *

       This program accepts one command line argument and sets the
       DOS ERRORLEVEL to that argument.  Currently, this program has
       a limit of 9 for the errorlevel, but apparently DOS has a a
       much higher limit (FFh -- the code is returned in a half-reg).
       An invalid or missing argument gives an error message and an
       errorlevel 0.  This program requires DOS 2.0.

       Usage:
             SETERROR n
       where n is between 0 and 9.


       Copyright (C) 1983  Tony Alan Rhea
       This program may be copied and distributed for personal use
       but not for profit provided this notice is included.  Author makes
       no warranty, expressed or implied, as to the correct nature and
       operation of this software.

       You may make and distribute as many copies of this program as you wish
       for your PERSONAL use only ( NOT for business purposes, please! ).
       Feel free to modify, mutilate, or adulterate this program.  If you come
       up with an bug or improvement, please let me know by writing me at this
       address:
               Tony A. Rhea
               1030 Ivy Lane
               Cary, NC  27511
       If you do modify it, please give me credit in the program.  This helps
       to preserve my ego and increase my fame (but, unfortunately, NOT my
       financial status).  Also, I would appreciate a copy of the modified
       version, preferably on disk (I'll be happy to return your diskette).

       If you like this program ( or HATE it ), please let me know.  Drop me
       a line at the address given above.

       This program has been submitted for publication in PC-WORLD magazine.


         Revision history:
            rev 1.0  10/24/83                         { original release }

       *
;
;
; Equates
;
;
space  equ     ' '
zero   equ     '0'
nine   equ     '9'
cr     equ     0dh
lf     equ     0ah
dollar equ     '$'
       page
;
;
; Program entry point
;
;
cseg   segment para 'code'
       assume  cs:cseg, ds:cseg, ss:nothing, es:cseg
       org     100h            ;for .COM file
entry  proc    near
       mov     ah,30h          ;set function code -- get DOS version number
       int     21h             ;and request DOS service
       cmp     al,0            ;is it pre-DOS 2.0?
       jne     entry10         ;if not, continue
       jmp     dosexit         ;else tell user & quit
;
;
; At this point we have DOS 2.0 or better.  Check the length of
; the command line parameter.  The number of characters on the command
; line is at PSP+80h and the parms themselves start at PSP+81h.
;
;
entry10 label  near
       mov     si,80h          ;set up address of parm length in PSP
       mov     cl,[si]         ;and get length into CX
       cmp     cl,2            ;look for two chars (space+digit)
       je      entry20         ;if not, continue
       jmp     errorexit       ;else bad parms -- exit
;
;
; At this point, we have two characters - make sure the
; first one is a space and the second is a digit.
;
;
entry20 label  near
       inc     si              ;get address of parm in PSP
       mov     bl,[si]         ;and get the first char in BL
       cmp     bl,space        ;is it a space?
       je      entry30         ;if so, continue
       jmp     errorexit       ;else bad parm -- exit
entry30 label  near
       inc     si              ;point to next (second) parm char
       mov     bl,[si]         ;and get second char into BL
       cmp     bl,zero         ;is it greater than or equal to a zero?
       jae     entry40         ;if so, continue
       jmp     errorexit       ;else not digit -- exit
entry40 label  near
       cmp     bl,nine         ;is it less than or equal to a nine?
       jbe     entry50         ;if so, continue
       jmp     errorexit       ;else not digit -- exit
       page
;
;
; At this point we have a valid digit as a parameter in BL.
; Convert the digit to binary and exit, setting the DOS ERRORLEVEL.
;
;
entry50 label  near
       sub     bl,zero         ;convert '0' to 0, '1' to 1, etc...
       mov     al,bl           ;and put requested errorlevel in AL
       mov     ah,4ch          ;set DOS function code -- terminate with errorlevel
       int     21h             ;and request DOS service (requested errorlevel returned)
;
;
; If we get here we don't have DOS 2.0.  Tell user about it and terminate via
; function 0 (which works for all DOS versions).
;
;
dosexit label near
       lea     dx,errmsg1      ;point DX to DOS error msg
       mov     ah,9            ;set function code -- print string
       int     21h             ;and request DOS service
       xor     ax,ax           ;set function code to zero -- program terminate
       int     21h             ;and request DOS service (no errorlevel returned)
;
;
; If we get here the user entered an invalid command line parameter.  Show him
; the syntax and exit, returning errorlevel 0.
;
;
errorexit label near
       lea     dx,errmsg2      ;point DX to syntax error msg
       mov     ah,9            ;set function code -- print string
       int     21h             ;and request DOS service
       mov     ax,4c00h        ;set DOS function code -- terminate with errorlevel
       int     21h             ;and request DOS service (errorlevel 0 returned)
entry  endp
       page
;
;
; Error messages
;
;
errmsg1 db     'SETERROR requires DOS 2.0 or greater.', cr, lf, dollar
errmsg2 equ    $
        db     'SETERROR -- sets the DOS ERRORLEVEL for batch file processing', cr, lf
        db     'Usage:', cr, lf
        db     '      SETERROR n', cr,lf
        db     'where n is between 0 and 9.', cr, lf, dollar
copyright db   'SETERROR -- Copyright (C) 1983 Tony Alan Rhea'
;
;
cseg   ends
       end     entry
 
Press <ENTER> 

Directory # 11 --  Time left 33 minute(s) 
Enter File #, <L>ist, <Q>uit or <C>hg Dir. SAM : 


        This disk copy was originally provided by "The Public Library",
        the software library of the Houston Area League of PC Users.
        Disks in the Public Libray are updated monthly.  Check with us
        for the latest versions of all programs.
 
        Programs are available from the Public Library at $2 per disk
        on user-provided disks.  To get a listing of the disks in the
        Public Library, send a self-addressed, stamped envelope to

             Nelson Ford,  P.O.Box 61565,  Houston, TX 77208.
