;
; QUERY - BATch file 'Y/N' prompt routine.
; Written byKevin Cogan.
; Copyright October, 1983
;
COMMENT &       This program, which can be called from a BATch file,
                prompts the user for yes or no (Y OR N) response
                and then returns an ERRORLEVEL of 1 to the BATch file
                for a reply of 'y' or 'Y' and a 0 for a reply of 'n'
                or 'N'. The only acceptable responses to the prompt
                are 'y', 'Y', 'n', or 'N'. an 80 column display is
                assumed.
                    The 'question' displayed from the BATch file
                can be via a REM statement or an ECHO statement, but
                the 'question' should end with a '?'. the '(Y or N)'
                prompt will then start 2 spaces beyond the '?'. if
                a '?' is not used, then the '(Y or N)' prompt will
                be placed on the next line following the 'question',
                in the third column. A typical application of this
                program is as follows: ZAP.BAT
                       
              ECH OFF
              DIR %1
              ECHO The above file(s) have been targeted for
              ECHO destruction. Is this acceptable?
              QUERY
              IF ERRORLEVEL 1 DEL %1
              IF NOT ERRORLEVEL 1 ECHO * Destruction aborted * &
;
; Set up stack segment.
;
       SSEG     SEGMENT STACK
                DB      16 DUP ('STACK   ')
       SSEG     ENDS
;
; Set up data segment which contains prompt.
;
       DSEG     SEGMENT 'DATA'
       PRMPT    DB      ' (Y or N)'     ; Prompt message
                
                DB      '$'             ; String terminator
       DSEG     ENDS
;
; Start of the routine.
;
       CSEG     SEGMENT 'CODE'
       START    PROC    FAR
                ASSUME CS:CSEG;DS:DSEG;SS:SSEG;ES:NOTHING
;
                MOV     AX,DSEG         ; Get location of data segment
                MOV     DS,AX           ;Load data segment into DS
;
; The first task is to find where the cursor is, since the 'question'
; requiring the prompt will be on the line above the current cursor
; location.
                MOV     BH,0            ; Set page number to 0
                MOV     AH,3            ; AH=3: Request cursor position
                INT     10H             ; Call BIOS for cursor position
;
; The cursor position is in DX (DH=row, DL=column). We now can
; begin searching the previous line, which contains the question,
; for a '?' which is the question terminator.
;
                SUB     DH,1            ; Decrement row index by 1
                MOV     CX,80           ; Load counter for '?' search
                MOV     DL,CL           ; Load column index
;
; Beginning of the '?' search loop. Search will begin in the last
; column of the display (79), and continue towards column 0 until
; search is successful. If no '?' is found, the prompt message
; will be placed on the line following the 'question'.
;
       LOOK     LABEL   NEAR
                SUB     DL,1            ; Decrement the column index
                MOV     AH,2            ; AH=2: Move cursor to (DH,DL)
                INT     10H             ; BIOS request to locate cursor
                MOV     AH,8            ; AH=8: Get value of character
                INT     10H             ; BIOS request for character
                CMP     AL,63           ; Is character a '?'
                JZ      FIND            ; Goto FIND when '?' is found
                LOOP    LOOK            ; Else continue looking
;
; If '?' search is unsuccessful, then the row index is incremented
; by 1 so that the prompt will appear on the next line.
;
                ADD     DH,1            ; Increment row index by 1
       FIND     LABEL   NEAR
                ADD     DL,1            ; Increment column index by 1
;
; If '?' search is unsuccessful, then the row index is incremented
; by 1 so that the prompt will appear on the next line.
;
; Prompt message is displayed and reply is read from the keyboard.
;
       PLACE    LABEL   NEAR
                MOV     AH,2            ; AH=2: Move cursor to (DH,DL)
                INT     10H             ; BIOS request to locate cursor
                PUSH    DX              ; Save cursor location
                MOV     DX,OFFSET PRMPT ; Load data location into DX
                MOV     AH,9            ; AH-9: Output data
                INT     21H             ;DOS service request
                POP     DX              ; Retrieve cursor location
                MOV     AH,1            ; AH-1: Wait for keyboard input
                INT     21H             ; DOS service request
;
; Check input for affirmative, negative, or illegeal value.
;
              
                CMP     AL,89           ; Is input 'Y'?
                JZ      YES             ; Then goto YES routine.
                CMP     AL,121          ; Is input 'y'?
                JZ      YES             ; Then goto YES routine.
                CMP     AL,78           ; Is input 'N'?
                JZ      NO              ; Then goto NO routine.
                CMP     AL,110          ; Is input 'n'?
                JZ      NO              ; Then goto NO routine.
                JMP     PLACE           ; Bad input: Reissue prompt
;
; Affirmative response routine. ERRORLEVEL flag is set to 1 via AL.
;
       YES      LABEL   NEAR
                MOV     AL,1            ; Set ERRORLEVEL to value of 1
                JMP     DONE            ; Goto wrap-up routine
;
; Negative response routine.  ERRORLEVEL flag is set to 0 via AL.
;
       NO       LABEL   NEAR
                MOV     AL,0            ; Set ERRORLEVEL value
;
; Wrap-up routine
;
       DONE     LABEL   NEAR
                PUSH    AX              ; Save ERRORLEVEL value
                MOV     DL,10           ; Set DL value for LINEFEED
                MOV     AH,2            ; AH=2: Output character in DL
                INT     21H             ; DOS service request
                MOV     DL,13           ; Set DL value for CR
                MOV     AH,2            ; AH=2: Output character in DL
                INT     21H             ; DOS service request
                POP     AX              ; Retrieve ERRORLEVEL value
                MOV     AH,4CH          ; AH=4CH: Terminate code
                INT     21H             ; DOS service request
       START    ENDP
       CSEG     ENDS
                END
