         name      argv
         title     ARGV --- return argument pointer
;
; ARGV.ASM:  return address and length of specified 
; command line argument or fully qualified program 
; name.  Treats blanks and tabs as whitespace, carriage 
; return as terminator.
;
; (C) 1987 Ray Duncan
; 
; Call with:  ES:BX = command line address
;                     (implicit: ES=PSP segment)
;             AX    = argument number (0 based)
;
; Returns:    ES:BX = argument address
;             AX    = argument length 
;                     (0=argument not found)
;             Other registers preserved.
;
; If called with AX=0 (argv[0]) and running under 
; MS-DOS version 3.0 or later, returns ES:BX pointing 
; to program name in environment block and AX=length, 
; otherwise returns ES:BX unchanged and AX=0.
;

cr      equ     0dh             ; ASCII carriage return
lf      equ     0ah             ; ASCII line feed
tab     equ     09h             ; ASCII tab
blank   equ     20h             ; ASCII space character

_TEXT   segment word public 'CODE'

        assume  cs:_TEXT

        public  argv            ; make ARGV available to Linker

argv    proc    near            ; get address & length of
                                ; command tail argument

        push    cx              ; save original CX and DI 
        push    di

        or      ax,ax           ; is it argument 0?
        jz      argv8           ; yes, jump to get program name

        xor     ah,ah           ; initialize argument counter

argv1:  mov     cx,-1           ; set flag = outside argument

argv2:  inc     bx              ; point to next character 
        cmp     byte ptr es:[bx],cr
        je      argv7           ; exit if carriage return
        cmp     byte ptr es:[bx],blank
        je      argv1           ; outside argument if ASCII blank
        cmp     byte ptr es:[bx],tab    
        je      argv1           ; outside argument if ASCII tab

                                ; if not blank or tab...
        jcxz    argv2           ; jump if already inside argument

        inc     ah              ; else count arguments found
        cmp     ah,al           ; is this the one we're looking for?
        je      argv4           ; yes, go find its length
        not     cx              ; no, set flag = inside argument
        jmp     argv2           ; and look at next character

argv4:                          ; found desired argument, now
                                ; determine its length...
        mov     ax,bx           ; save param. starting address 

argv5:  inc     bx              ; point to next character
        cmp     byte ptr es:[bx],cr
        je      argv6           ; found end if carriage return
        cmp     byte ptr es:[bx],blank
        je      argv6           ; found end if ASCII blank
        cmp     byte ptr es:[bx],tab    
        jne     argv5           ; found end if ASCII tab

argv6:  xchg    bx,ax           ; set ES:BX = argument address
        sub     ax,bx           ; and AX = argument length
        jmp     argvx           ; return to caller

argv7:  xor     ax,ax           ; set AX = 0, argument not found
        jmp     argvx           ; return to caller

argv8:                          ; special handling for argv=0
        mov     ax,3000h        ; check if DOS 3.0 or later
        int     21h             ; (force AL=0 in case DOS 1)
        cmp     al,3
        jb      argv7           ; DOS 1 or 2, return null param.
        mov     es,es:[2ch]     ; get environment segment from PSP
        xor     di,di           ; find the program name by
        xor     al,al           ; first skipping over all the
        mov     cx,-1           ; environment variables...
        cld
argv9:  repne scasb             ; scan for double null (can't use
        scasb                   ; (SCASW since might be odd addr.)
        jne     argv9           ; loop if it was a single null
        add     di,2            ; skip count word in environment
        mov     bx,di           ; save program name address
        mov     cx,-1           ; now find its length... 
        repne scasb             ; scan for another null byte
        not     cx              ; convert CX to length 
        dec     cx
        mov     ax,cx           ; return length in AX

argvx:                          ; common exit point
        pop     di              ; restore original CX and DI
        pop     cx
        ret                     ; return to caller

argv    endp

_TEXT   ends

        end     
