#include <windows.h>
#include <dos.h>
#include <time.h>

double FAR PASCAL __export GetFileDateTime(LPSTR lpszFileName);
double FAR PASCAL __export ConvertDosTime(struct _find_t *ff);
LONG FAR PASCAL __export GetFileSize(LPSTR lpszFileName);
LONG FAR PASCAL __export GetDiskFree(int drive);
WORD FAR PASCAL __export DosFindFirst(LPSTR lpszFileName, WORD nAttrib, struct _find_t *ff);
WORD FAR PASCAL __export DosFindNext(struct _find_t *ff);

double FAR PASCAL __export ConvertDosTime(struct _find_t *ff)
{
	struct tm tm;
	time_t mtime;

	// convert from DOS date/time format to time_t format	
	tm.tm_year = (ff->wr_date >> 9) + 80;
	tm.tm_mon =	((ff->wr_date >> 5) & 15) - 1;
	tm.tm_mday = (ff->wr_date & 31);
	tm.tm_hour = (ff->wr_time >> 11);
	tm.tm_min = ((ff->wr_time >> 5) & 63);
	tm.tm_sec = (ff->wr_time & 31) * 2;
	mtime = mktime(&tm);

	// convert from time_t format to Access format
	return((((double) mtime - (double) (7.0 * 60.0 * 60.0)) / (double) 86400.0) + (double) 25569.0);
}

WORD FAR PASCAL __export DosFindFirst(LPSTR lpszFileName, WORD nAttrib, struct _find_t *ff)
{
	return(_dos_findfirst(lpszFileName, nAttrib, ff));
}

WORD FAR PASCAL __export DosFindNext(struct _find_t *ff)
{
	return(_dos_findnext(ff));
}

LONG FAR PASCAL __export GetDiskFree(int drive)
{
	int ret;
	struct _diskfree_t df;
	
	ret = _dos_getdiskfree(drive, &df);
	return(ret == 0 ? (LONG) df.avail_clusters * (LONG) df.sectors_per_cluster * (LONG) df.bytes_per_sector : 0L);
}

double FAR PASCAL __export GetFileDateTime(LPSTR lpszFileName)
{
	int ret;
	struct _find_t ff;
	
	ret = _dos_findfirst(lpszFileName, 0, &ff);
	return(ret == 0 ? ConvertDosTime(&ff) : (double) 0);
}

LONG FAR PASCAL __export GetFileSize(LPSTR lpszFileName)
{
	int ret;
	struct _find_t ff;
	
	ret = _dos_findfirst(lpszFileName, 0, &ff);
	return(ret == 0 ? ff.size : 0L);
}

