' RAND    Sample Code in QB 4.5 by Luigi M. Bianchi   January 13, 1992
'
' RAND generates random numbers between 0 and 1.
' RAND uses the Wichmann-Hill algorithm (cf. BYTE, March 1987, p.127).
'
' The main module MUST initialize the random number generator, either
' with q=RAND(0.), for repeatable sequences, or with q=RAND(-1.), for
' randomized sequences, where q is a double-precision dummy variable.
' To generate random integers between a and b (a<b) use the expression
' INT((b-a+1)*RAND(1)+a).
'
' A similar declaration must be used in the main module.
'
DECLARE FUNCTION RAND (q AS DOUBLE)
END

' Initializations:
'
' q=RAND(0.)  starts the generator with seeds 1,10000,3000 (cf. op. cit.)
' q=RAND(-1.) randomizes (reseeds) the generator
' q=RAND(1.)  returns a random number (double precision) between 0 and 1
'
FUNCTION RAND (q AS DOUBLE) STATIC
'
DEFINT L-M    ' the seeds are 16-bit integers
DEFDBL Q-T    ' while the dummy & temp variables, and RAND are 64-bit doubles
'
IF q = 0. THEN ' if repeatable sequences
   L = 1: M = 10000: N = 3000
   EXIT FUNCTION    ' to ensure that only initialization is carried out
'
ELSEIF q < 0. THEN    ' if randomized sequences
   RANDOMIZE TIMER
   L = INT(30000 * RND) + 1
   M = INT(30000 * RND) + 1
   N = INT(30000 * RND) + 1
   EXIT FUNCTION    ' to ensure that only initialization is carried out
'
END IF
'
'  Wichmann-Hill Algorithm
'
L = 171 * (L MOD 177) - (L \ 177) * 2
IF L < 0 THEN L = L + 30269
M = 172 * (M MOD 176) - (M \ 176) * 35
IF M < 0 THEN M = M + 30307
N = 170 * (N MOD 178) - (N \ 178) * 63
IF N < 0 THEN N = N + 30323
temp = L / 30269 + M / 30307 + N / 30323
RAND = temp - INT(temp)
'
END FUNCTION

   Luigi M. Bianchi   CIS 72060,3723

