_TEXT SEGMENT WORD PUBLIC 'CODE'
           ORG 100H

INIT       PROC NEAR
           ASSUME CS:_TEXT,DS:_TEXT,es:nothing
           mov  es,es:[02ch]          ; release environment
           mov  ah,49h
           int  21h
           call INITIALIZE            ; setup our handler
           mov  dx,((offset progam_end+16)/16)+10h   ; Size of block to alloc
           mov  ax,3100h              ; term. & stay resident
           int  21h
INIT       ENDP


INT10      PROC FAR
           sti                        ; Enable Ints, so not to slow clock
           pushf                      ; Save the flags b4 compare
           cmp  ah,09h                ; See if Screen output function
           jb   bios_op
           je   our_op
           cmp  ah,0Ah
           je   our_op
           cmp  ah,0Eh
           je   our_op
           jmp  short bios_op
 our_op:                              ; Yes, Screen output
           cmp  al,91d
           jae  bios_op               ; if lowercase then do nothing
           cmp  al,64d                ; Is it lowercase
           ja   point_to_table        ; Yes, it is lowercase
           jmp  short bios_op         ; No, it is not lowercase
point_to_table:
           push ax
           mov  ah,32d                ;  Make it lowercase
           add  al,ah
           mov  cs:dch,al
           pop  ax
           mov  al,cs:dch
bios_op:                              ; Restore orginal flags
           popf                       ; Put them back on the stack
           pushf
           call cs:int10_ptr          ; call orginal handler
           iret                       ; return to caller

int10_ptr  equ this dword             ; Old INT 10H pointer
int10_ofs    dw ?                     ; Old INT 10H Offset
int10_seg    dw ?                     ; Old INT 10H Segment
dch          db ?                     ; Temp. Var.
INT10      ENDP


progam_end  equ  $-init               ; Do not alloc routine below
                                      ; to save memory

INITIALIZE  PROC NEAR
            mov  dx,offset intro1
            mov  ah,9
            int  21h
            mov  ax,3510h
            int  21h
            mov  int10_ofs,bx
            mov  int10_seg,es
            mov  ax,2510h
            mov  dx,offset int10
            int  21h
            ret
intro1  db  13,10,'DOS All LowerCase Rev.C,(C)Copr.1992, By Mark Vitt',13,10,'$'
INITIALIZE  ENDP

_TEXT ENDS
      END INIT



