\ This simple program illustrates the basics of a Forth program prepared
\ for ForthCMP. Comments can be anything after a backslash,
( or can be text within parenthesis on a single line )
0 #IF	Interpreted conditionals allow multiline comments, among other
	things, without having to bother with the comment characters.

	Lines can be up to 127 characters long, and spaces and tabs are
	ignored.

	To compile this program, the compiler, 4C.COM, must be in the
	execution path, and the files DOSGO.SCR and FORTHLIB.SCR must be
	either in the current directory or in a directory pointed to by
	the environment varible 4LIB. For example, "SET 4LIB=d:\FCLIB"
	will cause the directory d:\fclib to be used for file searches
	if the file is not found in the current directory. These library
	files, as all input files, are in source format. Source files have
	the default extensions 4TH or SCR. Either ASCII text files, such
	as this one, or Forth screen files, such as the library files, can
	be used interchangably. Any "included" screen file is read in via
	an implicit "1 LOAD" command.
#THEN

\ \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
\									\
\  If you like ForthCMP, please register it and get the programmers	\
\  manual plus a disk (specify size) with the current version and	\
\  additional support code:						\
\ 									\
\  Send a check or money order for $50.00 US to:			\
\      Tom Almy								\
\      17830 SW Shasta Trail						\
\      Tualatin, OR 97072						\
\ 									\
\ (To get the Software Floating Point files, you must prove ownership   \
\  of an LMI Forth Software Floating Point by enclosing a copy of the   \
\  first page in the manual section for Software Floating Point.)       \
\ \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

\ I80186	\ Uncomment this if you are using an 80186 or later processor

200 SEPSSEG	\ If you uncomment this line, then the program will have a
		\ separate stack segment, 200 bytes long, to hold the
		\ parameter and return stacks. This directive must come
		\ before the MSDOS or MSDOSEXE directive

\ ForthCMP programs must start with one of the following directives:

100 MSDOS \ Specifies to generate a COM file, allowing for a return stack
  	    \ size of 100 bytes. This generates a "tiny" model program.
\ 1000 100 MSDOSEXE \ Specifies to generate an EXE file, allowing 1000 bytes
	    \ for the data segment and 100 bytes for the return stack. This 
	    \ generates a small model program.

\ A maximal sized program can have 63k of code, 64k of static (dictionary)
\ data, and 64k of stack data. You can request additional memory segments
\ from DOS for large data arrays, for instance. Except when SEPSSEG is
\ specified, the parameter stack moves down into the heap. The heap can
\ be allocated using HERE (or DP) and ALLOT, just like in interpreted 
\ Forth. PAD floats above HERE.

\ A DRIVER option allows creating device drivers in ForthCMP.

\ There is also an option for creating ROMMABLE code for embedded 
\ processors.


\ A ForthCMP program always contains a function called MAIN that acts as
\ the main entry point. FORTCOM allows forward referencing, so we can safely
\ put the MAIN function first.

1 1 IN/OUT NEED TwoTimes	\ this tells the compiler that a forward
				\ referenced function has exactly one argument
				\ and one result value -- this allows the
				\ compiler to pass the argument and result
				\ in registers.
				\ The default is on the stack


: MAIN
	." HELLO NEW USER!" CR CR	\ this should look standard.
	." Type a number:" #IN
	." Two times the number is: " TwoTimes . CR
	." Multiplication table"
	MultTable
;					\ returns to DOS at the end. Make
					\ certain the stack is empty, or
					\ push a 0 on stack if not sure.
					\ You can also execute BYE at any
					\ point to return. You can even
					\ return error codes, if you wish.

1 1 IN/OUT	\ must match any forward declaration

CODE TwoTimes	\ We will use an assembly code routine to do the multiply
	AX AX ADD	\ arg and result use AX
	RET		\ couldn't be easier!
END-CODE


: MultTable	\ We didn't use IN/OUT here
    11 1 DO
    	CR
    	11 1 DO
	    I J *  5 .R	\ print each entry
	LOOP
    LOOP
;

\ Our program is done. Now we need to include the library of 83 Standard
\ functions that are not intrinsically generated.
\ The generated load map shows these functions, as well as the ones above.
\ You can use DEBUG to examine the generated code

INCLUDE FORTHLIB

END	\ Required last command -- writes out the compiled program

\ Now from the command line, execute "4c demo"
