DECLARE FUNCTION hilo% (lo%, hi%)
DECLARE FUNCTION unsigned& (i%)
DEFLNG A-Z
DECLARE FUNCTION pdqvall& (number$)
DEF fnj$ (x&, n) = RIGHT$("                          " + STR$(x&), n)
DIM cyl(255), head(255), wp(255), cap(255), sector(255), park(255), possible(255)
DIM x(255, 16)
DEF SEG = 0
' First, figure out current drive types
OUT &H70, &H12
b12 = INP(&H71)
hi12 = b12 MOD 16
lo12 = b12 \ 16
OUT &H70, &H19
b19 = INP(&H71)
OUT &H70, &H1A
b1a = INP(&H71)
' now decode to see if we have drives
ndrives = 0
IF lo12 = 0 THEN
  dtype = 0
ELSE
  IF lo12 < 15 THEN
    dtype = lo12
  ELSE
    dtype = b19
  END IF
END IF
IF hi12 = 0 THEN
  dtype1 = 0
ELSE
  IF hi12 < 15 THEN
    dtype1 = hi12
  ELSE
    dtype1 = b1a
  END IF
END IF
ndrives = 0
IF dtype <> 0 THEN ndrives = 1
IF dtype1 <> 0 THEN ndrives = ndrives + 1
true = -1: false = NOT true
tablofs% = hilo%(PEEK(&H118), PEEK(&H119))
tablseg% = hilo%(PEEK(&H11A), PEEK(&H11B))
'PRINT "Table begins at "; HEX$(tablseg%); ":"; HEX$(tablofs%)
DEF SEG = tablseg%
recstart = unsigned&(tablofs%)
'methods of finding disk table:
'  (1) use pointer at 0:118
'  (2) hardwired F000:E401
'  (3) search for 32 01 04 00 hex from 768K to 1024K
'
n$ = UCASE$(COMMAND$)
IF ndrives = 2 THEN method = 1 ELSE method = 2
IF INSTR(n$, "/H") <> 0 OR INSTR(n$, "/?") <> 0 THEN
  CLS
  PRINT "Drive configuration utility"
  PRINT : PRINT "(C) Mark Minasi/Moulton, Minasi & Company/ (301) 596-9206"
  PRINT
  PRINT "This will not work on XTs or PS/2s; it works on 286/386/486 PCs."
  PRINT "When you get a new drive, your PC's SETUP program wants to know a 'drive"
  PRINT "type number' -- a number generally from 1 to 47, that describes your drive."
  PRINT "This program reads your computer's ROM and finds the best match for your"
  PRINT "drive."
  PRINT
  PRINT "The only rub is, there is no standard place to put the drive table in ROM."
  PRINT "This program gives you the option to use one of three methods to find a"
  PRINT "ROM:"
  PRINT "         1 -- just goes to the most common address, F000:E401 for the table."
  PRINT "         2 -- the 'official' method (doesn't work if you have 2 drives)"
  PRINT "         3 -- brute force search of the ROM area.  Looks for a group of data"
  PRINT "              that matches the first record of MOST drive tables (it's the"
  PRINT "              record that describes the original XT 10 MB drive."
  PRINT "              --WARNING-- This can take time, so if you pick '3', be patient."
  PRINT
  PRINT "Invoke the program like so:  DRIVETAB [m]"
  PRINT "Where 'm' is the desired method -- 1, 2, or 3.  1 is default."
  GOTO over
END IF

IF INSTR(n$, "1") <> 0 THEN method = 1
IF INSTR(n$, "2") <> 0 THEN method = 2
IF INSTR(n$, "3") <> 0 THEN method = 3
nodt = false
IF method = 1 THEN
  DEF SEG = &HF000
  recstart = &HE401
ELSE
  IF method = 2 THEN
    DEF SEG = tablseg%
    recstart = unsigned&(tablofs%)
  ELSE
    IF method = 3 THEN
      'search for 32 01 04 00 in RAM
      PRINT "Searching for drive table";
      done = false
      key$ = CHR$(1) + CHR$(4) + CHR$(0)
      srseg = &HC000&
      WHILE (NOT done) AND (srseg < 65535)
        DEF SEG = srseg
        sofs = 0
        PRINT ".";
        WHILE (NOT done) AND (sofs <= 65532)
           IF PEEK(sofs) = &H32 THEN
             IF key$ = CHR$(PEEK(sofs + 1)) + CHR$(PEEK(sofs + 2)) + CHR$(PEEK(sofs + 3)) THEN
               done = true
               tablseg = srseg
               tablofs = sofs
             ELSE
               sofs = sofs + 1
             END IF
           ELSE
             sofs = sofs + 1
           END IF
        WEND
        srseg = srseg + &H1000
      WEND
      PRINT
      IF NOT done THEN
        nodt = true
      ELSE
        PRINT "Method 3 found table at "; HEX$(tablseg); ":"; HEX$(tablofs)
        recstart = sofs
        DEF SEG = tablseg
      END IF
    END IF
  END IF
END IF

maxcyl = 8' 800 hex = 2048 cylinders max
maxhead = 32
done = false
drivenum = 0
pagesize = 20
nprinted = 0
CLS
PRINT "Drive configuration utility"
PRINT : PRINT "(C) Mark Minasi/Moulton, Minasi & Company/ (301) 596-9206"
IF nodt THEN PRINT : PRINT "No drive table found -- nonstandard system.": GOTO over
PRINT
PRINT "This will not work on XTs or PS/2s; it works on 286/386/486 PCs."
PRINT "When you get a new drive, your PC's SETUP program wants to know a 'drive"
PRINT "type number' -- a number generally from 1 to 47, that describes your drive."
PRINT "This program reads your computer's ROM and finds the best match for your"
PRINT "drive.  To make it work, your need to know four things -- the number of"
PRINT "cylinders, heads, sectors, and the write precompensation cylinder.  If"
PRINT "you don't know these, call the dealer or the manufacturer."
PRINT
IF ndrives = 0 THEN
  PRINT "No drives in SETUP currently."
ELSE
  PRINT "SETUP shows current settings are:  drive 0 = type "; dtype;
  IF ndrives = 2 THEN PRINT " drive 1= type "; dtype1 ELSE PRINT
END IF
PRINT
FOR drivenum = 1 TO 255
  off1 = PEEK(1 + recstart)  'cylinders
  off0 = PEEK(0 + recstart)  'cylinders
  off2 = PEEK(2 + recstart)  'heads
  off6 = PEEK(6 + recstart)  'write precomp
  off5 = PEEK(5 + recstart)  'write precomp
  cyl(drivenum) = off1 * 256 + off0
  head(drivenum) = off2
  wp(drivenum) = off6 * 256 + off5
  sector(drivenum) = PEEK(14 + recstart)
  park(drivenum) = PEEK(12 + recstart) + PEEK(13 + recstart) * 256&
  IF cyl(drivenum) < 2900 AND head(drivenum) < 255 AND sector(drivenum) < 64 THEN
    cap(drivenum) = cyl(drivenum) * head(drivenum) * sector(drivenum) \ 2
  ELSE
    cap(drivenum) = 0
  END IF
  possible(drivenum) = true
  'fix wp because some ROMs include both wp=1024 AND wp=65535 for no w.p.
  IF ABS(wp(drivenum) - cyl(drivenum)) < 4 THEN wp(drivenum) = 65535
  recstart = recstart + 16
NEXT

' now figure out which is the last drive
i = 1
done = false
WHILE NOT done
  IF i > 255 THEN
     done = true
  ELSE
    IF (wp(i) <> 65535) AND (wp(i) > cyl(i)) THEN
      done = true
    ELSE
      IF cyl(i) > 2048 THEN
        done = true
      ELSE
        IF head(i) > 16 THEN
          done = true
        END IF
     END IF
   END IF
  END IF
  IF done THEN lastdrive = i - 1
  i = i + 1
WEND
'print "last drive=";lastdrive

INPUT "How many cylinders"; tcyl
INPUT "How many heads"; thead
INPUT "How many sectors"; tsector
INPUT "Write precomp (no=-1)"; twp
IF twp = -1 THEN twp = 65535

'Step 1: match write precomp
' More than 20 cylinders off == no good
FOR i = 1 TO lastdrive
  IF (ABS(twp - wp(i)) > 20) THEN possible(i) = false
NEXT

'Step 2: don't exaggerate about cylinders
FOR i = 1 TO lastdrive
  IF tcyl < cyl(i) THEN possible(i) = false
NEXT

'Step 3: don't exaggerate about head
FOR i = 1 TO lastdrive
  IF thead < head(i) THEN possible(i) = false
NEXT

'Step 4: match the sectors
FOR i = 1 TO lastdrive
  IF tsector <> sector(i) THEN possible(i) = false
NEXT

'Step 5: take the best
best = 0
bestsize = 0
FOR i = 1 TO lastdrive
   IF possible(i) AND (cap(i) > bestsize) THEN
      bestsize = cap(i)
      best = i
   END IF
NEXT

drivecap = tcyl * thead * 17 \ 2
lose = drivecap - bestsize
IF best = 0 THEN
 PRINT "Sorry -- nothing in your ROM matches your drive."
ELSE
 PRINT "The drive you describe is "; drivecap; "K in size."
 IF lose = 0 THEN
   PRINT "Use drive type "; best; " for a perfect match."
 ELSE
   PRINT "Take drive type "; best; " -- it yields a capacity of "; bestsize; "K."
   PRINT "You only lose "; lose; "K."
 END IF
 INPUT "Would you like me to update your SETUP CMOS for you"; a$
 IF UCASE$(LEFT$(a$, 1)) = "Y" THEN
   badinput = true
   WHILE badinput
     INPUT "Is it attached as drive 0 or drive 1"; dn
     IF dn <> 0 AND dn <> 1 THEN
       BEEP: PRINT "Do you want this new drive type "; best; " to be the first or"
       PRINT "second drive?"
     ELSE
       badinput = false
     END IF
   WEND
   ' now set up bytes 12, 19, and 1a
   IF dn = 0 THEN
     IF best < 15 THEN b12 = best * 16 + hi12 ELSE b12 = 15 * 16 + hi12
     IF best >= 15 THEN b19 = best
   ELSE
     IF best < 15 THEN b12 = lo12 * 16 + best ELSE b12 = lo12 * 16 + 15
     IF best >= 15 THEN b1a = best
   END IF
   OUT &H70, &H12
   OUT &H71, b12
   OUT &H70, &H19
   OUT &H71, b19
   OUT &H70, &H1A
   OUT &H71, b1a
   PRINT "Done.  The next you reboot, the changes will take effect."
 END IF
END IF

linesseen = 0
PRINT : INPUT "Would you like to see your computer's drive table"; r$
IF LEFT$(r$, 1) = "y" OR LEFT$(r$, 1) = "Y" THEN
   PRINT "Number   Cylinders Heads Sectors Write Precomp Landing Zone Capacity"
   FOR i = 1 TO lastdrive
     IF cyl(i) <> 0 THEN
      linesseen = linesseen + 1
      PRINT fnj$(i, 7); fnj$(cyl(i), 10); fnj$(head(i), 6); fnj$(sector(i), 8); fnj$(wp(i), 14); fnj$(park(i), 12); fnj$(cap(i), 9)
      IF linesseen MOD pagesize = 0 THEN PRINT "Press a key to continue"; : a$ = INPUT$(1): PRINT : linesseen = 0
     END IF
   NEXT
END IF
over:
END

FUNCTION hilo% (lo%, hi%) STATIC
'
' This function combines two integers that we are TREATING LIKE BYTES
' into a 16 bit word.  You can't just say hilo=256*hi+lo, because you
' run into the furshlugginer overflow.  Returns an integer suitable for
' passing into a register or the like.
'
t& = 256& * hi% + lo%
a$ = MKL$(t&)
combined% = CVI(MID$(a$, 1, 2))
hilo% = combined%
END FUNCTION

FUNCTION unsigned& (i%) STATIC
' This function transfers a two byte integer to a four byte integer
' WITHOUT sign propagation.  Thus, &hFFFF is seen by the system as
' a two-byte "-1".  Just saying "L&=&hFFFF" leads to L&=FFFFFFFF.
' Unsigned leaves L&=0000FFFF.
 t$ = MKI$(i%) + CHR$(0) + CHR$(0)
 unsigned& = CVL(t$)

END FUNCTION

