/*    ux.h

      UX - Universal Extractor
      Copyright (c) 1989-92 by Neil McAllister
      This program will process the commands and filenames passed to
      it to facilitate using the same commands for many different
      compressed file extraction programs.  It supports standard DOS
      wildcards and paths.  This program was previously called UXARC.

      This header file is needed by the UX.C and UXCFG.C source files
      to load the configuration structure information.

*/



#define   VERSION   "v3.20"                 /*  Options space signature  */
#define   MAX_TYPES 15                       /*  Max. # of file types  */

#define   VIEW      0
#define   TEST      1                       /*  UX command codes  */
#define   EXTRACT   2

#define   TRUE      1
#define   FALSE     0

struct options
  {
    char signature[ sizeof(VERSION) ];      /*  Options signature bytes   */
    int checksum;
    int total_types;
    char ext[MAX_TYPES][5];                 /* Up to MAX_TYPES extensions */
    char prg[MAX_TYPES][40];                /*  and extraction programs   */
    char cmd[MAX_TYPES][3][4];              /*  Command-line flags        */
  };


void get_opts( char *name );
void put_opts( char *name );
void uxfatal( char *ermsg );
