/*    uxcfg.c

      UX - Universal Extractor v3.20
      Copyright (c) 1989-92 by Neil McAllister
      This program will allow you to configure the program UX.COM to
      use the filenames you want.  In this version, the actual
      command-line parameters sent to the decompression program
      cannot be changed.  Since most compression programs use the
      same command-line parameters, this shouldn't be a problem.
      You should have a file called "UX.CFG" which lists the
      extension (not including period), and then the decompression
      program to use, separated by spaces.

      UX was written by Neil McAllister.  Though it bears his
      copyright notice to comply with the Borland License Statement,
      this program, the accompanying source code, and any documentation
      are hereby released to the public domain for free use and
      distribution without profit.
*/

#include "ux.h"
#include <fcntl.h>
#include <io.h>
#include <mem.h>
#include <process.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

struct options opts;

int main( int argc, char **argv )
  {
    FILE *cf;
    register int x;
    char num[4];

    fputs("\nUX Configuration Program " VERSION "   Copyright (c) 1989-92 by Neil McAllister\n", stdout );
    if ( argc > 1 )
      get_opts( &argv[1][0] );
    else
      get_opts( "UX.COM" );
    for ( x = 0; x < MAX_TYPES; x++ )
      {
        strcpy( &opts.ext[x][0], "?" );
        strcpy( &opts.prg[x][0], "?" );
        strcpy( &opts.cmd[x][VIEW][0], "?" );
        strcpy( &opts.cmd[x][EXTRACT][0], "?" );
        strcpy( &opts.cmd[x][TEST][0], "?" );
      }
    if ( argc > 2 )
        {
            if ( (cf = fopen(&argv[2][0],"r")) == NULL )
                uxfatal( "Unable to access configuration file." );
        }
    else
        if ( (cf = fopen("UX.CFG","r")) == NULL )
            uxfatal( "Unable to locate configuration file UX.CFG." );
    for ( x = 0; x < MAX_TYPES; x++ )
      if ( fscanf(cf, "%s%s%s%s%s", &opts.ext[x][0], &opts.prg[x][0], &opts.cmd[x][VIEW][0], &opts.cmd[x][TEST][0], &opts.cmd[x][EXTRACT][0] ) == EOF )
        break;
    fclose( cf );
    fputs( "\nRead ", stdout );
    fputs( itoa(x, num, 10), stdout );
    fputs( " fields from configuration file...\n", stdout );
    opts.total_types = x;
    if ( argc > 1 )
      put_opts( &argv[1][0] );
    else
      put_opts( "UX.COM" );
    return 0;
  }


void get_opts( char *name )         /*  Read the options structure  */
  {
    int fd, *p, i;
    extern struct options opts;

    if ( (fd = open(name, O_RDWR | O_BINARY)) == (-1) )
      uxfatal( "Unable to locate UX executable file.\n" );
    lseek( fd, 0L - sizeof(opts), SEEK_END );
    if ( read(fd, (unsigned char *)&opts, sizeof(opts)) != sizeof(opts) )
      uxfatal( "Unable to load options information.\n" );
    if ( strcmpi(VERSION, opts.signature) )
      {
        fputs( "Initializing options space...\n", stdout );
        strcpy( opts.signature, VERSION );
        opts.checksum = 0;
        for ( p = (int *)(&opts), i = sizeof(opts)/2; --i >= 0; )
          opts.checksum -= *p++;
        lseek( fd, 0L, SEEK_END );
        if ( write(fd, (char *)&opts, sizeof(opts)) != sizeof(opts) )
          uxfatal( "Unable to initialize options space.\n" );
      }
    close( fd );
  }


void put_opts( char *name )         /*  Write to the options structure  */
  {
    int fd, *p, i, checksum;
    extern struct options opts;

    if ( (fd = open(name, O_RDWR | O_BINARY)) == (-1) )
      uxfatal( "Unable to locate UX executable file.\n" );
    checksum = 0;
    for ( p = (int *)(&opts), i = sizeof(opts)/2; --i >= 0; )
      checksum -= *p++;
    if ( checksum != opts.checksum )
      fputs( "Options updated.\n", stdout );
    lseek( fd, 0L - sizeof(opts), SEEK_END );
    if ( write(fd, (char *)&opts, sizeof(opts)) != sizeof(opts) )
      uxfatal( "Unable to update options information.\n" );
    close( fd );
  }


void uxfatal( char *ermsg )           /*  Display error message and exit.  */
  {
    fputs( "\n***** FATAL: ", stdout );
    fputs( ermsg, stdout );
    fputs( "\nUsage:  UXCFG [executable file] [config file]\nSee documentation file UX.DOC for further instructions.\n", stdout );
    exit( 1 );
    return;
  }
