/*    ux.c

      UX - Universal Extractor
      Copyright (c) 1989-92 by Neil McAllister
      This program will process the commands and filenames passed to
      it to facilitate using the same commands for many different
      compressed file extraction programs.  It supports standard DOS
      wildcards and paths.  This program was previously called UXARC.

      UX was written by Neil McAllister.  Though it bears his
      copyright notice to comply with the Borland License Statement,
      this program, the accompanying source code, and any documentation
      are hereby released to the public domain for free use and
      distribution without profit.
*/


#include <dir.h>
#include <dos.h>                /*  Header files for declarations  */
#include <fcntl.h>
#include <process.h>
#include <stdio.h>
#include <string.h>
#include "ux.h"

struct options opts;

int main( int argc, char *argv[] )
  {
    char cmdln[256];                          /*  Storage for constructed command line  */
    char filename[81];                        /*  Storage for compressed file name  */
    struct ffblk fblk;                        /*  File information for findfirst()  */
    char cmd = (-1);                          /*  UX command code  */
    char arg = 0, flag;                       /*  Command line data storage  */
    register unsigned char x, i, j;           /*  General purpose counters  */
    unsigned char mult = 0;                   /*  Multiple file processing flag  */

    fputs( "\nUX - Universal Extractor " VERSION "   Copyright (c) 1989-92 by Neil McAllister\n", stdout );
    if ( argc == 1 )
      {
        fputs( "Usage:    UX [-t][-v][-x] <compressedfile> [...]\n", stdout );
        return 0;
      }
    for ( x = 1; x < argc; x++ )
      if ( argv[x][0] != '-'  &&  argv[x][0] != '/' )
        {
          arg = x;
          break;
        }
    if ( !arg )
      uxfatal( "No compressed file specified on command line.\n" );
    for ( x = 1; x < argc; x++ )
      if ( argv[x][0] == '-'  ||  argv[x][0] == '/' )
        switch ( argv[x][1] )
          {
            case 'v':
            case 'V':
              cmd = VIEW;
              break;
            case 't':
            case 'T':
              cmd = TEST;
              break;
            case 'x':
            case 'X':
              cmd = EXTRACT;
              break;
            default:
              uxfatal( "Unexpected character on command line.\n" );
          }
    cmd = ( cmd > (-1) )  ?  cmd : EXTRACT;
    get_opts( &argv[0][0] );
    for ( x = 0; argv[arg][x]; x++ )
      if ( argv[arg][x] == '.'  &&  (argv[arg][x+1] != '\\' && argv[arg][x+1] != '.') )
        {
          if ( argv[arg][x+1] == '*' )
            argv[arg][x] = 0;
          else
            if ( (argv[arg][x+1] == argv[arg][x+2]) && ( argv[arg][x+2] == argv[arg][x+3] ) && ( argv[arg][x+1] == '?' ) )
              argv[arg][x] = 0;
          break;
        }
    i = 0;
    do
      {
        flag = (-1);
        for ( ; i < opts.total_types; i++ )
          {
            strcpy( filename, &argv[arg][0] );
            if ( !argv[arg][x] )
              strcat( filename, &opts.ext[i][0] );
            if ( !strcmpi(&argv[arg][x], &opts.ext[i][0]) || !argv[arg][x] )
              flag = findfirst( filename, &fblk, FA_ARCH );
            if ( flag == 0 )
              break;
          }
        if ( i < MAX_TYPES  &&  flag == 0 )
          {
            strcpy( cmdln, &opts.prg[i][0] );
            if ( strcmpi( &opts.cmd[i][cmd][0], "?" ) )
              {
                strcat( cmdln, " " );
                strcat( cmdln, &opts.cmd[i][cmd][0] );
              }
            strcat( cmdln, " " );
            strcat( cmdln, filename );
            for ( j = arg+1; j < argc; j++ )
              {
                strcat( cmdln, " " );
                strcat( cmdln, &argv[j][0] );
              }
            if ( system(cmdln) == (-1) )
              uxfatal( "Unable to execute compressed file extraction program.\n" );
            else
              ++mult;
          }
      } while ( ++i < MAX_TYPES );
    if ( !mult )
      uxfatal( "No matching compressed files found.\n" );
    return 0;
  }


void uxfatal( char *ermsg )           /*  Display error message and exit.  */
  {
    fputs( "***** FATAL: ", stdout );
    fputs( ermsg, stdout );
    exit( 1 );
    return;
  }


void get_opts( char *name )         /*  Read the options structure  */
  {
    int fd, *p, i;
    extern struct options opts;

    if ( (fd = open(name, O_RDWR | O_BINARY)) == (-1) )
      uxfatal( "Unable to locate UX executable file.\n" );
    lseek( fd, 0L - sizeof(opts), SEEK_END );
    if ( read(fd, (unsigned char *)&opts, sizeof(opts)) != sizeof(opts) )
      fputs( "\n***** Initializing options space!\n", stdout );
    if ( strcmpi(VERSION, opts.signature) )
      uxfatal( "Options information is invalid!\n" );
    close( fd );
  }
