// file.cpp

#include"file.h"
#include<malloc.h>
#include<memory.h>

int File::Copy(char *destination)
    {
    int retval = 0;

//#if defined(NOTYET)
    if(!destination || !*destination)
        return 1;

//   char *buffer = (char *) malloc(MAXBUF);
    char *buffer = new char[MAXBUF];
    if(!buffer)
        return 1;

    File oldf(name);
    File newf(destination);

    if(!oldf.Open("rb") || !newf.Open("wb")) 
        {
        delete buffer;
        cout << "Unable to open source or destination file\n";
        return 1;
        }

    int num;
    while(num = oldf.Read(MAXBUF,buffer))
        newf.Write(num,buffer);
    newf.Close();
    oldf.Close();
//#endif
  delete buffer;
//    free(buffer);
    return retval;
    }

int File::ReadAt(long offset, int size, void *buf)
    {
    if(!Offset(offset))
        return Read(size,buf);
    return 0;
    }

int File::Read(int size,void *buf)
    {
    return fread(buf,1,size,fp);
    }

int File::_fRead(int size, void far *farbuf, char *nearbuf)
    {
    if(!nearbuf)
        return 0;
    int bytesread = Read(size,nearbuf);
    _fmemcpy(farbuf,nearbuf,bytesread);
    return bytesread;
    }

int File::WriteAt(long offset, int size, void *buf)
    {
    if(!Offset(offset))
        return Write(size, buf);
    return 0;
    }

int File::Write(int size, void *buf)
    {
    return fwrite(buf,1,size,fp);
    }

int File::_fWrite(int size, void far *farbuf, char *nearbuf)
    {
    if(!nearbuf)
        return 0;
    _fmemcpy(nearbuf,farbuf,size);
    int byteswritten = Write(size,nearbuf);
    return byteswritten;
    }

int File::Move(char *movedir)
    {
    if(!movedir || !*movedir)
        return 1;

    char *p;
    char *newname = NULL;

    if(p = strrchr(name,'\\'))
        p++;
    else
        p = name;
    newname = new char[strlen(movedir)+strlen(p)+2];
    strcpy(newname,movedir);
    strcat(newname,"\\");
    strcat(newname,p);

    int isopen = FALSE;
    char *oldmode;
    if(fp)
        {
        isopen = TRUE;
        oldmode = new char[strlen(mode)+1];
        strcpy(oldmode,mode);
        }

    Close();

    int retval;
    if(retval = rename(name,newname))  // fall thru to no more
        {
        printf("Unable to rename %s to %s...press <RETURN>\n",
            name,newname);
        char c;
        cin >> c;
        }
    else
        SetName(newname);
    if(isopen)
        {
        Open(oldmode);
        delete oldmode;
        }
    if(newname)
        delete newname;
    return retval;
    }

long File::Size(void)
    {
    if(fp)
        return filelength(fileno(fp));
    FindFile f(name,ALL_FILES);
    if(f.Found())
        return f.Size();
    return 0L;
    }

int File::Delete(void)
    {
    if(fp)
        Close();
    return remove(name);
    }

char *File::GetLine(void)
    {
    InitLineBuffer();
    return fgets(linebuffer,linelen-1,fp);
    }

void File::Close(void)             
    {   
    if(fp)
        {
        fclose(fp);
        fp = NULL;
        }
    }

int File::Open(char *m)
    {
    if(!name)
        return FALSE;
    strcpy(mode,m);
    if(!(fp = fopen(name,mode)))
        return FALSE;
    return TRUE;
    }

void File::SetName(char *newname)    
    {
    if(name)
        delete name;
    name = new char[strlen(newname)+1];
    strcpy(name,newname);
    }

File::~File(void)
    {
    Close();
    if(linebuffer)
        {
        delete linebuffer;
        linebuffer = NULL;
        }
    if(name)
        {
        delete name;
        name = NULL;
        }
    }

File::File(char *newname)         
    {   
    Init();
    SetName(newname);   
    }

void File::Init(void)
    {
    linelen = DEFAULTLINELEN;
    linebuffer  = NULL;
    fp = NULL;
    name = NULL;
    MAXBUF = 20000;
    *mode = NULL;
    }

void File::InitLineBuffer(void)
    {
    if(!linebuffer)
        linebuffer = new char[linelen];
    }

void File::SetLineBuffer(void)
    {
    if(linebuffer)
        delete linebuffer;
    linebuffer = NULL;
    InitLineBuffer();
    }
