/*************************************************
    LHPick : Pick files from LHA's archive
*************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>

FILE *f1, *f2, *f3;
char name[256], buf[SHRT_MAX];

void main(int ac, char *av[])
{
	unsigned long start;
	long size;
	char *p;

	if (ac != 4) {
		printf("usage : LHPICK info-file org-lzh new-lzh\n");
		return;
	}
	strcpy(name, av[1]);
	f1 = fopen(name, "rt");
	if (f1 == NULL) {
		printf("Info-file '%s' can't open.\n", av[1]);
		return;
	}
	strcpy(name, av[2]);
	f2 = fopen(name, "rb");
	if (f2 == NULL) {
		strcat(name, ".lzh");
		f2 = fopen(name, "rb");
		if (f2 == NULL) {
			printf("Org-lzh '%s' can't open.\n", av[2]);
			return;
		}
	}
	strcpy(name, av[3]);
	if (strchr(name, '.') == NULL) {
		strcat(name, ".lzh");
	}
	if (fopen(name, "rb")) {
		printf("New-lzh '%s' already exists.\n", name);
		return;
	}
	f3 = fopen(name, "wb");
	if (f3 == NULL) {
		printf("New-lzh '%s' can't open.\n", name);
		return;
	}
	while (fgets(buf, sizeof(buf), f1)) {
		if (*buf == '=') continue;
		start = strtoul(buf, &p, 16);
		size = strtoul(p, &p, 16) - start;
		if (size <= 0) {
			printf("Illegal position : %s\n", buf);
			continue;
		}
		fseek(f2, start, SEEK_SET);
		while (size) {
			int l;

			l = (size > sizeof(buf)) ? sizeof(buf) : size;
			fread(buf, l, 1, f2);
			fwrite(buf, l, 1, f3);
			size -= l;
		}
	}
	putc('\0', f3);
	fclose(f3);
	fclose(f2);
	fclose(f1);
}
