' RLE.BAS - Run Length Encoding routines.

' Version 1.00  05/27/91

' (C) Copyright 1991 K.A.T., Inc.
'                    502 NW 75th Street, Suite 214
'                    Gainesville, FL  32607

'                and William D. Hileman
'                    Route 2, Box 504
'                    Newberry, FL  32669
'                    (904) 472-6401

DEFINT A-Z

' $INCLUDE: 'RLEDECL.BAS'

FUNCTION RLECompress (Operation, InText$, OutText$, RepeatCode)

  OutText$ = ""
  IF INSTR(InText$, CHR$(RepeatCode)) THEN
    RepeatCode = -1
    FOR Cnt = 255 TO 0 STEP -1
      IF INSTR(InText$, CHR$(Cnt)) = 0 THEN
        RepeatCode = Cnt
        EXIT FOR
      END IF
    NEXT Cnt
    IF RepeatCode = -1 THEN
      RLECompress = -1
      EXIT FUNCTION
    END IF
  END IF
  LastChar$ = LEFT$(InText$, 1)
  CharCount = 1
  FOR Cnt = 2 TO LEN(InText$)
    IF MID$(InText$, Cnt, 1) = LastChar$ AND CharCount < 259 THEN
      CharCount = CharCount + 1
    ELSE
      IF Operation = 1 THEN
        IF CharCount < 4 THEN
          OutTextLen = OutTextLen + CharCount
        ELSE
          OutTextLen = OutTextLen + 3
        END IF
      ELSEIF CharCount < 4 THEN
        OutText$ = OutText$ + STRING$(CharCount, MID$(InText$, Cnt - 1, 1))
      ELSE
        OutText$ = OutText$ + CHR$(RepeatCode) + CHR$(CharCount - 4) + MID$(InText$, Cnt - 1, 1)
      END IF
      CharCount = 1
    END IF
    LastChar$ = MID$(InText$, Cnt, 1)
  NEXT Cnt
  IF Operation = 1 THEN
    IF CharCount < 4 THEN
      OutTextLen = OutTextLen + CharCount
    ELSE
      OutTextLen = OutTextLen + 3
    END IF
    RLECompress = OutTextLen
  ELSE
    IF CharCount < 4 THEN
      OutText$ = OutText$ + STRING$(CharCount, LastChar$)
    ELSE
      OutText$ = OutText$ + CHR$(RepeatCode) + CHR$(CharCount - 4) + LastChar$
    END IF
    IF LEN(OutText$) + 1 < LEN(InText$) THEN
      RLECompress = 0
    ELSE
      OutText$ = ""
      RLECompress = -2
    END IF
  END IF

END FUNCTION

FUNCTION RLEDeCompress (Operation, InText$, OutText$, RepeatCode)

OutText$ = ""
IF INSTR(InText$, CHR$(RepeatCode)) = 0 THEN
  RLEDeCompress = -1
  EXIT FUNCTION
END IF
ChrPtr = 1
TextLen = LEN(InText$)
OutTextLen = 0
RepeatChar$ = CHR$(RepeatCode)
WHILE ChrPtr <= TextLen
  InChar$ = MID$(InText$, ChrPtr, 1)
  IF InChar$ = RepeatChar$ THEN
    NumChars = ASC(MID$(InText$, ChrPtr + 1, 1)) + 4
    IF Operation = 1 THEN
      OutTextLen = OutTextLen + NumChars
    ELSE
      OutText$ = OutText$ + STRING$(NumChars, MID$(InText$, ChrPtr + 2, 1))
    END IF
    ChrPtr = ChrPtr + 3
  ELSE
    IF Operation = 1 THEN
      OutTextLen = OutTextLen + 1
    ELSE
      OutText$ = OutText$ + InChar$
    END IF
    ChrPtr = ChrPtr + 1
  END IF
WEND
IF Operation = 1 THEN
  RLEDeCompress = OutTextLen
ELSE
  RLEDeCompress = 0
END IF

END FUNCTION

