;
;+
;        Copyright (C) 1989-92 Terry Dutcher, All Rights Reserved
;
;***************************************************************************
;
;            THIS PROGRAM IS PROVIDED ON AN "AS IS" BASIS ONLY.
; 
; The author disclaims all warranties on the program, including without 
; limitation, all implied warranties of merchantablity and fitness.
; 
; Full permission and consent is hereby given to reproduce, distribute, and 
; publish and to permit others to reproduce this program and information 
; relating thereto according to the terms granted in the license agreement.
; 
;***************************************************************************
; 
;  System Title:     Set-Clock          Date Created:   07-Apr-89
; 
;  Module Name:      Procomm+ Script    Written By:     Terry Dutcher
; 
;  Revsion Number:   04.0P1-P           Revision Date:  31 August 1992
; 
;  Purpose: 
;
;       To front-end the CLKSET routine by dialing the Naval Observatory 
;       or NIST and passing it the time/date string (and switches etc.)
;
;  Change Log:
;
;       0.0 to 2.4 - Prerelease versions
;       2.5 to 2.7 - Performed all processing in the command file
;       3.0 - Use external CLKSET routine to process and set clocks.
;       3.1 - Use external configuration file
;       4.0 - build CFG file via program, pursue NIST
; 
;***************************************************************************
;- 

  emulate vt102
  clear
  curoff

; init the screen

  if mono
    clear 0
    box 0 0 5 79 112
    atsay 2 22 7 " S e t - C l o c k   -  Version 4.0-P "
    atsay 4 13 7  " Copyright (C) 1992 Terry Dutcher, All Rights Reserved "
    box 8 20 12 60 112
    atsay 10 25 7 "      --- Initializing ---     "
  else
    clear 16
    box 0 0 5 79 113
    atsay 2 22 31 " S e t - C l o c k   -  Version 4.0-P "
    atsay 4 13 31  " Copyright (C) 1992 Terry Dutcher, All Rights Reserved "
    box 8 20 12 60 113
    atsay 10 25 31 "      --- Initializing ---     "
  endif

  locate 15 0
  transmit "ATE1^M"
  waitfor "OK"
  transmit "^[[?6h"
  pause 1
  transmit "^[[15;23r"

  set baudrate 1200
  set parity space
  set databits 7
  set stopbits 1

  isfile "clkset.exe"
  if success 
    goto findcfg
  endif
  assign s1 "CLKSET routine not found. "
  gosub f_error

findcfg:
  gosub open_cfg

  fgets s1
  fgets s2
  fgets s9
  fgets s8
  fclosei

;
; Sample SC40-P.CFG.  The file should contain only 4 lines.  The lines
; MUST start in colum 1.  The 1st line is the number to manually dial
; to get to the SprintNet PAD (include dialing codes as necessary.)
; The second is your PC Pursuit UserId and Password seperated only by
; a comma.  The third is the start of the CLKSET command line.  The 
; number is the local time offset from Universal (GMT).  The fourth is 
; which time signal source.
;
; 202-459-7800          ;local SprintNet access #
; UserId,Password       ;PC Pursuit UserId and Password
; clkset 5              ;clkset command w/ east coast offset
; navy                  ;which time signal source
;

  substr s8 s8 0 4
  switch s8
   case "navy"
      assign s7 "D6530351^M"
      assign s6 " In Pursuit of the Naval Observatory "
      assign s5 "Unable to pursue the Naval Observatory "
      strfmt s3 "C D/DCWAS/12,%s" s2
      init n2 20
    endcase
   case "nist"
      assign s7 "D4944774^M"
      assign s6 "    In Pursuit of the NIST - ACTS    "
      assign s5 "Unable to pursue the NIST - ACTS "
      strfmt s3 "C D/CODEN/12,%s" s2
      init n2 28
    endcase
   case "_NULL"
      assign s1 "Missing time source in SC40-P.CFG "
      gosub f_error
    endcase
   default
      assign s1 "Invalid or unknown time source in SC40-P.CFG "
      gosub f_error
    endcase
  endswitch

  if mono
    atsay 10 22 7 s6
  else
    atsay 10 22 31 s6
  endif

  locate 19 0
  curon

  mdial s1
  if not connected
    assign s1 s5
    gosub f_error
  endif

;
; PC Pursuit to the emerald city
;
  transmit "^M"
  transmit "^M"
  waitfor "AL="
  transmit "D1"
  transmit "^M"
  waitfor "@"
  init n0 0

get_to_dc:
  if lt n0 4
    goto try_it
  endif
  hangup
  assign s1 "Double check your PC Pursuit id and password. "
  gosub f_error

try_it:
  transmit s3
  transmit "^M"
  waitfor "CONNECTED" 5
  if not waitfor
    inc n0 
    goto get_to_dc
  endif

;escape back to home PAD

  transmit "@"
  transmit "^M"
  waitfor "@" 3
  if waitfor
    goto set_up_modem
  endif
  init n1 0

; theres no place like home

tnplh:
  if lt n1 9
    goto at_cr
  endif
  hangup
  assign s1 "Unable to escape back to host PAD. "
  gosub f_error

at_cr:
  transmit "@"
  transmit "^M"
  waitfor "@" 3
  if waitfor
    goto gmooh
  else
    inc n1
    goto tnplh
  endif

; get me out of here !

gmooh:
  transmit "D"
  transmit "^M"
  waitfor "@" 3
  if waitfor
    pause 5
    init n0 0
    goto get_to_dc
  else
    goto gmooh
  endif

set_up_modem:
  transmit "CONT^M"
  pause 1

  transmit "ATZ"
  transmit "^M"
  waitfor "OK" 3
  if not waitfor
    init n1 0
    goto tnplh
  endif

  transmit "^E^M"
  waitfor "*" 3
  if not waitfor
    init n1 0
    goto tnplh
  endif

  transmit s7
  waitfor "DIALING..." 8
  if not waitfor
    init n1 0
    goto tnplh
  endif

  waitfor "ANSWER TONE" 25
  if not waitfor
    init n1 0
    goto tnplh
  endif

  waitfor "NO ERROR CONTROL"
;  if mono
;    clear 0
;    box 0 0 5 79 112
;    atsay 2 22 7 " S e t - C l o c k   -  Version 4.0-P "
;    atsay 4 13 7  " Copyright (C) 1992 Terry Dutcher, All Rights Reserved "
;  else
;    clear 17
;    box 0 0 5 79 113
;    atsay 2 22 31 " S e t - C l o c k   -  Version 4.0-P "
;    atsay 4 13 31  " Copyright (C) 1992 Terry Dutcher, All Rights Reserved "
;  endif
;  locate 15 0
;  message " "

; wait for a good string

  waitfor "*^M^J"                        ;wait for start of good string
  rget s1 n2 10                          ;get date / time string
  hangup                                 ;now hang up

; invoke clkset routine

  strfmt s8 "%s %s" s9 s1
  dos s8
  time s8 1
  date s7

  if mono
    scroll 0 8 0 16 79 7
    box 8 20 14 60 112
    atsay 10 27 7 " DOS Time and Date set to: "
    fatsay 11 31 7 " %s  %s " s8 s7
    atsay 13 22 112 s1
  else
    scroll 0 8 0 16 79 31
    box 8 20 14 60 113
    atsay 10 27 31 " DOS Time and Date set to: "
    fatsay 11 31 31 " %s  %s " s8 s7
    atsay 13 22 113 s1
  endif

  locate 23 0
  pause 10
;  quit
  exit

;
bookem:
;+
; BOOKEM (as in Danno) Routine.  Play dragnet music.
;-
  sound 587 65
  sound 32767 1
  sound 659 40
  sound 32767 1
  sound 698 40
  sound 32767 2
  sound 587 130
return
;
f_error:
;+
; F_ERROR Routine.  Prints error text and exits to DOS.
;-
  if mono
    clear 0
    box 0 0 5 79 112
    atsay 3 3 7 "  F A T A L   E R R O R  --  "
    atsay 3 32 7 s1
  else
    clear 17
    box 0 0 5 79 113
    atsay 3 3 31 "  F A T A L   E R R O R  --  "
    atsay 3 32 31 s1
  endif
  hangup
  gosub bookem
  pause 7
  clear 11
  curon
  quit
return
;
cfg_it:
;+
; CFG_IT Routine.  Subroutine to create config file on the fly.
;-
  gosub bookem
  curon

fnf:
  atsay 15 0 7 "Config file not found.  Create it ? [Y/N] "
  locate 15 44
  kflush
  keyget s0
  switch s0
    case "Y"
    endcase
    case "y"
    endcase
    case "N"
      quit
    endcase
    case "n"
      quit
    endcase
    case "_NULL"
      goto fnf
    endcase
    default
      goto fnf
    endcase
  endswitch

  isfile "cfg-sc.exe"
  if success 
    goto cfg_sc
  endif
  assign s1 "Configure SetClock routine not found. "
  gosub f_error

cfg_sc:
  dos "cfg-sc procomm pursuit"
  atsay 15 0 7 "                                          "
  atsay 15 0 7 "Continue execution ? [Y/N] "
  locate 15 27
  kflush
  keyget s0
  switch s0
    case "Y"
      return
    endcase
    case "y"
      return
    endcase
  endswitch
  quit
return
;
open_cfg:
;+
; OPEN_CFG Routine. Open the config file.
;-
find_it:
  isfile "sc40-p.cfg"
  if success 
    goto open_it
  endif
  gosub cfg_it
  goto find_it

open_it:
  fopeni "sc40-p.cfg" text
  if not success
    assign s1 "Unable to open config file. "
    gosub f_error
  endif
return
;

