                                                                         $IF 0
 ͸
 PowerBASIC :         ---<< Quick Box Displays >>---         January, 1992
 Source file:              --<< SOURCE CODE >>--              QuickBox.INC
 ;
     Copyright  (c) 1992    Business Enhancement Partnership Group 
                                                                        $ENDIF


 SUB QBOX(Box.Disp%,Box.Top%,Box.Lines%,Box.Left%,Box.Width%,Box.Fg%,Box.Bg%)
'===========================================================================
 SHARED Ulr%, Ulc%, Lrr%, Lrc%, Box.Colors%,Frame%,Shadow%

 CALL Video.Image(Box.Disp%)
 IF Box.Disp% <> 0 THEN EXIT SUB

 CALL BoxAsm(Box.Address)

 IF Box.Width%/2<>INT(Box.Width%/2) THEN INCR Box.Width%
 Box.Width% = MIN(Box.Width%,78)

 IF  Box.Left% < 1_
 THEN
     Ulc% = INT(80-Box.Width%)/2
     Lrc% = INT(79-Ulc%)
 ELSE
     Ulc% = MAX(Box.Left%,1)
     Lrc% = INT(Ulc%+Box.Width%-1)
 END IF

 IF Box.Top% <1_
 THEN
     Ulr% = INT(24-Box.Lines%)/2
 ELSE
     Ulr% = MAX(1,Box.Top%)
 END IF

 Lrr% = Ulr% + Box.Lines%

 Box.Colors% = Box.Bg% * 16 +Box.Fg%
 Frame%=1: Shadow%=1                    'SET TO Zero TO TURN OFF
 SOUND 400,.1
 SOUND 100,.1
 CALL absolute Box.Address (Ulr%,Ulc%,Lrr%,Lrc%,Box.Colors%,Frame%,Shadow%)
 DEF SEG
 Box.Top% = Ulr%:  Box.Left% = Ulc%
 END SUB


 SUB Video.Image(Save.Restore)  PUBLIC
'=============================                ' Save/Restore Screen Displays
 STATIC Box.Nbr
 LOCAL Screen.Image(), VideoAbs&, StorSeg&, StorOff, StorAbs&,_
       Segment&, Start&, Finish&, ScrnId$, Length&, Monitor.Type,_
       VideoSeg&

 DEF SEG = &H0040
 Monitor.Type=PEEK(&H0049)
 IF Monitor.Type=7_
 THEN
     VideoSeg&=&HB000
 ELSE
     VideoSeg&=&HB800
 END IF

 IF Save.Restore=0_                                   ' Save a new screen
 THEN
    INCR Box.Nbr
    IF   Box.Nbr>99_
    THEN
         Box.Nbr=-1
         EXIT SUB
    END IF
    REDIM       Screen.Image(1:2000)
    VideoAbs& = VideoSeg&*16
    StorSeg&  = VARSEG(Screen.Image(1))
    StorOff   = VARPTR(Screen.Image(1))
    StorAbs&  = (StorSeg&*16)+StorOff
    DEF SEG   = 0
    POKE$       StorAbs&, PEEK$(VideoAbs&,4000)
                                               '--<< Save Image To Disk >>--
    Segment&  = VARSEG(Screen.Image(1))
    Start&    = VARPTR(Screen.Image(1))
    Finish&   = VARPTR(Screen.Image(2000))
    ScrnId$   = "SCREEN"+USING$("##",Box.Nbr)+".IMG"
    REPLACE  " " WITH "0" IN ScrnId$
    Length&   = Finish& - Start& + 2
    DEF SEG   = VideoSeg&

    BSAVE       ScrnId$,StartAdr&,Length&
    DEF SEG
    EXIT SUB
  END IF

  IF Save.Restore<0 THEN Box.Nbr=1
                                          '--<< Restore Screen from Disk >>--
  IF Box.Nbr>0 THEN
    DEF SEG  =  VideoSeg&
    ScrnId$  = "SCREEN"+USING$("##",Box.Nbr)+".IMG"
    REPLACE " " WITH "0" IN ScrnId$

    IF DIR$(ScrnId$,0)>""_                  '--<< Does Image File Exist? >>--
    THEN
       BLOAD  ScrnId$
       DECR Box.Nbr,1
    END IF
  END IF

  IF  Save.Restore < 0_                        '--<< Kill All .IMG Files >>--
  THEN
        IF    DIR$("SCREEN*.IMG",0) > ""_
        THEN  KILL "SCREEN*.IMG"
  END IF
 END SUB




 SUB BoxAsm(Box.Address)
'====================
 SHARED Wndow()
  REDIM WNDOW(270)
  WhereAt& = VARSEG(Wndow(0))
  DEF SEG = WhereAt&
  Box.Address = VARPTR(Wndow(0))
  RESTORE windhex:
  FOR i% = 0 TO 269
     READ D$: POKE i%, VAL("&H" + D$)
  NEXT

 windhex:
'
DATA 55,8B,EC,83,EC,E,53,51,6,57,B9,7,0,BF,0,0,8B,5B,6,8B,7,48,89,43,F2,47,47
DATA E2,F3,FF,46,F6,FF,46,F4,FF,46,F2,BB,0,B0,A1,10,0,25,30,0,3D,30,0,74,3,BB
DATA 0,B8,8E,C3,8B,5E,FE,B8,A0,0,F7,E3,8B,5E,FC,D1,E3,3,C3,8B,F8,57,8B,46,F8
DATA 8B,5E,FC,2B,C3,40,8B,D8,53,8B,46,FA,8B,56,FE,2B,C2,40,8B,C8,51,BA,0,0,8A
DATA 66,F6,B0,20,83,7E,F4,0,74,5,B0,C4,BA,1,0,51,8B,CB,83,7E,F4,0,74,8,50,B0
DATA B3,AB,83,E9,1,58,F3,AB,83,7E,F4,0,74,8,50,83,EF,2,B0,B3,AB,58,83,FA,0,75
DATA E,83,7E,F2,0,74,8,50,B0,8,47,AA,4F,4F,58,2B,FB,2B,FB,81,C7,A0,0,59,B0,20
DATA 83,7E,F4,0,74,7,83,F9,2,75,2,B0,C4,BA,0,0,E2,AF,83,7E,F2,0,74,B,8B,CB,B0
DATA 8,83,C7,2,47,AA,E2,FC,83,7E,F4,0,74,27,59,5B,5F,B0,DA,AB,3,FB,3,FB,83,EF
DATA 4,B0,BF,AB,50,B8,A0,0,49,F7,E1,3,F8,58,83,EF,2,B0,D9,AB,2B,FB,2B,FB,B0
DATA C0,AB,5F,7,59,5B,8B,E5,5D,CA,E

END SUB
