'Date: 05-22-92 (12:20)
'From: TONY ELLIOTT
'-------------------------------------------------------------------------
'MK>Does anybody have a routine to check either the network node ID or the
'MK>card id on a NetBios based network, such as LanTastic?

'Here's a little routine you can use to return the machine name and ID
'on NetBios compatible networks. It'll return a null string if a
'compatible network is not running. Hope it helps.

'-------------------
DEFINT A-Z

DECLARE FUNCTION MachineName$ (MachineNumber%)
REM $INCLUDE: 'QBX.BI'                           'Use QB.BI for QB4.x

ThisMachine$ = MachineName$(MachineNumber%)
IF LEN(ThisMachine$) THEN
    PRINT "Machine Name: "; ThisMachine$
    PRINT "   Machine #:"; MachineNumber%
ELSE
    PRINT "NetBIOS compatible network not installed."
END IF

FUNCTION MachineName$ (MachineNumber%)

    'If a NetBIOS compatible network is installed, this function returns
    'the machine name as a result of the function and the machine's NetBIOS
    'ID number in the MachineNumber% parameter.

    'If a network is not detected, the function returns a null string.

    DIM Reg AS RegTypeX                 'In QB.BI (or QBX.BI if using PDS)
    DIM Temp AS STRING * 16             'Buffer to hold machine name
    MachineNumber% = 0                  'Make sure it is zero
    Reg.ax = 0                          'Use function 0 of interrupt 2ah
    CALL InterruptX(&H2A, Reg, Reg)
    IF Reg.ax AND &HFF00 THEN           'If AH <> 0 then network was found
        Reg.ax = &H5E00
        Reg.ds = VARSEG(Temp)
        Reg.dx = VARPTR(Temp)
        CALL InterruptX(&H21, Reg, Reg)
        IF Reg.flags AND 1 THEN         'Did an error occur?
            EXIT FUNCTION
        END IF
        MachineNumber% = Reg.cx AND &HFF    'Machine # in CL
        MachineName$ = RTRIM$(Temp)
    END IF

END FUNCTION

'-------------
