3 ' $linesize:125
4 ' $title: 'MAKEDOOR Copyright 1990 by Steven R. Kling'
5 '  WARNING !!! DO NOT CHANGE BYPASS OR Remove LINES 3- 50
6 '  Copyright 1990 by Steven R. Kling, all rights reserved.
7 '  First Released .....: January 12, 1991
8 '  Purpose.............:
9 '     MAKEDOOR has been written to provide BASIC programmers 
10 '    within the BBS community with (hopefully) a good quality door example.
11 '    MAKEDOOR will meet the author's expectation IF:  a journeyman level
12 '    BASIC programmer can read the MAKEDOOR.BAS source, and THEN: 
13 '    create a professional quality working door.
14 '                                                                         
15 ' *******************************NOTICE*************************************
16 ' *  A limited license is granted to all users of this program             *
17 ' *  and its companion documentation on the following conditions:          *
18 ' *                                                                        *
19 ' *                                                                        *
20 ' *    1.   The notices contained in lines 3 through 73 of the program     *
21 ' *         are not altered, bypassed, or removed.                         *
22 ' *    2.   The source code, and all documentation to this program         *
23 ' *         is not to be distributed to others in modified                 *
24 ' *         form (i.e. the line numbers must remain the same)  without     *
25 ' *         an express written agreement with Steven R. Kling, Techno-     *
26 ' *         ware PO BOX 103, Marshall, Virginia, 22115                     *
27 ' *    3.   No fee is to be charged (or any other consideration received)  *
28 ' *         for copying or distributing these programs without an express  *
29 ' *         written agreement with Steven R. Kling at the address noted    *
30 ' *         in (3) above.                                                  *
31 ' *    4.   You may freely distribute your programs in .EXE file format    *
32 ' *         only.  A comment denoting the use of MAKEDOOR would be         *
33 ' *         appreciated but is not required.                               *
34 ' *                                                                        *
35 ' *       Copyright (c) 1990 Steven R. Kling, Technoware                   *
36 ' **************************************************************************
37 '
38 ' Acknowledgements:
39 ' This program would not be possible if not for the basic idea that
40 ' users should help other users by sharing their ideas, programs,
41 ' methods, etc.  RBBS is the greatest example of this sharing of 
42 ' efforts, and is one of the primary reasons that free BBSes proliferate.
43 '
44 ' Many people have helped me learn about Bulletin Boards, and Doors.
45 ' These people have, in one form or another, shared their ideas, 
46 ' from which my understanding of this whole process is based.
47 ' Thanks to:
48 ' 
49 ' D. Thomas Mack, Ken Goosens, Jon Martin, and all of the other
50 ' contributors to RBBS.
51 '
52 ' John Morris and Chris Sherrick, the authors of the first great
53 ' door, Trade Wars (originally released with source code). 
54 '
55 ' Fast Fingers (Is F.F. a man or woman?) This person released many
56 '             ANSI graphics doors, and always freely gave away
57 '             the code.  I studied these doors to learn some
58 '             creative methods for door I/O. 
60 '
61 ' Phil Dewitt - Phil is the author of many, many doors.  We have
62 '               worked together on several.  He helped me write
63 '               my first door.
64 '
65 ' Gregg Snyder and all of the other Sysops of the DGS group.
66 '              This is a group of SYSOPs that are dedicated to
67 '              helping other with any BBS related projects.  
68 '              Several of the above mentioned people and I belong to 
69 '              this group of SYSOPs.  Many innovations in the BBS
70 '              programs were spawned from someone in this group.
71 '              Yet, these people will find time to help anyone with
72 '              a BBS problem.
73 '
74 ' ************************* Procedures ******************************
75 ' 
76 ' This code is hopefully well documented. This door is divided into
77 ' 3 parts:
78 '
79 '  a.  The Shell.  This is the beginning section, prior to the 
80 '      line Door.Code.Begins:.  In here you will define all common 
81 '      variables, subprograms, function`s, and constants.  Otherwise
82 '      you really shouldn't touch this section until you thoroughly
83 '      understand the code.
84 ' 
85 '  b.  The Door.  This is the section that you will write 100%.
86 '      and it starts at Door.Code.Begins.  Look at the sample
87 '      registration door that I have included.  Compile it, 
88 '      and run it.  Then study the code, and see how it works.
89 '      I wrote this code for ease of understanding.
90 '  
91 '  c.  The rest of the Shell and the Subprograms.  You will need
92 '      to modify the error trapping section, to support your 
93 '      requirements.  Also, if you open and close any data files,
94 '      you will need to write the code in Shutdown to correctly close
95 '      these.
96 '
97 '      FILE NUMBER #1 (as in OPEN #1 for INPUT) is used by the door
98 '                     for quick file I/O, where a file is opened,
99 '                     read (or written to), and then closed immediately.
100'                     This one could be used to read in door datafiles.
100'
101'      FILE NUMBER #2 is available for any use.
102'
103'      FILE NUMBER #3 is ALWAYS RESERVED for COMMs I/O.  Don't use
104'      this.  If you were to write a strictly FOSSIL only door,
105'      and removed all the associate code, then # becomes available.
106'     
107'      FILE NUMBER #4 is ALWAYS RESERVE FOR ERROR HANDLING ROUTINES.
108'
109'      FILE NUMBERS >= #4 are available for any use.
                             
110'   Each door must have a MAKEDOOR.DEF file (change the name to something
111'   specific to your application.  Look at the code for that section.

112'  CAN BE COMPILED UNDER QB4.5 or greater.  BASCOM 7.1 is recommended.
113'  (BASIC 7.1 PDS is the only BASIC compiler that I will use).
114'  REQUIRES FOSSCOMM,OBJ and GIVEBK31.OBJ from RBBS to work
115'
116'**********************************************************************
117'  COMPILE COMMAND: (DO NOT LOAD INTO QB or QBX environments!)
118'
119'  BC MAKEDOOR.BAS /w/x/c:512/o 
120'  NOTE: DO NOT USE /S command if you are compiling for others.
121'  
122'  LINK COMMAND:
123'  LINK MAKEDOOR+FOSSCOMM+GIVEBK31;
124'
125'  THIS PROGRAM HAS BEEN WRITTEN TO BE BUSTED INTO MODULES

' Here is where you would put all COMMON/SHARED variables,
'       make  constants 
'       declare other variables and dimension arrays                      
COMMON SHARED ARG$, BACK.SP$, BackTab%,BBS.Type$, Bk.Arw$, BC%, BP$, Bytes%
COMMON SHARED C.OLOR(), CR$, CS$, BACKSPACE$, Error.Flag%
COMMON SHARED COL%, COLOR.RESET$, COLOR.NORMAL$, ESC$, ANSI.COMMAND$
COMMON SHARED COM.PORT$, CURSOR$, DataBits%, DOOR.USERS.NAME$, False%
COMMON SHARED FC%, Filename$, FORCESPEED, Fos$, Fossil%
COMMON SHARED GRAPHICS%, GRP%, GRP$, LF$, LFEED, SingleChar%
COMMON SHARED LOG.OFF$, L.ocal%, MESSAGE.FILE$, MSR
COMMON SHARED NORET, NODE, NODE.ID$,Left%,Right%,Up%, Down%
COMMON SHARED Parity%, PAR, PCB14, Port%
COMMON SHARED RD$, RBBS.NAME$, Result%, row%, Scoreboard.File$
COMMON SHARED Security.Level$, Speed%, Stat%, StopBits%
COMMON SHARED SYSOP.FIRST$, SYSOP.LAST$, TabKey%,TABKEY$
COMMON SHARED Snoop,TIME.OFF, TIME.SAVE, True%,TXT$, User.Name$
' DECLARING THOSE VARIABLES NEEDED FOR THIS SAMPLE DOOR
COMMON SHARED FirstName$, LastName$, Street1$, Street2$
COMMON SHARED Company$, City$, State$,Zipcode$




Declare Function TI! ()            ' Keeps track of user time in door
Declare Sub LoadUserRBBSInfo ()    ' Reads DORINFOx.DEF
Declare Sub LoadPCBUserInfo ()     ' Reads PC-Board vers 12 & 14 PCBOARD.SYS
Declare Sub LoadWildcatUserInfo () ' Reads CALLINFO.BBS
Declare Sub PROut ()               ' Most used, Text I/O to Comms and console
Declare Sub PROutCR ()             ' same as above, but with Carriage Return
Declare SUB FsPROut ()             ' Fossil Output through this sub
Declare Sub Cartest ()             ' Monitor Carrier
Declare Sub OutOfTime ()           ' User out of time handling procedure
Declare Sub ShutDown ()            ' Clean and Dirty Door Close Handler
Declare Sub ClrScreen ()           ' Clears screen on users and console screens
Declare Sub ExitDoor ()            ' CLose door and end
Declare Sub InputLine ()           ' Input a normal line of text
Declare Sub InputChar ()           ' Input a single character
Declare Sub InputField (F$)        ' Field Input, supports cursor keys
Declare Sub MoveCursor(r%,c%)      ' Position Cursor
Declare Sub Ansi.Color (F%, B%, BL%, H%, L%) 
                                   ' old routine to change color attributes
Declare Sub Line25 ()              ' Used to Write the Door Legend on Sysop's Line 25
Declare Sub Nam.Adj (N$)           ' Used to Make name the same across BBS types
' Declare Sub Delay(s%)  This is a sub program found in
'                           the shareware & commercial versions of Probas 
'                           and commented out here.  Get the shareware or
'                           even better, buy the product and then use it.
'                           Delay() delays the input by s% seconds.                                     


DIM SHARED C.OLOR(32)
RANDOMIZE TIMER
KEY(8) ON
KEY(9) ON
KEY(10) ON
ON KEY(8)  GOSUB Forceoff
ON KEY(9)  GOSUB Snoop
ON KEY(10) GOSUB Chatter
False% = 0
True% = -1
ON ERROR GOTO Err.routine

DOOR.NAME$ = "MakeDoor Version 1.0"                        
Row% = 0: Col% = 0
' This section forces ANSI definitions for colors vice BASIC
C.OLOR(0) = 0   'black
C.OLOR(1) = 4   'red
C.OLOR(2) = 2   'green
C.OLOR(3) = 6   'yellow (brown)
C.OLOR(4) = 1   'blue
C.OLOR(5) = 5   'magenta
C.OLOR(6) = 3   'cyan
C.OLOR(7) = 7   'white
C.OLOR(8) = 8   'grey
C.OLOR(9) = 12  'light red
C.OLOR(10) = 10 'light green
C.OLOR(11) = 14 'yellow
C.OLOR(12) = 9  'light blue
C.OLOR(13) = 13 'light magenta
C.OLOR(14) = 11 'light cyan
C.OLOR(15) = 15 'white
C.OLOR(16) = 16 'black      (blink)
C.OLOR(17) = 20 'red        (blink)
C.OLOR(18) = 18 'green      (blink)
C.OLOR(19) = 22 'yellow     (blink)
C.OLOR(20) = 17 'blue       (blink)
C.OLOR(21) = 21 'magenta    (blink)
C.OLOR(22) = 19 'cyan       (blink)
C.OLOR(23) = 23 'white      (blink)
C.OLOR(24) = 24 'grey       (blink)
C.OLOR(25) = 28 'light red  (blink)
C.OLOR(26) = 26 'lght green (blink)
C.OLOR(27) = 30 'yellow     (blink)
C.OLOR(28) = 25 'light blue (blink)
C.OLOR(29) = 29 'lt magenta (blink)
C.OLOR(30) = 27 'lt cyan    (blink)
C.OLOR(31) = 31 'white      (blink)

Empty.Line$ = SPACE$(79)             
FOR.SURE.RBBS = 0

'read command line
RD$ = COMMAND$
PCB14 = FALSE%
' Check for PC Board flag version 14
IF INSTR(RD$,"/P=14")>0 THEN PCB14 = TRUE%
FORCESPEED=0

IF INSTR(RD$,"/C")>0 THEN
  FORCESPEED = 19200
  IF INSTR(RD$,"/C=")>0 THEN
    X$ = MID$(RD$,INSTR(RD$,"/C=")+3,5)
    IF LEN(X$)>0 THEN FORCESPEED = VAL(X$)
  END IF
END IF
RD$ = NODE.ID$

1001         ' ** Read the door's definition file
Filename$ = "MAKEDOOR.DEF"           

OPEN "MAKEDOOR.DEF" FOR INPUT AS #1
  ' Look at enclosed MAKEDOOR.DEF
  ' Every door needs to know a little bit about the system on which it is
  ' running.  As everything found herein can either be derived from an
  ' existing file on almost every BBS, or placed on the COMMAND line, 
  ' a Makedoor.def file is not necessary.  This door was written to 
  ' teach, and as Makedoor.def makes life easier this approach was used.

  INPUT #1, SYSOP.FIRST$  ' Sysops First Name
  INPUT #1, SYSOP.LAST$   ' Sysops Last Name
  INPUT #1, MESSAGE.FILE$ ' Name of BBS DOOR file
                          ' this makedoor support PCBOARD.SYS
                          ' DORINFOx.DEF, CALLINFO.BBS
  INPUT #1, COM.PORT$     ' COM PORT all Caps with no COLON
                          ' IMPORTANT *****!!!!!*****
                          ' To use FOSSIL routines, append this
                          ' line with /F!! example COM1 /F

  INPUT #1, RBBS.NAME$    ' the name of your board
  INPUT #1, LOG.OFF$      ' number of  minutes that the user can 
                          ' be inactive before forced out 
  INPUT #1, MAXTM$        ' max user time in Door
  INPUT #1, Access.Level$ ' Access level required to view door
                          ' Only fully supported in RBBS           
                          '  Look at the code and if you don't understand
                          ' then delete this line, or make the value a 0
  NM.TIME = VAL(MAXTM$)
  Access.level% = VAL(Access.level$)
CLOSE 1

1002                                           
'  Check to see if Fossil is desired          
                                              
IF INSTR(COM.PORT$, "/F") > 0 THEN                 
  Fossil% = True%                                           
  COM.PORT$ = LEFT$(LTRIM$(COM.PORT$), 4)                   
  Port% = VAL(RIGHT$(RTRIM$(COM.PORT$), 1)) - 1             
  IF Port% < 0 THEN L.ocal% = True%                              
  State% = 1
  CALL FosDTR(Port%, State%)            
  CALL FosInit(Port%, Result%)          
  IF Result% = -1 THEN
    Uh.oh$ = "Error initializing Fossil"
    GOTO Write.Err                      
  END IF                                
END IF

' Only COMs 1 & 2 are supported by this Sample door
' Support for COMs greater than 2 is left to the author

IF COM.PORT$ = "COM1" THEN
    ' These values are the are part of the Control Registers
    ' for the serial ports.  Get a good PC book for a further explanation.
    MCR = &H3FC
    MSR = &H3FE
    MPR = &H3FB
  else
    ' COM2
    MCR = &H2FC
    MSR = &H2FE
    MPR = &H2FB
END IF

NEXTCASE:
Filename$ = Message.File$
File.ext$ = ucase$(right$(message.file$,3))
select case file.ext$
   case "SYS"
      BBS.Type$ = "PC-Board"
      ' Version 14.0 PCBOARD.SYS
      CALL LoadPCBUserInfo
   case "BBS"
      ' This supports the old version of WILDCAT!'s CALLINFO.BBS file.
      ' I leave it up to the user to update this to use DOOR.SYS or 
      ' WILDCAT!'s other file.
      BBS.Type$ = "Wildcat!"
      CALL LoadWildcatUserInfo
   case "DEF"
      BBS.Type$ = "RBBS"
      CALL LoadRBBSUserInfo
   case else
End Select

 

FIRST.NAME.END% = INSTR(DOOR.USERS.NAME$, " ")
LAST.NAME.END%  = INSTR(FIRST.NAME.END% + 1, DOOR.USERS.NAME$ + "  ", "  ")
  FIRST$ = LEFT$(DOOR.USERS.NAME$, FIRST.NAME.END% - 1)
  LAST$ = MID$(DOOR.USERS.NAME$, FIRST.NAME.END% + 1, LAST.NAME.END% - (FIRST.NAME.END% + 1))
  USER.NAME$ = FIRST$ + " " + LAST$
  CLOSE 1
  IF FORCESPEED <> 0 AND  Val(BP$) <> 0 THEN
      BP$ = STR$(FORCESPEED)
  END IF

  LFEED = 0

' determine parity and number or data and stop bits by examining
'  the Serial Registers

  paritycheck% = inp(MPR) and 24
   if paritycheck% = 24 then 
        PAR% =  0
     PAR$ = ",E,7,1,CS,DS,CD"
       IF Fossil% = True% THEN 
         Parity% = 3                               
         DataBits% = 2                             
         StopBits% = 0                           
       END IF
      else
       PAR% = -1
       PAR$ = ",N,8,1,CS,DS,CD"
       IF Fossil% = True% THEN    
         Parity% = 2                               
         DataBits% = 3                             
         StopBits% = 0                             
       end if  
   end if

  Sys.Op% = False%
  TIME.SAVE = 5
  Error.Flag% = False%
  CR$  = CHR$(13)
  LF$  = CHR$(10)
  CS$  = CHR$(12)
  ESC$ = CHR$(27)
  ANSI.COMMAND$ = CHR$(91) ' All Ansi commands start with 
                            ' Esc (CHR27 and [ Chr91
  TABKEY$ = CHR$(9)
  Bk.Arw$ = CHR$(29) + " " + CHR$(29)
  BACKSPACE$ = CHR$(8)
  BACK.SP$ = CHR$(8) + " " + CHR$(8)
  COLOR.RESET$ = CHR$(27) + "[00;37;40m"
  COLOR.NORMAL$ = CHR$(27) + "[0m"
  L.ocal% = False%
  IF FIRST$ = "SYSOP" THEN
    Sys.Op% = True%
    IF Fossil% = False% THEN               
      IF INP(MSR) < 128 THEN L.ocal% = True%          
     ELSE                                  
      CALL FosStatus(Port%, Stat%)         
      Stat% = Stat% AND &H0080             
      IF Stat% <> &H0080 THEN L.ocal% = True%   
    END IF                                 
    FIRST$ = SYSOP.FIRST$
    LAST$ = SYSOP.LAST$
    CLOSE 3
  END IF
  Speed% = VAL(BP$)                        

  IF VAL(BP$) < 1 THEN L.ocal% = True%
  IF COM.PORT$ = "COM0" THEN
    CLS                                    
    LOCATE 12, 30,1                          
    PRINT "LOCAL WORKSTATION MODE"
    FOR SL = 1 TO 2000
    NEXT SL
    L.ocal% = True%
  END IF
  IF L.ocal% <> True% THEN                           
    IF Fossil% = False% THEN               
      OPEN COM.PORT$ + ":" + BP$ + PAR$ FOR RANDOM AS #3
     ELSE                                  
      Flow% = &H00F2                       
      CALL FosFlowCtl(Port%, Flow%)        
      CALL FosSpeed(Port%, Speed%, Parity%, DataBits%, StopBits%)  
    END IF 
  END IF
GOSUB Indoor


CALL NAM.ADJ(FIRST$)
CALL NAM.ADJ(LAST$)
ON.AT$ = TIME$
IF (Snoop OR L.ocal% = True%) THEN CALL LINE25

GOTO Door.Code.Begins     


COLORASK:

' This sample door is using the Row% and Col% variables to move the 
' cursor around the screen.  If this is used, or 
' if color is desired, then Graphics is REQUIRED.
' It is left up to the Author to modify this section to suit their 
' needs

IF GRP%=2 THEN RETURN
IF PAR <> -1 THEN RETURN
OLDGRP = GRP%
GRP% = 2
GOSUB INDOOR
FC% = 3
TXT$ = ""
CALL PROUTCR
TXT$ = "Your color selection mode indicates that in the main BBS you prefer plain"
CALL PROUTCR
TXT$ = "ASCII text. Graphics is REQUIRED for this door.  You have to change to color"
CALL PROUTCR
TXT$ = "mode inside this door (affects this door only and this session only)"
CALL PROUTCR
FC% = 4
TXT$ = ""
CALL PROUTCR
high% = 1
TXT$ = "Your system is capable of supporting `color or graphics'  IF this paragraph is"
CALL PROUTCR
high% = 1
TXT$ = "a different color than the last  -- or if the question below blinks."
CALL PROUTCR
TXT$ = ""
CALL PROUTCR
FC% = 7
BLINK% = 1
TXT$ = "      Use Graphics (Y/N)? "
CALL PROUT 
CALL InputLine                                     
TXT$ = LTRIM$(RTRIM$(TXT$))                         
TXT$ = MID$(UCASE$(TXT$),1,1)                      
IF TXT$ = "N"  THEN                                
  call ClrScreen                                   
  TXT$ = "I am sorry, but this door requires that you use graphics." 
  CALL PROUTCR       
  TXT$ = "<Press enter to return to " + rbbs.name$ +" >" 
  CALL PROUTCR
  CALL InputLine
  CALL ShutDown 
 ELSE           
  GRP% = 2 : RETURN                                       
END IF

GRP% = OLDGRP
RETURN
 

Door.Code.Begins:                  

'**********************************************************************
'**********************************************************************
'**********************************************************************
'**********                                                   *********
'**********    This is the start of your door code            *********
'**********                                                   *********
'**********       90% of your coding begins in here!          *********
'**********                                                   *********
'**********                                                   *********
'**********************************************************************
'**********************************************************************

     
' Here is the security level sample.  This can be taken out or modified
' at the authors discretion 

    If access.level% > 0 and  (access.level% > val(security.level$)) then    
         Call ClrScreen                                                      
         TXT$ = "I am sorry, but you don't have the access to view this door."
         call proutcr                              
         '  call delay(2)                              
         CALL ShutDown       
        end if               

' Everything that you send to the screen should go through one of the
' following subprograms

' ClrScreen - clears the screen

' PROUTCR - This simply prints the string TXT$ with  a carriage
'           return on the end.  If ROW%, COL%, FC%, BC%, HIGH%, or BLINK%
'           are not specified then it prints TXT$ at the current cursor
'           position.
'           Row% and Col% position cursor
'           FC% and BC% are for foreground and background colors
'           HIGH% and BLINK% are to change the intensity and make 
'           the foreground color blink, respectively.

  
' PROUT  - same as above, only with no Carriage return
' INPUTLINE - This subprogram closely mimics BASIC INPUT command
'             like above,set the colors and cursor
'             Answer is returned to the program in the string ARG$
               
' INPUTCHAR - This subprogram gets single key input, returns string
'             in ARG$.  Cursor and some other special keys are 
'             checked for.  

' INPUTFIELD(Field$) - Gets user input for a specified field.
'                  has built-in routines to look for 
'                  cursor movement within and between fields.
'                               ****NOTE*****
'                  All fields must be pre-initialized
'                  to their correct length with either spaces or
'                  some other default value, else this subprogram
'                  will generate an error.  This subprogram
'                  is kind of complicated.  I wrote it 
'                  for comprehension, not speed, and should be
'                  rewritten to improve throughput.
              

Call ClrScreen


' initializing the field variables
FirstName$ = space$(25)
LastName$  = space$(25)
Street1$   = space$(30)
Street2$   = space$(30)
Company$   = space$(40)
City$      = space$(25)
State$     = space$(2)
Zipcode$   = space$(9)

EditRecord:

row%= 4:col% = 24:TXT$ = "Ŀ":CALL PROUT
row%= 5:col% = 24:TXT$ = "       REGISTRATION DOOR           ":CALL PROUT
row%= 6:col% = 24:TXT$ = "":CALL PROUT
row% = 11:col% =50 : txt$ ="Use left and right cursor":call prout
row% = 12:col% =50 : txt$ ="Cursor keys to move within":call prout
row% = 13:col% =50 : txt$="a field, and the up and down":call prout
row% = 14:col% =50 : txt$="cursors keys to move between ":call prout
row% = 15:col% =50 : txt$="fields.": call prout

row% = 10:col% = 5
txt$ = "Enter the following information: ": call prout
row% = 13:col% = 5
txt$ = "First Name  : "+FirstName$:call prout
row% = 14:col% = 5
txt$ = "Last Name   : "+ LastName$:call prout
row% = 15: col% = 5
txt$ = "Street      : "+ Street1$:call prout
row% = 16: col% = 5
txt$ = "Street(cont): "+ Street2$:call prout 
row% = 17:col% = 5
txt$ = "City        : "+ City$:call prout
row% = 17: col% = 45
txt$ = "State : "+State$ : call prout
row% = 17: col% = 58
txt$ = "Zipcode: "+Zipcode$:call prout

Field1:
Call MoveCursor(13,19)   
call InputField(FirstName$)

Field2:
Call MoveCursor(14,19)
call InputField(LastName$)

if BACKTAB% then
   goto field1
end if
Field3:
Call MoveCursor(15,19)   
call inputfield(Street1$)

If backtab% then 
   goto field2
end if
Field4:
Call MoveCursor(16,19)
call inputfield(Street2$)
If BackTab% then
   goto Field3
End if

Field5:
Call MoveCursor(17,19)
Call InputField(City$)
If BackTab% then
   goto Field4
End if

Field6:

Call MoveCursor(17,53)
Call InputField(State$)
If BackTab% then
   goto Field5
End IF

Field7:
Call MoveCursor(17,67)
Call InputField(Zipcode$)
If BackTab% then 
   Goto Field6
End If
row% = 20:col% = 5
Txt$ = "Are you calling for a business/firm? ":Call Prout
Call InputChar
 
If UCase$(ARG$) = "Y" then
  row% = 18:col% = 5
  txt$ = "Company Name: "+Company$:call prout
  Call MoveCursor(18,19)
  Call InputField(Company$)
End if
makechoice:
row% = 20:col% = 1: txt$ = Empty.Line$:call prout
row% = 20:col% = 21
txt$ = "Please enter (S)ave, (E)dit, or (Q)uit): "
call PROUT:CALL InputChar
if len(arg$) > 0 then  arg$ = Ucase$(arg$)
  
Select case ARG$
 
    Case "S"
        ' In here you need to write the routine that saves the information
        ' to a data file.  This is left to the author.
       
     case "E"
      call ClrScreen
      goto editrecord
    case "Q" 

      quitchoice:  
      row% = 21: col% = 5
      Txt$ = "Are you sure you want to quit without saving your entry? "
      Call Prout: call InputChar
      if len(arg$) then arg$ = ucase$(arg$)
      select case arg$
         case "Y"
           call Shutdown
         case "N" 
           row% = 20:col% = 1: txt$ = Empty.Line$:call prout
           row% = 21:col% = 1:txt$ = empty.line$: call prout
           goto makechoice  
         case else
           row% = 21:col% = 1:txt$ = empty.line$: call prout
           goto quitchoice 
      end select 

    case else
       goto makechoice

End Select

Call ClrScreen:Txt$ = "That's All Folks!":call prout
' call delay(3) 
  CALL ShutDown


CLOSE
END


'**********************************************************************
'**********************************************************************
'**********************************************************************
'**********                                                   *********
'**********    This is the main portion of you door           *********
'**********                                                   *********
'**********          code should finish                       *********
'**********                                                   *********
'**********                                                   *********
'**********************************************************************
'**********************************************************************


Err.routine:                       '** Error routines
'DEVICE I/O ERROR
Error.Flag% = True%

' the following keeps the door from totally crashing,
' by recursively calling the error trap routine.
If error.Flag% then
  close
  end
end if


CLS
PRINT ERR
IF ERR = 57 THEN
    ERROR.FLAG% = fALSE%
    RESUME
END IF
'check for errors in reading door's DEF file or BBS-specific info
'  (MESSAGES, DORINFOx.DEF, CALLINFO.BBS, PCBOARD.SYS)


IF ERR = 53 THEN 

   select case File.name$
        case Message.file$
           select case BBS.Type$
	         case "PC-Board"
                    PRINT"CANNOT FIND PCBoard's FILE: "+MESSAGE.FILE$   
                 case "RBBS"               
                    PRINT "CANNOT FIND RBBS's FILE: " + MESSAGE.FILE$         
                 case "Wildcat!"
                     PRINT "CANNOT FIND Wildcat!'s FILE: " + MESSAGE.FILE$
                 case else
                    PRINT "CANNOT FIND DOOR FILE: " + MESSAGE.FILE$
           end select
                  case else
                    PRINT "CANNOT FIND DOOR FILE: " + File.Name$
   end select

END IF
IF ERR = 62 THEN 
   PRINT "THERE'S AN EXTRA LINE IN: " + file.name$

END IF
'  many of the most likely errors listed below -- author reponsibility
'  to trap and or take appropriate action -- all such errors in this
'  skeleton code result in abrupt termination of program and a return
'  to the BBS
'
' ERR = 5 = ILLEGAL FUNCTION CALL
' ERR = 6 = OVERFLOW
' ERR = 9 = SUBSCRIPT OUT OF RANGE
' ERR =11 = DIVISION BY ZERO
' ERR =24 = DEVICE TIMEOUT
' ERR =25 = DEVICE FAULT
' ERR =27 = OUT OF PAPER
' ERR =52 = BAD FILE NAME OR NUMBER
' ERR =53 = FILE NOT FOUND
' ERR =54 = BAD FILE MODE
' ERR =55 = FILE ALREADY OPEN
' ERR =57 = DEVICE I/O ERROR
' ERR =58 = FILE ALREADY EXISTS
' ERR =70 = PERMISSION DENIED
' ERR =71 = DISK NOT READY
' ERR =75 = PATH/FILE ACCESS ERROR
' ERR =76 = PATH NOT FOUND

Write.err:
TXT$ = "Error >" + STR$(ERR) + " File >" + DOOR.NAME$ + " Date >" + DATE$ + " " + TIME$
  IF LEN(Uh.oh$) > 1 THEN TXT$ = Uh.Oh$ + DOOR.NAME$ +  " Date >" + DATE$ + " " + TIME$
CALL PROUT                                             
CLOSE
OPEN "ERRORS.DOR" FOR APPEND AS #4
  PRINT #4, TXT$
CLOSE #4

Call Shutdown

Chatter:                           '*** F-10 CHAT MODE ***
                                
SAVETIME = TIME.OFF - TI!       
LINE.SAVE$ = TXT$
NORET = 0
TXT$ = ""
CALL PROUT
CALL PROUT
PRINT "SysOp - Hit ESC to exit chat mode"
TXT$ = "Hello!  This is " + SYSOP.FIRST$ + ","
CALL PROUT

Remote:

IF Fossil% = False% THEN                                 
  IF LOC(3) = 0 THEN GOTO Local.test
  Chat$ = INPUT$(1, 3)
 ELSE                                                    
  CALL FosReadAhead(Port%, NoChar%)                      
  IF No.Char% = - 1 THEN GOTO Local.Test                 
  FOR m% = 1 TO NoChar%                                  
    CALL FosRXChar(Port%, Char%)                         
    Chat$ = Chat$ + CHR$(Char%)                          
  NEXT m%                                                
END IF                                                   
IF ASC(Chat$) = 8 THEN
  PRINT Bk.Arw$;
  IF Fossil% = False% THEN                               
    PRINT #3, BACK.SP$;
   ELSE                                                  
    Fos$ = BACK.SP$                                      
    Call FsPrOut                                        
  END IF                                                 
 ELSEIF ASC(Chat$) = 27 THEN
  GOTO Local.inp
 ELSE
  PRINT Chat$;
  IF Fossil% = False% THEN                               
    PRINT #3, Chat$;
   ELSE                                                  
    Fos$ = TXT$                                            
    Call FsPrOut                                        
  END IF                                                 
END IF
IF ASC(Chat$) = 13 THEN 
  IF Fossil% = False% THEN                               
    PRINT #3, CHR$(10);
   ELSE                                                  
    Fos$ = CHR$(10)                                      
    Call FsPrOut                                        
  END IF                                                 
END IF
GOTO Remote

Local.test:

CALL Cartest
Chat$ = INKEY$
IF LEN(Chat$) = 0 THEN GOTO Remote

Local.inp:

IF ASC(Chat$) = 27 THEN GOTO Chat.end
IF ASC(Chat$) = 8 THEN
  PRINT Bk.Arw$;
  IF Fossil% = False% THEN                               
    PRINT #3, BACK.SP$;
   ELSE                                                  
    Fos$ = BACK.SP$                                      
    Call FsPrOut                                        
  END IF                                                 
 ELSE
  PRINT Chat$;
  IF Fossil% = False% THEN                               
    PRINT #3, Chat$;
   ELSE                                                  
    Fos$ = Chat$                                         
    Call FsPrOut                                        
  END IF                                                 
END IF
IF ASC(Chat$) = 13 THEN 
  IF Fossil% = False% THEN                               
    PRINT #3, CHR$(10);
   ELSE                                                  
    Fos$ = CHR$(10)                                      
    Call FsPrOUt                                        
  END IF                                                 
END IF
GOTO Remote

Chat.end:

TIME.OFF = TI! + SAVETIME
WARNING = TIME.OFF - (3 * 60)
EndTime! = TI! + 240
  TXT$ = ""
  call PROUT
  ARG$ = ""
  TXT$ = "Chat mode terminated"
  CALL PROUT
  TXT$ = LINE.SAVE$
  CALL PROUT
RETURN

Indoor:

EC = 0
TIME.OFF = TI! + (NM.TIME * 60)
IF GRP% = 2 THEN GRAPHICS% = 1% ELSE GRAPHICS% = 0
NO.MONITOR = 1
print "Return from Indoor"
RETURN

Snoop:

IF L.ocal% = True% THEN RETURN
IF NOT Snoop THEN
  LOCATE 24, 1, 1
  PRINT "SNOOP ON"
  CALL LINE25
  Snoop = NOT Snoop
 ELSE LOCATE , , 1
  Snoop = FALSE%
  CLS
END IF
RETURN

Forceoff:

TIME.NOW.LEFT = INT((TIME.OFF - TI!)/60)
PRINT "Minutes till user forced off? [";TIME.NOW.LEFT;"] ";
INPUT MIN.F.O$
IF MIN.F.O$ = "" THEN RETURN
FORCE.OFF = VAL(MIN.F.O$)
TXT$ = "YOU MUST BE OFF in" + STR$(FORCE.OFF) + " minutes!"
CALL PROUTCR
TXT$ = "Please complete what you are doing within that time"
CALL PROUTCR
TIME.OFF = TI! + (FORCE.OFF * 60)
WARNING = TIME.OFF - (3 * 60)
IF TIME.SAVE < 5 THEN TIME.SAVE = 5
TXT$=""
CALL PROUTCR
ARG$=""
ZX$=""
RETURN



SUB ANSI.COLOR (FC%, BC%, Blink%, high%, L.ocal%) STATIC

  IF FC% = BC% THEN
    BC% = 0
    IF FC% = 0 THEN FC% = 7
  END IF
  AC$ = CHR$(27) + "[3"

'  set local colors

  LFC% = FC%
  IF high% = 1 THEN LFC% = LFC% + 8
  IF Blink% = 1 THEN LFC% = LFC% + 16
  COLOR C.OLOR(LFC%), C.OLOR(BC%)

' see if running locally too
  IF L.ocal% = True% THEN
    Blink% = 0
    high% = 0
    EXIT SUB
  END IF
  REMOTE.ANSI$ = AC$ + MID$(STR$(FC%), 2, 1) + ";4" + MID$(STR$(BC%), 2, 1)    'USER ROUTINE
  IF Blink% = 1 THEN REMOTE.ANSI$ = REMOTE.ANSI$ + ";5"
  IF high% = 1 THEN REMOTE.ANSI$ = REMOTE.ANSI$ + ";1"
  REMOTE.ANSI$ = REMOTE.ANSI$ + "m"
  IF Fossil% = False% THEN                               
    PRINT #3, REMOTE.ANSI$;
   ELSE                                                 
    Fos$ = REMOTE.ANSI$                                  
    Bytes% = LEN(Fos$)                                   
    CALL FosWrite(Port%, Bytes%, Fos$)                   
  END IF                                                 
  Blink% = 0
  high% = 0
END SUB

SUB LINE25 STATIC                        
  SHARED FIRST$, LAST$, DOOR.NAME$, RD$, ON.AT$         
  COLOR 11, 1                                           
  LOCATE 25, 1,1                                          
  PRINT FIRST$ + " " + LAST$; TAB(34); DOOR.NAME$; TAB(57); "Node: " + RD$; TAB(70); ON.AT$ + "  ";
  COLOR 7, 0
END SUB

SUB NAM.ADJ (NAME$) STATIC
  AX = 0
  FOR LX = 1 TO LEN(NAME$)
    BX = ASC(MID$(NAME$, LX, 1))
    IF AX = 0 AND BX > 96 AND BX < 123 THEN
      MID$(NAME$, LX, 1) = CHR$(BX - 32)
     ELSEIF AX = 1 AND BX > 64 AND BX < 91 THEN
      MID$(NAME$, LX, 1) = CHR$(BX + 32)
    END IF
    AX = 1
    IF BX< 65 OR (BX >90 AND BX< 96) OR BX> 123 THEN AX = 0
  NEXT
END SUB

Function TI!
   TI! = CSNG(FIX((VAL(MID$(TIME$, 1, 2)) * 3600) +_
             (VAL(MID$(TIME$, 4, 2)) * 60) +_
             (VAL(MID$(TIME$, 7, 2)) * 1)))
END Function

SUB LoadPCBUserInfo
BBS.Type$ = "PC-Board"                        
OPEN "R", 1, MESSAGE.FILE$
  FIELD 1, 128 AS Z$
  IF PCB14 <> 0 THEN
    GET 1, 1
    GRP% = 1
    BP$ = MID$(Z$, 19, 5)    'BAUD RATE
    GRP$ =MID$(Z$, 12, 1)
    IF GRP$ = "Y" THEN
      GRP% = 2
    END IF
    PAR = -1
    Snoop = VAL(LEFT$(Z$, 2))
    DOOR.USERS.NAME$= MID$(Z$, 85, 25)
    exit sub
  END IF
  GET 1, 1                      ' PC-Board 12 format
  BP$ = MID$(Z$, 11, 4)         ' BAUD RATE
  GRP% = VAL(MID$(Z$, 57, 2))
  IF GRP% THEN
    GRP% = 2
  END IF
  PAR = -1
  Snoop = VAL(LEFT$(Z$, 2))
  DOOR.USERS.NAME$= MID$(Z$,15,27)
end sub



SUB LoadWildcatUserInfo 
    OPEN MESSAGE.FILE$ FOR INPUT AS #1
    LINE INPUT #1, DOOR.USERS.NAME$
    IF DOOR.USERS.NAME$ = "Sysop" THEN
      DOOR.USERS.NAME$ = "SYSOP"
    END IF
    DOOR.USERS.NAME$ = DOOR.USERS.NAME$ + "   "
    LINE INPUT #1, DUMMY$          ' BAUD CODE
    LINE INPUT #1, DUMMY$          ' CALLING FROM
    LINE INPUT #1, Security.level$ ' SECURITY LEVEL
    LINE INPUT #1, DUMMY$          ' TIME REMAINING
    LINE INPUT #1, DUMMY$
    GRP% = 1
    IF LEFT$(DUMMY$,3) = "COL" THEN GRP%=2
    LINE INPUT #1, DUMMY$          ' PASSWORD
    LINE INPUT #1, DUMMY$          ' USER REC NUM
    LINE INPUT #1, DUMMY$          ' MINUTES ONLINE
    LINE INPUT #1, DUMMY$          ' TIME ENTERED DOOR
    LINE INPUT #1, DUMMY$          ' TIME CALLED
    LINE INPUT #1, DUMMY$          ' CONF JOINED
    LINE INPUT #1, DUMMY$          ' DL FILE TOTL
    LINE INPUT #1, DUMMY$          ' DAILY DL LIMIT
    LINE INPUT #1, DUMMY$          ' DL K TOTL
    LINE INPUT #1, DUMMY$          ' MAX DL LIMIT
    LINE INPUT #1, DUMMY$          ' USER TELEPH #
    LINE INPUT #1, DUMMY$          ' TIME/DATE LAST CALL
    LINE INPUT #1, DUMMY$          ' NOV/EXPERT
    LINE INPUT #1, DUMMY$          ' PROTOCOL
    LINE INPUT #1, DUMMY$          ' LAST NEW FILE SEARCH
    LINE INPUT #1, DUMMY$          ' # SIGNONS
    LINE INPUT #1, DUMMY$          ' LINES/PAGE
    LINE INPUT #1, DUMMY$          ' LAST MSG READ
    LINE INPUT #1, DUMMY$          ' TOTL UPLOAD
    LINE INPUT #1, DUMMY$          ' TOTL DL
    LINE INPUT #1, DUMMY$          ' 7 OR 8 BITS
    PAR = -1
    IF VAL(DUMMY$) = 7 THEN
      GRP% = 1 : PAR = 0
    END IF
    LINE INPUT #1, LOCAL$          ' LOCAL OR REMOTE
    LINE INPUT #1, DUMMY$          ' COM PORT
    LINE INPUT #1, DUMMY$          ' USER BIRTHDATE
    LINE INPUT #1, BP$             ' USER BAUD RATE
    IF LEFT$(LOCAL$,3)= "LOC" THEN BP$=LOCAL$
    Snoop = -1                     'PRESUMABLY ALWAYS ON FOR WILDCAT!

END SUB

SUB LoadRBBSUserInfo 
  OPEN MESSAGE.FILE$ FOR INPUT AS #1
    LINE INPUT #1, DUMMY$          ' RBBS NAME
    LINE INPUT #1, DUMMY$          ' SYSOP FIRST
    LINE INPUT #1, DUMMY$          ' SYSOP LAST
    LINE INPUT #1, CP$          ' COM PORT
    LINE INPUT #1, BP$             ' CONNECT 
   IF CP$="COM0" OR DUMMY$="" THEN BP$="0"
    LINE INPUT #1, DUMMY$          ' NETWORK TYPE
    LINE INPUT #1, CFN.X$          ' CALLER FIRST NAME
    LINE INPUT #1, CLN.X$          ' CALLER LAST NAME
    LINE INPUT #1, DUMMY$          ' CITY STATE
    LINE INPUT #1, GRAFX$          ' GRAPHICS PRFERENCE
    LINE INPUT #1, Security.level$ ' SECURITY LEVEL  
    LINE INPUT #1, DUMMY$          ' TIME REMAINING
    DOOR.USERS.NAME$= CFN.X$ + " " + CLN.X$
    SNOOP = -1                     ' SET ON
    GRP% = 1
    IF VAL(GRAFX$)=2 THEN GRP%=2
    IF VAL(GRAFX$)=1 AND FOR.SURE.RBBS=0 THEN GRP%=2
    PAR = -1
    IF INSTR(BP$,"E")>0 THEN PAR = 0
    BP$ = STR$(VAL(BP$))
    PRINT "RBBS Complete"


end SUB

SUB FSPROUT 
  Bytes% = LEN(Fos$)                                       

FOR xxx% =  1 to bytes%
   foschar% = asc(mid$(Fos$,xxx%,1)) 
FOSSILTx2:
   call fostxcharnw(Port%,foschar%,Result%)
   If Result% = 0 then 
      CALL GIVEBACK
      GOTO FOSSILTx2
   END IF
next xxx%
  Call CarTest                                           
end sub

SUB CarTest 
IF L.ocal% = True% THEN exit sub
IF Fossil% = False% THEN                                  
  IF INP(MSR) >= 128 THEN exit sub
 ELSE                                                    
  CALL FosStatus(Port%, Stat%)                           
  Stat% = Stat% AND &H0080                               
  IF Stat% = &H0080 THEN exit sub                          
END IF                                                   
IF Snoop THEN PRINT "(**CARRIER DROPPED**)"

CLOSE
IF Fossil% = False% THEN            
  OUT MCR, INP(MCR) OR 1
 ELSE                                                    
  CALL FosExit(Port%)                                    
END IF                                                   
call shutdown
end sub

SUB PROUTCR
  lfeed = 1
  call prout
  lfeed = 0
end sub


SUB PROUT 
OUT.PUT:
IF GRAPHICS% = 1 THEN CALL ANSI.COLOR(FC%, BC%, Blink%, high%, L.ocal%)

Out.put1:

IF L.ocal% = True% or Snoop THEN

select case lfeed 
  case 0
      IF Row% <> 0 AND Col% <> 0 THEN
            LOCATE Row%, Col%,1
            PRINT TXT$;
          ELSE
            PRINT TXT$;
         END IF
  case else ' (Carriage return wanted)
      IF Row% <> 0 AND Col% <> 0 THEN
            LOCATE Row%, Col%,1
            PRINT TXT$
          ELSE
            PRINT TXT$
         END IF
end select


end if  ' (L.ocal% = True% or SNOOP)

IF L.ocal% = True% THEN GOTO Chk.line
IF Row% <> 0 AND Col% <> 0 THEN
  Row$ = STR$(Row%) : Row$ = MID$(Row$, 2, LEN(Row$) -1)
  Col$ = STR$(Col%) : Col$ = MID$(Col$, 2, LEN(Col$) -1)
  Cursor$ = CHR$(27)+ "[" + Row$ + ";" + Col$ + "H"
  IF Fossil% = False% THEN                                
    PRINT #3, Cursor$;
    PRINT #3, TXT$;
   ELSE                                                  
    Fos$ = Cursor$                                       
    Call FsPrOut                                        
    Fos$ = TXT$                                           
    Call FsPrOut                                        
  END IF                                                 
 ELSE                                                   
  IF Fossil% = False% THEN                               
    PRINT #3, TXT$;
   ELSE                                                  
    Fos$ = TXT$                                           
    Call FsPrOut                                        
  END IF                                                 
END IF
'
' The following section should only be used if you desire to reset the
' colors back to Color.Normal$ (as defined in the beginning of the
' program) after each screen write.  This usually isn't needed.  
' 
'
'IF GRAPHICS% = 1 THEN 
'  IF Fossil% = False% THEN                               
'    PRINT #3, COLOR.NORMAL$;
'   ELSE                                                  
'    Fos$ = COLOR.NORMAL$                                 
'    Call FsPrOut                                        
'  END IF                                                 
'END IF

IF LFEED = 1 THEN 
  IF Fossil% = False% THEN                               
    PRINT #3, LF$;
   ELSE                                                  
    Fos$ = LF$                                           
    Call FsPrOut                                        
  END IF                                                 
END IF

CALL Cartest
 


Chk.line:

GOSUB Check.time4
GOSUB Check.time3
NORET = 0
row% = 0:col% = 0
EXIT SUB

'Exit.door:
Call Shutdown

END

Call OutOfTime

Check.time4:

WARNING = TIME.OFF - 180
IF TI! > WARNING AND T.IMER = 1 THEN
  IF INT((TIME.OFF - TI!) / 60) < TIME.SAVE THEN
    WARNING = WARNING + 60
    TXT$ = "** YOU HAVE" + STR$(INT((TIME.OFF - TI!) / 60)) + " MINUTES REMAINING!! **"
    IF L.ocal% <> True% THEN 
      IF Fossil% = False% THEN                           
        PRINT #3, CHR$(7)
       ELSE                                              
        Fos$ = CHR$(7)                                   
        Call FsPrOut                                    
      END IF                                             
    END IF
    GOSUB OUT.PUT
    TIME.SAVE = INT((TIME.OFF - TI!) / 60)
    T.IMER = 0
    RETURN
  END IF
END IF
RETURN

Check.time3:

IF TI! > TIME.OFF THEN
  TXT$ = "TIME LIMIT EXCEEDED! +"
  call shutdown
END IF
RETURN

end sub

SUB OutOfTime
   TXT$ = "Time has expired!!!!" : 
  IF Fossil% = False% THEN                                 
    PRINT #3, TXT$ 
   ELSE                                                    
    Fos$ = TXT$                                              
   Call FsPrOut                                          
  END IF                                                   
PRINT TXT$
'Call Delay (2)
Call Shutdown
End Sub

sub Shutdown

' This is used for normal exits as well as fatal door crashes.
' Something could be wrong at this point, (loss of carrier,
' hardrive full, or whatever).
' Many users that only use your board to run the doors,
' hangup immediately after they are finished with the door.
' Many will break connection right as they hit the [Q]uit key.
' This will also cause a problem.
'  Therefore, the object of this subprogram  is to 
'  close files in priority order, and get out quickly.

' If another error occurs anywhere in this process, then
' the error routine will be recursivley called.
' but this time, Error.Flag% will be true, which will
' force the door to end.


' First, attempt to update and/or close all data files related
' to this door.  In a normal door end, this all works very well.
' When I close databases and indices, I force closure.
' If you have datafiles, and have the expertise, you should consider
' opening them in a "writethrough" vice buffered mode.  This could
' save your data as well.






' Lastly, announce to the user that the show's over...
' If he/she doesn't get to this point, that's okay.
' All datafiles have been closed, and the door will gracefully
' return to the bat file from which it was called.


TXT$ = "Returning to the board." 
IF Fossil% = False% THEN                                 
  PRINT #3, TXT$ 
 ELSE                                                    
  Fos$ = TXT$                                              
  Call FsPrOut
END IF

call exitdoor

end sub


SUB InputLine

TXT$ = ""
ARG$ = ""
Escape% = False%
Ansi.Command.Next% = False%
Up% = False%:Down% = False%: Left% = False%:Right% = False%
P.LINE = 0
NOFSX$ = ""
EndTime! = TI! + (VAL(LOG.OFF$) * 60)

InputLineStart:                                   ' Idle user check
IF TI! > EndTime! AND L.ocal% <> True% THEN
  TXT$="NO INPUT IN "+LOG.OFF$+" MINUTES! YOU'RE LOGGED OFF!"
  CALL PROUTCR
  CALL OutOfTime
END IF
CALL Cartest
TXT$ = INKEY$

'Always check for Sysop Console Input First, if none found, then
' check comport for user input
IF TXT$ = "" THEN 
   IF L.ocal% <> True% THEN 
     IF Fossil% = False% THEN                               
          IF NOT (EOF(3)) THEN                                 
            TXT$ = INPUT$(1, 3)
          END IF                                               
       ELSE                                                  
         CALL FosReadAhead(Port%, Char%)                      
         IF Char% <> -1 THEN                                   
            CALL FosRXChar(Port%, Char%)                       
            TXT$ = CHR$(Char%)                                   
         END IF   ' (IF CHAR% = -1) 
      END IF 'IF Fossil% = False%                                     
   END IF 'IF L.ocal% = True%
END IF ' IF TXT$ = ""
' 

' Check to see if this is a single character call

' First Check for Cursor Keys

If SingleChar% AND Txt$ = ESC$ then
   Escape% = True%
   goto InputLineStart
End if

If Escape% and Txt$ = Ansi.Command$ then
   Ansi.Command.Next% = True%
   Goto InputLineStart 
End if

If Ansi.Command.Next% then

select case Txt$

    case Chr$(68)
      Left% = True% 
      Exit Sub
    case CHR$(67)
       Right% = True%
       Exit Sub
    case CHR$(65)
       Up% = True%
       Exit Sub 
    case CHR$(66)
       Down% = True%
       Exit Sub 
    ' If you wanted too, this would be the place to trap other
    ' ANSI Commands
    case else
end select
end if ' (Ansi.Command.Next%)

if SingleChar% = True% AND Txt$ <> "" Then
   SingleChar% = False%
   Arg$ = Txt$
   Exit Sub
End if                                           



'Check to see if user enter a carriage return
IF TXT$ = CR$ THEN
  Arg$ = Txt$
  EXIT SUB
END IF






' list all of your special keys such as backspace and 
' tab prior in this area
IF TXT$ = CHR$(8) OR TXT$ = CHR$(7) THEN GOTO SpecialKeys

' Once you have indicated all the special keys that you want
' to flag then this line rejects all others.
' if you are having line noise problems with the door and
' your door will not be used by users with the international
' character set, then change the following line  to

'IF TXT$ < CHR$(32) or TXT$ > (128) THEN GOTO InputLineStart 

 IF TXT$ < CHR$(32) THEN GOTO InputLineStart

IF L.ocal% = True% OR  Snoop THEN
   PRINT TXT$;
end if

IF L.ocal% <>  True% THEN
   IF Fossil% = False% THEN                                 
       PRINT #3, TXT$;                                         
    ELSE                                                    
       Fos$ = TXT$                                              
       Call FsPrOut                                          
    END IF
end if 

CALL Cartest
GOTO InputLineStart

SpecialKeys:                                       ' Backspace

IF LEN(ARG$) = 0 THEN GOTO InputLineStart
ARG$ = LEFT$(ARG$, LEN(ARG$) - 1)
PRINT Bk.Arw$;
IF L.ocal% = True% THEN GOTO InputLineStart
IF Fossil% = False% THEN                                 
  PRINT #3, BACK.SP$;
 ELSE                                                    
  Fos$ = BACK.SP$                                        
  Call FsPrOut                                          
END IF                                                   
GOTO InputLineStart

NORET = 0
EXIT SUB


END SUB '(InputLine)


SUB ExitDoor

call clrScreen 
row% = 3:col% =22 :TXT$ = "Ŀ":call proutcr
row% = 4:col% =22 :TXT$ = "                                   ":call proutcr
row% = 5:col% =22 :TXT$ = "     This has been a TechnoWare    ":call proutcr
row% = 6:col% =22 :TXT$ = "     Demonstration of MakeDoor     ":call proutcr
row% = 7:col% =22 :TXT$ = "                                   ":call proutcr
row% = 8:col% =22 :TXT$ = "                                   ":call proutcr
row% = 9:col% =22 :TXT$ = "     For the latest version of     ":call proutcr
row% =10:col% =22 :TXT$ = "      MakeDoor, please call:       ":call proutcr
row% =11:col% =22 :TXT$ = "                                   ":call proutcr
row% =12:col% =22 :TXT$ = "     Technopeasants' East BBS      ":call proutcr
row% =13:col% =22 :TXT$ = "  (301)-927-4258 (PC Pursuitable)  ":call proutcr
row% =14:col% =22 :TXT$ = "":call proutcr
'call delay(2)
row% = 22:col% = 1:TXT$ = "Returning to "+RBBS.NAME$
CALL PROUTCR
CLOSE
END

END SUB '(ExitDoor)

SUB InputChar
SingleChar% = True%
Call InputLine
END SUB

SUB InputField(Field$)
TabKey% = FALSE%
BACKTAB% = FALSE%
homerow% = csrlin
homecol% = pos(0)
'row% = homerow%:col% = homecol%
LengthField% = Len(field$)

for x% = 1 to LengthField%

  BeginFieldInput:
  Call InputChar
   
 ' NEXT Yy%

  ' *** LEFT CURSOR KEY INPUT  (OR BACKSPACE KEY)
  ' after InputChar gets a keystroke, it advances
  ' the cursor one, so to move back one character
  ' we have to substract two from current cursor position
  ' The Next x% at the bottom will advance the character 
  ' pointer so we also need to subtract two from it
  '  Left% IS check for remote cursor, while the rest is check for
  '                                    local cursor key
  if Left% OR (arg$ = BACKSPACE$ OR (len(arg$) > 1 and Mid$(arg$,2,1) = "K"))  then
     if x% > 1 then
       'move the character pointer in the string
       x% = x% - 2
       ' reposition the cursor
       ' move it on the local screen
       col% = col% - 2
       goto positioncursor
      end if
   end if


  '  *** RIGHT CURSOR INPUT
  ' after InputChar gets a keystroke, it advances
  ' the cursor one, so for a right cursor, we shouldn't
  ' have to do anything
  ' Check for Right Cursor Key
  
   
  if Right% OR (len(arg$) > 1 and Mid$(arg$,2,1) = "M")  then
     if x% < LengthField% then
        goto positioncursor    
     end if
  end if
  ' *** TAB 

  if Down% = TRUE% or arg$ = TABKEY$ THEN
      TabKey% = TRUE%
      x% = lengthfield% + 1
      goto LoopField
  end if
  ' *** BACKTAB
      if UP% = TRUE% or (len(arg$) > 1 and asc(mid$(arg$,2,1)) = 15)  then
        BACKTAB% = TRUE%
      x% = lengthfield% + 1
      goto LoopField
  end if
  ' *** CARRIAGE RETURN
   if arg$ = cr$ then
      x% = lengthfield% + 1
      goto LoopField
   end if
   ' NOW REJECT ALL OTHER ASCII CODES NOT WANTED PRIOR TO 
   ' SCREEN DISPLAY
   if len(ARG$) > 1 then goto BEGINFIELDINPUT
   if asc(arg$) < 32 then goto BEGINFIELDINPUT

  ' print the field again after each loop
    mid$(Field$,x%,1)  = arg$: row% = homerow%:col% = homecol% + (x%-1)
    txt$ = Mid$(Field$,x%,1):call prout
    positioncursor:
    row% = homerow%:col% = homecol%+ (x%-1)
    'locate row%,col%,1
    call MoveCursor(row%,Col%+1)
  LoopField:
Next x%

END SUB

sub MoveCursor(r%,c%)
  row% = r%:col% = c%:txt$="":call prout
end sub

Sub ClrScreen              
Filename$ = "Clear Screen"
Clear$ = CHR$(27) + "[2J"         
 CALL  CARTEST                    
IF L.ocal% <> True% THEN                  
  IF Fossil% = False% THEN        
    PRINT #3, Clear$              
   ELSE                           
    Fos$ = Clear$                 
    Call FsPrOut                 
  END IF                          
END IF
IF L.ocal% = True% OR SNOOP THEN       
  CLS 
  CALL LINE25                     
END IF                            
end sub

