'Set up window and print intro screen.
SCREEN #1 TEXT
WINDOW CURSOR ON
WINDOW FULL
WINDOW TITLE "The Locomotive BASIC 2 Tutorial, Version 1
PRINT "                              By Matt Roberts
PRINT "                              3 Cedar St., #8
PRINT "                         Montpelier, Vt 05602-3006
PRINT "                               (802)223-2553
PRINT
PRINT
PRINT "If you find the programs on this disk useful, a donation of $5.00 would
PRINT "be greatly appreciated.  Thanks.
PRINT
PRINT
PRINT "If you're having trouble using this program, you can call between 9AM
PRINT "and 9PM EST, and I'll try to help.
PRINT
PRINT
PRINT
PRINT
GOSUB continue
'
'Window is now set up.
'
'
'
'Now direct BASIC 2 to create a menu of options.
LABEL menu
CLS
WINDOW TITLE "Your Options:
PRINT "F1- Introduction
PRINT
PRINT "F2- Lesson 1
PRINT
PRINT "F3- Lesson 2"
PRINT
PRINT "Esc- Quit
PRINT
PRINT
PRINT "Please press the key corresponding to your choice. ";
LABEL wait2
a=INKEY
IF a=-1 GOTO wait2
IF a=315 GOTO intro
IF a=316 GOTO lesson1
IF a=317 GOTO lesson2
IF a=27 GOTO finished
GOTO wait2
'
'
'INTRODUCTION
'
'
LABEL intro
CLS
WINDOW TITLE "Introduction
PRINT "Welcome to Version 1 of the Locomotive BASIC 2 Tutor.  The idea behind
PRINT "this tutorial is not to make you an expert in BASIC 2 programming (I'm
PRINT "not all that great myself), but to give you a general overview of how
PRINT "this version of BASIC works.
PRINT
PRINT
GOSUB continue
CLS
PRINT "I'll be talking about commands, functions, and operators in BASIC 2 (also
PRINT "known as `keywords') throughout this tutorial.  These keywords will usually
PRINT "be set off by the single-quote symbols, like this:
PRINT
PRINT "`REM'"
PRINT
PRINT "When you use those keywords in a BASIC 2 program of your own, don't
PRINT "type the quotes.  Otherwise, you'll get a `Syntax Error' as a response.
PRINT
PRINT "While we're on the subject, `Syntax Error' is just BASIC 2's way of saying
PRINT "`I don't understand.'  If it doesn't understand what you want it to do,
PRINT "it will give up.
PRINT
PRINT
GOSUB continue
CLS
PRINT "Another thing you should know is that I probably won't be taking a lot
PRINT "to tell you how get around in BASIC 2's environment.  Instead, I'll be
PRINT "focusing primarily on programming techniques.  When you've finished with
PRINT "this tutorial, you should be able to write simple programs.  Your Amstrad
PRINT "manual should be able to guide you through the use of menus and such
PRINT "in the BASIC 2 environment.
PRINT
PRINT
GOSUB continue
CLS
PRINT "Although this program has a `Quit' feature in the menu, you may find
PRINT "that you want to leave a lesson before it's finished.  To quit in the
PRINT "middle of a lesson (Tsk), move the mouse up to the `Program' option in
PRINT "the menu bar at the top of the screen.  Choose `Stop', and the program
PRINT "will end.
PRINT
PRINT
GOSUB continue
GOTO menu
'
'
'LESSON 1
'
'
LABEL lesson1
CLS
WINDOW TITLE "Lesson 1
PRINT "In this lesson, we'll start using simple commands and work our way up.
PRINT "You may see the same commands repeated in later lessons, but they'll
PRINT "be used in more complex ways.
PRINT
PRINT
GOSUB continue
CLS
WINDOW TITLE "REM
PRINT "Let's start with what is probably the simplest of commands, REM.  It's
PRINT "one of the few commands which can't possibly damage your program, for
PRINT "the simple reason that it doesn't do anything.  REM is short for REMARK,
PRINT "and has the single purpose of allowing you to insert any comments you
PRINT "might care to make.  It has no effect on your program, and any commands
PRINT "which follow the REM command on the same line are ignored.  This can
PRINT "have major uses if you want to temporarily make a line non-functional
PRINT "without rewriting or deleting.  Just stick REM in front of the command
PRINT "you don't want executed, and it will be ignored.
GOSUB continue
CLS
PRINT "So, you could have a line in your program that reads:
PRINT
PRINT "REM Now is the time for all good men to come to the aid of your party.
PRINT
PRINT "If you want an example that might make a bit more sense, here's one:
PRINT
PRINT "REM Here are the subroutines for file management.
PRINT
PRINT "If you want an example that might make a bit less sense, here's one:
PRINT
PRINT "REM 2W0P[3WE0-89IO45R 'ASF4T5-FANTw924]
PRINT
PRINT "REM can be abbreviated by using a ' symbol, like so:
PRINT
PRINT "' Now is the time for all good men to party.
GOSUB continue
CLS
WINDOW TITLE "Controlling Screen Appearance
PRINT "If you're not going to be drawing graphics on your main screen, and you'll
PRINT "be asking for user input, you'll want a good looking cursor.  This lets
PRINT "the user to see where the next character he or she inputs will be typed,
PRINT "and I've personally found it easier to type input when I know where it
PRINT "will appear.  I don't know why exactly, I just know I'm more comfortable
PRINT "with a cursor.
PRINT
PRINT
GOSUB continue
CLS
PRINT "To create a cursor which looks like the one in this program, you'll use
PRINT "the following commands:
PRINT
PRINT "`SCREEN #1 TEXT'
PRINT
PRINT "followed by
PRINT
PRINT "`WINDOW CURSOR ON'
PRINT
PRINT
PRINT "This will, in my opinion, give a somewhat more professional appearance
PRINT "to your programs.
PRINT
PRINT
GOSUB continue
CLS
PRINT "While you've got the Results-1 window in text mode, you can't use graphics.
PRINT "To restore graphics capabilities to your Results-1 window, use the command
PRINT
PRINT "`SCREEN #1 GRAPHICS'"
PRINT
PRINT "If you want to lose the cursor, type `WINDOW CURSOR OFF'
PRINT
PRINT
GOSUB continue
CLS
PRINT "Another neat trick, which makes your programs look a bit nicer, is to
PRINT "make your Results-1 window full sized, like this one.  The command is
PRINT "quite simple:
PRINT
PRINT "`WINDOW FULL'
PRINT
PRINT "This works fine for the Results-1 window; to get a full-sized screen
PRINT "in the Results-2 window, you'll just add `#2' to your program line, like
PRINT "so:
PRINT
PRINT "`WINDOW #2 FULL'
PRINT
PRINT "How to get the Results-2 screen to come up using BASIC 2 commands will
PRINT "be covered later.
PRINT
PRINT
GOSUB continue
CLS
WINDOW TITLE "WINDOW TITLE
PRINT "Another way to get an attractive looking screen is through the use of
PRINT "the command `WINDOW TITLE'.  It puts a title at the top of the Results-1
PRINT "or -2 screen, giving your programs a more polished appearance, especially
PRINT "in the case of menus.  The window title right now is, of course, `WINDOW
PRINT "TITLE'; it helps give you an idea about the topic we're covering, and
PRINT "almost makes it look like I know what I'm doing."
PRINT
PRINT "To get your program to put up a window title with the message of your
PRINT "choice, type `WINDOW TITLE ";CHR$(34); "the message of your choice.";CHR$(34);"'"
PRINT
PRINT "While the message you choose, of course, is up to you, it has to be led
PRINT "off with at least one quotation mark.  The end quote is optional.
PRINT
PRINT
GOSUB continue
CLS
WINDOW TITLE "PRINT
PRINT "Printing stuff on the screen is fairly simple; you just use the PRINT
PRINT "command.  If you want to print text, the command is:
PRINT
PRINT "PRINT ";CHR$(34);"The text of your choice.";CHR$(34)
PRINT
PRINT "While the first quotation mark has to lead off your text, the second
PRINT "quote is optional, unless you're using multiple lines (discussed later).
PRINT
PRINT "Printing numbers and the results of numeric calcualtions is a bit different.
PRINT "When printing a number, avoid the quotes; if you use quotes, BASIC 2
PRINT "will think you are printing text, and won't allow you to perform calcula-"
PRINT "tions on the number.
GOSUB continue
CLS
PRINT "So, to print the number 2, you would type:
PRINT
PRINT "`PRINT 2'
PRINT
PRINT "You can also do calculations.  If you wanted to add 2 and 2, for example,
PRINT "You would type:
PRINT
PRINT "`PRINT 2+2'
PRINT
PRINT "BASIC 2 would then print the number 4 on your screen.  You can use this
PRINT "method for any type of calculation.
PRINT
PRINT "You can also print numeric and string variables, but such things should
PRINT "probably be saved for a later lesson.
GOSUB continue
GOTO menu


'LESSON 2

LABEL lesson2
CLS
WINDOW TITLE "GOSUB"
PRINT "If you're typing in a routine that you'll be using over and over, you"
PRINT "can probably just type it once, by using the command GOSUB.  This allows"
PRINT "you to use the procedure as a module that BASIC 2 can refer to whenever"
PRINT "the need arises.  The module will have a label, which puts us slightly"
PRINT "ahead of ourselves, but here's the subroutine for pressing any key when"
PRINT "ready, which I call ";CHR$(34);"CONTINUE";CHR$(34);":"
PRINT
PRINT
PRINT "LABEL continue
PRINT "PRINT
PRINT "PRINT
PRINT "PRINT ";CHR$(34);"Press any key to continue. ";CHR$(34);";"
PRINT "LABEL wait"
PRINT "a$=INKEY$
PRINT "if a$=";CHR$(34);CHR$(34);" GOTO wait"
PRINT "RETURN"
GOSUB continue
CLS
PRINT "This subroutine is called by the command ";CHR$(34);"GOSUB continue";CHR$(34);"."
PRINT "The command RETURN instructs the subroutine to return to the line directly"
PRINT "following the GOSUB command that called it.  As a result, you can call"
PRINT "this subroutine from anywhere in the program you like."
PRINT
PRINT "Every GOSUB command must be matched with a RETURN command at the end"
PRINT "of the subroutine, or you'll get an error message."
GOSUB continue
CLS
WINDOW TITLE "LABEL"
PRINT "In the preceding routine, you may have noticed the line LABEL continue."
PRINT "You'll need this if you're not using line numbers, and want to use a GOTO"
PRINT "or GOSUB command.  Once you've labelled a spot in your program, you can
PRINT "refer to it at any time, with a GOTO label or, in the case of subroutines,"
PRINT "GOSUB label."
PRINT
PRINT "Here, label refers to the label you've given the location.  LABEL itself is"
PRINT "a BASIC 2 keyword, so you don't want to actually type GOTO LABEL, but
PRINT "rather (for instance) GOTO continue, where continue is the label you've
PRINT "given your program location."
PRINT
PRINT "The command is also useful with the ON ERROR GOTO command, and its partner,"
PRINT "RESUME.  These will be covered in a later lesson."
GOSUB continue
CLS
WINDOW TITLE "Multiple Lines"
PRINT "You can use the colon to separate your program lines.  The advantages"
PRINT "are that less memory is required to run the program when this method"
PRINT "is used, and that the program tends to run a little faster.  The dis-"
PRINT "advantage is that the program is hard to read."
PRINT
PRINT "Because BASIC 2 doesn't have block IF-THEN statements, the colon is"
PRINT "sometimes necessary.  When the condition set by IF is met, all commands"
PRINT "which are on the same line (including those separated by colons) are"
PRINT "carried out.  However, this can cause problems, since those same commands"
PRINT "are not carried out if the condition is not met.  You can, of course,"
PRINT "defeat this by using ELSE.  This gets a little complicated, and should"
PRINT "probably be treated in a later lesson."
GOSUB continue
GOTO menu

LABEL finished
CLS
PRINT "Do you also want to leave BASIC 2? (y/n) ";
LABEL wait3
a$=INKEY$
IF a$="" THEN GOTO wait3
IF a$="y" THEN GOTO quitbasc
IF a$="Y" THEN GOTO quitbasc
IF a$="n" THEN GOTO stayhere
IF a$="N" THEN GOTO stayhere
GOTO wait3
LABEL stayhere
PRINT a$
WINDOW TITLE "Results-1
WINDOW FULL OFF
WINDOW CURSOR OFF
SCREEN #1 GRAPHICS
CLS
END

LABEL quitbasc
PRINT a$
QUIT

LABEL continue
PRINT
PRINT
PRINT "Press any key to continue. ";
LABEL wait
a$=INKEY$
IF a$="" THEN GOTO wait
RETURN
