;*******************************************************************************
;* Assembly Subroutines For DECGIF3.BAS 
;* By Rich Geldreich 1992
;* Assembled with TASM v2.00
;*
;* Routine for rescaling an integer array containing a scan line.
;* Simple pixel slashing- no bells or whistles.
;* 
;*
.286
Ideal
Model Small
Public Rescale
CodeSeg
Even
Proc    Rescale ;A() B() NumPoints NewScale
                ;12  10      8        6
        Push    bp                              ;Get stack frame. 
        Mov     bp, sp                          
        Push    es ds si di                     ;Save important regs.
                
        Mov     bx, [ss:bp+10]                  ;Get location of destination
        Mov     di, [ds:bx+0Ah]                 ;array.
        Mov     es, [ds:bx+02h]
        
        Mov     bx, [ss:bp+12]                  ;Get location of source array.
        Mov     si, [ds:bx+0Ah]
        Mov     ds, [ds:bx+02h]

        Mov     dx, [ss:bp+06]                  ;Get new scale.
        Mov     bp, [ss:bp+08]                  ;Get number of pixels to sling.
        Shl     bp, 1                           ;* 2 for words.
        Add     bp, si                          ;BP has end address now.
        
        Mov     bl, dh                          ;bx have high step.
        Xor     dh, dh                          ;dl has low step
        Mov     bh, dh                          ;Clear bh too.
        
        Even                                    ;Faster to jump to an even address.
@@10:
        Mov     al, [ds:si]                     ;Get a pixel.
        Stosb                                   ;Sling it.
        Inc     di
        
        Add     dh, dl                          ;Add up remainder.
        Mov     cx, si                          ;For checking is si changes.
        Adc     si, bx                          ;Add carry and high step to source.
        Cmp     si, cx                          ;Did it change?
        Je      @@20                            
        Sub     cx, si                          ;See how much.
        Neg     cx                              ;It's gotta be negative.
        Add     si, cx                          ;Add it for words.
@@20:        
        Cmp     si, bp                          ;All pixels slung?
        Jnae    @@10                            ;Nope.
 
        Pop     di si ds es bp                  ;Pop regs and return.
        Retf    8
Endp    Rescale                                 
End
        
