DEFDBL A-Z
CONST FALSE = (0 = 1)
CONST TRUE = (1 = 1)
CONST PI = 3.141592653589#
CONST Rad2Deg = 180 / PI
DEF fnMargin (x) = x * 1.000001
CONST Video = TRUE

Init:
  PRINT "CHAIN generator for POVRay 1.0  by K. Koehler  v1.1"
  PRINT
  ' 08-10-92 KJK New program (@ Inlaws between houses)
  ' 08-26-92 KJK Minor tweeks: Build chain top-down.
		 Now builds circular chain.

  INPUT "Link Inside Diameter     :", LinkID
  INPUT "Metal Radius             :", MetalRadius
  Structure$ = ""
  WHILE Structure$ = ""
    INPUT "Structure (Straight/Arc) :", Structure$
    Structure$ = LEFT$(UCASE$(Structure$), 1)
    IF Structure$ <> "S" AND Structure$ <> "A" THEN Structure$ = ""
  WEND
  IF Structure$ = "S" THEN INPUT "Number of Links          :", Links
  IF Structure$ = "A" THEN
    ArcMethod$ = ""
    WHILE ArcMethod$ = ""
      INPUT "Arc Method (Links/Radius):", ArcMethod$
      ArcMethod$ = LEFT$(UCASE$(ArcMethod$), 1)
      IF ArcMethod$ <> "L" AND ArcMethod$ <> "R" THEN ArcMethod$ = ""
    WEND
    IF ArcMethod$ = "R" THEN INPUT "Arc Radius               :", ArcRadius
    IF ArcMethod$ = "L" THEN INPUT "Number of Links/360 deg. :", Links
  END IF
  LinkUnit = 1
  LinkHieght = LinkUnit / 2 + MetalRadius
  LinkWidth = LinkID + MetalRadius
  LoopOrigin = LinkHieght - LinkWidth
  a9 = -2 * (LinkWidth ^ 2 + MetalRadius ^ 2)	' torus stuff
  a25 = 2 * (LinkWidth ^ 2 - MetalRadius ^ 2)	' torus stuff
  a34 = (LinkWidth ^ 2 - MetalRadius ^ 2) ^ 2	' torus stuff
  if Structure$="S" then
    Distance= -1.2 * LinkUnit * Links
  endif
  IF Structure$ = "A" THEN
    IF ArcMethod$ = "R" THEN
      ArcIncrement = ATN((LinkUnit / 2) / SQR(((LinkUnit / 2) ^ 2) + (ArcRadius ^ 2))) * Rad2Deg * 2
      Links=360/ArcIncrement
    END IF
    IF ArcMethod$ = "L" THEN
      ArcIncrement = 360 / Links
      ArcRadius = (LinkUnit / 2) / TAN((ArcIncrement / 2) / Rad2Deg)
    END IF
    ArcBoundIn = ArcRadius
    ArcBoundOut = SQR(((LinkUnit / 2) ^ 2) + (ArcRadius ^ 2))
    Distance= -2.8 * ArcBoundOut
  END IF
  MaxX = LinkWidth + MetalRadius
  MaxY = LinkHieght + MetalRadius
  MaxZ = MetalRadius
  MaxXYZ = MaxX
  IF MaxY > MaxXYZ THEN MaxXYZ = MaxY
  IF MaxZ > MaxXYZ THEN MaxXYZ = MaxZ
  IF Video THEN SCREEN 1: COLOR 7
  wy = MaxXYZ * 1.1			  ' allow % extra screen space
  wx = wy * 1.5 			  ' adjust aspect ratio
  IF Video THEN WINDOW (-wx, -wy)-(wx, wy)

BuildExample:
  OPEN "chain.pov" FOR OUTPUT AS #1
  GOSUB DatTop
  GOSUB DatBottom
  CLOSE #1

BuildObject:
  OPEN "chain.inc" FOR OUTPUT AS #1
  PRINT #1, ""
  PRINT #1, "#declare ChainTex0  = texture { Shiny  colour Red  }"
  PRINT #1, "#declare ChainTex1  = texture { Shiny  colour Blue }"
  PRINT #1, ""
  PRINT #1, "#declare Torus ="
  PRINT #1, "   quartic {"
  PRINT #1, "      <1.0 0.0 0.0 0.0 2.0 0.0 0.0 2.0 0.0 "
  PRINT #1, "      "; a9; " 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0"
  PRINT #1, "       0.0 0.0 1.0 0.0 0.0 2.0 0.0 "; a25; " 0.0"
  PRINT #1, "       0.0 0.0 0.0 1.0 0.0 "; a9; "0.0"; a34; ">"
  PRINT #1, "    } // end_quartic"
  PRINT #1, ""
  PRINT #1, "#declare Link ="
  PRINT #1, "  object {"
  PRINT #1, "  union {"
  PRINT #1, "       // LinkID ="; LinkID; " MetalRadius ="; MetalRadius; " Links ="; Links
  PRINT #1, "    intersection {"
  PRINT #1, USING "      box { <###.#### ###.#### ###.####> "; -(LinkWidth + MetalRadius); -LoopOrigin; -MetalRadius;
  PRINT #1, USING "<###.#### ###.#### ###.####> }"; -(LinkWidth - MetalRadius); LoopOrigin; MetalRadius
  PRINT #1, "      quadric { Cylinder_Y ";
  PRINT #1, USING "scale <###.#### 1 ###.####>  "; MetalRadius; MetalRadius;
  PRINT #1, USING "translate <###.#### 0 0> }"; -LinkWidth
  PRINT #1, "    }"
  IF Video THEN
    LINE (-(LinkWidth + MetalRadius), -LoopOrigin)-(-(LinkWidth + MetalRadius), LoopOrigin), 4
    LINE (-(LinkWidth - MetalRadius), -LoopOrigin)-(-(LinkWidth - MetalRadius), LoopOrigin), 1
  END IF
  PRINT #1, "    intersection {"
  PRINT #1, USING "      box { <###.#### ###.#### ###.####> "; (LinkWidth - MetalRadius); -LoopOrigin; -MetalRadius;
  PRINT #1, USING "<###.#### ###.#### ###.####> }"; (LinkWidth + MetalRadius); LoopOrigin; MetalRadius
  PRINT #1, "      quadric { Cylinder_Y ";
  PRINT #1, USING "scale <###.#### 1 ###.####>  "; MetalRadius; MetalRadius;
  PRINT #1, USING "translate <###.#### 0 0> }"; LinkWidth
  PRINT #1, "    }"
  IF Video THEN
    LINE ((LinkWidth - MetalRadius), -LoopOrigin)-((LinkWidth - MetalRadius), LoopOrigin), 1
    LINE ((LinkWidth + MetalRadius), -LoopOrigin)-((LinkWidth + MetalRadius), LoopOrigin), 4
  END IF
  PRINT #1, "    intersection {"
  PRINT #1, "      plane { <0 -1 0> 0 }"
  PRINT #1, "      quartic { Torus rotate <90 0 0> }"
  PRINT #1, USING "      translate <0 ###.#### 0>"; LoopOrigin
  PRINT #1, "    }"
  IF Video THEN
    CIRCLE (0, LoopOrigin), LinkWidth + MetalRadius, 4, 0, PI
    CIRCLE (0, LoopOrigin), LinkWidth - MetalRadius, 1, 0, PI
  END IF
  PRINT #1, "    intersection {"
  PRINT #1, "      plane { <0  1 0> 0 }"
  PRINT #1, "      quartic { Torus rotate <90 0 0> }"
  PRINT #1, USING "      translate <0 ###.#### 0>"; -LoopOrigin
  PRINT #1, "    }"
  IF Video THEN
    CIRCLE (0, -LoopOrigin), LinkWidth + MetalRadius, 4, PI, 2 * PI
    CIRCLE (0, -LoopOrigin), LinkWidth - MetalRadius, 1, PI, 2 * PI
  END IF
  PRINT #1, "  } // end_union"
  PRINT #1, "  texture { ChainTex0 }"
  PRINT #1, "  bounded_by {"
  PRINT #1, USING "    box { <###.#### ###.#### ###.####> "; -MaxX; -MaxY; -MaxZ;
  PRINT #1, USING "<###.#### ###.#### ###.####> } "; MaxX; MaxY; MaxZ
  PRINT #1, "    } // end_bound"
  PRINT #1, "  } // end_object"
  IF Links > 1 THEN
    IF Structure$ = "S" THEN GOSUB BuildChainStraight
  '  IF Structure$ = "A" AND ArcMethod$ = "R" THEN GOSUB BuildChainLoopRadial
    IF Structure$ = "A" AND ArcMethod$ = "R" THEN GOSUB BuildChainLoopLink
    IF Structure$ = "A" AND ArcMethod$ = "L" THEN GOSUB BuildChainLoopLink
  END IF
  CLOSE #1
  IF Video THEN WHILE INKEY$ = "": WEND
END

BuildChainStraight:
  toggle% = FALSE
  Range = (LinkUnit * (Links - 1) / 2)
  PRINT #1,
  PRINT #1, "#declare Chain ="
  PRINT #1, "  composite {"
  PRINT #1, "       // Center of link at chain ends = <0 +/-"; Range; " 0>"
  FOR k = Range TO -Range STEP LinkUnit
    PRINT #1, USING "    object { Link  translate <0 #####.#### 0>  "; k;
    IF toggle% THEN
      PRINT #1, "rotate <0 90 0>  ";
    ELSE
      PRINT #1, "texture { ChainTex1 } ";
    END IF
    toggle% = NOT toggle%
    PRINT #1, "}"
  NEXT k
  PRINT #1, "    bounded_by {"
  PRINT #1, USING "      box { <###.#### ###.#### ###.####> "; -MaxX; -MaxY - Range; -MaxX;
  PRINT #1, USING "<###.#### ###.#### ###.####> } "; MaxX; MaxY + Range; MaxX
  PRINT #1, "    } // end_bound"
  PRINT #1, "  } // end_composite"
  RETURN

BuildChainLoopLink:
  toggle% = FALSE
  PRINT #1,
  PRINT #1, "#declare Chain ="
  PRINT #1, "  composite {"
  print #1,	 "       // ArcRadius=";ArcRadius;"  Links=";Links
  FOR k = 0 TO Links-1
    PRINT #1, "    object { Link ";
    IF toggle% THEN PRINT #1, "rotate <0 90 0> ";
    PRINT #1, "translate <"; ArcRadius; "0 0> ";
    PRINT #1, "rotate <0 0 "; ArcIncrement * k; "> ";
    IF NOT toggle% THEN PRINT #1, "texture { ChainTex1 } ";
    toggle% = NOT toggle%
    PRINT #1, "}"
  NEXT k
  PRINT #1, "    bounded_by {"
  PRINT #1, "      intersection {"
  PRINT #1, "        quadric { Cylinder_Z  scale <"; ArcBoundOut+MaxY; ArcBoundOut+MaxY; "1> }"
  PRINT #1, "        quadric { Cylinder_Z  scale <"; ArcBoundIn-MaxY; ArcBoundIn-MaxY; "1> inverse }"
  PRINT #1, "        box { <"; -(ArcBoundIn + MaxY); -(ArcBoundIn + MaxY); -MaxY; "> ";
  PRINT #1, "<"; (ArcBoundIn + MaxY); (ArcBoundIn + MaxY); MaxY; "> }"
  PRINT #1, "      }"
  PRINT #1, "    }"
  PRINT #1, "  }"
  RETURN

DspFile:
  PRINT #1, ""
  PRINT #1, "camera {"
  PRINT #1, "   location  <0.0 0.0 "; Distance; ">"
  PRINT #1, "   direction <0.0 0.0 1.0>"
  PRINT #1, "   up  <0.0  1.0  0.0>"
  PRINT #1, "   right <1.33333 0.0 0.0>"
  PRINT #1, "   look_at <0.0 0.0 0.0>"
  PRINT #1, "}"
  PRINT #1, ""
  PRINT #1, "/* put down the beloved famous raytrace green/yellow checkered floor */"
  PRINT #1, "object {"
  PRINT #1, "   plane { <0.0 1.0 0.0>"; -(LinkUnit * (Links + 1) / 2); "}"
  PRINT #1, "   texture {"
  PRINT #1, "      checker colour Yellow colour Green"
  PRINT #1, "      scale <"; MaxXYZ / 3 * Links; " "; MaxXYZ / 3 * Links; " "; MaxXYZ / 3 * Links; ">"
  PRINT #1, "      ambient 0.3"
  PRINT #1, "      diffuse 0.7"
  PRINT #1, "   }"
  PRINT #1, "}"
  PRINT #1, ""
  IF Links = 1 THEN
    PRINT #1, "object {"
    PRINT #1, "    Link"
    PRINT #1, "}"
  ELSE
    PRINT #1, "composite {"
    PRINT #1, "    Chain
    print #1, "//  rotate <0 30 0>"
    PRINT #1, "}"
  END IF
  PRINT #1, ""
  PRINT #1, "object { light_source { ";
  PRINT #1, "<"; 10 * MaxXYZ; " "; 12 * MaxXYZ; " "; -13 * MaxXYZ; ">";
  PRINT #1, " colour White } }"
RETURN

DatTop:
  PRINT #1, "// Persistence of Vision Raytracer"
  PRINT #1, "#include "; CHR$(34); "shapes.inc"; CHR$(34)
  PRINT #1, "#include "; CHR$(34); "colors.inc"; CHR$(34)
  PRINT #1, "#include "; CHR$(34); "textures.inc"; CHR$(34)
  PRINT #1, ""
  PRINT #1, "//----------------------- Definitions start here -----------------------"
RETURN

DatBottom:
  PRINT #1, ""
  PRINT #1, "#include "; CHR$(34); "chain.inc"; CHR$(34)
  PRINT #1, ""
  PRINT #1, "//----------------------- Display starts here --------------------------"
  PRINT #1, ""
  GOSUB DspFile
RETURN

