'       3-D GRAPH II  Version 1.0a By Kevin Patterson
'       Filename 3DGRAFII.BAS (.ZIP)  in QuickBasic Format
  
'       3-D Graph II is a QuickBasic (QBASIC compatible) graphing program
'       used to generate 3-dimensional graphs or funtion plots.  All of
'       the standard mathematical functions are available as well as a few
'       additional funtions for ease of use.

'       Since the mathematical function is generated by an interpreter, and
'       the function is changed by altering the program code itself, I do
'       not recommend running this program in a compiled state.  This pro-
'       gram was intended to be run under QBASIC or the QuickBasic inter-
'       preter.

'       A graph is generated by a mathematical formula that produces a
'       variable, Y, that is base on the X coordinate and/or the Z coor-
'       dinate as well as calculations using trigonometric functions.

'       To start the program immediatly, press <Shift>-<F5>.  The program
'       will generate a 3-D graph based on the following DEFAULT formula:
 
'                            Y = SIN(X) - COS(Z)
  
'       Ignore the following program line.  It is needed for initialization.

DEFSNG A, D-F, H-P, S-Z: DEFINT B-C, G, Q-R: CLS : SCREEN 0, 0, 0: LOCATE 1, 1, 0: COLOR 7, 0: CLS : PI = 3.141593

'       The following definition can be changed to create a graph of a
'       different function.  The n and m represent numbers or other function
'       combinations.  The available operators and constants are:

'          n + m    n - m    n * m    n / m    n ^ m    n \ m   n MOD m
'          ABS(n)   ATN(n)  CINT(n)   COS(n)   EXP(n)   INT(n)   LOG(n)
'          SGN(n)   SIN(n)   SQR(n)   TAN(n)  n AND m   n OR m   NOT n
'          n XOR m   (  )      PI       X        Z

'       The function used to produce the graph can consist of any combination
'       of the above operators.  Any illegal calculations will be reported
'       by the program.  (For example, taking the square root of a negative
'       number.)

'       To change the function to be graphed, replace the formula after the
'       equals sign with your own algebraic function based on X and/or Z:

DEF FNY (X, Z) = SIN(X) - COS(Z)
                              
'       The following lines allow you to change the graph's outer limits:

XMIN = -PI       'This is the left edge (minimum X coordinate) of the graph.
XMAX = PI        'This is the right edge (maximum X coordinate) of the graph.
YMIN = -PI       'This is the bottom (maximum Y coordinate) of the graph.
YMAX = PI        'This is the top (minimum Y coordinate) of the graph.
ZMIN = -PI       'This is the front (maximum Z coordinate) of the graph.
ZMAX = PI        'This is the back (minimum Z coordinate) of the graph.

'       The following constant adjusts the quality of the graphical output:

FREQ = 20        'This value tells the program how defined the graph will
                 'be.  The higher the value, the more defined the graph,
                 'but the more time it will take to produce the graph.

'       The following lines change video defaults:

CI = 1           'Set this constant to 1 for color, 0 for black & white.
CLIP = 1         'Set this constant to 1 to 'clip' any lines that extend
                 'beyond the top or bottom of the graph.  Set to 0 to allow
                 'lines to extend to edge of screen.

QMODE = 6        'Set this constant to one of the following video modes:

'                       6 - 640x480x16          3 - 640x480x2
'                       5 - 320x200x256         2 - 720x348x2
'                       4 - 320X200x4           1 - 640x200x2
               
'       The best video mode will be downward selected automatically.

'       The following line enables or disables error checking.  With error-
'       checking enabled, the program will report errors and give you the
'       option to continue immediately.  With error checking disabled, the
'       program will pass the error to QuickBASIC or QBASIC.

ERCHK = 1       'Set to 1 to enable, 0 to disable.

'       To contact the author for additional high-quality programs, write:

'       Kevin H. Patterson
'       Rt. 2 Box 194
'       Blytheville, AR  72315

'       In case of technical difficulty, you may call (501) 763-2470 after
'       4:00 pm weekdays for support.  (Ask for Kevin)

'       Although this is a shareware program, I do not ask for registration
'       unless you feel this program is worthy of comment.  Suggested
'       donation $5.00.
'
'                   /////PROGRAM CODE STARTS HERE/////

DIM LZX(FREQ), LZY(FREQ)

DEF FNADJX (X, Z) = Z * .5 + X
DEF FNADJY (Y, Z) = Z * .5 + Y

ON ERROR GOTO SCRFIX

IF QMODE = 3 THEN GOTO S640480002: CI = 0
IF QMODE = 2 THEN GOTO S720348002: CI = 0
IF QMODE = 1 THEN GOTO S640200002: CI = 0
IF CI = 0 THEN GOTO NOCLR
IF QMODE = 6 THEN GOTO S640480016
IF QMODE = 5 THEN GOTO S320200256
IF QMODE = 4 THEN GOTO S320200004
PRINT "ERROR: VIDEO MODE UNKNOWN"
PRINT "Sorry, the default video mode must be between 1 and 6 inclusive."
GOTO EXT

YESCLR:

S640480016:
QMODE = 6: CMIN = 1: CMAX = 15: SCREEN 12
PALETTE 15, 31 + 256 * 31 + 65536 * 31
PRINT "15 Color Simulation:  640x480x16"
PRINT "Generating color array..."
GOTO GRAPH

S320200256:
QMODE = 5: CMIN = 1: CMAX = 192: SCREEN 13
PALETTE 255, 31 + 256 * 31 + 65536 * 31: COLOR 255
PRINT "192 Color Simulation:  320x200x256"
PRINT "Generating color array..."
F = 2: C = 0: R = 63: G = 0: B = 0
FOR G = 1 TO 63 STEP F: C = C + 1: PALETTE C, R + G * 256 + B * 65536: NEXT
G = G - F
FOR R = 62 TO 0 STEP -F: C = C + 1: PALETTE C, R + G * 256 + B * 65536: NEXT
R = R + F
FOR B = 1 TO 63 STEP F: C = C + 1: PALETTE C, R + G * 256 + B * 65536: NEXT
B = B - F
FOR G = 62 TO 0 STEP -F: C = C + 1: PALETTE C, R + G * 256 + B * 65536: NEXT
G = G + F
FOR R = 1 TO 63 STEP F: C = C + 1: PALETTE C, R + G * 256 + B * 65536: NEXT
R = R - F
FOR B = 62 TO 0 STEP -F: C = C + 1: PALETTE C, R + G * 256 + B * 65536: NEXT
B = B + F
GOTO GRAPH

S320200004:
QMODE = 4: CMIN = 1: CMAX = 3: SCREEN 1
PRINT "3 Color Simulation:  320x200x4"
PRINT "Using preset color array."
GOTO GRAPH

NOCLR:

S640480002:
CMIN = 1: CMAX = 1: QMODE = 3: SCREEN 11
PRINT "1 Color Simulation:  640x480x2"
PRINT "Using predefined color array."
GOTO GRAPH

S720348002:
CMIN = 1: CMAX = 1: QMODE = 2: SCREEN 3
PRINT "1 Color Simulation:  720x348x2"
PRINT "Using preset color array."
GOTO GRAPH

S640200002:
CMIN = 1: CMAX = 1: QMODE = 1: SCREEN 2
PRINT "2 Color Simulation:  640x200x2"
PRINT "Using preset color array."
GOTO GRAPH

S080025016:
CMIN = 1: CMAX = 15: QMODE = 0: SCREEN 0
PRINT "ERROR: NO GRAPHICS ADAPTOR"
PRINT "Sorry, you need a graphics adaptor to run this program."
GOTO EXT

SCRFIX:
IF QMODE = 6 THEN RESUME S320200256
IF QMODE = 5 THEN RESUME S320200004
IF QMODE = 4 THEN RESUME S640480002
IF QMODE = 3 THEN RESUME S720348002
IF QMODE = 2 THEN RESUME S640200002
RESUME S080025016

GRAPH:
IF ERCHK = 1 THEN ON ERROR GOTO PROGERROR
IF ERCHK = 0 THEN ON ERROR GOTO 0
CLS
XSMIN = XMIN - .25 * (XMAX - XMIN): YSMIN = YMIN - .25 * (YMAX - YMIN)
XSMAX = XMAX + .25 * (XMAX - XMIN): YSMAX = YMAX + .25 * (YMAX - YMIN)
WINDOW (XSMIN, YSMIN)-(XSMAX, YSMAX)

FOR Z = ZMAX TO ZMIN STEP -((ZMAX - ZMIN) / FREQ): Q = 0: FOR X = XMIN TO XMAX STEP (XMAX - XMIN) / FREQ: Q = Q + 1: LX = LZX(Q): LY = LZY(Q): LZX(Q) = FNADJX(X, Z): YTEMP = FNY(X, Z)
IF YTEMP < YMIN AND CLIP = 1 THEN YTEMP = YMIN ELSE IF YTEMP > YMAX AND CLIP = 1 THEN YTEMP = YMAX
LZY(Q) = FNADJY(YTEMP, Z)
IF Q = 1 THEN LZX(Q - 1) = LZX(Q): LZY(Q - 1) = LZY(Q)
IF CI <> 1 THEN C = 1: GOTO NOCLR2
C = ABS(INT((YTEMP - YMIN) / (YMAX - YMIN) * (CMAX - CMIN)) MOD (CMAX - CMIN + 1)) + CMIN
NOCLR2:
LINE (LZX(Q - 1), LZY(Q - 1))-(LZX(Q), LZY(Q)), C: IF Z = ZMAX THEN GOTO SKIP1
LINE (LX, LY)-(LZX(Q), LZY(Q)), C
SKIP1:
NEXT X: NEXT Z

EXT:
END

PROGERROR:
LOCATE 1, 1
PRINT "A program error has occured.  Please check your default settings."
PRINT
PRINT "Do you want to continue? (Y/N) ";
LINE INPUT A$: IF A$ = "N" THEN RESUME EXT
RESUME NEXT

