; =====================================================
; FORMFEED 1.0 - Copyright (C) 1992 by Michael Sigmundt
; =====================================================

           name      FORMFEED
           page      63,80
           title     FORMFEED.COM -- Shift-PrnScrn Sends Formfeed to Printer

lf         equ       10                     ; Linefeed Character for the screen
formfeed   equ       12                     ; Formfeed Character
cr         equ       13                     ; Return Character for the screen
escape     equ       27                     ; Decimal ESC character
reset_code equ       'E'                    ; Laser printer reset character(s)
printport  equ       0                      ; Printer Port 0 = LPT1, 1 = LPT2

_CODE      segment   word public 'CODE'
           org       100h                   ; All .COM files start at 100h
           assume    cs:_CODE,ds:_CODE      ; Assume that CS = DS

start:     jmp       init                   ; Jump to Setup Routine

           int_old   label word             ; Memory Variable to store
           int_addr  dd    0                ;  old Prn Scrn interrupt address

prog       proc      near                   ; Interrupt Routine
           push      ax                     ; Save all Registers
           push      bx
           push      cx                     ; Flags do not need to be
           push      dx                     ;  pushed since they are
           push      di                     ;  automatically pushed
           push      si                     ;  when an interrupt is
           push      ds                     ;  first called.
           push      es
           mov       ax,cs
           mov       ds,ax                  ; Set data segment = code segment

           mov       dx,printport           ; Printer Port
           mov       ah,02h                 ; Function 02
           int       17h                    ; Check Printer Port Status
           and       ah,10010000b           ; Bits 4 & 7 must both be 1 to print
           cmp       ah,10010000b           ; AND & CMP, Can't TEST for 2 bits
           je        prn_ok                 ; If equal, go ahead and print
           mov       ax,0e07h               ; Put 0e in AH, and Bell Char. in AL
           mov       bx,0h                  ; Text Page 0 and Colour 0
           int       10h                    ; Write Bell Character to Console
           jmp       exit_prog              ; Jump to end of program

prn_ok:    mov       ah,02h                 ; Function 02h
           int       16h                    ; Get Keyboard Flags
           test      al,00000001b           ; Test bit 0 for Right-Shift key
           jnz       do_form                ; If pressed, do a formfeed,
           test      al,00000010b           ; Test bit 1 for Left-Shift key
           jnz       do_reset               ; If pressed, reset printer
                                            ;  otherwise do original Print Scrn
           pushf                            ; Push Flags before calling original
           call      int_addr               ;  interrupt since it will pop flags
           jmp       exit_prog              ; Jump to the end of the program

do_form:   mov       dx,printport           ; Printer Port Number
           mov       ah,0h                  ; Function number 00h
           mov       al,formfeed            ; Formfeed Character
           int       17h                    ; Write character to printer
           jmp       exit_prog

do_reset:  mov       dx,printport           ; Printer Port Number
           mov       ah,0h                  ; Function number 00h
           mov       al,escape              ; Escape Character
           int       17h                    ; Write Escape Character
           mov       ah,0h                  ; Function number 00h
           mov       al,reset_code          ; Reset Character to follow Escape
           int       17h                    ; Write Reset Character

exit_prog: pop       es                     ; Restore all Registers
           pop       ds
           pop       si
           pop       di
           pop       dx
           pop       cx
           pop       bx
           pop       ax
           iret                             ; Interrupt Return
prog       endp

init       proc      near                   ; Setup routine
           mov       ah,09h                 ; Funtion 09 displays a string
           mov       dx,offset message      ; Point DX to start of string
           int       21h                    ; Display string
           mov       ah,35h                 ; Function 35 gets interrupt vector
           mov       al,05h                 ; Prn Scrn Interrupt number
           int       21h                    ; Get Interrupt Vector
           mov       int_old,bx             ; Store Old Offset
           mov       int_old[2],es          ; Store Old Segment
           mov       ah,25h                 ; Function 25 sets interrupt vector
           lea       dx,prog                ; Put Offset of prog into DX
           int       21h                    ; Set Interrupt Vector to prog
           mov       dx,offset init         ; Last address to keep in memory
           int       27h                    ; Terminate and stay resident
init       endp

message    db        cr,lf
           db        'FORMFEED 1.0 - Copyright (C) 1992 by Michael Sigmundt',cr,lf
           db        '=====================================================',cr,lf,lf
           db        'Press [Right Shift] + [Print Scrn] to send a FormFeed to LPT1',cr,lf
           db        'Press  [Left Shift] + [Print Scrn] to send a ESC + E  to LPT1 (LaserJet Reset)',cr,lf,lf
           db        'A Beep indicates that the printer in not accepting data...',cr,lf
           db        '$'

_CODE      ends

           end       start                  ; Start is where to begin execution
