/*
//
// NCB.H
//
// (c) Copyright 1990, 1991 Adrian King.
//
// $Header$
//
// $Log$
//
// Header file defining NetBIOS Ncb structure.
// 
*/

struct Ncb {
	BYTE	NCB_command;			// NCB COMMAND FIELD
	BYTE	NCB_retcode;			// NCB RETURN CODE
	BYTE	NCB_lsn;				// NCB LOCAL SESSION NUMBER
	BYTE	NCB_num;				// NCB ALIAS NUMBER
	char far *	NCB_buffer; 		// NCB POINTER TO MESSAGE BUFFER
	WORD	NCB_length;				// NCB LENGTH (IN BYTES)
	BYTE	NCB_callname[D_NAMESZ];	// NCB NAME ON REMOTE ATTACHMENT
	BYTE	NCB_name[D_NAMESZ];		// NCB ALIAS NAME
	BYTE	NCB_rto;				// NCB RECEIVE TIMEOUT
	BYTE	NCB_sto;				// NCB SEND TIMEOUT
	FARPROC NCB_post;				// NCB POINTER TO POST ROUTINE
	BYTE	NCB_lana_num;			// NCB ATTACHMENT #1 FOR SECOND ATTACHMENT
	BYTE	NCB_cmd_cplt;			// COMMAND PENDING INDICATION
	BYTE	NCB_reserve[14];    	// NCB RESERVED AREA
};

#define	NETBIOS_INT	0x005c		// NetBIOS interrupt number
#define NCBNO_WAIT	0x0080	    // Flag for 'no wait' commands

	//
	//	NetBIOS command code definitions.
	//
	//	OR these command codes with NCBNO_WAIT for command
	//	with no wait.
	//

#define	NCBRESET				0x0032	// Reset local attachment
#define NCBSTATUS				0x0033	// Receive status of sessions
#define NCBCANCEL				0x0035	// Cancel request
#define NCBADDNAME				0x0030	// Add unique name
#define NCBADDGROUPNAME 		0x0036	// Add group name
#define NCBDELETENAME			0x0031  // Delete name
#define NCBCALL 				0x0010  // Open session
#define NCBLISTEN				0x0011  // Listen for a call
#define NCBHANGUP				0x0012  // End a session
#define NCBSEND 				0x0014  // Send
#define NCBSENDMULTIPLE 		0x0017  // Send multiple
#define NCBRECEIVE				0x0015  // Receive
#define NCBRECEIVEANY			0x0016  // Receive from any
#define NCBSESSIONSTATUS   		0x0034  // Session status
#define NCBSENDDATAGRAM 		0x0020  // Send a datagram
#define NCBRECEIVEDATAGRAM 		0x0021  // Receive a datagram
#define NCBSENDBROADCAST 		0x0022  // Send a broadcast datagram
#define NCBRECEIVEBROADCAST  	0x0023 	// Receive a broadcast datagram
#define NCBINVALID				0x007f	// An invalid NCB command
