#include <stdio.h>
#include <conio.h>
#include <dos.h>

#include "nos.h"
#include "noslib.h"
#include "netpq.h"

extern struct serverdef *server;
extern struct localqueuedef *localqueue;

extern int maxlocalqueuecount, localqueuecount, numberoflogins;

f2keypressed ()
{
//  handles response for f2 key (control queue)

int f2menuitems = 4;
char *f2menu [] =
    {
    "Cancel File",
    "Hold File",
    "Release File",
    "Rush File",
    "Show Info",
    "View File",
    "Copy File",
    "Keep File",
    };
int f2xsize = strlen (f2menu [2]);

int i, action, servernum, queuenum;
int ybase;

    ybase = wherey () + 1;
    if (ybase + f2menuitems > 24)
	ybase = 24 - f2menuitems;

    if (localqueuecount == 0)
	{
	message ("THERE ARE NO FILES QUEUED\a", true);
	nohighlight ();
	sleep (2);
	return 0;
	}
    do
	{
	if ( (action = menu (&f2menu, f2menuitems, f2xsize, firstxpos, ybase)) != -1)
	    {
	    do
		{
		if ( (servernum = displayservernames (ybase)) != -1)
		    {
		    if ( (queuenum = displayqueuenumbers (servernum, ybase)) != -1)
			{
			handlequeuerequest (action, servernum, queuenum);
			return 0;
			}
		    }
		}while (servernum != -1);
	    }
	}while (action != -1);
    return -1;
}


displayqueuenumbers (int servernum, int ybase)
{
//  displays a menu of all queued file sequence numbers

int i, selection, j;
char *localqueuenames [20];
char buf [20];

    i = 0;
    j = 0;

    while ( (i < maxlocalqueuecount) && (i < 20) )
	{
	if (localqueue [i] .server == servernum)
	    localqueuenames [j++] = &localqueue [i] .sequencestring;
	i++;
	}

    if (j > (21 - (numberoflogins * 5)) / numberoflogins)
	j = 1 + (21 - (numberoflogins * 5)) / numberoflogins;

    if (ybase + j > 24)
	ybase = 24 - j;

    if (j > 0)
	selection = menu (&localqueuenames, j, 6, thirdxpos, ybase);
    else
	{
	gotoxy (1, 1);
	errorhighlight ();
	message ("THERE ARE NO FILES QUEUED\a", true);
	nohighlight ();
	sleep (2);
	return (-1);
	}
    return selection;
}




handlequeuerequest (int action, int servernum, int queuenum)
{
//  processes the queue action requested by the operator

    action += CQ_cancel;

    if (action <= CQ_rush)
	{
	if (action == CQ_cancel)
	    if (checkqueueprivileges (servernum) == -1)
		return -1;
	message ("UPDATING, PLEASE WAIT ...", false);
	if (NOSControlQueue (&localqueue [queuenum] .printer, action, &server [servernum] .servername, localqueue [queuenum] .QE_sequence) == -1)
	    NOSperror ("NOSControlQueue");
	return 0;
	}
}
