/*
                 NETGET REXX v1.0 by John Mastwijk of 1:134/65
       Based on Jeff Galbraith's (1:134/21) excellent DOS utility GETNET

  NetGet will extract a given net from a St. Louis format nodelist and format
   it nicely (or not if you prefer :-).  Its useful for creating a "BBS LIST"
                     type bulletin for your bulletin board.

    Modify and/or butcher to your hearts content. There aren't any comments
       in the REXX and its really messy, but its fairly self-explanatory.

        If you make any nifty modifications, please send me the update!
*/
ARG Zone Net A B
IF Net = '' THEN
  DO
    CALL LINEOUT StdErr,"NETGET REXX v1.0 by John Mastwijk of 1:134/65 (FidoNet) & 40:649/1015 (ibmNET)"
    CALL LINEOUT StdErr," - Based on Jeff Galbraith's excellent DOS (cough, hack :-) program GETNET"
    CALL LINEOUT StdErr,""
    CALL LINEOUT StdErr,"Usage:  NETGET [zone] [net] [/Llistname] [/F] [/X]"
    CALL LINEOUT StdErr,""
    CALL LINEOUT StdErr,"        ZONE and NET numbers are required.  Eg.  NETGET 1 134"
    CALL LINEOUT StdErr,""
    CALL LINEOUT StdErr,"   /L - Optional.  If supplied, "listname" is used.  Path is optional but"
    CALL LINEOUT StdErr,"        extension IS required.  If this parameter is omitted, the most"
    CALL LINEOUT StdErr,"        current FidoNet nodelist in the current directory is assumed."
    CALL LINEOUT StdErr,"        Eg. NETGET 40 649 /Ld:\nodelist\ibmlist.196 /X"
    CALL LINEOUT StdErr,""
    CALL LINEOUT StdErr,"   /F - Optional.  If supplied, the output is formatted.  HOST, HUB, DOWN,"
    CALL LINEOUT StdErr,"        PVT, and MO nodes ARE included and they are indicated as such in"
    CALL LINEOUT StdErr,"        the output.  Eg. NETGET 1 134 /F"
    CALL LINEOUT StdErr,""
    CALL LINEOUT StdErr,"   /X - Optional.  If supplied, the output is formatted BUT HOST, HUB, DOWN,"
    CALL LINEOUT StdErr,"        PVT, and MO nodes are NOT included.  Eg. NETGET 1 134 /X"
    CALL LINEOUT StdErr,""
    CALL LINEOUT StdErr,"   If neither /F nor /X are supplied, output is in RAW nodelist format."
    CALL LINEOUT StdErr,"   Output can be re-directed.  Eg. NETGET 1 134 /X >D:\BULLETIN\NET134.LST"
  END
ELSE
  DO
    IF (DATATYPE(Zone) <> "NUM") | (DATATYPE(Net) <> "NUM") THEN
      DO
        CALL LINEOUT StdErr,"Error:  Invalid ZONE and/or NODE"
        EXIT
      END
    IF LEFT(A,2) = "/L" THEN
      File = SUBSTR(A,3)
    ELSE
      IF LEFT(B,2) = "/L" THEN
        File = SUBSTR(B,3)
      ELSE
        DO
          W = LEFT(DATE('W'),2)
          D = DATE('D')
          SELECT
            WHEN W = "Sa" THEN
              D = D - 1
            WHEN W = "Su" THEN
              D = D - 2
            WHEN W = "Mo" THEN
              D = D - 3
            WHEN W = "Tu" THEN
              D = D - 4
            WHEN W = "We" THEN
              D = D - 5
            WHEN W = "Th" THEN
              D = D - 6
            OTHERWISE
              NOP
          END
          File = 'NODELIST.'RIGHT(D,3,'0')
        END
    IF LINES(File) = 0 THEN
      DO
        CALL LINEOUT StdErr, "Error: " File "not found"
        EXIT
      END
    Other = ''
    IF (LEFT(A,2) = "/F") | (LEFT(B,2) = "/F") THEN
      Other = 'F'
    IF (LEFT(A,2) = "/X") | (LEFT(B,2) = "/X") THEN
      Other = 'X'

    /* Find ZONE */
    Line = LINEIN(File)
    DO WHILE LINES(File)
      IF LEFT(Line,5 + LENGTH(Zone)) = "Zone,"Zone THEN
        LEAVE
      Line = LINEIN(File)
    END

    IF SUBSTR(Line,6,LENGTH(Zone)) <> Zone THEN
      DO
        CALL LINEOUT StdErr, "Error:  Zone" Zone "not found in" File
        EXIT
      END

    /* Find NET */
    Line = LINEIN(File)
    DO WHILE LINES(File)
      IF LEFT(Line,5 + LENGTH(Net)) = "Host,"Net THEN
        LEAVE
      IF LEFT(Line,5) = "Zone," THEN
        LEAVE
      Line = LINEIN(File)
    END

    IF SUBSTR(Line,6,LENGTH(Net)) <> Net THEN
      DO
        CALL LINEOUT StdErr, "Error:  Net" Net "not found in Zone" Zone
        EXIT
      END

    IF Other <> '' THEN
      DO
        SAY CENTRE("--= Net" Net "of" FILESPEC("N", File) "on" DATE('N') "=--", 79)
        IF Other = 'F' THEN
          SAY "            H = Host, B = Hub, D = Down, P = Private, M = Mail only"
        ELSE
          SAY ""
        SAY " NODE   BBS NAME             AREA     SYSOP                PHONE         BAUD"
        SAY " ============================================================================="
      END

    CALL Output
    Line = LINEIN(File)
    DO UNTIL (LEFT(Line,1) = ';') | (\LINES(File))
      CALL Output
      Line = LINEIN(File)
    END
  END
EXIT

Output : PROCEDURE EXPOSE Line Other
  IF Other = '' THEN
    SAY Line
  ELSE
    DO
      IF ((LEFT(Line,1) <> ',') | (LASTPOS(",MO",Line) <> 0)) & (Other = 'X') THEN
        NOP
      ELSE
        DO
          Desg = LEFT(Line, POS(',',Line) - 1)
          Temp = RIGHT(Line, LENGTH(Line) - POS(',',Line))
          IF Desg = "Host" THEN
            Node = '0'
          ELSE
            Node = LEFT(Temp, POS(',',Temp) - 1)
          Temp = TRANSLATE(RIGHT(Temp, LENGTH(Temp) - POS(',',Temp)),' ','_')
          Name = LEFT(Temp, POS(',',Temp) - 1)
          Temp = RIGHT(Temp, LENGTH(Temp) - POS(',',Temp))
          City = LEFT(Temp, POS(',',Temp) - 1)
          Temp = RIGHT(Temp, LENGTH(Temp) - POS(',',Temp))
          Sysp = LEFT(Temp, POS(',',Temp) - 1)
          Temp = RIGHT(Temp, LENGTH(Temp) - POS(',',Temp))
          Phne = LEFT(Temp, POS(',',Temp) - 1)
          Phne = RIGHT(Phne, LENGTH(Phne) - POS('-',Phne))
          Temp = RIGHT(Temp, LENGTH(Temp) - POS(',',Temp))
          Baud = LEFT(Temp, POS(',',Temp) - 1)

          SELECT
            WHEN LASTPOS(",MO",Line) <> 0 THEN
              Flag = 'M'
            WHEN Desg = "Host" THEN
              Flag = 'H'
            WHEN Desg = "Hub" THEN
              Flag = 'B'
            WHEN Desg = "Pvt" THEN
              DO
                Flag = 'P'
                Phne = "-- PRIVATE --"  /* Max. 12 characters */
              END
            WHEN Desg = "Down" THEN
              DO
                Flag = 'D'
                Phne = "--- DOWN ---"  /*  Max. 12 characters */
              END
            OTHERWISE
              Flag = ' '
          END

          SAY " "RIGHT(Node,4)" "Flag" "LEFT(Name,19)"  "LEFT(City,7)" ",
               LEFT(Sysp,20)" "LEFT(Phne,12)"  "LEFT(Baud,4)
        END
    END
RETURN
