;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                ;
;	written by Keith P. Robison              ;
;                                                ;
;     Copyright Syracuse University 1988         ;
;                                                ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


	name 	SetcopyPascalLinkInterface

CGroup	group	Code

	assume	cs: CGroup,  ds: nothing

Code	segment public 'CODE'



        public	 _net_directory_request
        public	 _net_semaphore_request
;
;	define the network DOS function codes
;
directory_request_code 		equ	226
;-----------------------------------------------------------------------

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                ;
;   directory_request : dir  request function    ;
;          by Keith Robison                      ;
;                                                ;
; procedure net_directory_request [c,varying]    ;
;                                                ;
;                                                ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

_net_directory_request	proc	far
	mov	ah,directory_request_code
	push	bp
        mov	bp,sp
        push	es
        push	ds
        push	ax
        mov	di,[bp + 6]
        mov	ax,[bp + 8]
        mov	es,ax
        mov	si,[bp + 0AH]
        mov	ax,[bp + 0CH]
        mov	ds,ax
        pop	ax
        int	21h
        mov	ah,0
        pop	ds
        pop     es
        pop	bp
        ret
_net_directory_request	endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;		semaphore request     0C5H       ;
; al= 0  open a semaphore                        ;
;     1  examine a semaphore                     ;
;     2  wait for a semaphore                    ;
;     3  Signal a semaphore                      ;
;     4  close a semaphore                       ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

_net_semaphore_request	proc	far	; selector,bx,cx,dx
	push	bp
        mov	bp,sp
        mov     ax,[bp+6]	; selector  0-4
	mov	ah,0C5H		; semaphore request code
        mov	dx,[bp+0CH]
        mov	di,[bp+0AH]
        mov	cx,[di];
        push	di
        int	21H
        pop	di
        mov	[di],cx
        mov	di,[bp+8]
        mov	[di],bx
        mov	di,[bp+0CH]
        mov	[di],dx
        mov	ah,0
        pop	bp
        ret
_net_semaphore_request	endp

Code	ends

	end
