        page    55,132
TITLE	SETGRAPH subroutines called by Microsoft Pascal for SETCOPY

SETGRAPH	SEGMENT PARA PUBLIC 'CODE'
	        ASSUME  CS:SETGRAPH


	PUBLIC		GOTOXY
	PUBLIC		SCROLL_SCREEN_UP

;---------------------------------------------------------------
;
;       GOTOXY  -  Set cursor on screen at passed location
;
;       GOTOXY(  row : Integer     - row and column where
;                col : Integer )   - cursor is to be moved
;
;       Returned        :nothing
;
;---------------------------------------------------------------
; Procedure gotoxy(CONST ROW,COL : Integer);
;---------------------------------------------------------------

GOTOXY	PROC FAR

ROWPAR  EQU     8               ;row parameter location
COLPAR  EQU     6               ;Col parameter location
        PUSH    BP              ;save caller's BP register
        MOV     BP,SP           ;point BP to parameters passed
	push	ax
	push	bx
	push	dx
	mov	ah,0FH
	int	10h 		;get active page
        MOV     DX,[BP+ROWPAR]  ;move row to DX
        MOV     DH,DL           ;move DL to DH
        MOV     AX,[BP+COLPAR]  ;move column to CX
        MOV     DL,AL           ;move CL to DL
        MOV     AH,02           ;Move cursor functor
        INT     10H             
	pop	dx
	pop	bx
	pop	ax
        MOV     SP,BP
        POP     BP              ;return to caller
        RET     4

GOTOXY	ENDP

;-----------------------------------------------------------------------
; Procedure scroll_screen_up( nlines,ulr,ulc,lrr,lrc,ATTR: Integer);
;-----------------------------------------------------------------------

SCROLL_SCREEN_UP	PROC	FAR

	PUSH	BP
        MOV	BP,SP

	PUSH	AX
	PUSH	BX
	PUSH    CX
	PUSH	DX
        MOV	AX,[BP+10H]
        MOV	DX,[BP+08H]
	MOV	BX,[BP+0AH]
	MOV	DH,BL
	MOV	CX,[BP+0CH]
	MOV	BX,[BP+0EH]
	MOV	CH,BL
	MOV	BX,[BP+6H]
	MOV	BH,BL
	MOV	BL,0
        MOV	AH,6
        INT	10H
        MOV	AH,0
	POP	DX
	POP	CX
	POP	BX
	POP	AX

        POP	BP
        RET	0CH


;[BP+10H]   nlines
;[BP+08H]   llc
;[BP+0AH]   llr
;[BP+0CH]   ulc
;[BP+0EH]   ulr
;[BP+6H]   attr


SCROLL_SCREEN_UP	ENDP

SETGRAPH	ENDS
        END

