;SPIX.ASM
;Program fr att skriva en pixel p skrmen i 16-frgers lgen
;640*480, 800*600 och 1024*768
;TB syntax:
;   call    plot    (column%,x%,y%,col%)
;   sub plot    inline
;       $inline "spix.bin"
;   end sub     

.286
pixseg  equ 0A000h      ;segment fr displayminnet
col equ 6               ;frg
y   equ 10              ;y-koordinat
x   equ 14              ;x-koordinat
column  equ 18          ;antal columner (byte) bildbredd

code segment
	assume  cs:code
	
	push    bp          ;save base pointer
	mov bp,sp           ;move stack pointer to bp
	push    ds

	mov dx,3CEh     
	mov ax,0F01h        ;alla frgplan till
	out dx,ax           ;skriv Fh till enable set/reset reg

	mov al,0        
	lds di,[bp+col] 
	mov ah,byte ptr ds:[di] 
	out dx,ax           ;skriv col till set/reset reg

	lds di,[bp+x]
	mov ax,ds:[di]      ;ladda x-koordinaten
	mov cx,ax           ;spara x i cx
	shr ax,3            ;x1=x/8
	mov bx,ax           ;spara x1 i bx
	and cx,7            ;isolera 3 lgsta bitar i cl
	mov ah,128          ;1 i MSB
	ror ah,cl           ;rotera hger cl steg
	mov al,8        
	out dx,ax           ;skriv mask till bit mask reg

	lds di,[bp+y]
	mov ax,ds:[di]      ;ladda y-koordinaten
;   mov cx,ax           ;spara y i cx
;   and ax,511          ;isolera bit 0-7, y'=y mod 512
	lds di,[bp+column]
	mul ds:[di]         ;column*y'  
	shl dx,12           ;1000h om dx=1 (>64k vid mul)
	add ax,bx           ;column*y+x1
	mov si,ax           ;offset 

	mov ax,pixseg   
	add ax,dx           ;addera 1000h om adr>64k
	mov ds,ax           ;segment
	mov bl,ds:si        ;dummy read
	mov ds:si,al        ;dummy write

	mov dx,3CEh         ;terstll vissa register
	mov ax,0FF08h       ;terstll med FF   
	out dx,ax           ;skriv till bit mask reg

	mov ax,0001h        ;terstll med 0
	out dx,ax           ;skriv till enable set/reset reg

	pop ds
	pop bp

code ends
end
