
; VSLD.LSP
; Copyright from 8-90 by Terry Priest
; Any problems or comments contact me at at home
; 11428 DENZER ROAD   EVANSVILLE, IND.  47712
; The user needs to implement a menu screen of directories called **DIRS (see
; the comment in the text) and a fully blank screen called **BLANK.

; Overview:
; VSLD is a grtext/grread program that uses the side menu to display a list
; of drawings or slides from any directory. The top half of the screen has
; the file list. Picking a name issues the Vslide command on that name.
; You can pick as many times as you want and change pages.  The bottom half
; of the screen has the option list, one of which is Insert.  After picking
; a file name and viewing the slide, the options are Insert, Copy, Move,
; Rename & Delete.  The simple convention that makes it work like a visual
; drawing manager is to have the drawings and representative slides in the
; same directory with the same name. This is easily done.  The Dos functions
; work on the drawing and slide as an inseparable pair.

; VSLD is shareware. Those of you who find it useful may send me $10.  You
; will have the satisfaction of knowing you have encouraged me.  I shall send
; you by return mail a disk (specify 3.5 or 5.25) with VSLD, NSRT, NWLST and
; EasyMacros.  For $25 I will also send you the Rel 11 behemoth INDEX, the
; next version of VSLD.  INDEX is a smart menu list processing dos utility in
; lisp taking Autocad specific actions with files and grouping lists of lists.
; Its about that confused really but the bottom line is that you can index
; your drawings (or network or worm) many different ways by picking list names
; and branching to another list or using a list of filenames.

; The VSLD screen looks like this:                         

; The number of files displayed depends on the SCRLEN variable set in the
; first line of the program so all displays can use all their side menu lines.

;"DRAWINGS" or "SLIDES" - Shows current file type listed and toggles between.
; "INSERT" - Inserts the currently displayed file
; "COPY" - Copies the currently displayed (or picked) file (both .DWG & .SLD)
; "MOVE" - Moves the currently displayed file (both .DWG & .SLD)
; "RENAME" - Renames the currently displayed file (both .DWG & .SLD)
; "DELETE" - Deletes the currently displayed file (both .DWG & .SLD)
;
; "Info Off" or "Info On" - Displays (when on) a dir list of the displayed
;                           file.  This works well with dual screen and not
;                           at all with single screen.
; "Exit On" or "Exit Off" - Insert and Exit (works with attributes or single
;                           Insert) or Insert and Stay (will pause four times
;                           for the Insert and then continue the menu loop).
; "MAKELIST" - Logging the directory for the file list with the shell command
;              produces an up-to-date list but is somewhat slow. The same list
;              can be written to a file and read in as a log-on list. If it
;              becomes outdated it can be deleted or simply remade.
; "DEL LIST" - Delete hard drive dir list file
; "SAV L ON" or "SAVL OFF" - Toggle will save or set to nil the file list as
;                            the function exits.  If saved the function starts
;                            instantly without first asking for a directory.


;			 VSLD -
;		A DRAWING DATABASE MANAGER
;		    by TERRY PRIEST

;   A DRAWING DATABASE MANAGER SHOULD CONSIST OF A VIEWING FUNCTION AND
;AN INSERTION FUNCTION.  ADDITIONALLY WE SHOULD BE ABLE TO COPY, MOVE,
;RENAME AND DELETE OUR DRAWINGS EVEN WHILE WE ARE LOOKING AT THEM.
			 
;    VSLD (STANDS FOR VIEW SLIDE) DISPLAYS A DYNAMIC LIST OF EITHER
;DRAWINGS OR SLIDES IN ANY DRIVE OR DIRECTORY COMPLETE WITH PAGING
;ON THE TOP HALF OF THE SIDE SCREEN.  THE LOWER HALF DISPLAYS THE MENU
;OPTIONS.  PICKING FROM THE FILE LIST PRODUCES A DISPLAY OF THE SLIDE.
;FOR MAXIMUM UTILITY, IT IS ASSUMED (BUT NOT NECESSARY) THAT A DRAWING
;AND A REPRESENTATIVE SLIDE OF THE SAME NAME BOTH EXIST IN THE DIRECTORY.
;THE FILE EXTENSION (.DWG OR .SLD) IS STRIPPED OFF SO THE LIST CAN BE USED
;TO VIEW THE SLIDE, INSERT THE DRAWING, OR USE THE DOS FUNCTIONS ON BOTH.
			 
;   SLIDES ARE THE PERFECT VEHICLE FOR VISUALLY REFERENCING A DRAWING
;BEFORE INSERTING IT.  ANY NUMBER OF SLIDES CAN BE VIEWED AND THE LIST
;PAGED WITH "NEXT" AND "PREVIOUS" OPTIONS. THE "INSERT" OPTION WILL INSERT
;THE CURRENTLY DISPLAYED FILE (OR LAST PICKED IF NO SLIDE EXISTS). THE
;DOS FUNCTIONS, "COPY", "MOVE", "RENAME", AND "DELETE", WILL OPERATE ON
;THE CURRENTLY DISPLAYED FILE AS A DRAWING/SLIDE PAIR.  COPY, MOVE, AND
;RENAME CHECK FOR DUPLICATE NAMES.  DELETE REQUIRES A DOUBLE CLICK ON THE
;SAME SPACE.  "EXIT" LEAVES THE PROGRAM AND REDRAWS THE GRAPHICS SCREEN
;AND SIDE MENU.
		      
;   THE PROGRAM WORKS WITH ANY DRIVE OR DIRECTORY, WITH BACKSLASHES OR
;FORESLASHES.  VSLD FIRST ASKS FOR A PATH.  IT CAN BE TYPED IN,
;BUT VSLD CALLS AN AUTOCAD MENU SCREEN OF DIRECTORIES.  IT CAN BE ONE,
;OR SEVERAL PAGES.   PSLASH.LSP (FROM "INSIDE AUTOLISP") CHANGES THE ACAD
;MENU FORESLASH TO A DOS BACKSLASH.  THIS DIRECTORY INDEX IN OUR MENU LOGS
;ON VSLD AND ALSO PROVIDES A TARGET DIRECTORY FOR COPYING (AS WELL AS BEING
;USEFUL TO OTHER PROGRAMS PUTTING BLOCKS AND SLIDES INTO THE DIRECTORIES).
;WE PICK THE DIRECTORY, THEN THE FILE.  THE USER CAN LOOK THROUGH A LARGE
;NUMBER OF DRAWINGS, CATEGORIZED BY DIRECTORY NAME, AND FIND THE
;DRAWINGS HE WANTS TO USE.  THE LAST DIRECTORY REMAINS THE DEFAULT.
		      
;   A LISP PROGRAM CALLED BLK.LSP BY MIKE PILLERS WAS THE FIRST PROGRAM
;I WAS AWARE OF THAT USED GRTEXT AND GRREAD TO CREATE A SMART MENU
;ON THE SIDE SCREEN.  ANY LIST OF NAMES - LIKE BLOCKS, FILES, VIEWS, ETC. -
;CAN BE WRITTEN TO THE SCREEN WITH GRTEXT.  GRREAD ALLOWS US TO PICK
;OUT ANY NAME FROM THE LIST FOR PROCESSING.  USING A COND STATEMENT TO
;ENABLE MENU CHOICES (ANALOGOUS TO DBASE'S "DO CASE" MENU STRUCTURE) INSIDE
;A WHILE LOOP IS THE KEY TO VSLD, AND COULD BE A TEMPLATE FOR MANY OTHER
;PROGRAMS.  WE CAN VIEW FILES REPEATEDLY, THEIR NAME BECOMING THE VARIABLE
;ASSIGNMENT, THEN PICK ANY MENU OPTION (WHICH MAY USE THE VARIABLE),
;THEN VIEW ANOTHER FILE, ETC.

;   WE CAN EASILY HAVE A DIRECTORY OF DRAWINGS THAT EACH HAVE A SLIDE
;OF THE SAME NAME.  SLIDES CAN BE MADE ONE AT A TIME WITH MSLIDE, OR
;"INSIDE AUTOLISP" BY SMITH AND GESNER CONTAINS A LISTING FOR A FILE
;SLIDE.LSP THAT WILL CREATE A SCRIPT THAT MAKES SLIDES FROM A WHOLE
;DIRECTORY OF DRAWINGS.  THE SCRIPT CSLIDE.SCR IS PLACED IN THE SAME
;DIRECTORY WITH THE DRAWINGS.  AUTOCAD IS STARTED WITH THE SCRIPT FILE
;AND THE SLIDES ARE MADE WITHOUT OPERATOR INPUT. THE SAME BOOK HAS A
;FUNCTION INDISPENSABLE TO VSLD CALLED GETFIL.LSP (MY GETFLS) WHICH
;OBTAINS THE FILE LIST.
			   
;   VSLD.LSP CAN BE USED TO DISPLAY ANY AUTOCAD DRAWING FOR ANY PURPOSE.
;NO ONE HAS TO MAINTAIN AN UP-TO-DATE LIST OF BLOCKS OR TYPE IN A SINGLE
;BLOCK NAME.  IT WORKS ON A LOCAL HARD DISK, OR ACROSS A NETWORK.  ON THE
;NETWORK SLIDEWARE CAN HELP ORGANIZE AS EVERYBODY CAN USE THE SAME
;DIRECTORY INDEX, TO USE THE SAME DRAWINGS, WHICH BECOME STANDARD BLOCKS.

;*****************************************************************************
(defun C:VSLD (/ fl pageno readno scrlen pages newnam dwgspc sldspc tmpdir
  tmp pathln dir filext)     ;fls path & flag variables are global
(setq scrlen 20) ;change screen length here to match your display's # of lines
(if (not fls) (setq path (getdir path)  filext (if flagf "sld" "dwg")
   fls (getfls path filext "dir.$")  pathln (1+ (strlen path)))
  (progn  (setq pathln (dirlen (car fls)))                ;else if fls exist
   (if (= path (setq tmp (substr (car fls) 1 (1- pathln))))        ;dir test
      (prompt " Path OK ") (prompt (strcat "Old Path<" (if path path "nil")
                                     "> New Path<" (setq path tmp)">" )))))
 (setq pageno 0  pages (pag#s fls scrlen))
 (menucmd "S=BLANK")                ;**Blank is a blank menu page
 (while   (/= readno (+ scrlen 3))  (grtext)                 ;The menu loop
             (grtext (+ scrlen 1) "PREVIOUS")
             (grtext (+ scrlen 2) "NEXT")
             (grtext (+ scrlen 3) "EXIT")        ;current file list mode below
             (grtext (+ scrlen 5) (if flagf "SLIDES" "DRAWINGS"))  
             (grtext (+ scrlen 7) "INSERT")
	     (grtext (+ scrlen 8) "COPY")     ;dos functions will use the file
             (grtext (+ scrlen 9) "MOVE")     ;displayed in the upper left of
             (grtext (+ scrlen 10) "RENAME")  ;the screen
             (grtext (+ scrlen 11) "DELETE")
             (grtext (+ scrlen 13) (if flagi "Info On"  "Info Off"))
             (grtext (+ scrlen 14) (if flage "Exit Off"  "Exit On"))
             (grtext (+ scrlen 15) "MAKELIST")                ;make list file
             (grtext (+ scrlen 16) "DEL LIST")              ;delete list file
             (grtext (+ scrlen 17) (if flagsv "Sav L ON" "SavL OFF"))
             (prompt "SELECT BLOCK/DWG TO VIEW SLIDE\n")
             (dspfls fls scrlen pathln pageno)              ;display file list
             (grtext -1 (strcat path " " (if fl (substr fl pathln) "")))
             (grtext -2 (strcat "Page No. " (itoa pageno)))
	     (setq readno (nth 1 (grread)))                       ;stop here
(cond                                 ;which line number does readno contain
((and (>= readno 0) (< readno scrlen)(not (listp readno))) ;in the file list
    (if (setq fl (nth (+ readno (* pageno scrlen)) fls))
     (progn (if flagi  (command "SH" (strcat "dir "  fl ".*")))
      (if (findfile (strcat fl ".SLD")) (command "VSLIDE" fl)
       (progn (grclear) (prompt (strcat " No Slide found for " fl "\n")))))))

((= readno (+ scrlen 1)) (prevpg))              ;"Previous" page
((= readno (+ scrlen 2)) (nextpg))              ;"Next" page

((= readno (+ scrlen 5))                    ;"Drawings" or "Slides" displayed
   (if flagf (setq fls (getfls path "dwg" "dir.$") flagf nil)
             (setq fls (getfls path "sld" "dir.$") flagf T))
   (setq  pageno 0  pages (pag#s fls scrlen) fl nil))

((= readno (+ scrlen 7)) (if fl                   ;"Insert" option
   (if (findfile (strcat fl ".DWG"))
    (if (not flage) (progn  (command "INSERT" fl ) (setq readno (+ scrlen 3))) 
          (command "REDRAW" "INSERT" fl pause pause pause pause))
   (prompt (strcat " NO DRAWING FOUND FOR " fl "\n"))))) 

; The dos functions will use the file displayed in the upper left of the screen
((= readno (+ scrlen 8))                           ;"Copy" option
;WARNING: An oddity of DOS is that you cannot copy to a path with a trailing
;slash, yet if it is the root dir, you must use a trailing slash, or the
;current dir will be written to instead.  Since a DOS path might or might not
;have a drive prefix, this is hard to deal with. RESULT: If you try to copy
;to the root dir, unless it is current, which is usually the case for floppies,
;you will copy to the current dir instead; you will overwrite files without
;being informed; the program will check and indicate that Copy failed.
;DON'T COPY OR MOVE TO THE ROOT DIR UNLESS IT IS CURRENT IN DOS.
 (if fl (progn (prompt (strcat "\nCopy " fl))(setq tmpdir (getdir tmpdir))
  (if (and
   (not (findfile (setq dwgspc (strcat tmpdir (substr fl pathln) ".DWG"))))
   (not (findfile (setq sldspc (strcat tmpdir (substr fl pathln) ".SLD")))))
    (progn (setq dir (substr tmpdir 1 (1- (strlen tmpdir))))   ;no slash after
           (command "SH" (strcat "COPY " fl  ".* " dir))
           (if (not (or (findfile dwgspc) (findfile sldspc)))
              (prompt "\nCOPY FAILED -  Check for Valid Path\n")))
    (prompt "\nNOT ALLOWED - DUPLICATE NAME\n")))))

((= readno (+ scrlen 9))                            ;"Move" option
(if fl (progn (prompt (strcat "\nMove " fl)) (setq tmpdir (getdir tmpdir))
 (if (and
  (not (findfile (setq dwgspc (strcat tmpdir (substr fl pathln) ".DWG"))))
  (not (findfile (setq sldspc (strcat tmpdir (substr fl pathln) ".SLD")))))
    (progn (setq dir (substr tmpdir 1 (1- (strlen tmpdir))))
           (command "SH" (strcat "COPY " fl  ".* " dir))
           (if (or (findfile dwgspc) (findfile sldspc)) (progn
              (command "SH" (strcat "DEL " fl  ".* " ))(grclear)
              (setq fls (remove fl fls) fl nil  pages (pag#s fls scrlen)))
              (prompt "\nCOPY FAILED - Delete Cancelled - Check Path\n")))
    (prompt "\nNOT ALLOWED - DUPLICATE NAME\n")) )))

((= readno (+ scrlen 10))                           ;"Rename" option
   (if fl (progn (prompt (strcat "\nRename " fl)) 
     (setq newnam (strcase (getstring "\nNew file name <don't give Path> ")))
     (if (not (member (strcat path newnam) fls))      ; not foolproof
      (progn (command "SH" (strcat "RENAME " fl ".dwg "  newnam ".dwg"))
             (command "SH" (strcat "RENAME " fl ".sld "  newnam ".sld"))
       (setq fls (subst (strcat path newnam) fl fls) fl (strcat path newnam)))
      (prompt "\nNOT ALLOWED - DUPLICATE NAME\n")))))

((= readno (+ scrlen 11)) (if fl (progn              ;"Delete" option
   (prompt "\nDouble Click on Delete to DELETE Displayed file")
   (prompt (strcat "\nOK to DELETE "  fl " .DWG & .SLD "))
   (setq readno (nth 1 (grread)))  (if (= readno (+ scrlen 11))
      (progn (command "SH" (strcat "DEL " fl  ".* " )) (grclear)
         (setq fls (remove fl fls) fl nil  pages (pag#s fls scrlen)))
   (prompt "\nCANCELLED\n")))))
                      ;This <below> does not work with a single screen setup
((= readno (+ scrlen 13))                       ;"Info Off" "Info On" toggle
   (if flagi (setq flagi nil)(setq flagi T))) ;flagi = flag_info

((= readno (+ scrlen 14))                       ;"Exit On" "Exit Off" toggle
   (if flage (setq flage nil)(setq flage T))) ;flage = flag_exit

((= readno (+ scrlen 15)) ;Makes a list file on dir,  flagf = flag_filemode
   (if flagf (setq fls (getfls path "sld" (strcat path "sld.txt")))
             (setq fls (getfls path "dwg" (strcat path "dwg.txt"))))
   (setq  pageno 0  pages (pag#s fls scrlen) fl nil))

((= readno (+ scrlen 16)) ;Deletes the list file on dir
   (if flagf (progn (command "SH" (strcat "DEL " path "SLD.TXT"))
                    (setq fls (getfls path "sld" "dir.$")))
             (progn (command "SH" (strcat "DEL " path "DWG.TXT"))
                    (setq fls (getfls path "dwg" "dir.$"))))
   (setq  pageno 0  pages (pag#s fls scrlen) fl nil))

((= readno (+ scrlen 17))                        ;"Save List On/Off"
  (if flagsv (setq flagsv nil)(setq flagsv T)))  ;flagsv = flag_save_vsldlist
))  ;cond and while
(if (not flagsv) (setq fls nil))                  ;save list flag
(grtext) (menucmd "S=E")(redraw)) ;exit to your menu screen, end function VSLD
;*****************************************************************************
;Subr to remove word from list. Updates file list after deleting file.
(defun remove (word lst)    ;l is lower case L, not #1
(if (member word lst) (append (reverse (cdr (member word (reverse lst))))
(cdr (member word lst))) lst))

;Slash operator subroutine - changes menu foreslash to dos backslash (fix)
;pslash is from "Inside Autolisp", Smith & Gesner,-"gratefully acknowledged"
(defun pslash (path / inc slash wpath char)
 (setq inc 1  wpath ""  slash "\\")
 (while (/= "" (setq char (substr path inc 1)))
 (setq wpath (strcat wpath (if (member char '("\\" "/")) slash char))
       inc (1+ inc)))
 (if (and (/= wpath "") (/= (substr wpath (strlen wpath) 1) slash))
         (setq wpath (strcat wpath slash)))
 wpath) 

;Subr getfls is a derivative of GETFIL from "Inside Autolisp" Smith & Gesner
;"dir.$" is always tmp, filext.txt (e.g."dwg.txt") if exists is generic lookup
(defun getfls (path filext fname / fls)
  (if (and (= fname "dir.$") (findfile (strcat path filext ".txt")))
   (progn (prompt (strcat "\nRead list file "  path filext ".txt "))
          (setq fls (readfl (strcat path filext ".txt"))))
   (progn (mkfile path filext fname) (setq fls (readfl fname))))
(if fls fls (prompt "\nNo files found ")))

;Subr (makefile path file-extension file-name-to-make )
(defun mkfile (path filext fname / fl fil)
    (setq fil (open fname "w")) (close fil)
    (setq fl (strcat path "*." filext))
    (command "SH" (strcat "for %f in (" fl ") do echo %f >> " fname ))
    (command "SH" (strcat "SORT < " fname " > tmp.$"))
    (command "SH" (strcat " copy tmp.$ " fname))
    (command "SH" (strcat " del tmp.$")))

;Subr (readfile file-name-to-read )
(defun readfl (fname / fls fl fil remext)
 (if (setq fil (open fname "r")) (progn  ;if we can open file
 (if (setq fl (read-line fil)) (progn
 (setq remext (- (strlen fl) (dotlen fl))) ; remove extension
 (while (and fl (/= "" fl))                          ;the read-line loop
 (setq fls (append fls (list (substr fl 1 (- (strlen fl) remext)))))
 (setq fl (read-line fil)))))   ; while progn if
 (if (= fname "dir.$")(progn (close fil) (command "SH" "del dir.$"))
                             (close fil))) ;if progn
(prompt "\nFile could not be opened ")) ;if
fls )   ;returns fls

;Subr to get file name dot substr length - Get length of file name, start at
(defun dotlen (fl / dot inc)    ; end and count backwards to dot.
 (setq inc (strlen fl) dot ".") ;(dotlen "1234.678")returns 4 (substr str 1 4)
 (while (and (/= inc 0) (/= dot (substr fl inc 1))) (setq inc (1- inc)))
 (if (= inc 0) (setq inc (strlen fl)) (setq inc (1- inc))) inc)

;Number of Screen Pages subroutine
(defun pag#s (fls scrlen / pages)
 (setq pages (/ (length fls) scrlen))
 (if (and (= 0 (rem (length fls) scrlen))(>= pages 1))(setq pages (1- pages)))
 pages)    ;returns

;Display Files to Screen subroutine
(defun dspfls (fls scrlen pathln pageno / inc)
(setq inc 0)
(repeat scrlen (if (> (length fls) (+ inc (* pageno scrlen)))	
  (grtext inc (substr (nth (+ inc (* pageno scrlen)) fls) pathln)))
  (setq inc (1+ inc))))

(defun prevpg ()   ;Subr previous page
  (if (/= pageno 0) (setq pageno (1- pageno)) (setq pageno pages)))
(defun nextpg ()   ;Subr next page
  (if (/= pageno pages) (setq pageno (1+ pageno)) (setq pageno 0)))

;Subr to get directory and present default. Set up your own primary default.
;Empty string default "" not recommended because findfile will search all
;Set acad= directories
(defun getdir (tmpdir / tmp)                      
  (if (= tmpdir nil) (setq tmpdir "c:\\acad\\"))
  (menucmd "s=blank") (menucmd "s=dirs")
  (if (and (setq tmp (getstring (strcat "\nPATH< " tmpdir " >: ")))
           (/= tmp ""))   (setq tmpdir (pslash tmp)))
  (menucmd "s=blank") tmpdir)
; An important part of the program is the menu of directories here (above)
; called "S=DIRS". Make an index of your directories on one or several pages.
; A new page call will not trigger GETSTRING until a selection is made.
; Write the directory with the standard acad menu foreslash (this is what
; pslash is for!).   Use the same directory menu index to start VSLD

;Subr to get directory string length - Get length of file name, start at end
(defun dirlen (fl / slash inc)           ; and count backwards to last slash.
 (setq inc (strlen fl) slash "\\")       ; (dirlen "1234\678") returns 6
 (while (and (/= inc 0) (/= slash (substr fl inc 1)))(setq inc (1- inc)))
 (setq inc (1+ inc)) inc)                ;(substr "1234\678" 6) returns "678"
;*****************************************************************************


