' PALDEMO.BAS
' Demo of routines found in PALCALLS.BAS

' VGX quicklibrary is REQUIRED

' LOAD or MERGE PALCALLS.BAS into this program.

' These palette routines will work ONLY in VGA SCREEN 12 mode!

DEFINT A-Z

DECLARE SUB VGXLoad (fil$, PalFlag%)


DECLARE SUB GraySumCurrent ()      'gray-sums current palette
DECLARE SUB graysumforced ()       'gray-sums using forced values
DECLARE SUB BlankPal ()            'all colors = black (watch out!)
DECLARE SUB ReadDACBLOCK (Pal%())  'get the current pallete into array
DECLARE SUB SetDACBLOCK (Pal%())   'set the current pallete using array
DECLARE SUB FadeIn (P%())
DECLARE SUB FadeOut ()             'fades to attribute zero
DECLARE SUB Fade2Black ()          'fades to black
DECLARE SUB RotatePalette (StartPal%, EndPal%, speed%, Dir%) 'rotates the palette
DECLARE FUNCTION VGAPALETTE& (R%, G%, B%)

DIM VGAPal(0 TO 23) AS INTEGER
' dimension a palette array to hold 48 bytes (you might want SHARED or
' COMMON palette arrays.)

DECLARE SUB PauseX (seconds!)
'''''''''''''''
SCREEN 12

y = 20
kolor = 0
FOR x = 0 TO 600 STEP 40
   LINE (x, y)-(x + 36, y + 72), kolor, BF
   kolor = kolor + 1
NEXT x

' First, let's load the current palette into VGApal
' so we can restore it later.
CALL ReadDACBLOCK(VGAPal())   'get the current pallete into array

LOCATE 8, 1
COLOR 1
PRINT "First we will blank the palette.  All colors will equal zero but the"
PRINT "screen data will remain.  Hit a key to blank, THEN HIT A KEY AGAIN..."
DO: LOOP WHILE INKEY$ = ""

CALL BlankPal
'BE CAREFUL using BlankPal because the screen will STAY black until you
'restore a real palette.

DO: LOOP WHILE INKEY$ = ""
CALL SetDACBLOCK(VGAPal())   'set the palette we stored above

COLOR 2: PRINT "Hit a key to continue..."
DO: LOOP WHILE INKEY$ = ""

PALETTE 0, 30
CALL ReadDACBLOCK(VGAPal())   'get the current pallete into array

COLOR 3
PRINT "We have used PALETTE 0,30 to change the background color."
PRINT "Now we will FADE to the BACKGROUND color and then fade back."
PRINT "Hit a key to begin..."
DO: LOOP WHILE INKEY$ = ""

CALL FadeOut
CALL PauseX(1)
CALL FadeIn(VGAPal())

PALETTE 4, 54
COLOR 4
PRINT "We will now fade to BLACK no matter what the background color is."
PRINT "Hit a key to begin..."
DO: LOOP WHILE INKEY$ = ""

CALL Fade2Black
CALL PauseX(1)
CALL FadeIn(VGAPal())

COLOR 5: PRINT "Hit a key to continue..."
DO: LOOP WHILE INKEY$ = ""
PALETTE 0, 0
CALL ReadDACBLOCK(VGAPal())   'get the current pallete into array

COLOR 6
PRINT "We will now ROTATE the palette in all colors."
PRINT "Hit a key to begin then hit a key AGAIN to FINISH..."
DO: LOOP WHILE INKEY$ = ""

Dir = 1
StartPal% = 0: EndPal% = 15: speed% = 450
CALL RotatePalette(StartPal%, EndPal%, speed%, Dir%) 'rotates the palette

Dir = 0
COLOR 7: PRINT "We can go faster...and just rotate part of the pallete"
StartPal% = 4: EndPal% = 13: speed% = 120
CALL RotatePalette(StartPal%, EndPal%, speed%, Dir%) 'rotates the palette

Dir = 1
COLOR 8: PRINT "We can go faster still!!!";
StartPal% = 3: EndPal% = 13: speed% = 0
CALL RotatePalette(StartPal%, EndPal%, speed%, Dir%) 'rotates the palette

' Next we will show the gray values...
COLOR 9
PRINT "Hit any key to show the Gray-sum version of the current palette..."
DO: LOOP WHILE INKEY$ = ""

CALL GraySumCurrent

'restore the VGApal array palette
COLOR 10: PRINT "Hit any key to restore the palette..."
DO: LOOP WHILE INKEY$ = ""

CALL SetDACBLOCK(VGAPal())   'set the palette with array

' Next we will show the FORCED gray values...
COLOR 11
PRINT "Hit any key to show the FORCED Gray-sum version of the current palette..."
DO: LOOP WHILE INKEY$ = ""

CALL graysumforced

DO: LOOP WHILE INKEY$ = ""
PALETTE 15, 63
COLOR 15
PRINT
PRINT "This was a demo of PALCALLS.BAS, a group of nine VGA palette"
PRINT "QB subprograms supplied free to registered users of VGX."

LINE (1, 1)-(639, 100), 0, BF

StartPal% = 1: EndPal% = 14: speed% = 50
CALL RotatePalette(StartPal%, EndPal%, speed%, Dir%) 'rotates the palette

CLS
CALL graysumforced

PALETTE 0, VGAPALETTE&(0, 0, 18)
PALETTE 1, VGAPALETTE&(16, 16, 0)
PALETTE 2, VGAPALETTE&(20, 28, 8)
PALETTE 3, VGAPALETTE&(24, 32, 14)
PALETTE 4, VGAPALETTE&(40, 34, 9)
PALETTE 5, VGAPALETTE&(48, 38, 6)
PALETTE 6, VGAPALETTE&(56, 50, 0)
PALETTE 7, VGAPALETTE&(63, 63, 0)
PALETTE 8, VGAPALETTE&(56, 56, 4)
PALETTE 9, VGAPALETTE&(49, 49, 9)
PALETTE 10, VGAPALETTE&(42, 42, 14)
PALETTE 11, VGAPALETTE&(40, 30, 20)
PALETTE 12, VGAPALETTE&(38, 24, 20)
PALETTE 13, VGAPALETTE&(30, 20, 9)
PALETTE 14, VGAPALETTE&(16, 10, 4)
PALETTE 15, VGAPALETTE&(7, 7, 0)


k = 1
FOR x = 1 TO 340
   CIRCLE (x * 1.3333333#, 240), x, k
   k = k + 1: IF k = 16 THEN k = 1
NEXT x
CALL RotatePalette(1, 15, 0, 1) 'rotates the palette

' load ARROW.VGX
CALL VGXLoad("arrow", 3)
RotatePalette 1, 15, 20, 0

FadeOut

CLS
PALETTE
SCREEN 0
END

SUB PauseX (seconds!)

t2! = TIMER + seconds!
DO: LOOP UNTIL TIMER > t2!

END SUB

