DEFINT A-Z

REM $INCLUDE: 'IDOOR.bi'
REM $DYNAMIC

DECLARE SUB AnsiAvatarDemo ()
DECLARE SUB ColorCodeDemo ()
DECLARE SUB DialogBoxDemo ()
DECLARE SUB GetRestoreDemo ()
DECLARE SUB InputDemo ()
DECLARE SUB MakeWindowDemo ()
DECLARE SUB MusicDemo ()
DECLARE SUB DetectDemo ()
DECLARE SUB OpeningScreen ()

Initialize

IF DisplayType = 0 THEN
  PRINT "Sorry!  This DEMO requires ANSI or AVATAR to run!  Change the appropriate"
  PRINT "setting in the DOOR INFO file!"
  END
END IF
RANDOMIZE TIMER

DO

  OpeningScreen
  REDIM List$(10)
  List$(1) = "1. General Info"
  List$(2) = "2. Dialog Box Demo"
  List$(3) = "3. Ansi/Avatar Demo"
  List$(4) = "4. Make Window Demo"
  List$(5) = "5. Input Demo"
  List$(6) = "6. Save/Restore Demo"
  List$(7) = "7. Color Code Demo"
  List$(8) = "8. Play ANSI Music"
  List$(9) = "9. ANSI/AVATAR Detect"
  List$(10) = "10. Exit DD Demo"
  ch = DialogBox(List$(), 7, 28, 10, 21, "N", "N", "Y", 1, 9, 0, 1, 7)
 
  SELECT CASE ch
    CASE 1
      SELECT CASE DisplayType
        CASE 1
          ch2 = SendAnsi("GENINFO")
        CASE 2
          ch2 = SendAvatar("GENINFO")
      END SELECT
      EnterKey "Press [|MENTER|B] to continue.", 9, 0, 23, 1
    CASE 2
      DialogBoxDemo
    CASE 3
      AnsiAvatarDemo
    CASE 4
      MakeWindowDemo
    CASE 5
      InputDemo
    CASE 6
      GetRestoreDemo
    CASE 7
      ColorCodeDemo
    CASE 8
      MusicDemo
    CASE 9
      DetectDemo
    CASE 10, -1
      ExitDoor
      CLS
      END
  END SELECT

LOOP

REM $STATIC
SUB AnsiAvatarDemo

  DisplayTypeOld = DisplayType

  ChangeColor 0, 0
  ClearWindow

  MakeWindow 1, 30, 3, 49, "", "", 1, 9, 0, 1, 0
  SendColorLine 2, 32, "ANSI/AVATAR Demo", 7, 1
  MakeWindow 5, 6, 12, 74, "", "", 1, 9, 0, 1, 0

  crlf$ = CHR$(13) + CHR$(10)
  SendColorLine 6, 8, "INSTA-DOOR has a built in ANSI/AVATAR 0,0+ DRIVER for you" + crlf$, 7, 1
  SendColorLine 7, 8, "to use, eliminating the need for ANSI.SYS to be installed.  The" + crlf$, 7, 1
  SendColorLine 8, 8, "driver writes directly to video memory, for greatest speed and" + crlf$, 7, 1
  SendColorLine 9, 8, "efficiency.  Any ANSI/AVATAR file (unlimited size!) can be" + crlf$, 7, 1
  SendColorLine 10, 8, "displayed.  Make sure you are using an ANSI terminal, then press" + crlf$, 7, 1
  SendColorLine 11, 8, "any key (ESC to EXIT):", 7, 1
  
  K$ = Hitkey$(Who)
  IF K$ = CHR$(27) THEN EXIT SUB

  DisplayType = 1
  GOSUB DrawPattern
  IF ch = -1 THEN
    SendColorLine 13, 1, "File not found.", 7, 0
    K$ = Hitkey$(Who)
  ELSE
    EnterKey "Press [|MENTER|B] to continue.", 9, 0, 23, 1
  END IF

  ChangeColor 0, 0
  ClearWindow

  MakeWindow 1, 2, 5, 79, "", "", 1, 9, 0, 1, 0
  SendColorLine 2, 8, "Now look at the same file, except this time in AVATAR!  The", 7, 1
  SendColorLine 3, 8, "display speed typically increases 25-30% compared to ANSI.", 7, 1
  SendColorLine 4, 8, "Set your terminal to AVATAR, then press any key (ESC to EXIT):", 7, 1

  K$ = Hitkey$(Who)
  IF K$ = CHR$(27) THEN EXIT SUB
  
  DisplayType = 2
  GOSUB DrawPattern
  IF ch = -1 THEN
    SendColorLine 6, 1, "File not found.", 7, 0
    K$ = Hitkey$(Who)
  ELSE
    EnterKey "Press [|MENTER|B] to continue.", 9, 0, 23, 1
  END IF
  
  DisplayType = DisplayTypeOld

  EXIT SUB

DrawPattern:
  ChangeColor 0, 0
  ClearWindow
  ChangeColor 1, 0
  FOR a = 2 TO 9
    ChangePos a, a + 4
    SendCode "|B"
    SendLongString STRING$(70 - a * 2, "")
    SendCode "|b"
  NEXT
  SendColorLine 11, 31, "I N S T A  D O O R", 15, 0
  ChangeColor 1, 0
  FOR a = 13 TO 20
    ChangePos a, 26 - a
    SendCode "|B"
    SendLongString STRING$(a * 2 + 26, "")
    SendCode "|b"
  NEXT

RETURN

END SUB

SUB ColorCodeDemo

  ChangeColor 0, 0
  ClearWindow

  MakeWindow 1, 31, 3, 49, "", "", 1, 9, 0, 1, 0
  SendColorLine 2, 33, "COLOR CODE Demo", 7, 1

  MakeWindow 5, 2, 9, 79, "", "", 1, 9, 0, 1, 0
  SendColorLine 6, 6, "You can embed color codes in text to change colors on the fly instead", 7, 1
  SendColorLine 7, 6, "of using ChangeColor commands.  A color code is a pipe ('|') followed", 7, 1
  SendColorLine 8, 6, "by a single letter representing the color you wish to change to:", 7, 1

  ChangePos 11, 1
  ChangeColor 1, 0
  SendCode "            b = BLUE, |gg = GREEN, |cc = CYAN, |rr = RED, |mM = MAGENTA," + CHR$(13) + CHR$(10)
  SendCode "            |yy = BROWN, |ww = LIGHT GREY, |LL = DARK GREY, |BB = LIGHT BLUE," + CHR$(13) + CHR$(10)
  SendCode "            |GG = LIGHT GREEN, |CC = LIGHT CYAN, |RR = LIGHT RED," + CHR$(13) + CHR$(10)
  SendCode "            |MM = PURPLE, |YY = YELLOW, |WW = WHITE" + CHR$(13) + CHR$(10) + CHR$(10)
  
  ChangeColor 7, 0
  SendPlainCode "FOR EXAMPLE:" + CHR$(13) + CHR$(10) + CHR$(10)
  SendPlainCode "   |wThis is an |Yexample |wof a |Rtext string |wwith |Gembeded color codes!" + CHR$(13) + CHR$(10)
  SendCode "         |wThis is an |Yexample |wof a |Rtext string |wwith |Gembeded color codes!"

  EnterKey "Press [|MENTER|B] to continue.", 9, 0, 23, 1
  
END SUB

SUB DetectDemo

  ChangeColor 0, 0
  ClearWindow

  MakeWindow 1, 25, 4, 54, "", "", 1, 9, 0, 1, 0
  SendColorLine 2, 27, "ANSI/AVATAR DETECTION Demo", 7, 1
  SendColorLine 3, 33, "Press any key", 7, 1

  K$ = Hitkey$(Who)

  ChangeColor 0, 0
  ch = CheckTermulation

  SendColorLine 11, 26, "The |YTERMINAL |wdetected is ", 7, 0

  SELECT CASE ch
    CASE 0
      tmp$ = "|YNONE"
    CASE 1
      tmp$ = "|YANSI"
    CASE 2
      tmp$ = "|YAVATAR"
  END SELECT

  SendCode tmp$

  EnterKey "Press [|MENTER|B] to continue.", 9, 0, 23, 1

END SUB

SUB DialogBoxDemo

 ChangeColor 0, 0
 ClearWindow

 MakeWindow 1, 1, 5, 80, "", "", 1, 9, 0, 1, 0

 SendColorLine 2, 8, "With INSTA-DOOR you have a scrollable Dialog Box to use in your", 7, 1
 SendColorLine 3, 7, "programs.  Turn NUM LOCK on so you can use the keypad to move the bar", 7, 1
 SendColorLine 4, 35, "up and down.", 7, 1

 MakeWindow 20, 1, 22, 80, "", "", 1, 9, 0, 1, 0
 SendColorLine 21, 4, "[2]=Down  [8]=Up [3]=PgDn [9]=PgUp [7]=Top [1]=Bottom [ENTER]=Select Item", 7, 1

 MakeWindow 9, 40, 15, 70, "", "", 1, 9, 0, 1, 0
 SendColorLine 11, 43, "Here is a mini dialog box", 7, 1
 SendColorLine 12, 43, "which contains only five", 7, 1
 SendColorLine 13, 43, "items.  Please select one.", 7, 1

 REDIM List$(5)
 FOR p = 1 TO 5
  List$(p) = "Item #" + LTRIM$(STR$(p))
 NEXT

 ch = DialogBox(List$(), 9, 15, 5, 10, "N", "N", "N", 1, 9, 0, 1, 7)

 MakeWindow 9, 40, 15, 70, "", "", 1, 9, 0, 1, 0
 SendColorLine 12, 47, List$(ch) + " selected.", 7, 1
 SendColorLine 14, 44, "Press a key to continue.", 13, 1
 K$ = Hitkey$(Who)

 ERASE List$

 MakeWindow 9, 40, 15, 70, "", "", 1, 9, 0, 1, 0
 SendColorLine 11, 42, "Now here is a dialog box", 7, 1
 SendColorLine 12, 42, "which contains fifty", 7, 1
 SendColorLine 13, 42, "choices.  Please select one.", 7, 1

 REDIM List$(50)
 FOR p = 1 TO 50
  List$(p) = "Item #" + LTRIM$(STR$(p))
 NEXT

 ch = DialogBox(List$(), 9, 15, 5, 10, "N", "N", "N", 1, 9, 0, 1, 7)

 MakeWindow 9, 40, 15, 70, "", "", 1, 9, 0, 1, 0
 SendColorLine 12, 47, List$(ch) + " selected.", 7, 1
 SendColorLine 14, 44, "Press a key to continue.", 13, 1
 K$ = Hitkey$(Who)

 ERASE List$

END SUB

SUB GetRestoreDemo

  ChangeColor 0, 0
  ClearWindow

  MakeWindow 1, 30, 3, 49, "", "", 1, 9, 0, 1, 0
  SendColorLine 2, 32, "GET/RESTORE Demo", 7, 1

  MakeWindow 5, 2, 8, 79, "", "", 1, 9, 0, 1, 0
  SendColorLine 6, 8, "With GetANSIScreen and PutANSIScreen, you can save and restore", 7, 1
  SendColorLine 7, 8, "parts of the screen.  Press any key (ESC to EXIT):", 7, 1

  K$ = Hitkey$(Who)
  IF K$ = CHR$(27) THEN EXIT SUB

  REDIM scrn1(1000)
  REDIM scrn2(1000)
  REDIM scrn3(1000)
  REDIM scrn4(2000)

  GetAnsiScreen scrn1(), 10, 12, 14, 34
  MakeWindow 10, 12, 14, 34, "", "", 1, 8, 8, 2, 0
  GetAnsiScreen scrn2(), 12, 20, 18, 74
  MakeWindow 12, 20, 18, 74, "", "", 2, 9, 9, 4, 0
  GetAnsiScreen scrn3(), 10, 38, 22, 42
  MakeWindow 10, 38, 22, 42, "", "", 3, 4, 4, 5, 0
  GetAnsiScreen scrn4(), 14, 19, 16, 61
  MakeWindow 14, 19, 16, 61, "", "", 1, 9, 0, 1, 0

  SendColorLine 15, 21, "Press any key to make windows disappear", 7, 1

  K$ = Hitkey$(Who)
  PutAnsiScreen scrn4(), 14, 19, 16, 61, "N"
  K$ = Hitkey$(Who)
  PutAnsiScreen scrn3(), 10, 38, 22, 42, "N"
  K$ = Hitkey$(Who)
  PutAnsiScreen scrn2(), 12, 20, 18, 74, "N"
  K$ = Hitkey$(Who)
  PutAnsiScreen scrn1(), 10, 12, 14, 34, "N"

  EnterKey "Press [|MENTER|B] to continue.", 9, 0, 23, 1

  ERASE scrn1, scrn2, scrn3, scrn4


END SUB

SUB InputDemo

  ChangeColor 0, 0
  ClearWindow

  MakeWindow 1, 33, 3, 46, "", "", 1, 9, 0, 1, 0
  SendColorLine 2, 35, "INPUT Demo", 7, 1

  MakeWindow 5, 2, 9, 79, "", "", 1, 9, 0, 1, 0
  SendColorLine 6, 4, "With the command INPUTDATA, you can get INPUT into your programs.  You can", 7, 1
  SendColorLine 7, 4, "set the input field text and length beforehand, and you can control the", 7, 1
  SendColorLine 8, 4, "colors of the field.", 7, 1
  
  SendColorLine 12, 18, "See what I mean?  ", 5, 0
  ans$ = InputData(25, 15, 1, " Yes I do!", "", "")

  EnterKey "Press [|MENTER|B] to continue.", 9, 0, 23, 1

END SUB

SUB MakeWindowDemo

  ChangeColor 0, 0
  ClearWindow

  MakeWindow 1, 31, 3, 49, "", "", 1, 9, 0, 1, 0
  SendColorLine 2, 33, "MakeWindow Demo", 7, 1

  MakeWindow 5, 2, 8, 79, "", "", 1, 9, 0, 1, 0
  SendColorLine 6, 8, "Using the MakeWindow command, you can make windows of any size, with", 7, 1
  SendColorLine 7, 8, "different bordertypes, different colors, etc.  Press a key to see!", 7, 1

  K$ = Hitkey$(Who)

  FOR a = 1 TO 10
    Row = INT(RND * 5) + 10
    row2 = Row + INT(RND * 10) + 1
    IF row2 > 22 THEN row2 = 22
    Col = INT(RND * 70) + 2
    col2 = Col + INT(RND * 50) + 1
    IF col2 > 79 THEN col2 = 79
    bt = INT(RND * 3) + 1
    bkg = INT(RND * 8)
    DO
      tfc = INT(RND * 16)
      bfc = INT(RND * 16)
    LOOP UNTIL tfc <> bkg AND bfc <> bkg
    hdr = INT(RND * 16)
    MakeWindow Row, Col, row2, col2, "", "", bt, tfc, bfc, bkg, hdr
  NEXT

  EnterKey "Press [|MENTER|B] to continue.", 9, 0, 23, 1

END SUB

SUB MusicDemo

  ChangeColor 0, 0
  ClearWindow

  MakeWindow 1, 33, 3, 46, "", "", 1, 9, 0, 1, 0
  SendColorLine 2, 35, "MUSIC Demo", 7, 1

  MakeWindow 5, 2, 8, 79, "", "", 1, 9, 0, 1, 0
  SendColorLine 6, 8, "The ANSI\AVATAR driver supports ANSI music.  Turn MUSIC ON in your", 7, 1
  SendColorLine 7, 8, "terminal program, then choose a song:", 7, 1

  REDIM List$(5)
  List$(1) = "The Addams Family"
  List$(2) = "Leave it to Beaver"
  List$(3) = "Jeopardy Theme"
  List$(4) = "James Bond"
  List$(5) = "Beverly Hill Cop"
  ch = DialogBox(List$(), 10, 30, 5, 18, "Y", "Y", "Y", 1, 9, 0, 1, 7)
  IF ch = -1 THEN EXIT SUB

  SELECT CASE ch
    CASE 1
      m$ = "L16O2G>C8EC8<AF8>D5C<B8>D<B8GE8>C5<G>C8EC8<AF8>D5C<B8GA8B>C4"
    CASE 2
      m$ = "L16O2G>C8EGECD8FA8GF#G>C<A8FD3<G>C8EGECD8FA8GF#G>C<AD<B>C8"
    CASE 3
      m$ = "T75L16O2G8>C8<G8C8G8>C8<G4G8>C8<G8>C8E5DC<BAG#G8>C8<G8CCG8>C8<G4>C5<AG8F8E8D8C8"
    CASE 4
      m$ = "T65L16O2D8<G>DD#8<G>D#E8<G>ED#8<G>D#D8<G>DD#8<G>D#E8<G>ED#8<G>D#"
    CASE 5
      m$ = "T125L16O2G4B-5G8G>C8<G8F8G4>D5<G8G>D#8D8<B-8G8>D8G8<GF8FD8A8G4"
  END SELECT

  ANSIMusic m$

  EnterKey "Press [|MENTER|B] to continue.", 9, 0, 23, 1

END SUB

SUB OpeningScreen

  ChangeColor 0, 0
  ClearWindow
  MakeWindow 1, 2, 5, 79, "", "", 1, 9, 0, 1, 0
  MakeWindow 21, 2, 23, 79, "", "", 1, 9, 0, 1, 0

  SendColorLine 2, 28, "INSTA-DOOR(TM) Demo v1.0", 7, 1
  SendColorLine 3, 23, "Copyright (C) M&J Alliance Software", 7, 1
  SendColorLine 4, 31, "ALL RIGHTS RESERVED", 7, 1
  SendColorLine 22, 6, "[2]=Down, [8]=Up, [7]=Top, [1]=Bottom, [ENTER]=Select Item, [ESC]=Exit", 7, 1
  
END SUB

